# owntone.spec.  Generated from owntone.spec.in by configure.
# -*- Mode:rpm-spec -*-
%global username owntone
%global groupname owntone

%bcond_without alsa
%bcond_without pulseaudio
%bcond_with spotify
%bcond_with lastfm
%bcond_with chromecast

%global _hardened_build 1

Summary: iTunes-compatible DAAP server with MPD and RSP support
Name: owntone
Version: 28.2
Release: 1%{?dist}
License: GPLv2+
Group: Applications/Multimedia
Url: https://github.com/owntone/owntone-server
Source0: https://github.com/owntone/%{name}/archive/%{version}/%{name}-%{version}.tar.gz
%{?systemd_ordering}
BuildRequires: gcc, make, systemd, pkgconfig, libunistring-devel
BuildRequires: pkgconfig(zlib), pkgconfig(libconfuse), pkgconfig(mxml)
BuildRequires: pkgconfig(sqlite3) >= 3.5.0, pkgconfig(libevent) >= 2.0.0
BuildRequires: pkgconfig(json-c), antlr3-C-devel, libgcrypt-devel >= 1.2.0
BuildRequires: libgpg-error-devel >= 1.6
BuildRequires: pkgconfig(libavformat), pkgconfig(libavcodec)
BuildRequires: pkgconfig(libswscale), pkgconfig(libavutil)
BuildRequires: pkgconfig(libavfilter), pkgconfig(libcurl)
BuildRequires: pkgconfig(openssl), pkgconfig(libwebsockets) > 2.0.2
BuildRequires: pkgconfig(libsodium), pkgconfig(avahi-client) >= 0.6.24
# pkgconfig(libplist) not used universally, so require libplist-devel instead
BuildRequires: libplist-devel >= 0.16
Requires(pre): shadow-utils
%if %{with alsa}
BuildRequires: pkgconfig(alsa)
%endif
%if %{with pulseaudio}
BuildRequires: pkgconfig(libpulse)
%endif
%if %{with spotify}
BuildRequires: libspotify-devel
%endif
%if %{with chromecast}
BuildRequires: pkgconfig(libprotobuf-c)
BuildRequires: pkgconfig(gnutls)
%endif

%global homedir %{_localstatedir}/lib/%{name}
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%description
OwnTone is a DAAP/DACP (iTunes), MPD (Music Player Daemon) and RSP (Roku) media
server.

It has support for AirPlay devices/speakers, Apple Remote (and compatibles),
MPD clients, Chromecast, network streaming, internet radio, Spotify and LastFM.

It does not support streaming video by AirPlay nor Chromecast.

DAAP stands for Digital Audio Access Protocol, and is the protocol used
by iTunes and friends to share/stream media libraries over the network.

%prep
%setup -q

%build
%configure \
  --with%{!?with_alsa:out}-alsa --with%{!?with_pulseaudio:out}-pulseaudio \
  --with-libcurl --with-libwebsockets --with-libsodium --with-libplist \
  --with-avahi %{?with_spotify:--enable-spotify} \
  %{?with_lastfm:--enable-lastfm} %{?with_chromecast:--enable-chromecast} \
  --with-daapd-user=%{username} --with-daapd-group=%{groupname}
%make_build

%install
make install DESTDIR=%{buildroot} docdir=%{_pkgdocdir}
rm -f %{buildroot}%{_pkgdocdir}/INSTALL
mkdir -p %{buildroot}%{homedir}
mkdir -p %{buildroot}%{_localstatedir}/log
touch %{buildroot}%{_localstatedir}/log/%{name}.log
mkdir -p %{buildroot}%{_unitdir}
install -m 0644 owntone.service %{buildroot}%{_unitdir}/%{name}.service
rm -f %{buildroot}%{_libdir}/%{name}/*.la

%pre
getent group %{groupname} >/dev/null || groupadd -r %{groupname}
getent passwd %{username} >/dev/null || \
    useradd -r -g %{groupname} -d %{homedir} -s /sbin/nologin \
    -c '%{name} User' %{username}
exit 0

%post
%systemd_post %{name}.service

%preun
%systemd_preun %{name}.service

%postun
%systemd_postun_with_restart %{name}.service

%files
%{!?_licensedir:%global license %%doc}
%license COPYING
%{_pkgdocdir}
%config(noreplace) %{_sysconfdir}/owntone.conf
%{_sbindir}/owntone
%{_libdir}/%{name}/
%{_datarootdir}/%{name}/
%{_unitdir}/%{name}.service
%attr(0750,%{username},%{groupname}) %{_localstatedir}/cache/%{name}
%attr(0750,%{username},%{groupname}) %{homedir}
%ghost %{_localstatedir}/log/%{name}.log
%{_mandir}/man?/*

%changelog
* Sat Mar 17 2018 Scott Shambarger <devel@shambarger.net> - 26.0-1
   - 26.0 release.
   - Update spec file to handle new feature defaults.
   - Added new files/directories.

* Tue Dec 20 2016 Scott Shambarger <devel@shambarger.net> - 24.2-1
   - Initial RPM release candidate.
