# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_neighbour_cell_data_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.9e Packet Neighbour Cell Data
# top-level object: Packet Neighbour Cell Data message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

container_repetition_struct = CSN1List(name='container_repetition_struct', trunc=True, list=[
  CSN1Bit(name='pd', bit=3),
  CSN1Alt(num=-1, alt={
    '00001': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00010': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00011': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00100': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00101': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00110': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '00111': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01000': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01001': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01010': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01011': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01100': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01101': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01110': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '01111': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10000': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10001': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10010': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10011': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10100': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10101': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10110': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '10111': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11000': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11001': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11010': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11011': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11100': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11101': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11110': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=([0], lambda x: x))]),
    '11111': ('cd_length', [
    CSN1Bit(name='container_data', bit=8, num=-1)])}),
  CSN1Val(name='cd_length', val='00000')])

packet_neighbour_cell_data_message_content = CSN1List(name='packet_neighbour_cell_data_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1List(list=[
    CSN1Val(name='', val='0'),
    CSN1Ref(name='global_tfi', obj=global_tfi_ie),
    CSN1List(list=[
      CSN1Bit(name='container_id', bit=2),
      CSN1Bit(name='spare'),
      CSN1Bit(name='container_index', bit=5),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='arfcn', bit=10),
        CSN1Bit(name='bsic', bit=6)])}),
      CSN1Ref(name='container', obj=container_repetition_struct),
      CSN1Ref(obj=padding_bits)])])])

