# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_power_control_timing_advance_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.13 Packet Power Control/Timing Advance
# top-level object: Packet Power Control/Timing Advance message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.global_power_control_parameters_ie import global_power_control_parameters_ie
from pycrate_csn1dir.global_packet_timing_advance_ie import global_packet_timing_advance_ie
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie
from pycrate_csn1dir.power_control_parameters_ie import power_control_parameters_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

packet_power_control_timing_advance_message_content = CSN1List(name='packet_power_control_timing_advance_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1List(list=[
    CSN1Val(name='', val='0'),
    CSN1Ref(name='global_tfi', obj=global_tfi_ie),
    CSN1List(list=[
      CSN1Val(name='', val='0'),
      CSN1List(list=[
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(name='global_power_control_parameters', obj=global_power_control_parameters_ie)])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
          CSN1Ref(name='power_control_parameters', obj=power_control_parameters_ie)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', [
            CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie)]),
            '1': ('', [
            CSN1Ref(name='power_control_parameters', obj=power_control_parameters_ie)])})])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='carrier_identification', bit=2)])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='carrier_count', bit=4),
                CSN1Bit(name='dlmc_carrier_bitmap', bit=([1], lambda x: x + 1))])}),
              CSN1Ref(obj=padding_bits)]),
              None: ('', [])})]),
            None: ('', [])})]),
          None: ('', [])})])])])])

