# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class Remote_Operations_Information_Objects:

    _name_  = u'Remote-Operations-Information-Objects'
    _oid_   = [2, 4, 5, 0]
    
    _obj_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _type_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        ]
    _set_ = [
        ]
    _val_ = [
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _class_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _param_ = [
        ]
    
    #-----< OPERATION >-----#
    OPERATION = CLASS(name=u'OPERATION', mode=MODE_TYPE)
    _OPERATION_ArgumentType = OPEN(name=u'ArgumentType', mode=MODE_TYPE, opt=True)
    _OPERATION_argumentTypeOptional = BOOL(name=u'argumentTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_returnResult = BOOL(name=u'returnResult', mode=MODE_VALUE, default=True)
    _OPERATION_ResultType = OPEN(name=u'ResultType', mode=MODE_TYPE, opt=True)
    _OPERATION_resultTypeOptional = BOOL(name=u'resultTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')), opt=True)
    _OPERATION_Linked = CLASS(name=u'Linked', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_synchronous = BOOL(name=u'synchronous', mode=MODE_VALUE, default=False)
    _OPERATION_alwaysReturns = BOOL(name=u'alwaysReturns', mode=MODE_VALUE, default=True)
    _OPERATION_InvokePriority = INT(name=u'InvokePriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_ResultPriority = INT(name=u'ResultPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_operationCode = CHOICE(name=u'operationCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    OPERATION._cont = ASN1Dict([
        (u'ArgumentType', _OPERATION_ArgumentType),
        (u'argumentTypeOptional', _OPERATION_argumentTypeOptional),
        (u'returnResult', _OPERATION_returnResult),
        (u'ResultType', _OPERATION_ResultType),
        (u'resultTypeOptional', _OPERATION_resultTypeOptional),
        (u'Errors', _OPERATION_Errors),
        (u'Linked', _OPERATION_Linked),
        (u'synchronous', _OPERATION_synchronous),
        (u'alwaysReturns', _OPERATION_alwaysReturns),
        (u'InvokePriority', _OPERATION_InvokePriority),
        (u'ResultPriority', _OPERATION_ResultPriority),
        (u'operationCode', _OPERATION_operationCode),
        ])
    
    #-----< ERROR >-----#
    ERROR = CLASS(name=u'ERROR', mode=MODE_TYPE)
    _ERROR_ParameterType = OPEN(name=u'ParameterType', mode=MODE_TYPE, opt=True)
    _ERROR_parameterTypeOptional = BOOL(name=u'parameterTypeOptional', mode=MODE_VALUE, opt=True)
    _ERROR_ErrorPriority = INT(name=u'ErrorPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _ERROR_errorCode = CHOICE(name=u'errorCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    ERROR._cont = ASN1Dict([
        (u'ParameterType', _ERROR_ParameterType),
        (u'parameterTypeOptional', _ERROR_parameterTypeOptional),
        (u'ErrorPriority', _ERROR_ErrorPriority),
        (u'errorCode', _ERROR_errorCode),
        ])
    
    #-----< OPERATION-PACKAGE >-----#
    OPERATION_PACKAGE = CLASS(name=u'OPERATION-PACKAGE', mode=MODE_TYPE)
    _OPERATION_PACKAGE_Both = CLASS(name=u'Both', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Consumer = CLASS(name=u'Consumer', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Supplier = CLASS(name=u'Supplier', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    OPERATION_PACKAGE._cont = ASN1Dict([
        (u'Both', _OPERATION_PACKAGE_Both),
        (u'Consumer', _OPERATION_PACKAGE_Consumer),
        (u'Supplier', _OPERATION_PACKAGE_Supplier),
        (u'id', _OPERATION_PACKAGE_id),
        ])
    
    #-----< CONNECTION-PACKAGE >-----#
    CONNECTION_PACKAGE = CLASS(name=u'CONNECTION-PACKAGE', mode=MODE_TYPE)
    _CONNECTION_PACKAGE_bind = CLASS(name=u'bind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)]))
    _CONNECTION_PACKAGE_unbind = CLASS(name=u'unbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'synchronous', True)]))
    _CONNECTION_PACKAGE_responderCanUnbind = BOOL(name=u'responderCanUnbind', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_unbindCanFail = BOOL(name=u'unbindCanFail', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONNECTION_PACKAGE._cont = ASN1Dict([
        (u'bind', _CONNECTION_PACKAGE_bind),
        (u'unbind', _CONNECTION_PACKAGE_unbind),
        (u'responderCanUnbind', _CONNECTION_PACKAGE_responderCanUnbind),
        (u'unbindCanFail', _CONNECTION_PACKAGE_unbindCanFail),
        (u'id', _CONNECTION_PACKAGE_id),
        ])
    
    #-----< CONTRACT >-----#
    CONTRACT = CLASS(name=u'CONTRACT', mode=MODE_TYPE)
    _CONTRACT_connection = CLASS(name=u'connection', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONNECTION-PACKAGE')), opt=True)
    _CONTRACT_OperationsOf = CLASS(name=u'OperationsOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorConsumerOf = CLASS(name=u'InitiatorConsumerOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorSupplierOf = CLASS(name=u'InitiatorSupplierOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONTRACT._cont = ASN1Dict([
        (u'connection', _CONTRACT_connection),
        (u'OperationsOf', _CONTRACT_OperationsOf),
        (u'InitiatorConsumerOf', _CONTRACT_InitiatorConsumerOf),
        (u'InitiatorSupplierOf', _CONTRACT_InitiatorSupplierOf),
        (u'id', _CONTRACT_id),
        ])
    
    #-----< ROS-OBJECT-CLASS >-----#
    ROS_OBJECT_CLASS = CLASS(name=u'ROS-OBJECT-CLASS', mode=MODE_TYPE)
    _ROS_OBJECT_CLASS_Is = CLASS(name=u'Is', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ROS-OBJECT-CLASS')), opt=True)
    _ROS_OBJECT_CLASS_Initiates = CLASS(name=u'Initiates', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_Responds = CLASS(name=u'Responds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_InitiatesAndResponds = CLASS(name=u'InitiatesAndResponds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    ROS_OBJECT_CLASS._cont = ASN1Dict([
        (u'Is', _ROS_OBJECT_CLASS_Is),
        (u'Initiates', _ROS_OBJECT_CLASS_Initiates),
        (u'Responds', _ROS_OBJECT_CLASS_Responds),
        (u'InitiatesAndResponds', _ROS_OBJECT_CLASS_InitiatesAndResponds),
        (u'id', _ROS_OBJECT_CLASS_id),
        ])
    
    #-----< Code >-----#
    Code = CHOICE(name=u'Code', mode=MODE_TYPE)
    _Code_local = INT(name=u'local', mode=MODE_TYPE)
    _Code_global_ = OID(name=u'global', mode=MODE_TYPE)
    Code._cont = ASN1Dict([
        (u'local', _Code_local),
        (u'global', _Code_global_),
        ])
    Code._ext = None
    
    #-----< Priority >-----#
    Priority = INT(name=u'Priority', mode=MODE_TYPE)
    Priority._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< refuse >-----#
    refuse = CLASS(name=u'refuse', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    refuse._val = dict([(u'errorCode', (u'local', -1))])
    
    #-----< emptyBind >-----#
    emptyBind = CLASS(name=u'emptyBind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyBind._val = dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)])
    
    #-----< emptyUnbind >-----#
    emptyUnbind = CLASS(name=u'emptyUnbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyUnbind._val = dict([(u'synchronous', True)])
    
    _all_ = [
        _OPERATION_ArgumentType,
        _OPERATION_argumentTypeOptional,
        _OPERATION_returnResult,
        _OPERATION_ResultType,
        _OPERATION_resultTypeOptional,
        _OPERATION_Errors,
        _OPERATION_Linked,
        _OPERATION_synchronous,
        _OPERATION_alwaysReturns,
        _OPERATION_InvokePriority,
        _OPERATION_ResultPriority,
        _OPERATION_operationCode,
        OPERATION,
        _ERROR_ParameterType,
        _ERROR_parameterTypeOptional,
        _ERROR_ErrorPriority,
        _ERROR_errorCode,
        ERROR,
        _OPERATION_PACKAGE_Both,
        _OPERATION_PACKAGE_Consumer,
        _OPERATION_PACKAGE_Supplier,
        _OPERATION_PACKAGE_id,
        OPERATION_PACKAGE,
        _CONNECTION_PACKAGE_bind,
        _CONNECTION_PACKAGE_unbind,
        _CONNECTION_PACKAGE_responderCanUnbind,
        _CONNECTION_PACKAGE_unbindCanFail,
        _CONNECTION_PACKAGE_id,
        CONNECTION_PACKAGE,
        _CONTRACT_connection,
        _CONTRACT_OperationsOf,
        _CONTRACT_InitiatorConsumerOf,
        _CONTRACT_InitiatorSupplierOf,
        _CONTRACT_id,
        CONTRACT,
        _ROS_OBJECT_CLASS_Is,
        _ROS_OBJECT_CLASS_Initiates,
        _ROS_OBJECT_CLASS_Responds,
        _ROS_OBJECT_CLASS_InitiatesAndResponds,
        _ROS_OBJECT_CLASS_id,
        ROS_OBJECT_CLASS,
        _Code_local,
        _Code_global_,
        Code,
        Priority,
        refuse,
        emptyBind,
        emptyUnbind,
    ]

class MobileDomainDefinitions:

    _name_  = u'MobileDomainDefinitions'
    _oid_   = [0, 4, 0, 0, 0, 1]
    
    _obj_ = [
        u'mobileDomainId',
        u'gsm-NetworkId',
        u'gsm-AccessId',
        u'gsm-OperationAndMaintenanceId',
        u'gsm-MessagingId',
        u'CommonComponentId',
        u'ac-Id',
        u'as-Id',
        u'ase-Id',
        u'moduleId',
        u'er-Id',
        ]
    _type_ = [
        u'CommonComponentId',
        ]
    _set_ = [
        ]
    _val_ = [
        u'mobileDomainId',
        u'gsm-NetworkId',
        u'gsm-AccessId',
        u'gsm-OperationAndMaintenanceId',
        u'gsm-MessagingId',
        u'ac-Id',
        u'as-Id',
        u'ase-Id',
        u'moduleId',
        u'er-Id',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< mobileDomainId >-----#
    mobileDomainId = OID(name=u'mobileDomainId', mode=MODE_VALUE)
    mobileDomainId._val = (0, 4, 0, 0)
    
    #-----< gsm-NetworkId >-----#
    gsm_NetworkId = OID(name=u'gsm-NetworkId', mode=MODE_VALUE)
    gsm_NetworkId._val = (0, 4, 0, 0, 1)
    
    #-----< gsm-AccessId >-----#
    gsm_AccessId = OID(name=u'gsm-AccessId', mode=MODE_VALUE)
    gsm_AccessId._val = (0, 4, 0, 0, 2)
    
    #-----< gsm-OperationAndMaintenanceId >-----#
    gsm_OperationAndMaintenanceId = OID(name=u'gsm-OperationAndMaintenanceId', mode=MODE_VALUE)
    gsm_OperationAndMaintenanceId._val = (0, 4, 0, 0, 3)
    
    #-----< gsm-MessagingId >-----#
    gsm_MessagingId = OID(name=u'gsm-MessagingId', mode=MODE_VALUE)
    gsm_MessagingId._val = (0, 4, 0, 0, 4)
    
    #-----< CommonComponentId >-----#
    CommonComponentId = INT(name=u'CommonComponentId', mode=MODE_TYPE)
    CommonComponentId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=None, er=[])
    
    #-----< ac-Id >-----#
    ac_Id = INT(name=u'ac-Id', mode=MODE_VALUE, typeref=ASN1RefType(('MobileDomainDefinitions', 'CommonComponentId')))
    ac_Id._val = 0
    
    #-----< as-Id >-----#
    as_Id = INT(name=u'as-Id', mode=MODE_VALUE, typeref=ASN1RefType(('MobileDomainDefinitions', 'CommonComponentId')))
    as_Id._val = 1
    
    #-----< ase-Id >-----#
    ase_Id = INT(name=u'ase-Id', mode=MODE_VALUE, typeref=ASN1RefType(('MobileDomainDefinitions', 'CommonComponentId')))
    ase_Id._val = 2
    
    #-----< moduleId >-----#
    moduleId = INT(name=u'moduleId', mode=MODE_VALUE, typeref=ASN1RefType(('MobileDomainDefinitions', 'CommonComponentId')))
    moduleId._val = 3
    
    #-----< er-Id >-----#
    er_Id = INT(name=u'er-Id', mode=MODE_VALUE, typeref=ASN1RefType(('MobileDomainDefinitions', 'CommonComponentId')))
    er_Id._val = 4
    
    _all_ = [
        mobileDomainId,
        gsm_NetworkId,
        gsm_AccessId,
        gsm_OperationAndMaintenanceId,
        gsm_MessagingId,
        CommonComponentId,
        ac_Id,
        as_Id,
        ase_Id,
        moduleId,
        er_Id,
    ]

class MAPv2_CommonDataTypes:

    _name_  = u'MAPv2-CommonDataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 18, 2]
    
    _obj_ = [
        u'TBCD-STRING',
        u'AddressString',
        u'maxAddressLength',
        u'ISDN-AddressString',
        u'maxISDN-AddressLength',
        u'ISDN-SubaddressString',
        u'maxISDN-SubaddressLength',
        u'ExternalSignalInfo',
        u'SignalInfo',
        u'maxSignalInfoLength',
        u'ProtocolId',
        u'IMSI',
        u'TMSI',
        u'SubscriberId',
        u'IMEI',
        u'LocationInfo',
        u'HLR-Id',
        u'HLR-List',
        u'maxNumOfHLR-Id',
        u'LMSI',
        u'GlobalCellId',
        u'NetworkResource',
        u'Category',
        u'BearerServiceList',
        u'maxNumOfBearerServices',
        u'TeleserviceList',
        u'maxNumOfTeleservices',
        u'BasicServiceCode',
        u'BasicServiceList',
        u'maxNumOfBasicServices',
        u'BasicServiceGroupList',
        u'maxNumOfBasicServiceGroups',
        ]
    _type_ = [
        u'TBCD-STRING',
        u'AddressString',
        u'ISDN-AddressString',
        u'ISDN-SubaddressString',
        u'ExternalSignalInfo',
        u'SignalInfo',
        u'ProtocolId',
        u'IMSI',
        u'TMSI',
        u'SubscriberId',
        u'IMEI',
        u'LocationInfo',
        u'HLR-Id',
        u'HLR-List',
        u'LMSI',
        u'GlobalCellId',
        u'NetworkResource',
        u'Category',
        u'BearerServiceList',
        u'TeleserviceList',
        u'BasicServiceCode',
        u'BasicServiceList',
        u'BasicServiceGroupList',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxAddressLength',
        u'maxISDN-AddressLength',
        u'maxISDN-SubaddressLength',
        u'maxSignalInfoLength',
        u'maxNumOfHLR-Id',
        u'maxNumOfBearerServices',
        u'maxNumOfTeleservices',
        u'maxNumOfBasicServices',
        u'maxNumOfBasicServiceGroups',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< TBCD-STRING >-----#
    TBCD_STRING = OCT_STR(name=u'TBCD-STRING', mode=MODE_TYPE)
    
    #-----< AddressString >-----#
    AddressString = OCT_STR(name=u'AddressString', mode=MODE_TYPE)
    AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< maxAddressLength >-----#
    maxAddressLength = INT(name=u'maxAddressLength', mode=MODE_VALUE)
    maxAddressLength._val = 20
    
    #-----< ISDN-AddressString >-----#
    ISDN_AddressString = OCT_STR(name=u'ISDN-AddressString', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    ISDN_AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< maxISDN-AddressLength >-----#
    maxISDN_AddressLength = INT(name=u'maxISDN-AddressLength', mode=MODE_VALUE)
    maxISDN_AddressLength._val = 9
    
    #-----< ISDN-SubaddressString >-----#
    ISDN_SubaddressString = OCT_STR(name=u'ISDN-SubaddressString', mode=MODE_TYPE)
    ISDN_SubaddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=21)], ev=None, er=[])
    
    #-----< maxISDN-SubaddressLength >-----#
    maxISDN_SubaddressLength = INT(name=u'maxISDN-SubaddressLength', mode=MODE_VALUE)
    maxISDN_SubaddressLength._val = 21
    
    #-----< ExternalSignalInfo >-----#
    ExternalSignalInfo = SEQ(name=u'ExternalSignalInfo', mode=MODE_TYPE)
    _ExternalSignalInfo_protocolId = ENUM(name=u'protocolId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ProtocolId')))
    _ExternalSignalInfo_signalInfo = OCT_STR(name=u'signalInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'SignalInfo')))
    ExternalSignalInfo._cont = ASN1Dict([
        (u'protocolId', _ExternalSignalInfo_protocolId),
        (u'signalInfo', _ExternalSignalInfo_signalInfo),
        ])
    ExternalSignalInfo._ext = []
    
    #-----< SignalInfo >-----#
    SignalInfo = OCT_STR(name=u'SignalInfo', mode=MODE_TYPE)
    SignalInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    
    #-----< maxSignalInfoLength >-----#
    maxSignalInfoLength = INT(name=u'maxSignalInfoLength', mode=MODE_VALUE)
    maxSignalInfoLength._val = 200
    
    #-----< ProtocolId >-----#
    ProtocolId = ENUM(name=u'ProtocolId', mode=MODE_TYPE)
    ProtocolId._cont = ASN1Dict([(u'gsm-0408', 1), (u'gsm-0806', 2), (u'gsm-BSSMAP', 3), (u'ets-300102-1', 4)])
    ProtocolId._ext = None
    
    #-----< IMSI >-----#
    IMSI = OCT_STR(name=u'IMSI', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TBCD-STRING')))
    IMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< TMSI >-----#
    TMSI = OCT_STR(name=u'TMSI', mode=MODE_TYPE)
    TMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< SubscriberId >-----#
    SubscriberId = CHOICE(name=u'SubscriberId', mode=MODE_TYPE)
    _SubscriberId_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _SubscriberId_tmsi = OCT_STR(name=u'tmsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TMSI')))
    SubscriberId._cont = ASN1Dict([
        (u'imsi', _SubscriberId_imsi),
        (u'tmsi', _SubscriberId_tmsi),
        ])
    SubscriberId._ext = None
    
    #-----< IMEI >-----#
    IMEI = OCT_STR(name=u'IMEI', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TBCD-STRING')))
    IMEI._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< LocationInfo >-----#
    LocationInfo = CHOICE(name=u'LocationInfo', mode=MODE_TYPE)
    _LocationInfo_roamingNumber = OCT_STR(name=u'roamingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _LocationInfo_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    LocationInfo._cont = ASN1Dict([
        (u'roamingNumber', _LocationInfo_roamingNumber),
        (u'msc-Number', _LocationInfo_msc_Number),
        ])
    LocationInfo._ext = None
    
    #-----< HLR-Id >-----#
    HLR_Id = OCT_STR(name=u'HLR-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    
    #-----< HLR-List >-----#
    HLR_List = SEQ_OF(name=u'HLR-List', mode=MODE_TYPE)
    _HLR_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'HLR-Id')))
    HLR_List._cont = _HLR_List__item_
    HLR_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfHLR-Id >-----#
    maxNumOfHLR_Id = INT(name=u'maxNumOfHLR-Id', mode=MODE_VALUE)
    maxNumOfHLR_Id._val = 50
    
    #-----< LMSI >-----#
    LMSI = OCT_STR(name=u'LMSI', mode=MODE_TYPE)
    LMSI._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< GlobalCellId >-----#
    GlobalCellId = OCT_STR(name=u'GlobalCellId', mode=MODE_TYPE)
    GlobalCellId._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=7)], ev=None, er=[])
    
    #-----< NetworkResource >-----#
    NetworkResource = ENUM(name=u'NetworkResource', mode=MODE_TYPE)
    NetworkResource._cont = ASN1Dict([(u'plmn', 0), (u'hlr', 1), (u'vlr', 2), (u'pvlr', 3), (u'controllingMSC', 4), (u'vmsc', 5), (u'eir', 6), (u'rss', 7)])
    NetworkResource._ext = None
    
    #-----< Category >-----#
    Category = OCT_STR(name=u'Category', mode=MODE_TYPE)
    Category._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< BearerServiceList >-----#
    BearerServiceList = SEQ_OF(name=u'BearerServiceList', mode=MODE_TYPE)
    _BearerServiceList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    BearerServiceList._cont = _BearerServiceList__item_
    BearerServiceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfBearerServices >-----#
    maxNumOfBearerServices = INT(name=u'maxNumOfBearerServices', mode=MODE_VALUE)
    maxNumOfBearerServices._val = 50
    
    #-----< TeleserviceList >-----#
    TeleserviceList = SEQ_OF(name=u'TeleserviceList', mode=MODE_TYPE)
    _TeleserviceList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    TeleserviceList._cont = _TeleserviceList__item_
    TeleserviceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< maxNumOfTeleservices >-----#
    maxNumOfTeleservices = INT(name=u'maxNumOfTeleservices', mode=MODE_VALUE)
    maxNumOfTeleservices._val = 20
    
    #-----< BasicServiceCode >-----#
    BasicServiceCode = CHOICE(name=u'BasicServiceCode', mode=MODE_TYPE)
    _BasicServiceCode_bearerService = OCT_STR(name=u'bearerService', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    _BasicServiceCode_teleservice = OCT_STR(name=u'teleservice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    BasicServiceCode._cont = ASN1Dict([
        (u'bearerService', _BasicServiceCode_bearerService),
        (u'teleservice', _BasicServiceCode_teleservice),
        ])
    BasicServiceCode._ext = None
    
    #-----< BasicServiceList >-----#
    BasicServiceList = SEQ_OF(name=u'BasicServiceList', mode=MODE_TYPE)
    _BasicServiceList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')))
    BasicServiceList._cont = _BasicServiceList__item_
    BasicServiceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=70)], ev=None, er=[])
    
    #-----< maxNumOfBasicServices >-----#
    maxNumOfBasicServices = INT(name=u'maxNumOfBasicServices', mode=MODE_VALUE)
    maxNumOfBasicServices._val = 70
    
    #-----< BasicServiceGroupList >-----#
    BasicServiceGroupList = SEQ_OF(name=u'BasicServiceGroupList', mode=MODE_TYPE)
    _BasicServiceGroupList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')))
    BasicServiceGroupList._cont = _BasicServiceGroupList__item_
    BasicServiceGroupList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< maxNumOfBasicServiceGroups >-----#
    maxNumOfBasicServiceGroups = INT(name=u'maxNumOfBasicServiceGroups', mode=MODE_VALUE)
    maxNumOfBasicServiceGroups._val = 13
    
    _all_ = [
        TBCD_STRING,
        AddressString,
        maxAddressLength,
        ISDN_AddressString,
        maxISDN_AddressLength,
        ISDN_SubaddressString,
        maxISDN_SubaddressLength,
        _ExternalSignalInfo_protocolId,
        _ExternalSignalInfo_signalInfo,
        ExternalSignalInfo,
        SignalInfo,
        maxSignalInfoLength,
        ProtocolId,
        IMSI,
        TMSI,
        _SubscriberId_imsi,
        _SubscriberId_tmsi,
        SubscriberId,
        IMEI,
        _LocationInfo_roamingNumber,
        _LocationInfo_msc_Number,
        LocationInfo,
        HLR_Id,
        _HLR_List__item_,
        HLR_List,
        maxNumOfHLR_Id,
        LMSI,
        GlobalCellId,
        NetworkResource,
        Category,
        _BearerServiceList__item_,
        BearerServiceList,
        maxNumOfBearerServices,
        _TeleserviceList__item_,
        TeleserviceList,
        maxNumOfTeleservices,
        _BasicServiceCode_bearerService,
        _BasicServiceCode_teleservice,
        BasicServiceCode,
        _BasicServiceList__item_,
        BasicServiceList,
        maxNumOfBasicServices,
        _BasicServiceGroupList__item_,
        BasicServiceGroupList,
        maxNumOfBasicServiceGroups,
    ]

class MAPv2_MS_DataTypes:

    _name_  = u'MAPv2-MS-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 11, 2]
    
    _obj_ = [
        u'UpdateLocationArg',
        u'UpdateLocationRes',
        u'ExtensibleUpdateLocationRes',
        u'CancelLocationArg',
        u'PurgeMS-Arg',
        u'IMSI-WithLMSI',
        u'SendIdentificationRes',
        u'AuthenticationSetList',
        u'AuthenticationSet',
        u'RAND',
        u'SRES',
        u'Kc',
        u'PrepareHO-Arg',
        u'PerformHO-Arg',
        u'ChannelType',
        u'ClassmarkInfo',
        u'HandoverPriority',
        u'PrepareHO-Res',
        u'PerformHO-Res',
        u'PrepareSubsequentHO-Arg',
        u'PerformSubsequentHO-Arg',
        u'SendAuthenticationInfoArg',
        u'SendAuthenticationInfoRes',
        u'Ki',
        u'EquipmentStatus',
        u'SendParametersArg',
        u'RequestParameterList',
        u'RequestParameter',
        u'SentParameterList',
        u'SentParameter',
        u'maxNumOfSentParameter',
        u'InsertSubscriberDataArg',
        u'SubscriberData',
        u'SubscriberStatus',
        u'ODB-Data',
        u'ODB-GeneralData',
        u'ODB-HPLMN-Data',
        u'ZoneCodeList',
        u'ZoneCode',
        u'maxNumOfZoneCodes',
        u'InsertSubscriberDataRes',
        u'RegionalSubscriptionResponse',
        u'DeleteSubscriberDataArg',
        u'DeleteSubscriberDataRes',
        u'ResetArg',
        u'RestoreDataArg',
        u'RestoreDataRes',
        ]
    _type_ = [
        u'UpdateLocationArg',
        u'UpdateLocationRes',
        u'ExtensibleUpdateLocationRes',
        u'CancelLocationArg',
        u'PurgeMS-Arg',
        u'IMSI-WithLMSI',
        u'SendIdentificationRes',
        u'AuthenticationSetList',
        u'AuthenticationSet',
        u'RAND',
        u'SRES',
        u'Kc',
        u'PrepareHO-Arg',
        u'PerformHO-Arg',
        u'ChannelType',
        u'ClassmarkInfo',
        u'HandoverPriority',
        u'PrepareHO-Res',
        u'PerformHO-Res',
        u'PrepareSubsequentHO-Arg',
        u'PerformSubsequentHO-Arg',
        u'SendAuthenticationInfoArg',
        u'SendAuthenticationInfoRes',
        u'Ki',
        u'EquipmentStatus',
        u'SendParametersArg',
        u'RequestParameterList',
        u'RequestParameter',
        u'SentParameterList',
        u'SentParameter',
        u'InsertSubscriberDataArg',
        u'SubscriberData',
        u'SubscriberStatus',
        u'ODB-Data',
        u'ODB-GeneralData',
        u'ODB-HPLMN-Data',
        u'ZoneCodeList',
        u'ZoneCode',
        u'InsertSubscriberDataRes',
        u'RegionalSubscriptionResponse',
        u'DeleteSubscriberDataArg',
        u'DeleteSubscriberDataRes',
        u'ResetArg',
        u'RestoreDataArg',
        u'RestoreDataRes',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxNumOfSentParameter',
        u'maxNumOfZoneCodes',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< UpdateLocationArg >-----#
    UpdateLocationArg = SEQ(name=u'UpdateLocationArg', mode=MODE_TYPE)
    _UpdateLocationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _UpdateLocationArg_locationInfo = CHOICE(name=u'locationInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LocationInfo')))
    _UpdateLocationArg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateLocationArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')), opt=True)
    UpdateLocationArg._cont = ASN1Dict([
        (u'imsi', _UpdateLocationArg_imsi),
        (u'locationInfo', _UpdateLocationArg_locationInfo),
        (u'vlr-Number', _UpdateLocationArg_vlr_Number),
        (u'lmsi', _UpdateLocationArg_lmsi),
        ])
    UpdateLocationArg._ext = []
    
    #-----< UpdateLocationRes >-----#
    UpdateLocationRes = CHOICE(name=u'UpdateLocationRes', mode=MODE_TYPE)
    _UpdateLocationRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateLocationRes_extensibleUpdateLocationRes = SEQ(name=u'extensibleUpdateLocationRes', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ExtensibleUpdateLocationRes')))
    UpdateLocationRes._cont = ASN1Dict([
        (u'hlr-Number', _UpdateLocationRes_hlr_Number),
        (u'extensibleUpdateLocationRes', _UpdateLocationRes_extensibleUpdateLocationRes),
        ])
    UpdateLocationRes._ext = None
    
    #-----< ExtensibleUpdateLocationRes >-----#
    ExtensibleUpdateLocationRes = SEQ(name=u'ExtensibleUpdateLocationRes', mode=MODE_TYPE)
    _ExtensibleUpdateLocationRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    ExtensibleUpdateLocationRes._cont = ASN1Dict([
        (u'hlr-Number', _ExtensibleUpdateLocationRes_hlr_Number),
        ])
    ExtensibleUpdateLocationRes._ext = []
    
    #-----< CancelLocationArg >-----#
    CancelLocationArg = CHOICE(name=u'CancelLocationArg', mode=MODE_TYPE)
    _CancelLocationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _CancelLocationArg_imsi_WithLMSI = SEQ(name=u'imsi-WithLMSI', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'IMSI-WithLMSI')))
    CancelLocationArg._cont = ASN1Dict([
        (u'imsi', _CancelLocationArg_imsi),
        (u'imsi-WithLMSI', _CancelLocationArg_imsi_WithLMSI),
        ])
    CancelLocationArg._ext = None
    
    #-----< PurgeMS-Arg >-----#
    PurgeMS_Arg = SEQ(name=u'PurgeMS-Arg', mode=MODE_TYPE)
    _PurgeMS_Arg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _PurgeMS_Arg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    PurgeMS_Arg._cont = ASN1Dict([
        (u'imsi', _PurgeMS_Arg_imsi),
        (u'vlr-Number', _PurgeMS_Arg_vlr_Number),
        ])
    PurgeMS_Arg._ext = []
    
    #-----< IMSI-WithLMSI >-----#
    IMSI_WithLMSI = SEQ(name=u'IMSI-WithLMSI', mode=MODE_TYPE)
    _IMSI_WithLMSI_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _IMSI_WithLMSI_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')))
    IMSI_WithLMSI._cont = ASN1Dict([
        (u'imsi', _IMSI_WithLMSI_imsi),
        (u'lmsi', _IMSI_WithLMSI_lmsi),
        ])
    IMSI_WithLMSI._ext = []
    
    #-----< SendIdentificationRes >-----#
    SendIdentificationRes = SEQ(name=u'SendIdentificationRes', mode=MODE_TYPE)
    _SendIdentificationRes_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _SendIdentificationRes_authenticationSetList = SEQ_OF(name=u'authenticationSetList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'AuthenticationSetList')), opt=True)
    SendIdentificationRes._cont = ASN1Dict([
        (u'imsi', _SendIdentificationRes_imsi),
        (u'authenticationSetList', _SendIdentificationRes_authenticationSetList),
        ])
    SendIdentificationRes._ext = []
    
    #-----< AuthenticationSetList >-----#
    AuthenticationSetList = SEQ_OF(name=u'AuthenticationSetList', mode=MODE_TYPE)
    _AuthenticationSetList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'AuthenticationSet')))
    AuthenticationSetList._cont = _AuthenticationSetList__item_
    AuthenticationSetList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< AuthenticationSet >-----#
    AuthenticationSet = SEQ(name=u'AuthenticationSet', mode=MODE_TYPE)
    _AuthenticationSet_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RAND')))
    _AuthenticationSet_sres = OCT_STR(name=u'sres', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SRES')))
    _AuthenticationSet_kc = OCT_STR(name=u'kc', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'Kc')))
    AuthenticationSet._cont = ASN1Dict([
        (u'rand', _AuthenticationSet_rand),
        (u'sres', _AuthenticationSet_sres),
        (u'kc', _AuthenticationSet_kc),
        ])
    AuthenticationSet._ext = []
    
    #-----< RAND >-----#
    RAND = OCT_STR(name=u'RAND', mode=MODE_TYPE)
    RAND._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< SRES >-----#
    SRES = OCT_STR(name=u'SRES', mode=MODE_TYPE)
    SRES._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< Kc >-----#
    Kc = OCT_STR(name=u'Kc', mode=MODE_TYPE)
    Kc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< PrepareHO-Arg >-----#
    PrepareHO_Arg = SEQ(name=u'PrepareHO-Arg', mode=MODE_TYPE)
    _PrepareHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')), opt=True)
    _PrepareHO_Arg_ho_NumberNotRequired = NULL(name=u'ho-NumberNotRequired', mode=MODE_TYPE, opt=True)
    _PrepareHO_Arg_bss_APDU = SEQ(name=u'bss-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    PrepareHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PrepareHO_Arg_targetCellId),
        (u'ho-NumberNotRequired', _PrepareHO_Arg_ho_NumberNotRequired),
        (u'bss-APDU', _PrepareHO_Arg_bss_APDU),
        ])
    PrepareHO_Arg._ext = []
    
    #-----< PerformHO-Arg >-----#
    PerformHO_Arg = SEQ(name=u'PerformHO-Arg', mode=MODE_TYPE)
    _PerformHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')))
    _PerformHO_Arg_servingCellId = OCT_STR(name=u'servingCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')))
    _PerformHO_Arg_channelType = OCT_STR(name=u'channelType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ChannelType')))
    _PerformHO_Arg_classmarkInfo = OCT_STR(name=u'classmarkInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ClassmarkInfo')))
    _PerformHO_Arg_handoverPriority = OCT_STR(name=u'handoverPriority', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'HandoverPriority')), opt=True)
    _PerformHO_Arg_kc = OCT_STR(name=u'kc', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'Kc')), opt=True)
    PerformHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PerformHO_Arg_targetCellId),
        (u'servingCellId', _PerformHO_Arg_servingCellId),
        (u'channelType', _PerformHO_Arg_channelType),
        (u'classmarkInfo', _PerformHO_Arg_classmarkInfo),
        (u'handoverPriority', _PerformHO_Arg_handoverPriority),
        (u'kc', _PerformHO_Arg_kc),
        ])
    PerformHO_Arg._ext = None
    
    #-----< ChannelType >-----#
    ChannelType = OCT_STR(name=u'ChannelType', mode=MODE_TYPE)
    ChannelType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< ClassmarkInfo >-----#
    ClassmarkInfo = OCT_STR(name=u'ClassmarkInfo', mode=MODE_TYPE)
    ClassmarkInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< HandoverPriority >-----#
    HandoverPriority = OCT_STR(name=u'HandoverPriority', mode=MODE_TYPE)
    HandoverPriority._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< PrepareHO-Res >-----#
    PrepareHO_Res = SEQ(name=u'PrepareHO-Res', mode=MODE_TYPE)
    _PrepareHO_Res_handoverNumber = OCT_STR(name=u'handoverNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _PrepareHO_Res_bss_APDU = SEQ(name=u'bss-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    PrepareHO_Res._cont = ASN1Dict([
        (u'handoverNumber', _PrepareHO_Res_handoverNumber),
        (u'bss-APDU', _PrepareHO_Res_bss_APDU),
        ])
    PrepareHO_Res._ext = []
    
    #-----< PerformHO-Res >-----#
    PerformHO_Res = SEQ(name=u'PerformHO-Res', mode=MODE_TYPE)
    _PerformHO_Res_handoverNumber = OCT_STR(name=u'handoverNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _PerformHO_Res_accessSignalInfo = SEQ(name=u'accessSignalInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    PerformHO_Res._cont = ASN1Dict([
        (u'handoverNumber', _PerformHO_Res_handoverNumber),
        (u'accessSignalInfo', _PerformHO_Res_accessSignalInfo),
        ])
    PerformHO_Res._ext = None
    
    #-----< PrepareSubsequentHO-Arg >-----#
    PrepareSubsequentHO_Arg = SEQ(name=u'PrepareSubsequentHO-Arg', mode=MODE_TYPE)
    _PrepareSubsequentHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')))
    _PrepareSubsequentHO_Arg_targetMSC_Number = OCT_STR(name=u'targetMSC-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _PrepareSubsequentHO_Arg_bss_APDU = SEQ(name=u'bss-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    PrepareSubsequentHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PrepareSubsequentHO_Arg_targetCellId),
        (u'targetMSC-Number', _PrepareSubsequentHO_Arg_targetMSC_Number),
        (u'bss-APDU', _PrepareSubsequentHO_Arg_bss_APDU),
        ])
    PrepareSubsequentHO_Arg._ext = []
    
    #-----< PerformSubsequentHO-Arg >-----#
    PerformSubsequentHO_Arg = SEQ(name=u'PerformSubsequentHO-Arg', mode=MODE_TYPE)
    _PerformSubsequentHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')))
    _PerformSubsequentHO_Arg_servingCellId = OCT_STR(name=u'servingCellId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')))
    _PerformSubsequentHO_Arg_targetMSC_Number = OCT_STR(name=u'targetMSC-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _PerformSubsequentHO_Arg_classmarkInfo = OCT_STR(name=u'classmarkInfo', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ClassmarkInfo')), opt=True)
    PerformSubsequentHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PerformSubsequentHO_Arg_targetCellId),
        (u'servingCellId', _PerformSubsequentHO_Arg_servingCellId),
        (u'targetMSC-Number', _PerformSubsequentHO_Arg_targetMSC_Number),
        (u'classmarkInfo', _PerformSubsequentHO_Arg_classmarkInfo),
        ])
    PerformSubsequentHO_Arg._ext = None
    
    #-----< SendAuthenticationInfoArg >-----#
    SendAuthenticationInfoArg = OCT_STR(name=u'SendAuthenticationInfoArg', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    
    #-----< SendAuthenticationInfoRes >-----#
    SendAuthenticationInfoRes = SEQ_OF(name=u'SendAuthenticationInfoRes', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'AuthenticationSetList')))
    
    #-----< Ki >-----#
    Ki = OCT_STR(name=u'Ki', mode=MODE_TYPE)
    Ki._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< EquipmentStatus >-----#
    EquipmentStatus = ENUM(name=u'EquipmentStatus', mode=MODE_TYPE)
    EquipmentStatus._cont = ASN1Dict([(u'whiteListed', 0), (u'blackListed', 1), (u'greyListed', 2)])
    EquipmentStatus._ext = None
    
    #-----< SendParametersArg >-----#
    SendParametersArg = SEQ(name=u'SendParametersArg', mode=MODE_TYPE)
    _SendParametersArg_subscriberId = CHOICE(name=u'subscriberId', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'SubscriberId')))
    _SendParametersArg_requestParameterList = SEQ_OF(name=u'requestParameterList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RequestParameterList')))
    SendParametersArg._cont = ASN1Dict([
        (u'subscriberId', _SendParametersArg_subscriberId),
        (u'requestParameterList', _SendParametersArg_requestParameterList),
        ])
    SendParametersArg._ext = None
    
    #-----< RequestParameterList >-----#
    RequestParameterList = SEQ_OF(name=u'RequestParameterList', mode=MODE_TYPE)
    _RequestParameterList__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RequestParameter')))
    RequestParameterList._cont = _RequestParameterList__item_
    RequestParameterList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< RequestParameter >-----#
    RequestParameter = ENUM(name=u'RequestParameter', mode=MODE_TYPE)
    RequestParameter._cont = ASN1Dict([(u'requestIMSI', 0), (u'requestAuthenticationSet', 1), (u'requestSubscriberData', 2), (u'requestKi', 4)])
    RequestParameter._ext = None
    
    #-----< SentParameterList >-----#
    SentParameterList = SEQ_OF(name=u'SentParameterList', mode=MODE_TYPE)
    _SentParameterList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SentParameter')))
    SentParameterList._cont = _SentParameterList__item_
    SentParameterList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    
    #-----< SentParameter >-----#
    SentParameter = CHOICE(name=u'SentParameter', mode=MODE_TYPE)
    _SentParameter_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _SentParameter_authenticationSet = SEQ(name=u'authenticationSet', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'AuthenticationSet')))
    _SentParameter_subscriberData = SEQ(name=u'subscriberData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SubscriberData')))
    _SentParameter_ki = OCT_STR(name=u'ki', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'Ki')))
    SentParameter._cont = ASN1Dict([
        (u'imsi', _SentParameter_imsi),
        (u'authenticationSet', _SentParameter_authenticationSet),
        (u'subscriberData', _SentParameter_subscriberData),
        (u'ki', _SentParameter_ki),
        ])
    SentParameter._ext = None
    
    #-----< maxNumOfSentParameter >-----#
    maxNumOfSentParameter = INT(name=u'maxNumOfSentParameter', mode=MODE_VALUE)
    maxNumOfSentParameter._val = 6
    
    #-----< InsertSubscriberDataArg >-----#
    InsertSubscriberDataArg = SEQ(name=u'InsertSubscriberDataArg', mode=MODE_TYPE)
    _InsertSubscriberDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')), opt=True)
    _InsertSubscriberDataArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _InsertSubscriberDataArg_category = OCT_STR(name=u'category', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'Category')), opt=True)
    _InsertSubscriberDataArg_subscriberStatus = ENUM(name=u'subscriberStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SubscriberStatus')), opt=True)
    _InsertSubscriberDataArg_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BearerServiceList')), opt=True)
    _InsertSubscriberDataArg_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TeleserviceList')), opt=True)
    _InsertSubscriberDataArg_provisionedSS = SEQ_OF(name=u'provisionedSS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-InfoList')), opt=True)
    _InsertSubscriberDataArg_odb_Data = SEQ(name=u'odb-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ODB-Data')), opt=True)
    _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_regionalSubscriptionData = SEQ_OF(name=u'regionalSubscriptionData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ZoneCodeList')), opt=True)
    InsertSubscriberDataArg._cont = ASN1Dict([
        (u'imsi', _InsertSubscriberDataArg_imsi),
        (u'msisdn', _InsertSubscriberDataArg_msisdn),
        (u'category', _InsertSubscriberDataArg_category),
        (u'subscriberStatus', _InsertSubscriberDataArg_subscriberStatus),
        (u'bearerServiceList', _InsertSubscriberDataArg_bearerServiceList),
        (u'teleserviceList', _InsertSubscriberDataArg_teleserviceList),
        (u'provisionedSS', _InsertSubscriberDataArg_provisionedSS),
        (u'odb-Data', _InsertSubscriberDataArg_odb_Data),
        (u'roamingRestrictionDueToUnsupportedFeature', _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionData', _InsertSubscriberDataArg_regionalSubscriptionData),
        ])
    InsertSubscriberDataArg._ext = []
    
    #-----< SubscriberData >-----#
    SubscriberData = SEQ(name=u'SubscriberData', mode=MODE_TYPE)
    _SubscriberData_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SubscriberData_category = OCT_STR(name=u'category', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'Category')), opt=True)
    _SubscriberData_subscriberStatus = ENUM(name=u'subscriberStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SubscriberStatus')), opt=True)
    _SubscriberData_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BearerServiceList')), opt=True)
    _SubscriberData_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TeleserviceList')), opt=True)
    _SubscriberData_provisionedSS = SEQ_OF(name=u'provisionedSS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-InfoList')), opt=True)
    _SubscriberData_odb_Data = SEQ(name=u'odb-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ODB-Data')), opt=True)
    _SubscriberData_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SubscriberData_regionalSubscriptionData = SEQ_OF(name=u'regionalSubscriptionData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ZoneCodeList')), opt=True)
    SubscriberData._cont = ASN1Dict([
        (u'msisdn', _SubscriberData_msisdn),
        (u'category', _SubscriberData_category),
        (u'subscriberStatus', _SubscriberData_subscriberStatus),
        (u'bearerServiceList', _SubscriberData_bearerServiceList),
        (u'teleserviceList', _SubscriberData_teleserviceList),
        (u'provisionedSS', _SubscriberData_provisionedSS),
        (u'odb-Data', _SubscriberData_odb_Data),
        (u'roamingRestrictionDueToUnsupportedFeature', _SubscriberData_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionData', _SubscriberData_regionalSubscriptionData),
        ])
    SubscriberData._ext = None
    
    #-----< SubscriberStatus >-----#
    SubscriberStatus = ENUM(name=u'SubscriberStatus', mode=MODE_TYPE)
    SubscriberStatus._cont = ASN1Dict([(u'serviceGranted', 0), (u'operatorDeterminedBarring', 1)])
    SubscriberStatus._ext = None
    
    #-----< ODB-Data >-----#
    ODB_Data = SEQ(name=u'ODB-Data', mode=MODE_TYPE)
    _ODB_Data_odb_GeneralData = BIT_STR(name=u'odb-GeneralData', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ODB-GeneralData')))
    _ODB_Data_odb_HPLMN_Data = BIT_STR(name=u'odb-HPLMN-Data', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ODB-HPLMN-Data')), opt=True)
    ODB_Data._cont = ASN1Dict([
        (u'odb-GeneralData', _ODB_Data_odb_GeneralData),
        (u'odb-HPLMN-Data', _ODB_Data_odb_HPLMN_Data),
        ])
    ODB_Data._ext = []
    
    #-----< ODB-GeneralData >-----#
    ODB_GeneralData = BIT_STR(name=u'ODB-GeneralData', mode=MODE_TYPE)
    ODB_GeneralData._cont = ASN1Dict([(u'allOG-CallsBarred', 0), (u'internationalOGCallsBarred', 1), (u'internationalOGCallsNotToHPLMN-CountryBarred', 2), (u'premiumRateInformationOGCallsBarred', 3), (u'premiumRateEntertainementOGCallsBarred', 4), (u'ss-AccessBarred', 5)])
    ODB_GeneralData._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< ODB-HPLMN-Data >-----#
    ODB_HPLMN_Data = BIT_STR(name=u'ODB-HPLMN-Data', mode=MODE_TYPE)
    ODB_HPLMN_Data._cont = ASN1Dict([(u'plmn-SpecificBarringType1', 0), (u'plmn-SpecificBarringType2', 1), (u'plmn-SpecificBarringType3', 2), (u'plmn-SpecificBarringType4', 3)])
    ODB_HPLMN_Data._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< ZoneCodeList >-----#
    ZoneCodeList = SEQ_OF(name=u'ZoneCodeList', mode=MODE_TYPE)
    _ZoneCodeList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ZoneCode')))
    ZoneCodeList._cont = _ZoneCodeList__item_
    ZoneCodeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< ZoneCode >-----#
    ZoneCode = OCT_STR(name=u'ZoneCode', mode=MODE_TYPE)
    ZoneCode._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< maxNumOfZoneCodes >-----#
    maxNumOfZoneCodes = INT(name=u'maxNumOfZoneCodes', mode=MODE_VALUE)
    maxNumOfZoneCodes._val = 10
    
    #-----< InsertSubscriberDataRes >-----#
    InsertSubscriberDataRes = SEQ(name=u'InsertSubscriberDataRes', mode=MODE_TYPE)
    _InsertSubscriberDataRes_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TeleserviceList')), opt=True)
    _InsertSubscriberDataRes_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BearerServiceList')), opt=True)
    _InsertSubscriberDataRes_ss_List = SEQ_OF(name=u'ss-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-List')), opt=True)
    _InsertSubscriberDataRes_odb_GeneralData = BIT_STR(name=u'odb-GeneralData', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ODB-GeneralData')), opt=True)
    _InsertSubscriberDataRes_regionalSubscriptionResponse = ENUM(name=u'regionalSubscriptionResponse', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RegionalSubscriptionResponse')), opt=True)
    InsertSubscriberDataRes._cont = ASN1Dict([
        (u'teleserviceList', _InsertSubscriberDataRes_teleserviceList),
        (u'bearerServiceList', _InsertSubscriberDataRes_bearerServiceList),
        (u'ss-List', _InsertSubscriberDataRes_ss_List),
        (u'odb-GeneralData', _InsertSubscriberDataRes_odb_GeneralData),
        (u'regionalSubscriptionResponse', _InsertSubscriberDataRes_regionalSubscriptionResponse),
        ])
    InsertSubscriberDataRes._ext = []
    
    #-----< RegionalSubscriptionResponse >-----#
    RegionalSubscriptionResponse = ENUM(name=u'RegionalSubscriptionResponse', mode=MODE_TYPE)
    RegionalSubscriptionResponse._cont = ASN1Dict([(u'msc-AreaRestricted', 0), (u'tooManyZoneCodes', 1), (u'zoneCodesConflict', 2), (u'regionalSubscNotSupported', 3)])
    RegionalSubscriptionResponse._ext = None
    
    #-----< DeleteSubscriberDataArg >-----#
    DeleteSubscriberDataArg = SEQ(name=u'DeleteSubscriberDataArg', mode=MODE_TYPE)
    _DeleteSubscriberDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _DeleteSubscriberDataArg_basicServiceList = SEQ_OF(name=u'basicServiceList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceList')), opt=True)
    _DeleteSubscriberDataArg_ss_List = SEQ_OF(name=u'ss-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-List')), opt=True)
    _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_regionalSubscriptionIdentifier = OCT_STR(name=u'regionalSubscriptionIdentifier', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ZoneCode')), opt=True)
    DeleteSubscriberDataArg._cont = ASN1Dict([
        (u'imsi', _DeleteSubscriberDataArg_imsi),
        (u'basicServiceList', _DeleteSubscriberDataArg_basicServiceList),
        (u'ss-List', _DeleteSubscriberDataArg_ss_List),
        (u'roamingRestrictionDueToUnsupportedFeature', _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionIdentifier', _DeleteSubscriberDataArg_regionalSubscriptionIdentifier),
        ])
    DeleteSubscriberDataArg._ext = []
    
    #-----< DeleteSubscriberDataRes >-----#
    DeleteSubscriberDataRes = SEQ(name=u'DeleteSubscriberDataRes', mode=MODE_TYPE)
    _DeleteSubscriberDataRes_regionalSubscriptionResponse = ENUM(name=u'regionalSubscriptionResponse', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RegionalSubscriptionResponse')), opt=True)
    DeleteSubscriberDataRes._cont = ASN1Dict([
        (u'regionalSubscriptionResponse', _DeleteSubscriberDataRes_regionalSubscriptionResponse),
        ])
    DeleteSubscriberDataRes._ext = []
    
    #-----< ResetArg >-----#
    ResetArg = SEQ(name=u'ResetArg', mode=MODE_TYPE)
    _ResetArg_networkResource = ENUM(name=u'networkResource', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')), opt=True)
    _ResetArg_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _ResetArg_hlr_List = SEQ_OF(name=u'hlr-List', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'HLR-List')), opt=True)
    ResetArg._cont = ASN1Dict([
        (u'networkResource', _ResetArg_networkResource),
        (u'hlr-Number', _ResetArg_hlr_Number),
        (u'hlr-List', _ResetArg_hlr_List),
        ])
    ResetArg._ext = []
    
    #-----< RestoreDataArg >-----#
    RestoreDataArg = SEQ(name=u'RestoreDataArg', mode=MODE_TYPE)
    _RestoreDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _RestoreDataArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')), opt=True)
    RestoreDataArg._cont = ASN1Dict([
        (u'imsi', _RestoreDataArg_imsi),
        (u'lmsi', _RestoreDataArg_lmsi),
        ])
    RestoreDataArg._ext = []
    
    #-----< RestoreDataRes >-----#
    RestoreDataRes = SEQ(name=u'RestoreDataRes', mode=MODE_TYPE)
    _RestoreDataRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _RestoreDataRes_msNotReachable = NULL(name=u'msNotReachable', mode=MODE_TYPE, opt=True)
    RestoreDataRes._cont = ASN1Dict([
        (u'hlr-Number', _RestoreDataRes_hlr_Number),
        (u'msNotReachable', _RestoreDataRes_msNotReachable),
        ])
    RestoreDataRes._ext = []
    
    _all_ = [
        _UpdateLocationArg_imsi,
        _UpdateLocationArg_locationInfo,
        _UpdateLocationArg_vlr_Number,
        _UpdateLocationArg_lmsi,
        UpdateLocationArg,
        _UpdateLocationRes_hlr_Number,
        _UpdateLocationRes_extensibleUpdateLocationRes,
        UpdateLocationRes,
        _ExtensibleUpdateLocationRes_hlr_Number,
        ExtensibleUpdateLocationRes,
        _CancelLocationArg_imsi,
        _CancelLocationArg_imsi_WithLMSI,
        CancelLocationArg,
        _PurgeMS_Arg_imsi,
        _PurgeMS_Arg_vlr_Number,
        PurgeMS_Arg,
        _IMSI_WithLMSI_imsi,
        _IMSI_WithLMSI_lmsi,
        IMSI_WithLMSI,
        _SendIdentificationRes_imsi,
        _SendIdentificationRes_authenticationSetList,
        SendIdentificationRes,
        _AuthenticationSetList__item_,
        AuthenticationSetList,
        _AuthenticationSet_rand,
        _AuthenticationSet_sres,
        _AuthenticationSet_kc,
        AuthenticationSet,
        RAND,
        SRES,
        Kc,
        _PrepareHO_Arg_targetCellId,
        _PrepareHO_Arg_ho_NumberNotRequired,
        _PrepareHO_Arg_bss_APDU,
        PrepareHO_Arg,
        _PerformHO_Arg_targetCellId,
        _PerformHO_Arg_servingCellId,
        _PerformHO_Arg_channelType,
        _PerformHO_Arg_classmarkInfo,
        _PerformHO_Arg_handoverPriority,
        _PerformHO_Arg_kc,
        PerformHO_Arg,
        ChannelType,
        ClassmarkInfo,
        HandoverPriority,
        _PrepareHO_Res_handoverNumber,
        _PrepareHO_Res_bss_APDU,
        PrepareHO_Res,
        _PerformHO_Res_handoverNumber,
        _PerformHO_Res_accessSignalInfo,
        PerformHO_Res,
        _PrepareSubsequentHO_Arg_targetCellId,
        _PrepareSubsequentHO_Arg_targetMSC_Number,
        _PrepareSubsequentHO_Arg_bss_APDU,
        PrepareSubsequentHO_Arg,
        _PerformSubsequentHO_Arg_targetCellId,
        _PerformSubsequentHO_Arg_servingCellId,
        _PerformSubsequentHO_Arg_targetMSC_Number,
        _PerformSubsequentHO_Arg_classmarkInfo,
        PerformSubsequentHO_Arg,
        SendAuthenticationInfoArg,
        SendAuthenticationInfoRes,
        Ki,
        EquipmentStatus,
        _SendParametersArg_subscriberId,
        _SendParametersArg_requestParameterList,
        SendParametersArg,
        _RequestParameterList__item_,
        RequestParameterList,
        RequestParameter,
        _SentParameterList__item_,
        SentParameterList,
        _SentParameter_imsi,
        _SentParameter_authenticationSet,
        _SentParameter_subscriberData,
        _SentParameter_ki,
        SentParameter,
        maxNumOfSentParameter,
        _InsertSubscriberDataArg_imsi,
        _InsertSubscriberDataArg_msisdn,
        _InsertSubscriberDataArg_category,
        _InsertSubscriberDataArg_subscriberStatus,
        _InsertSubscriberDataArg_bearerServiceList,
        _InsertSubscriberDataArg_teleserviceList,
        _InsertSubscriberDataArg_provisionedSS,
        _InsertSubscriberDataArg_odb_Data,
        _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature,
        _InsertSubscriberDataArg_regionalSubscriptionData,
        InsertSubscriberDataArg,
        _SubscriberData_msisdn,
        _SubscriberData_category,
        _SubscriberData_subscriberStatus,
        _SubscriberData_bearerServiceList,
        _SubscriberData_teleserviceList,
        _SubscriberData_provisionedSS,
        _SubscriberData_odb_Data,
        _SubscriberData_roamingRestrictionDueToUnsupportedFeature,
        _SubscriberData_regionalSubscriptionData,
        SubscriberData,
        SubscriberStatus,
        _ODB_Data_odb_GeneralData,
        _ODB_Data_odb_HPLMN_Data,
        ODB_Data,
        ODB_GeneralData,
        ODB_HPLMN_Data,
        _ZoneCodeList__item_,
        ZoneCodeList,
        ZoneCode,
        maxNumOfZoneCodes,
        _InsertSubscriberDataRes_teleserviceList,
        _InsertSubscriberDataRes_bearerServiceList,
        _InsertSubscriberDataRes_ss_List,
        _InsertSubscriberDataRes_odb_GeneralData,
        _InsertSubscriberDataRes_regionalSubscriptionResponse,
        InsertSubscriberDataRes,
        RegionalSubscriptionResponse,
        _DeleteSubscriberDataArg_imsi,
        _DeleteSubscriberDataArg_basicServiceList,
        _DeleteSubscriberDataArg_ss_List,
        _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature,
        _DeleteSubscriberDataArg_regionalSubscriptionIdentifier,
        DeleteSubscriberDataArg,
        _DeleteSubscriberDataRes_regionalSubscriptionResponse,
        DeleteSubscriberDataRes,
        _ResetArg_networkResource,
        _ResetArg_hlr_Number,
        _ResetArg_hlr_List,
        ResetArg,
        _RestoreDataArg_imsi,
        _RestoreDataArg_lmsi,
        RestoreDataArg,
        _RestoreDataRes_hlr_Number,
        _RestoreDataRes_msNotReachable,
        RestoreDataRes,
    ]

class MAPv2_DialogueInformation:

    _name_  = u'MAPv2-DialogueInformation'
    _oid_   = [0, 4, 0, 0, 1, 3, 3, 2]
    
    _obj_ = [
        u'map-DialogueAS',
        u'MAP-DialoguePDU',
        u'MAP-OpenInfo',
        u'MAP-AcceptInfo',
        u'MAP-CloseInfo',
        u'MAP-RefuseInfo',
        u'Reason',
        u'MAP-UserAbortInfo',
        u'MAP-UserAbortChoice',
        u'ResourceUnavailableReason',
        u'ProcedureCancellationReason',
        u'MAP-ProviderAbortInfo',
        u'MAP-ProviderAbortReason',
        ]
    _type_ = [
        u'MAP-DialoguePDU',
        u'MAP-OpenInfo',
        u'MAP-AcceptInfo',
        u'MAP-CloseInfo',
        u'MAP-RefuseInfo',
        u'Reason',
        u'MAP-UserAbortInfo',
        u'MAP-UserAbortChoice',
        u'ResourceUnavailableReason',
        u'ProcedureCancellationReason',
        u'MAP-ProviderAbortInfo',
        u'MAP-ProviderAbortReason',
        ]
    _set_ = [
        ]
    _val_ = [
        u'map-DialogueAS',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< map-DialogueAS >-----#
    map_DialogueAS = OID(name=u'map-DialogueAS', mode=MODE_VALUE)
    map_DialogueAS._val = (0, 4, 0, 0, 1, 1, 1, 1)
    
    #-----< MAP-DialoguePDU >-----#
    MAP_DialoguePDU = CHOICE(name=u'MAP-DialoguePDU', mode=MODE_TYPE)
    _MAP_DialoguePDU_map_open = SEQ(name=u'map-open', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-OpenInfo')))
    _MAP_DialoguePDU_map_accept = SEQ(name=u'map-accept', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-AcceptInfo')))
    _MAP_DialoguePDU_map_close = SEQ(name=u'map-close', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-CloseInfo')))
    _MAP_DialoguePDU_map_refuse = SEQ(name=u'map-refuse', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-RefuseInfo')))
    _MAP_DialoguePDU_map_userAbort = SEQ(name=u'map-userAbort', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-UserAbortInfo')))
    _MAP_DialoguePDU_map_providerAbort = SEQ(name=u'map-providerAbort', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-ProviderAbortInfo')))
    MAP_DialoguePDU._cont = ASN1Dict([
        (u'map-open', _MAP_DialoguePDU_map_open),
        (u'map-accept', _MAP_DialoguePDU_map_accept),
        (u'map-close', _MAP_DialoguePDU_map_close),
        (u'map-refuse', _MAP_DialoguePDU_map_refuse),
        (u'map-userAbort', _MAP_DialoguePDU_map_userAbort),
        (u'map-providerAbort', _MAP_DialoguePDU_map_providerAbort),
        ])
    MAP_DialoguePDU._ext = None
    
    #-----< MAP-OpenInfo >-----#
    MAP_OpenInfo = SEQ(name=u'MAP-OpenInfo', mode=MODE_TYPE)
    _MAP_OpenInfo_destinationReference = OCT_STR(name=u'destinationReference', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')), opt=True)
    _MAP_OpenInfo_originationReference = OCT_STR(name=u'originationReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')), opt=True)
    MAP_OpenInfo._cont = ASN1Dict([
        (u'destinationReference', _MAP_OpenInfo_destinationReference),
        (u'originationReference', _MAP_OpenInfo_originationReference),
        ])
    MAP_OpenInfo._ext = []
    
    #-----< MAP-AcceptInfo >-----#
    MAP_AcceptInfo = SEQ(name=u'MAP-AcceptInfo', mode=MODE_TYPE)
    MAP_AcceptInfo._cont = ASN1Dict([
        ])
    MAP_AcceptInfo._ext = []
    
    #-----< MAP-CloseInfo >-----#
    MAP_CloseInfo = SEQ(name=u'MAP-CloseInfo', mode=MODE_TYPE)
    MAP_CloseInfo._cont = ASN1Dict([
        ])
    MAP_CloseInfo._ext = []
    
    #-----< MAP-RefuseInfo >-----#
    MAP_RefuseInfo = SEQ(name=u'MAP-RefuseInfo', mode=MODE_TYPE)
    _MAP_RefuseInfo_reason = ENUM(name=u'reason', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-DialogueInformation', 'Reason')))
    MAP_RefuseInfo._cont = ASN1Dict([
        (u'reason', _MAP_RefuseInfo_reason),
        ])
    MAP_RefuseInfo._ext = []
    
    #-----< Reason >-----#
    Reason = ENUM(name=u'Reason', mode=MODE_TYPE)
    Reason._cont = ASN1Dict([(u'noReasonGiven', 0), (u'invalidDestinationReference', 1), (u'invalidOriginatingReference', 2)])
    Reason._ext = None
    
    #-----< MAP-UserAbortInfo >-----#
    MAP_UserAbortInfo = SEQ(name=u'MAP-UserAbortInfo', mode=MODE_TYPE)
    _MAP_UserAbortInfo_map_UserAbortChoice = CHOICE(name=u'map-UserAbortChoice', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-UserAbortChoice')))
    MAP_UserAbortInfo._cont = ASN1Dict([
        (u'map-UserAbortChoice', _MAP_UserAbortInfo_map_UserAbortChoice),
        ])
    MAP_UserAbortInfo._ext = []
    
    #-----< MAP-UserAbortChoice >-----#
    MAP_UserAbortChoice = CHOICE(name=u'MAP-UserAbortChoice', mode=MODE_TYPE)
    _MAP_UserAbortChoice_userSpecificReason = NULL(name=u'userSpecificReason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MAP_UserAbortChoice_userResourceLimitation = NULL(name=u'userResourceLimitation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MAP_UserAbortChoice_resourceUnavailable = ENUM(name=u'resourceUnavailable', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'ResourceUnavailableReason')))
    _MAP_UserAbortChoice_applicationProcedureCancellation = ENUM(name=u'applicationProcedureCancellation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-DialogueInformation', 'ProcedureCancellationReason')))
    MAP_UserAbortChoice._cont = ASN1Dict([
        (u'userSpecificReason', _MAP_UserAbortChoice_userSpecificReason),
        (u'userResourceLimitation', _MAP_UserAbortChoice_userResourceLimitation),
        (u'resourceUnavailable', _MAP_UserAbortChoice_resourceUnavailable),
        (u'applicationProcedureCancellation', _MAP_UserAbortChoice_applicationProcedureCancellation),
        ])
    MAP_UserAbortChoice._ext = None
    
    #-----< ResourceUnavailableReason >-----#
    ResourceUnavailableReason = ENUM(name=u'ResourceUnavailableReason', mode=MODE_TYPE)
    ResourceUnavailableReason._cont = ASN1Dict([(u'shortTermResourceLimitation', 0), (u'longTermResourceLimitation', 1)])
    ResourceUnavailableReason._ext = None
    
    #-----< ProcedureCancellationReason >-----#
    ProcedureCancellationReason = ENUM(name=u'ProcedureCancellationReason', mode=MODE_TYPE)
    ProcedureCancellationReason._cont = ASN1Dict([(u'handoverCancellation', 0), (u'radioChannelRelease', 1), (u'networkPathRelease', 2), (u'callRelease', 3), (u'associatedProcedureFailure', 4), (u'tandemDialogueRelease', 5), (u'remoteOperationsFailure', 6)])
    ProcedureCancellationReason._ext = None
    
    #-----< MAP-ProviderAbortInfo >-----#
    MAP_ProviderAbortInfo = SEQ(name=u'MAP-ProviderAbortInfo', mode=MODE_TYPE)
    _MAP_ProviderAbortInfo_map_ProviderAbortReason = ENUM(name=u'map-ProviderAbortReason', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-DialogueInformation', 'MAP-ProviderAbortReason')))
    MAP_ProviderAbortInfo._cont = ASN1Dict([
        (u'map-ProviderAbortReason', _MAP_ProviderAbortInfo_map_ProviderAbortReason),
        ])
    MAP_ProviderAbortInfo._ext = []
    
    #-----< MAP-ProviderAbortReason >-----#
    MAP_ProviderAbortReason = ENUM(name=u'MAP-ProviderAbortReason', mode=MODE_TYPE)
    MAP_ProviderAbortReason._cont = ASN1Dict([(u'abnormalDialogue', 0), (u'invalidPDU', 1)])
    MAP_ProviderAbortReason._ext = None
    
    _all_ = [
        map_DialogueAS,
        _MAP_DialoguePDU_map_open,
        _MAP_DialoguePDU_map_accept,
        _MAP_DialoguePDU_map_close,
        _MAP_DialoguePDU_map_refuse,
        _MAP_DialoguePDU_map_userAbort,
        _MAP_DialoguePDU_map_providerAbort,
        MAP_DialoguePDU,
        _MAP_OpenInfo_destinationReference,
        _MAP_OpenInfo_originationReference,
        MAP_OpenInfo,
        MAP_AcceptInfo,
        MAP_CloseInfo,
        _MAP_RefuseInfo_reason,
        MAP_RefuseInfo,
        Reason,
        _MAP_UserAbortInfo_map_UserAbortChoice,
        MAP_UserAbortInfo,
        _MAP_UserAbortChoice_userSpecificReason,
        _MAP_UserAbortChoice_userResourceLimitation,
        _MAP_UserAbortChoice_resourceUnavailable,
        _MAP_UserAbortChoice_applicationProcedureCancellation,
        MAP_UserAbortChoice,
        ResourceUnavailableReason,
        ProcedureCancellationReason,
        _MAP_ProviderAbortInfo_map_ProviderAbortReason,
        MAP_ProviderAbortInfo,
        MAP_ProviderAbortReason,
    ]

class MAPv2_SS_Code:

    _name_  = u'MAPv2-SS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 15, 2]
    
    _obj_ = [
        u'SS-Code',
        u'allSS',
        u'allLineIdentificationSS',
        u'clip',
        u'clir',
        u'colp',
        u'colr',
        u'mci',
        u'allForwardingSS',
        u'cfu',
        u'allCondForwardingSS',
        u'cfb',
        u'cfnry',
        u'cfnrc',
        u'allCallOfferingSS',
        u'ct',
        u'mah',
        u'allCallCompletionSS',
        u'cw',
        u'hold',
        u'ccbs',
        u'allMultiPartySS',
        u'multiPTY',
        u'allCommunityOfInterest-SS',
        u'cug',
        u'allChargingSS',
        u'aoci',
        u'aocc',
        u'allAdditionalInfoTransferSS',
        u'uus',
        u'allBarringSS',
        u'barringOfOutgoingCalls',
        u'baoc',
        u'boic',
        u'boicExHC',
        u'barringOfIncomingCalls',
        u'baic',
        u'bicRoam',
        u'allPLMN-specificSS',
        u'plmn-specificSS-1',
        u'plmn-specificSS-2',
        u'plmn-specificSS-3',
        u'plmn-specificSS-4',
        u'plmn-specificSS-5',
        u'plmn-specificSS-6',
        u'plmn-specificSS-7',
        u'plmn-specificSS-8',
        u'plmn-specificSS-9',
        u'plmn-specificSS-A',
        u'plmn-specificSS-B',
        u'plmn-specificSS-C',
        u'plmn-specificSS-D',
        u'plmn-specificSS-E',
        u'plmn-specificSS-F',
        ]
    _type_ = [
        u'SS-Code',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allSS',
        u'allLineIdentificationSS',
        u'clip',
        u'clir',
        u'colp',
        u'colr',
        u'mci',
        u'allForwardingSS',
        u'cfu',
        u'allCondForwardingSS',
        u'cfb',
        u'cfnry',
        u'cfnrc',
        u'allCallOfferingSS',
        u'ct',
        u'mah',
        u'allCallCompletionSS',
        u'cw',
        u'hold',
        u'ccbs',
        u'allMultiPartySS',
        u'multiPTY',
        u'allCommunityOfInterest-SS',
        u'cug',
        u'allChargingSS',
        u'aoci',
        u'aocc',
        u'allAdditionalInfoTransferSS',
        u'uus',
        u'allBarringSS',
        u'barringOfOutgoingCalls',
        u'baoc',
        u'boic',
        u'boicExHC',
        u'barringOfIncomingCalls',
        u'baic',
        u'bicRoam',
        u'allPLMN-specificSS',
        u'plmn-specificSS-1',
        u'plmn-specificSS-2',
        u'plmn-specificSS-3',
        u'plmn-specificSS-4',
        u'plmn-specificSS-5',
        u'plmn-specificSS-6',
        u'plmn-specificSS-7',
        u'plmn-specificSS-8',
        u'plmn-specificSS-9',
        u'plmn-specificSS-A',
        u'plmn-specificSS-B',
        u'plmn-specificSS-C',
        u'plmn-specificSS-D',
        u'plmn-specificSS-E',
        u'plmn-specificSS-F',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< SS-Code >-----#
    SS_Code = OCT_STR(name=u'SS-Code', mode=MODE_TYPE)
    SS_Code._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< allSS >-----#
    allSS = OCT_STR(name=u'allSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allSS._val = b'\x00'
    
    #-----< allLineIdentificationSS >-----#
    allLineIdentificationSS = OCT_STR(name=u'allLineIdentificationSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allLineIdentificationSS._val = b'\x10'
    
    #-----< clip >-----#
    clip = OCT_STR(name=u'clip', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    clip._val = b'\x11'
    
    #-----< clir >-----#
    clir = OCT_STR(name=u'clir', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    clir._val = b'\x12'
    
    #-----< colp >-----#
    colp = OCT_STR(name=u'colp', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    colp._val = b'\x13'
    
    #-----< colr >-----#
    colr = OCT_STR(name=u'colr', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    colr._val = b'\x14'
    
    #-----< mci >-----#
    mci = OCT_STR(name=u'mci', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    mci._val = b'\x15'
    
    #-----< allForwardingSS >-----#
    allForwardingSS = OCT_STR(name=u'allForwardingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allForwardingSS._val = b' '
    
    #-----< cfu >-----#
    cfu = OCT_STR(name=u'cfu', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cfu._val = b'!'
    
    #-----< allCondForwardingSS >-----#
    allCondForwardingSS = OCT_STR(name=u'allCondForwardingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allCondForwardingSS._val = b'('
    
    #-----< cfb >-----#
    cfb = OCT_STR(name=u'cfb', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cfb._val = b')'
    
    #-----< cfnry >-----#
    cfnry = OCT_STR(name=u'cfnry', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cfnry._val = b'*'
    
    #-----< cfnrc >-----#
    cfnrc = OCT_STR(name=u'cfnrc', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cfnrc._val = b'+'
    
    #-----< allCallOfferingSS >-----#
    allCallOfferingSS = OCT_STR(name=u'allCallOfferingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allCallOfferingSS._val = b'0'
    
    #-----< ct >-----#
    ct = OCT_STR(name=u'ct', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    ct._val = b'1'
    
    #-----< mah >-----#
    mah = OCT_STR(name=u'mah', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    mah._val = b'2'
    
    #-----< allCallCompletionSS >-----#
    allCallCompletionSS = OCT_STR(name=u'allCallCompletionSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allCallCompletionSS._val = b'@'
    
    #-----< cw >-----#
    cw = OCT_STR(name=u'cw', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cw._val = b'A'
    
    #-----< hold >-----#
    hold = OCT_STR(name=u'hold', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    hold._val = b'B'
    
    #-----< ccbs >-----#
    ccbs = OCT_STR(name=u'ccbs', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    ccbs._val = b'C'
    
    #-----< allMultiPartySS >-----#
    allMultiPartySS = OCT_STR(name=u'allMultiPartySS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allMultiPartySS._val = b'P'
    
    #-----< multiPTY >-----#
    multiPTY = OCT_STR(name=u'multiPTY', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    multiPTY._val = b'Q'
    
    #-----< allCommunityOfInterest-SS >-----#
    allCommunityOfInterest_SS = OCT_STR(name=u'allCommunityOfInterest-SS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allCommunityOfInterest_SS._val = b'`'
    
    #-----< cug >-----#
    cug = OCT_STR(name=u'cug', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    cug._val = b'a'
    
    #-----< allChargingSS >-----#
    allChargingSS = OCT_STR(name=u'allChargingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allChargingSS._val = b'p'
    
    #-----< aoci >-----#
    aoci = OCT_STR(name=u'aoci', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    aoci._val = b'q'
    
    #-----< aocc >-----#
    aocc = OCT_STR(name=u'aocc', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    aocc._val = b'r'
    
    #-----< allAdditionalInfoTransferSS >-----#
    allAdditionalInfoTransferSS = OCT_STR(name=u'allAdditionalInfoTransferSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allAdditionalInfoTransferSS._val = b'\x80'
    
    #-----< uus >-----#
    uus = OCT_STR(name=u'uus', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    uus._val = b'\x81'
    
    #-----< allBarringSS >-----#
    allBarringSS = OCT_STR(name=u'allBarringSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allBarringSS._val = b'\x90'
    
    #-----< barringOfOutgoingCalls >-----#
    barringOfOutgoingCalls = OCT_STR(name=u'barringOfOutgoingCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    barringOfOutgoingCalls._val = b'\x91'
    
    #-----< baoc >-----#
    baoc = OCT_STR(name=u'baoc', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    baoc._val = b'\x92'
    
    #-----< boic >-----#
    boic = OCT_STR(name=u'boic', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    boic._val = b'\x93'
    
    #-----< boicExHC >-----#
    boicExHC = OCT_STR(name=u'boicExHC', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    boicExHC._val = b'\x94'
    
    #-----< barringOfIncomingCalls >-----#
    barringOfIncomingCalls = OCT_STR(name=u'barringOfIncomingCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    barringOfIncomingCalls._val = b'\x99'
    
    #-----< baic >-----#
    baic = OCT_STR(name=u'baic', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    baic._val = b'\x9a'
    
    #-----< bicRoam >-----#
    bicRoam = OCT_STR(name=u'bicRoam', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    bicRoam._val = b'\x9b'
    
    #-----< allPLMN-specificSS >-----#
    allPLMN_specificSS = OCT_STR(name=u'allPLMN-specificSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    allPLMN_specificSS._val = b'\xf0'
    
    #-----< plmn-specificSS-1 >-----#
    plmn_specificSS_1 = OCT_STR(name=u'plmn-specificSS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_1._val = b'\xf1'
    
    #-----< plmn-specificSS-2 >-----#
    plmn_specificSS_2 = OCT_STR(name=u'plmn-specificSS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_2._val = b'\xf2'
    
    #-----< plmn-specificSS-3 >-----#
    plmn_specificSS_3 = OCT_STR(name=u'plmn-specificSS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_3._val = b'\xf3'
    
    #-----< plmn-specificSS-4 >-----#
    plmn_specificSS_4 = OCT_STR(name=u'plmn-specificSS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_4._val = b'\xf4'
    
    #-----< plmn-specificSS-5 >-----#
    plmn_specificSS_5 = OCT_STR(name=u'plmn-specificSS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_5._val = b'\xf5'
    
    #-----< plmn-specificSS-6 >-----#
    plmn_specificSS_6 = OCT_STR(name=u'plmn-specificSS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_6._val = b'\xf6'
    
    #-----< plmn-specificSS-7 >-----#
    plmn_specificSS_7 = OCT_STR(name=u'plmn-specificSS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_7._val = b'\xf7'
    
    #-----< plmn-specificSS-8 >-----#
    plmn_specificSS_8 = OCT_STR(name=u'plmn-specificSS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_8._val = b'\xf8'
    
    #-----< plmn-specificSS-9 >-----#
    plmn_specificSS_9 = OCT_STR(name=u'plmn-specificSS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_9._val = b'\xf9'
    
    #-----< plmn-specificSS-A >-----#
    plmn_specificSS_A = OCT_STR(name=u'plmn-specificSS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_A._val = b'\xfa'
    
    #-----< plmn-specificSS-B >-----#
    plmn_specificSS_B = OCT_STR(name=u'plmn-specificSS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_B._val = b'\xfb'
    
    #-----< plmn-specificSS-C >-----#
    plmn_specificSS_C = OCT_STR(name=u'plmn-specificSS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_C._val = b'\xfc'
    
    #-----< plmn-specificSS-D >-----#
    plmn_specificSS_D = OCT_STR(name=u'plmn-specificSS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_D._val = b'\xfd'
    
    #-----< plmn-specificSS-E >-----#
    plmn_specificSS_E = OCT_STR(name=u'plmn-specificSS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_E._val = b'\xfe'
    
    #-----< plmn-specificSS-F >-----#
    plmn_specificSS_F = OCT_STR(name=u'plmn-specificSS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    plmn_specificSS_F._val = b'\xff'
    
    _all_ = [
        SS_Code,
        allSS,
        allLineIdentificationSS,
        clip,
        clir,
        colp,
        colr,
        mci,
        allForwardingSS,
        cfu,
        allCondForwardingSS,
        cfb,
        cfnry,
        cfnrc,
        allCallOfferingSS,
        ct,
        mah,
        allCallCompletionSS,
        cw,
        hold,
        ccbs,
        allMultiPartySS,
        multiPTY,
        allCommunityOfInterest_SS,
        cug,
        allChargingSS,
        aoci,
        aocc,
        allAdditionalInfoTransferSS,
        uus,
        allBarringSS,
        barringOfOutgoingCalls,
        baoc,
        boic,
        boicExHC,
        barringOfIncomingCalls,
        baic,
        bicRoam,
        allPLMN_specificSS,
        plmn_specificSS_1,
        plmn_specificSS_2,
        plmn_specificSS_3,
        plmn_specificSS_4,
        plmn_specificSS_5,
        plmn_specificSS_6,
        plmn_specificSS_7,
        plmn_specificSS_8,
        plmn_specificSS_9,
        plmn_specificSS_A,
        plmn_specificSS_B,
        plmn_specificSS_C,
        plmn_specificSS_D,
        plmn_specificSS_E,
        plmn_specificSS_F,
    ]

class MAPv2_CH_DataTypes:

    _name_  = u'MAPv2-CH-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 13, 2]
    
    _obj_ = [
        u'CUG-CheckInfo',
        u'NumberOfForwarding',
        u'SendRoutingInfoArg',
        u'SendRoutingInfoRes',
        u'RoutingInfo',
        u'ProvideRoamingNumberArg',
        ]
    _type_ = [
        u'CUG-CheckInfo',
        u'NumberOfForwarding',
        u'SendRoutingInfoArg',
        u'SendRoutingInfoRes',
        u'RoutingInfo',
        u'ProvideRoamingNumberArg',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< CUG-CheckInfo >-----#
    CUG_CheckInfo = SEQ(name=u'CUG-CheckInfo', mode=MODE_TYPE)
    _CUG_CheckInfo_cug_Interlock = OCT_STR(name=u'cug-Interlock', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Interlock')))
    _CUG_CheckInfo_cug_OutgoingAccess = NULL(name=u'cug-OutgoingAccess', mode=MODE_TYPE, opt=True)
    CUG_CheckInfo._cont = ASN1Dict([
        (u'cug-Interlock', _CUG_CheckInfo_cug_Interlock),
        (u'cug-OutgoingAccess', _CUG_CheckInfo_cug_OutgoingAccess),
        ])
    CUG_CheckInfo._ext = []
    
    #-----< NumberOfForwarding >-----#
    NumberOfForwarding = INT(name=u'NumberOfForwarding', mode=MODE_TYPE)
    NumberOfForwarding._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< SendRoutingInfoArg >-----#
    SendRoutingInfoArg = SEQ(name=u'SendRoutingInfoArg', mode=MODE_TYPE)
    _SendRoutingInfoArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _SendRoutingInfoArg_cug_CheckInfo = SEQ(name=u'cug-CheckInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'CUG-CheckInfo')), opt=True)
    _SendRoutingInfoArg_numberOfForwarding = INT(name=u'numberOfForwarding', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'NumberOfForwarding')), opt=True)
    _SendRoutingInfoArg_networkSignalInfo = SEQ(name=u'networkSignalInfo', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    SendRoutingInfoArg._cont = ASN1Dict([
        (u'msisdn', _SendRoutingInfoArg_msisdn),
        (u'cug-CheckInfo', _SendRoutingInfoArg_cug_CheckInfo),
        (u'numberOfForwarding', _SendRoutingInfoArg_numberOfForwarding),
        (u'networkSignalInfo', _SendRoutingInfoArg_networkSignalInfo),
        ])
    SendRoutingInfoArg._ext = []
    
    #-----< SendRoutingInfoRes >-----#
    SendRoutingInfoRes = SEQ(name=u'SendRoutingInfoRes', mode=MODE_TYPE)
    _SendRoutingInfoRes_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _SendRoutingInfoRes_routingInfo = CHOICE(name=u'routingInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'RoutingInfo')))
    _SendRoutingInfoRes_cug_CheckInfo = SEQ(name=u'cug-CheckInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'CUG-CheckInfo')), opt=True)
    SendRoutingInfoRes._cont = ASN1Dict([
        (u'imsi', _SendRoutingInfoRes_imsi),
        (u'routingInfo', _SendRoutingInfoRes_routingInfo),
        (u'cug-CheckInfo', _SendRoutingInfoRes_cug_CheckInfo),
        ])
    SendRoutingInfoRes._ext = []
    
    #-----< RoutingInfo >-----#
    RoutingInfo = CHOICE(name=u'RoutingInfo', mode=MODE_TYPE)
    _RoutingInfo_roamingNumber = OCT_STR(name=u'roamingNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _RoutingInfo_forwardingData = SEQ(name=u'forwardingData', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingData')))
    RoutingInfo._cont = ASN1Dict([
        (u'roamingNumber', _RoutingInfo_roamingNumber),
        (u'forwardingData', _RoutingInfo_forwardingData),
        ])
    RoutingInfo._ext = None
    
    #-----< ProvideRoamingNumberArg >-----#
    ProvideRoamingNumberArg = SEQ(name=u'ProvideRoamingNumberArg', mode=MODE_TYPE)
    _ProvideRoamingNumberArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _ProvideRoamingNumberArg_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_previousRoamingNumber = OCT_STR(name=u'previousRoamingNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')), opt=True)
    _ProvideRoamingNumberArg_gsm_BearerCapability = SEQ(name=u'gsm-BearerCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    _ProvideRoamingNumberArg_networkSignalInfo = SEQ(name=u'networkSignalInfo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    ProvideRoamingNumberArg._cont = ASN1Dict([
        (u'imsi', _ProvideRoamingNumberArg_imsi),
        (u'msc-Number', _ProvideRoamingNumberArg_msc_Number),
        (u'msisdn', _ProvideRoamingNumberArg_msisdn),
        (u'previousRoamingNumber', _ProvideRoamingNumberArg_previousRoamingNumber),
        (u'lmsi', _ProvideRoamingNumberArg_lmsi),
        (u'gsm-BearerCapability', _ProvideRoamingNumberArg_gsm_BearerCapability),
        (u'networkSignalInfo', _ProvideRoamingNumberArg_networkSignalInfo),
        ])
    ProvideRoamingNumberArg._ext = []
    
    _all_ = [
        _CUG_CheckInfo_cug_Interlock,
        _CUG_CheckInfo_cug_OutgoingAccess,
        CUG_CheckInfo,
        NumberOfForwarding,
        _SendRoutingInfoArg_msisdn,
        _SendRoutingInfoArg_cug_CheckInfo,
        _SendRoutingInfoArg_numberOfForwarding,
        _SendRoutingInfoArg_networkSignalInfo,
        SendRoutingInfoArg,
        _SendRoutingInfoRes_imsi,
        _SendRoutingInfoRes_routingInfo,
        _SendRoutingInfoRes_cug_CheckInfo,
        SendRoutingInfoRes,
        _RoutingInfo_roamingNumber,
        _RoutingInfo_forwardingData,
        RoutingInfo,
        _ProvideRoamingNumberArg_imsi,
        _ProvideRoamingNumberArg_msc_Number,
        _ProvideRoamingNumberArg_msisdn,
        _ProvideRoamingNumberArg_previousRoamingNumber,
        _ProvideRoamingNumberArg_lmsi,
        _ProvideRoamingNumberArg_gsm_BearerCapability,
        _ProvideRoamingNumberArg_networkSignalInfo,
        ProvideRoamingNumberArg,
    ]

class MAPv2_ER_DataTypes:

    _name_  = u'MAPv2-ER-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 17, 2]
    
    _obj_ = [
        u'RoamingNotAllowedCause',
        u'CallBarringCause',
        u'CUG-RejectCause',
        u'SS-IncompatibilityCause',
        u'PW-RegistrationFailureCause',
        u'SM-DeliveryFailureCause',
        u'SM-EnumeratedDeliveryFailureCause',
        u'SM-DeliveryFailureCauseWithDiagnostic',
        ]
    _type_ = [
        u'RoamingNotAllowedCause',
        u'CallBarringCause',
        u'CUG-RejectCause',
        u'SS-IncompatibilityCause',
        u'PW-RegistrationFailureCause',
        u'SM-DeliveryFailureCause',
        u'SM-EnumeratedDeliveryFailureCause',
        u'SM-DeliveryFailureCauseWithDiagnostic',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< RoamingNotAllowedCause >-----#
    RoamingNotAllowedCause = ENUM(name=u'RoamingNotAllowedCause', mode=MODE_TYPE)
    RoamingNotAllowedCause._cont = ASN1Dict([(u'plmnRoamingNotAllowed', 0), (u'operatorDeterminedBarring', 3)])
    RoamingNotAllowedCause._ext = None
    
    #-----< CallBarringCause >-----#
    CallBarringCause = ENUM(name=u'CallBarringCause', mode=MODE_TYPE)
    CallBarringCause._cont = ASN1Dict([(u'barringServiceActive', 0), (u'operatorBarring', 1)])
    CallBarringCause._ext = None
    
    #-----< CUG-RejectCause >-----#
    CUG_RejectCause = ENUM(name=u'CUG-RejectCause', mode=MODE_TYPE)
    CUG_RejectCause._cont = ASN1Dict([(u'incomingCallsBarredWithinCUG', 0), (u'subscriberNotMemberOfCUG', 1), (u'requestedBasicServiceViolatesCUG-Constraints', 5), (u'calledPartySS-InteractionViolation', 7)])
    CUG_RejectCause._ext = None
    
    #-----< SS-IncompatibilityCause >-----#
    SS_IncompatibilityCause = SEQ(name=u'SS-IncompatibilityCause', mode=MODE_TYPE)
    _SS_IncompatibilityCause_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')), opt=True)
    _SS_IncompatibilityCause_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _SS_IncompatibilityCause_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')), opt=True)
    SS_IncompatibilityCause._cont = ASN1Dict([
        (u'ss-Code', _SS_IncompatibilityCause_ss_Code),
        (u'basicService', _SS_IncompatibilityCause_basicService),
        (u'ss-Status', _SS_IncompatibilityCause_ss_Status),
        ])
    SS_IncompatibilityCause._ext = []
    
    #-----< PW-RegistrationFailureCause >-----#
    PW_RegistrationFailureCause = ENUM(name=u'PW-RegistrationFailureCause', mode=MODE_TYPE)
    PW_RegistrationFailureCause._cont = ASN1Dict([(u'undetermined', 0), (u'invalidFormat', 1), (u'newPasswordsMismatch', 2)])
    PW_RegistrationFailureCause._ext = None
    
    #-----< SM-DeliveryFailureCause >-----#
    SM_DeliveryFailureCause = CHOICE(name=u'SM-DeliveryFailureCause', mode=MODE_TYPE)
    _SM_DeliveryFailureCause_sm_DeliveryFailureCauseWithDiagnostic = SEQ(name=u'sm-DeliveryFailureCauseWithDiagnostic', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-DeliveryFailureCauseWithDiagnostic')))
    _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause = ENUM(name=u'sm-EnumeratedDeliveryFailureCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-EnumeratedDeliveryFailureCause')))
    SM_DeliveryFailureCause._cont = ASN1Dict([
        (u'sm-DeliveryFailureCauseWithDiagnostic', _SM_DeliveryFailureCause_sm_DeliveryFailureCauseWithDiagnostic),
        (u'sm-EnumeratedDeliveryFailureCause', _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause),
        ])
    SM_DeliveryFailureCause._ext = None
    
    #-----< SM-EnumeratedDeliveryFailureCause >-----#
    SM_EnumeratedDeliveryFailureCause = ENUM(name=u'SM-EnumeratedDeliveryFailureCause', mode=MODE_TYPE)
    SM_EnumeratedDeliveryFailureCause._cont = ASN1Dict([(u'memoryCapacityExceeded', 0), (u'equipmentProtocolError', 1), (u'equipmentNotSM-Equipped', 2), (u'unknownServiceCentre', 3), (u'sc-Congestion', 4), (u'invalidSME-Address', 5), (u'subscriberNotSC-Subscriber', 6)])
    SM_EnumeratedDeliveryFailureCause._ext = None
    
    #-----< SM-DeliveryFailureCauseWithDiagnostic >-----#
    SM_DeliveryFailureCauseWithDiagnostic = SEQ(name=u'SM-DeliveryFailureCauseWithDiagnostic', mode=MODE_TYPE)
    _SM_DeliveryFailureCauseWithDiagnostic_sm_EnumeratedDeliveryFailureCause = ENUM(name=u'sm-EnumeratedDeliveryFailureCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-EnumeratedDeliveryFailureCause')))
    _SM_DeliveryFailureCauseWithDiagnostic_diagnosticInfo = OCT_STR(name=u'diagnosticInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'SignalInfo')), opt=True)
    SM_DeliveryFailureCauseWithDiagnostic._cont = ASN1Dict([
        (u'sm-EnumeratedDeliveryFailureCause', _SM_DeliveryFailureCauseWithDiagnostic_sm_EnumeratedDeliveryFailureCause),
        (u'diagnosticInfo', _SM_DeliveryFailureCauseWithDiagnostic_diagnosticInfo),
        ])
    SM_DeliveryFailureCauseWithDiagnostic._ext = []
    
    _all_ = [
        RoamingNotAllowedCause,
        CallBarringCause,
        CUG_RejectCause,
        _SS_IncompatibilityCause_ss_Code,
        _SS_IncompatibilityCause_basicService,
        _SS_IncompatibilityCause_ss_Status,
        SS_IncompatibilityCause,
        PW_RegistrationFailureCause,
        _SM_DeliveryFailureCause_sm_DeliveryFailureCauseWithDiagnostic,
        _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause,
        SM_DeliveryFailureCause,
        SM_EnumeratedDeliveryFailureCause,
        _SM_DeliveryFailureCauseWithDiagnostic_sm_EnumeratedDeliveryFailureCause,
        _SM_DeliveryFailureCauseWithDiagnostic_diagnosticInfo,
        SM_DeliveryFailureCauseWithDiagnostic,
    ]

class MAPv2_Errors:

    _name_  = u'MAPv2-Errors'
    _oid_   = []
    
    _obj_ = [
        u'systemFailure',
        u'dataMissing',
        u'unexpectedDataValue',
        u'facilityNotSupported',
        u'unknownSubscriber',
        u'numberChanged',
        u'unknownBaseStation',
        u'unknownMSC',
        u'unidentifiedSubscriber',
        u'unknownEquipment',
        u'roamingNotAllowed',
        u'illegalSubscriber',
        u'illegalEquipment',
        u'bearerServiceNotProvisioned',
        u'teleserviceNotProvisioned',
        u'invalidTargetBaseStation',
        u'noRadioResourceAvailable',
        u'noHandoverNumberAvailable',
        u'subsequentHandoverFailure',
        u'tracingBufferFull',
        u'noRoamingNumberAvailable',
        u'Mwd-Set',
        u'absentSubscriber',
        u'callBarred',
        u'forwardingViolation',
        u'cug-Reject',
        u'illegalSS-Operation',
        u'ss-ErrorStatus',
        u'ss-NotAvailable',
        u'ss-SubscriptionViolation',
        u'ss-Incompatibility',
        u'unknownAlphabet',
        u'ussd-Busy',
        u'pw-RegistrationFailure',
        u'negativePW-Check',
        u'numberOfPW-AttemptsViolation',
        u'subscriberBusyForMT-SMS',
        u'sm-DeliveryFailure',
        u'messageWaitingListFull',
        ]
    _type_ = [
        u'Mwd-Set',
        ]
    _set_ = [
        ]
    _val_ = [
        u'systemFailure',
        u'dataMissing',
        u'unexpectedDataValue',
        u'facilityNotSupported',
        u'unknownSubscriber',
        u'numberChanged',
        u'unknownBaseStation',
        u'unknownMSC',
        u'unidentifiedSubscriber',
        u'unknownEquipment',
        u'roamingNotAllowed',
        u'illegalSubscriber',
        u'illegalEquipment',
        u'bearerServiceNotProvisioned',
        u'teleserviceNotProvisioned',
        u'invalidTargetBaseStation',
        u'noRadioResourceAvailable',
        u'noHandoverNumberAvailable',
        u'subsequentHandoverFailure',
        u'tracingBufferFull',
        u'noRoamingNumberAvailable',
        u'absentSubscriber',
        u'callBarred',
        u'forwardingViolation',
        u'cug-Reject',
        u'illegalSS-Operation',
        u'ss-ErrorStatus',
        u'ss-NotAvailable',
        u'ss-SubscriptionViolation',
        u'ss-Incompatibility',
        u'unknownAlphabet',
        u'ussd-Busy',
        u'pw-RegistrationFailure',
        u'negativePW-Check',
        u'numberOfPW-AttemptsViolation',
        u'subscriberBusyForMT-SMS',
        u'sm-DeliveryFailure',
        u'messageWaitingListFull',
        ]
    _class_ = [
        u'systemFailure',
        u'dataMissing',
        u'unexpectedDataValue',
        u'facilityNotSupported',
        u'unknownSubscriber',
        u'numberChanged',
        u'unknownBaseStation',
        u'unknownMSC',
        u'unidentifiedSubscriber',
        u'unknownEquipment',
        u'roamingNotAllowed',
        u'illegalSubscriber',
        u'illegalEquipment',
        u'bearerServiceNotProvisioned',
        u'teleserviceNotProvisioned',
        u'invalidTargetBaseStation',
        u'noRadioResourceAvailable',
        u'noHandoverNumberAvailable',
        u'subsequentHandoverFailure',
        u'tracingBufferFull',
        u'noRoamingNumberAvailable',
        u'absentSubscriber',
        u'callBarred',
        u'forwardingViolation',
        u'cug-Reject',
        u'illegalSS-Operation',
        u'ss-ErrorStatus',
        u'ss-NotAvailable',
        u'ss-SubscriptionViolation',
        u'ss-Incompatibility',
        u'unknownAlphabet',
        u'ussd-Busy',
        u'pw-RegistrationFailure',
        u'negativePW-Check',
        u'numberOfPW-AttemptsViolation',
        u'subscriberBusyForMT-SMS',
        u'sm-DeliveryFailure',
        u'messageWaitingListFull',
        ]
    _param_ = [
        ]
    
    #-----< systemFailure >-----#
    systemFailure = CLASS(name=u'systemFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _systemFailure_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    systemFailure._val = dict([(u'ParameterType', _systemFailure_val_ParameterType), (u'errorCode', (u'local', 34))])
    
    #-----< dataMissing >-----#
    dataMissing = CLASS(name=u'dataMissing', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    dataMissing._val = dict([(u'errorCode', (u'local', 35))])
    
    #-----< unexpectedDataValue >-----#
    unexpectedDataValue = CLASS(name=u'unexpectedDataValue', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unexpectedDataValue._val = dict([(u'errorCode', (u'local', 36))])
    
    #-----< facilityNotSupported >-----#
    facilityNotSupported = CLASS(name=u'facilityNotSupported', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    facilityNotSupported._val = dict([(u'errorCode', (u'local', 21))])
    
    #-----< unknownSubscriber >-----#
    unknownSubscriber = CLASS(name=u'unknownSubscriber', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownSubscriber._val = dict([(u'errorCode', (u'local', 1))])
    
    #-----< numberChanged >-----#
    numberChanged = CLASS(name=u'numberChanged', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    numberChanged._val = dict([(u'errorCode', (u'local', 44))])
    
    #-----< unknownBaseStation >-----#
    unknownBaseStation = CLASS(name=u'unknownBaseStation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownBaseStation._val = dict([(u'errorCode', (u'local', 2))])
    
    #-----< unknownMSC >-----#
    unknownMSC = CLASS(name=u'unknownMSC', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownMSC._val = dict([(u'errorCode', (u'local', 3))])
    
    #-----< unidentifiedSubscriber >-----#
    unidentifiedSubscriber = CLASS(name=u'unidentifiedSubscriber', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unidentifiedSubscriber._val = dict([(u'errorCode', (u'local', 5))])
    
    #-----< unknownEquipment >-----#
    unknownEquipment = CLASS(name=u'unknownEquipment', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownEquipment._val = dict([(u'errorCode', (u'local', 7))])
    
    #-----< roamingNotAllowed >-----#
    roamingNotAllowed = CLASS(name=u'roamingNotAllowed', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _roamingNotAllowed_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'RoamingNotAllowedCause')))
    roamingNotAllowed._val = dict([(u'ParameterType', _roamingNotAllowed_val_ParameterType), (u'errorCode', (u'local', 8))])
    
    #-----< illegalSubscriber >-----#
    illegalSubscriber = CLASS(name=u'illegalSubscriber', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    illegalSubscriber._val = dict([(u'errorCode', (u'local', 9))])
    
    #-----< illegalEquipment >-----#
    illegalEquipment = CLASS(name=u'illegalEquipment', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    illegalEquipment._val = dict([(u'errorCode', (u'local', 12))])
    
    #-----< bearerServiceNotProvisioned >-----#
    bearerServiceNotProvisioned = CLASS(name=u'bearerServiceNotProvisioned', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    bearerServiceNotProvisioned._val = dict([(u'errorCode', (u'local', 10))])
    
    #-----< teleserviceNotProvisioned >-----#
    teleserviceNotProvisioned = CLASS(name=u'teleserviceNotProvisioned', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    teleserviceNotProvisioned._val = dict([(u'errorCode', (u'local', 11))])
    
    #-----< invalidTargetBaseStation >-----#
    invalidTargetBaseStation = CLASS(name=u'invalidTargetBaseStation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    invalidTargetBaseStation._val = dict([(u'errorCode', (u'local', 23))])
    
    #-----< noRadioResourceAvailable >-----#
    noRadioResourceAvailable = CLASS(name=u'noRadioResourceAvailable', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    noRadioResourceAvailable._val = dict([(u'errorCode', (u'local', 24))])
    
    #-----< noHandoverNumberAvailable >-----#
    noHandoverNumberAvailable = CLASS(name=u'noHandoverNumberAvailable', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    noHandoverNumberAvailable._val = dict([(u'errorCode', (u'local', 25))])
    
    #-----< subsequentHandoverFailure >-----#
    subsequentHandoverFailure = CLASS(name=u'subsequentHandoverFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    subsequentHandoverFailure._val = dict([(u'errorCode', (u'local', 26))])
    
    #-----< tracingBufferFull >-----#
    tracingBufferFull = CLASS(name=u'tracingBufferFull', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    tracingBufferFull._val = dict([(u'errorCode', (u'local', 40))])
    
    #-----< noRoamingNumberAvailable >-----#
    noRoamingNumberAvailable = CLASS(name=u'noRoamingNumberAvailable', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    noRoamingNumberAvailable._val = dict([(u'errorCode', (u'local', 39))])
    
    #-----< Mwd-Set >-----#
    Mwd_Set = BOOL(name=u'Mwd-Set', mode=MODE_TYPE)
    
    #-----< absentSubscriber >-----#
    absentSubscriber = CLASS(name=u'absentSubscriber', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _absentSubscriber_val_ParameterType = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    absentSubscriber._val = dict([(u'ParameterType', _absentSubscriber_val_ParameterType), (u'errorCode', (u'local', 27))])
    
    #-----< callBarred >-----#
    callBarred = CLASS(name=u'callBarred', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _callBarred_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    callBarred._val = dict([(u'ParameterType', _callBarred_val_ParameterType), (u'errorCode', (u'local', 13))])
    
    #-----< forwardingViolation >-----#
    forwardingViolation = CLASS(name=u'forwardingViolation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    forwardingViolation._val = dict([(u'errorCode', (u'local', 14))])
    
    #-----< cug-Reject >-----#
    cug_Reject = CLASS(name=u'cug-Reject', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _cug_Reject_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CUG-RejectCause')))
    cug_Reject._val = dict([(u'ParameterType', _cug_Reject_val_ParameterType), (u'errorCode', (u'local', 15))])
    
    #-----< illegalSS-Operation >-----#
    illegalSS_Operation = CLASS(name=u'illegalSS-Operation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    illegalSS_Operation._val = dict([(u'errorCode', (u'local', 16))])
    
    #-----< ss-ErrorStatus >-----#
    ss_ErrorStatus = CLASS(name=u'ss-ErrorStatus', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _ss_ErrorStatus_val_ParameterType = OCT_STR(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')))
    ss_ErrorStatus._val = dict([(u'ParameterType', _ss_ErrorStatus_val_ParameterType), (u'errorCode', (u'local', 17))])
    
    #-----< ss-NotAvailable >-----#
    ss_NotAvailable = CLASS(name=u'ss-NotAvailable', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    ss_NotAvailable._val = dict([(u'errorCode', (u'local', 18))])
    
    #-----< ss-SubscriptionViolation >-----#
    ss_SubscriptionViolation = CLASS(name=u'ss-SubscriptionViolation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _ss_SubscriptionViolation_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')))
    ss_SubscriptionViolation._val = dict([(u'ParameterType', _ss_SubscriptionViolation_val_ParameterType), (u'errorCode', (u'local', 19))])
    
    #-----< ss-Incompatibility >-----#
    ss_Incompatibility = CLASS(name=u'ss-Incompatibility', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _ss_Incompatibility_val_ParameterType = SEQ(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SS-IncompatibilityCause')))
    ss_Incompatibility._val = dict([(u'ParameterType', _ss_Incompatibility_val_ParameterType), (u'errorCode', (u'local', 20))])
    
    #-----< unknownAlphabet >-----#
    unknownAlphabet = CLASS(name=u'unknownAlphabet', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownAlphabet._val = dict([(u'errorCode', (u'local', 71))])
    
    #-----< ussd-Busy >-----#
    ussd_Busy = CLASS(name=u'ussd-Busy', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    ussd_Busy._val = dict([(u'errorCode', (u'local', 72))])
    
    #-----< pw-RegistrationFailure >-----#
    pw_RegistrationFailure = CLASS(name=u'pw-RegistrationFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _pw_RegistrationFailure_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'PW-RegistrationFailureCause')))
    pw_RegistrationFailure._val = dict([(u'ParameterType', _pw_RegistrationFailure_val_ParameterType), (u'errorCode', (u'local', 37))])
    
    #-----< negativePW-Check >-----#
    negativePW_Check = CLASS(name=u'negativePW-Check', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    negativePW_Check._val = dict([(u'errorCode', (u'local', 38))])
    
    #-----< numberOfPW-AttemptsViolation >-----#
    numberOfPW_AttemptsViolation = CLASS(name=u'numberOfPW-AttemptsViolation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    numberOfPW_AttemptsViolation._val = dict([(u'errorCode', (u'local', 43))])
    
    #-----< subscriberBusyForMT-SMS >-----#
    subscriberBusyForMT_SMS = CLASS(name=u'subscriberBusyForMT-SMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    subscriberBusyForMT_SMS._val = dict([(u'errorCode', (u'local', 31))])
    
    #-----< sm-DeliveryFailure >-----#
    sm_DeliveryFailure = CLASS(name=u'sm-DeliveryFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _sm_DeliveryFailure_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-DeliveryFailureCause')))
    sm_DeliveryFailure._val = dict([(u'ParameterType', _sm_DeliveryFailure_val_ParameterType), (u'errorCode', (u'local', 32))])
    
    #-----< messageWaitingListFull >-----#
    messageWaitingListFull = CLASS(name=u'messageWaitingListFull', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    messageWaitingListFull._val = dict([(u'errorCode', (u'local', 33))])
    
    _all_ = [
        systemFailure,
        _systemFailure_val_ParameterType,
        dataMissing,
        unexpectedDataValue,
        facilityNotSupported,
        unknownSubscriber,
        numberChanged,
        unknownBaseStation,
        unknownMSC,
        unidentifiedSubscriber,
        unknownEquipment,
        roamingNotAllowed,
        _roamingNotAllowed_val_ParameterType,
        illegalSubscriber,
        illegalEquipment,
        bearerServiceNotProvisioned,
        teleserviceNotProvisioned,
        invalidTargetBaseStation,
        noRadioResourceAvailable,
        noHandoverNumberAvailable,
        subsequentHandoverFailure,
        tracingBufferFull,
        noRoamingNumberAvailable,
        Mwd_Set,
        absentSubscriber,
        _absentSubscriber_val_ParameterType,
        callBarred,
        _callBarred_val_ParameterType,
        forwardingViolation,
        cug_Reject,
        _cug_Reject_val_ParameterType,
        illegalSS_Operation,
        ss_ErrorStatus,
        _ss_ErrorStatus_val_ParameterType,
        ss_NotAvailable,
        ss_SubscriptionViolation,
        _ss_SubscriptionViolation_val_ParameterType,
        ss_Incompatibility,
        _ss_Incompatibility_val_ParameterType,
        unknownAlphabet,
        ussd_Busy,
        pw_RegistrationFailure,
        _pw_RegistrationFailure_val_ParameterType,
        negativePW_Check,
        numberOfPW_AttemptsViolation,
        subscriberBusyForMT_SMS,
        sm_DeliveryFailure,
        _sm_DeliveryFailure_val_ParameterType,
        messageWaitingListFull,
    ]

class MAPv2_OM_DataTypes:

    _name_  = u'MAPv2-OM-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 12, 2]
    
    _obj_ = [
        u'ActivateTraceModeArg',
        u'TraceReference',
        u'TraceType',
        u'DeactivateTraceModeArg',
        u'TraceSubscriberActivityArg',
        u'CallReference',
        u'NoteInternalHO-Arg',
        u'HandoverType',
        ]
    _type_ = [
        u'ActivateTraceModeArg',
        u'TraceReference',
        u'TraceType',
        u'DeactivateTraceModeArg',
        u'TraceSubscriberActivityArg',
        u'CallReference',
        u'NoteInternalHO-Arg',
        u'HandoverType',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< ActivateTraceModeArg >-----#
    ActivateTraceModeArg = SEQ(name=u'ActivateTraceModeArg', mode=MODE_TYPE)
    _ActivateTraceModeArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')), opt=True)
    _ActivateTraceModeArg_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceReference')))
    _ActivateTraceModeArg_traceType = INT(name=u'traceType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceType')))
    _ActivateTraceModeArg_omc_Id = OCT_STR(name=u'omc-Id', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')), opt=True)
    ActivateTraceModeArg._cont = ASN1Dict([
        (u'imsi', _ActivateTraceModeArg_imsi),
        (u'traceReference', _ActivateTraceModeArg_traceReference),
        (u'traceType', _ActivateTraceModeArg_traceType),
        (u'omc-Id', _ActivateTraceModeArg_omc_Id),
        ])
    ActivateTraceModeArg._ext = []
    
    #-----< TraceReference >-----#
    TraceReference = OCT_STR(name=u'TraceReference', mode=MODE_TYPE)
    TraceReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< TraceType >-----#
    TraceType = INT(name=u'TraceType', mode=MODE_TYPE)
    TraceType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< DeactivateTraceModeArg >-----#
    DeactivateTraceModeArg = SEQ(name=u'DeactivateTraceModeArg', mode=MODE_TYPE)
    _DeactivateTraceModeArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')), opt=True)
    _DeactivateTraceModeArg_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceReference')))
    DeactivateTraceModeArg._cont = ASN1Dict([
        (u'imsi', _DeactivateTraceModeArg_imsi),
        (u'traceReference', _DeactivateTraceModeArg_traceReference),
        ])
    DeactivateTraceModeArg._ext = []
    
    #-----< TraceSubscriberActivityArg >-----#
    TraceSubscriberActivityArg = SEQ(name=u'TraceSubscriberActivityArg', mode=MODE_TYPE)
    _TraceSubscriberActivityArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')), opt=True)
    _TraceSubscriberActivityArg_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceReference')))
    _TraceSubscriberActivityArg_traceType = INT(name=u'traceType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceType')))
    _TraceSubscriberActivityArg_omc_Id = OCT_STR(name=u'omc-Id', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')), opt=True)
    _TraceSubscriberActivityArg_callReference = OCT_STR(name=u'callReference', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'CallReference')), opt=True)
    TraceSubscriberActivityArg._cont = ASN1Dict([
        (u'imsi', _TraceSubscriberActivityArg_imsi),
        (u'traceReference', _TraceSubscriberActivityArg_traceReference),
        (u'traceType', _TraceSubscriberActivityArg_traceType),
        (u'omc-Id', _TraceSubscriberActivityArg_omc_Id),
        (u'callReference', _TraceSubscriberActivityArg_callReference),
        ])
    TraceSubscriberActivityArg._ext = None
    
    #-----< CallReference >-----#
    CallReference = OCT_STR(name=u'CallReference', mode=MODE_TYPE)
    CallReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< NoteInternalHO-Arg >-----#
    NoteInternalHO_Arg = SEQ(name=u'NoteInternalHO-Arg', mode=MODE_TYPE)
    _NoteInternalHO_Arg_handoverType = ENUM(name=u'handoverType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'HandoverType')))
    _NoteInternalHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'GlobalCellId')), opt=True)
    _NoteInternalHO_Arg_channelId = SEQ(name=u'channelId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    NoteInternalHO_Arg._cont = ASN1Dict([
        (u'handoverType', _NoteInternalHO_Arg_handoverType),
        (u'targetCellId', _NoteInternalHO_Arg_targetCellId),
        (u'channelId', _NoteInternalHO_Arg_channelId),
        ])
    NoteInternalHO_Arg._ext = None
    
    #-----< HandoverType >-----#
    HandoverType = ENUM(name=u'HandoverType', mode=MODE_TYPE)
    HandoverType._cont = ASN1Dict([(u'interBSS', 0), (u'intraBSS', 1)])
    HandoverType._ext = None
    
    _all_ = [
        _ActivateTraceModeArg_imsi,
        _ActivateTraceModeArg_traceReference,
        _ActivateTraceModeArg_traceType,
        _ActivateTraceModeArg_omc_Id,
        ActivateTraceModeArg,
        TraceReference,
        TraceType,
        _DeactivateTraceModeArg_imsi,
        _DeactivateTraceModeArg_traceReference,
        DeactivateTraceModeArg,
        _TraceSubscriberActivityArg_imsi,
        _TraceSubscriberActivityArg_traceReference,
        _TraceSubscriberActivityArg_traceType,
        _TraceSubscriberActivityArg_omc_Id,
        _TraceSubscriberActivityArg_callReference,
        TraceSubscriberActivityArg,
        CallReference,
        _NoteInternalHO_Arg_handoverType,
        _NoteInternalHO_Arg_targetCellId,
        _NoteInternalHO_Arg_channelId,
        NoteInternalHO_Arg,
        HandoverType,
    ]

class MAPv2_TS_Code:

    _name_  = u'MAPv2-TS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 19, 2]
    
    _obj_ = [
        u'TeleserviceCode',
        u'allTeleservices',
        u'allSpeechTransmissionServices',
        u'telephony',
        u'emergencyCalls',
        u'allShortMessageServices',
        u'shortMessageMT-PP',
        u'shortMessageMO-PP',
        u'allFacsimileTransmissionServices',
        u'facsimileGroup3AndAlterSpeech',
        u'automaticFacsimileGroup3',
        u'facsimileGroup4',
        u'allDataTeleservices',
        u'allTeleservices-ExeptSMS',
        u'allPLMN-specificTS',
        u'plmn-specificTS-1',
        u'plmn-specificTS-2',
        u'plmn-specificTS-3',
        u'plmn-specificTS-4',
        u'plmn-specificTS-5',
        u'plmn-specificTS-6',
        u'plmn-specificTS-7',
        u'plmn-specificTS-8',
        u'plmn-specificTS-9',
        u'plmn-specificTS-A',
        u'plmn-specificTS-B',
        u'plmn-specificTS-C',
        u'plmn-specificTS-D',
        u'plmn-specificTS-E',
        u'plmn-specificTS-F',
        ]
    _type_ = [
        u'TeleserviceCode',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allTeleservices',
        u'allSpeechTransmissionServices',
        u'telephony',
        u'emergencyCalls',
        u'allShortMessageServices',
        u'shortMessageMT-PP',
        u'shortMessageMO-PP',
        u'allFacsimileTransmissionServices',
        u'facsimileGroup3AndAlterSpeech',
        u'automaticFacsimileGroup3',
        u'facsimileGroup4',
        u'allDataTeleservices',
        u'allTeleservices-ExeptSMS',
        u'allPLMN-specificTS',
        u'plmn-specificTS-1',
        u'plmn-specificTS-2',
        u'plmn-specificTS-3',
        u'plmn-specificTS-4',
        u'plmn-specificTS-5',
        u'plmn-specificTS-6',
        u'plmn-specificTS-7',
        u'plmn-specificTS-8',
        u'plmn-specificTS-9',
        u'plmn-specificTS-A',
        u'plmn-specificTS-B',
        u'plmn-specificTS-C',
        u'plmn-specificTS-D',
        u'plmn-specificTS-E',
        u'plmn-specificTS-F',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< TeleserviceCode >-----#
    TeleserviceCode = OCT_STR(name=u'TeleserviceCode', mode=MODE_TYPE)
    TeleserviceCode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< allTeleservices >-----#
    allTeleservices = OCT_STR(name=u'allTeleservices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allTeleservices._val = b'\x00'
    
    #-----< allSpeechTransmissionServices >-----#
    allSpeechTransmissionServices = OCT_STR(name=u'allSpeechTransmissionServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allSpeechTransmissionServices._val = b'\x10'
    
    #-----< telephony >-----#
    telephony = OCT_STR(name=u'telephony', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    telephony._val = b'\x11'
    
    #-----< emergencyCalls >-----#
    emergencyCalls = OCT_STR(name=u'emergencyCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    emergencyCalls._val = b'\x12'
    
    #-----< allShortMessageServices >-----#
    allShortMessageServices = OCT_STR(name=u'allShortMessageServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allShortMessageServices._val = b' '
    
    #-----< shortMessageMT-PP >-----#
    shortMessageMT_PP = OCT_STR(name=u'shortMessageMT-PP', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    shortMessageMT_PP._val = b'!'
    
    #-----< shortMessageMO-PP >-----#
    shortMessageMO_PP = OCT_STR(name=u'shortMessageMO-PP', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    shortMessageMO_PP._val = b'"'
    
    #-----< allFacsimileTransmissionServices >-----#
    allFacsimileTransmissionServices = OCT_STR(name=u'allFacsimileTransmissionServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allFacsimileTransmissionServices._val = b'`'
    
    #-----< facsimileGroup3AndAlterSpeech >-----#
    facsimileGroup3AndAlterSpeech = OCT_STR(name=u'facsimileGroup3AndAlterSpeech', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    facsimileGroup3AndAlterSpeech._val = b'a'
    
    #-----< automaticFacsimileGroup3 >-----#
    automaticFacsimileGroup3 = OCT_STR(name=u'automaticFacsimileGroup3', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    automaticFacsimileGroup3._val = b'b'
    
    #-----< facsimileGroup4 >-----#
    facsimileGroup4 = OCT_STR(name=u'facsimileGroup4', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    facsimileGroup4._val = b'c'
    
    #-----< allDataTeleservices >-----#
    allDataTeleservices = OCT_STR(name=u'allDataTeleservices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allDataTeleservices._val = b'p'
    
    #-----< allTeleservices-ExeptSMS >-----#
    allTeleservices_ExeptSMS = OCT_STR(name=u'allTeleservices-ExeptSMS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allTeleservices_ExeptSMS._val = b'\x80'
    
    #-----< allPLMN-specificTS >-----#
    allPLMN_specificTS = OCT_STR(name=u'allPLMN-specificTS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    allPLMN_specificTS._val = b'\xd0'
    
    #-----< plmn-specificTS-1 >-----#
    plmn_specificTS_1 = OCT_STR(name=u'plmn-specificTS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_1._val = b'\xd1'
    
    #-----< plmn-specificTS-2 >-----#
    plmn_specificTS_2 = OCT_STR(name=u'plmn-specificTS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_2._val = b'\xd2'
    
    #-----< plmn-specificTS-3 >-----#
    plmn_specificTS_3 = OCT_STR(name=u'plmn-specificTS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_3._val = b'\xd3'
    
    #-----< plmn-specificTS-4 >-----#
    plmn_specificTS_4 = OCT_STR(name=u'plmn-specificTS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_4._val = b'\xd4'
    
    #-----< plmn-specificTS-5 >-----#
    plmn_specificTS_5 = OCT_STR(name=u'plmn-specificTS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_5._val = b'\xd5'
    
    #-----< plmn-specificTS-6 >-----#
    plmn_specificTS_6 = OCT_STR(name=u'plmn-specificTS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_6._val = b'\xd6'
    
    #-----< plmn-specificTS-7 >-----#
    plmn_specificTS_7 = OCT_STR(name=u'plmn-specificTS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_7._val = b'\xd7'
    
    #-----< plmn-specificTS-8 >-----#
    plmn_specificTS_8 = OCT_STR(name=u'plmn-specificTS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_8._val = b'\xd8'
    
    #-----< plmn-specificTS-9 >-----#
    plmn_specificTS_9 = OCT_STR(name=u'plmn-specificTS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_9._val = b'\xd9'
    
    #-----< plmn-specificTS-A >-----#
    plmn_specificTS_A = OCT_STR(name=u'plmn-specificTS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_A._val = b'\xda'
    
    #-----< plmn-specificTS-B >-----#
    plmn_specificTS_B = OCT_STR(name=u'plmn-specificTS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_B._val = b'\xdb'
    
    #-----< plmn-specificTS-C >-----#
    plmn_specificTS_C = OCT_STR(name=u'plmn-specificTS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_C._val = b'\xdc'
    
    #-----< plmn-specificTS-D >-----#
    plmn_specificTS_D = OCT_STR(name=u'plmn-specificTS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_D._val = b'\xdd'
    
    #-----< plmn-specificTS-E >-----#
    plmn_specificTS_E = OCT_STR(name=u'plmn-specificTS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_E._val = b'\xde'
    
    #-----< plmn-specificTS-F >-----#
    plmn_specificTS_F = OCT_STR(name=u'plmn-specificTS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_F._val = b'\xdf'
    
    _all_ = [
        TeleserviceCode,
        allTeleservices,
        allSpeechTransmissionServices,
        telephony,
        emergencyCalls,
        allShortMessageServices,
        shortMessageMT_PP,
        shortMessageMO_PP,
        allFacsimileTransmissionServices,
        facsimileGroup3AndAlterSpeech,
        automaticFacsimileGroup3,
        facsimileGroup4,
        allDataTeleservices,
        allTeleservices_ExeptSMS,
        allPLMN_specificTS,
        plmn_specificTS_1,
        plmn_specificTS_2,
        plmn_specificTS_3,
        plmn_specificTS_4,
        plmn_specificTS_5,
        plmn_specificTS_6,
        plmn_specificTS_7,
        plmn_specificTS_8,
        plmn_specificTS_9,
        plmn_specificTS_A,
        plmn_specificTS_B,
        plmn_specificTS_C,
        plmn_specificTS_D,
        plmn_specificTS_E,
        plmn_specificTS_F,
    ]

class MAPv2_SS_DataTypes:

    _name_  = u'MAPv2-SS-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 14, 2]
    
    _obj_ = [
        u'RegisterSS-Arg',
        u'NoReplyConditionTime',
        u'SS-Info',
        u'ForwardingInfo',
        u'ForwardingFeatureList',
        u'ForwardingFeature',
        u'SS-Status',
        u'ForwardingOptions',
        u'CallBarringInfo',
        u'CallBarringFeatureList',
        u'CallBarringFeature',
        u'CUG-Info',
        u'CUG-SubscriptionList',
        u'CUG-Subscription',
        u'CUG-Index',
        u'CUG-Interlock',
        u'IntraCUG-Options',
        u'maxNumOfCUG',
        u'CUG-FeatureList',
        u'CUG-Feature',
        u'InterCUG-Restrictions',
        u'SS-Data',
        u'SS-SubscriptionOption',
        u'CliRestrictionOption',
        u'OverrideCategory',
        u'SS-ForBS-Code',
        u'Cli-RestrictionInfo',
        u'InterrogateSS-Res',
        u'SS-UserData',
        u'USSD-Arg',
        u'USSD-Res',
        u'USSD-DataCodingScheme',
        u'USSD-String',
        u'maxUSSD-StringLength',
        u'Password',
        u'GuidanceInfo',
        u'BeginSubscriberActivityArg',
        u'SS-List',
        u'maxNumOfSS',
        u'SS-InfoList',
        u'ForwardingData',
        ]
    _type_ = [
        u'RegisterSS-Arg',
        u'NoReplyConditionTime',
        u'SS-Info',
        u'ForwardingInfo',
        u'ForwardingFeatureList',
        u'ForwardingFeature',
        u'SS-Status',
        u'ForwardingOptions',
        u'CallBarringInfo',
        u'CallBarringFeatureList',
        u'CallBarringFeature',
        u'CUG-Info',
        u'CUG-SubscriptionList',
        u'CUG-Subscription',
        u'CUG-Index',
        u'CUG-Interlock',
        u'IntraCUG-Options',
        u'CUG-FeatureList',
        u'CUG-Feature',
        u'InterCUG-Restrictions',
        u'SS-Data',
        u'SS-SubscriptionOption',
        u'CliRestrictionOption',
        u'OverrideCategory',
        u'SS-ForBS-Code',
        u'Cli-RestrictionInfo',
        u'InterrogateSS-Res',
        u'SS-UserData',
        u'USSD-Arg',
        u'USSD-Res',
        u'USSD-DataCodingScheme',
        u'USSD-String',
        u'Password',
        u'GuidanceInfo',
        u'BeginSubscriberActivityArg',
        u'SS-List',
        u'SS-InfoList',
        u'ForwardingData',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxNumOfCUG',
        u'maxUSSD-StringLength',
        u'maxNumOfSS',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< RegisterSS-Arg >-----#
    RegisterSS_Arg = SEQ(name=u'RegisterSS-Arg', mode=MODE_TYPE)
    _RegisterSS_Arg_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    _RegisterSS_Arg_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _RegisterSS_Arg_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')), opt=True)
    _RegisterSS_Arg_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _RegisterSS_Arg_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'NoReplyConditionTime')), opt=True)
    RegisterSS_Arg._cont = ASN1Dict([
        (u'ss-Code', _RegisterSS_Arg_ss_Code),
        (u'basicService', _RegisterSS_Arg_basicService),
        (u'forwardedToNumber', _RegisterSS_Arg_forwardedToNumber),
        (u'forwardedToSubaddress', _RegisterSS_Arg_forwardedToSubaddress),
        (u'noReplyConditionTime', _RegisterSS_Arg_noReplyConditionTime),
        ])
    RegisterSS_Arg._ext = []
    
    #-----< NoReplyConditionTime >-----#
    NoReplyConditionTime = INT(name=u'NoReplyConditionTime', mode=MODE_TYPE)
    NoReplyConditionTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=30)], ev=None, er=[])
    
    #-----< SS-Info >-----#
    SS_Info = CHOICE(name=u'SS-Info', mode=MODE_TYPE)
    _SS_Info_forwardingInfo = SEQ(name=u'forwardingInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingInfo')))
    _SS_Info_callBarringInfo = SEQ(name=u'callBarringInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CallBarringInfo')))
    _SS_Info_cug_Info = SEQ(name=u'cug-Info', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Info')))
    _SS_Info_ss_Data = SEQ(name=u'ss-Data', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Data')))
    SS_Info._cont = ASN1Dict([
        (u'forwardingInfo', _SS_Info_forwardingInfo),
        (u'callBarringInfo', _SS_Info_callBarringInfo),
        (u'cug-Info', _SS_Info_cug_Info),
        (u'ss-Data', _SS_Info_ss_Data),
        ])
    SS_Info._ext = None
    
    #-----< ForwardingInfo >-----#
    ForwardingInfo = SEQ(name=u'ForwardingInfo', mode=MODE_TYPE)
    _ForwardingInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')), opt=True)
    _ForwardingInfo_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingFeatureList')))
    ForwardingInfo._cont = ASN1Dict([
        (u'ss-Code', _ForwardingInfo_ss_Code),
        (u'forwardingFeatureList', _ForwardingInfo_forwardingFeatureList),
        ])
    ForwardingInfo._ext = []
    
    #-----< ForwardingFeatureList >-----#
    ForwardingFeatureList = SEQ_OF(name=u'ForwardingFeatureList', mode=MODE_TYPE)
    _ForwardingFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingFeature')))
    ForwardingFeatureList._cont = _ForwardingFeatureList__item_
    ForwardingFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< ForwardingFeature >-----#
    ForwardingFeature = SEQ(name=u'ForwardingFeature', mode=MODE_TYPE)
    _ForwardingFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _ForwardingFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')), opt=True)
    _ForwardingFeature_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ForwardingFeature_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _ForwardingFeature_forwardingOptions = OCT_STR(name=u'forwardingOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingOptions')), opt=True)
    _ForwardingFeature_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'NoReplyConditionTime')), opt=True)
    ForwardingFeature._cont = ASN1Dict([
        (u'basicService', _ForwardingFeature_basicService),
        (u'ss-Status', _ForwardingFeature_ss_Status),
        (u'forwardedToNumber', _ForwardingFeature_forwardedToNumber),
        (u'forwardedToSubaddress', _ForwardingFeature_forwardedToSubaddress),
        (u'forwardingOptions', _ForwardingFeature_forwardingOptions),
        (u'noReplyConditionTime', _ForwardingFeature_noReplyConditionTime),
        ])
    ForwardingFeature._ext = []
    
    #-----< SS-Status >-----#
    SS_Status = OCT_STR(name=u'SS-Status', mode=MODE_TYPE)
    SS_Status._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ForwardingOptions >-----#
    ForwardingOptions = OCT_STR(name=u'ForwardingOptions', mode=MODE_TYPE)
    ForwardingOptions._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< CallBarringInfo >-----#
    CallBarringInfo = SEQ(name=u'CallBarringInfo', mode=MODE_TYPE)
    _CallBarringInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')), opt=True)
    _CallBarringInfo_callBarringFeatureList = SEQ_OF(name=u'callBarringFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CallBarringFeatureList')))
    CallBarringInfo._cont = ASN1Dict([
        (u'ss-Code', _CallBarringInfo_ss_Code),
        (u'callBarringFeatureList', _CallBarringInfo_callBarringFeatureList),
        ])
    CallBarringInfo._ext = []
    
    #-----< CallBarringFeatureList >-----#
    CallBarringFeatureList = SEQ_OF(name=u'CallBarringFeatureList', mode=MODE_TYPE)
    _CallBarringFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CallBarringFeature')))
    CallBarringFeatureList._cont = _CallBarringFeatureList__item_
    CallBarringFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< CallBarringFeature >-----#
    CallBarringFeature = SEQ(name=u'CallBarringFeature', mode=MODE_TYPE)
    _CallBarringFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _CallBarringFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')), opt=True)
    CallBarringFeature._cont = ASN1Dict([
        (u'basicService', _CallBarringFeature_basicService),
        (u'ss-Status', _CallBarringFeature_ss_Status),
        ])
    CallBarringFeature._ext = []
    
    #-----< CUG-Info >-----#
    CUG_Info = SEQ(name=u'CUG-Info', mode=MODE_TYPE)
    _CUG_Info_cug_SubscriptionList = SEQ_OF(name=u'cug-SubscriptionList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-SubscriptionList')))
    _CUG_Info_cug_FeatureList = SEQ_OF(name=u'cug-FeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-FeatureList')), opt=True)
    CUG_Info._cont = ASN1Dict([
        (u'cug-SubscriptionList', _CUG_Info_cug_SubscriptionList),
        (u'cug-FeatureList', _CUG_Info_cug_FeatureList),
        ])
    CUG_Info._ext = []
    
    #-----< CUG-SubscriptionList >-----#
    CUG_SubscriptionList = SEQ_OF(name=u'CUG-SubscriptionList', mode=MODE_TYPE)
    _CUG_SubscriptionList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Subscription')))
    CUG_SubscriptionList._cont = _CUG_SubscriptionList__item_
    CUG_SubscriptionList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< CUG-Subscription >-----#
    CUG_Subscription = SEQ(name=u'CUG-Subscription', mode=MODE_TYPE)
    _CUG_Subscription_cug_Index = INT(name=u'cug-Index', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Index')))
    _CUG_Subscription_cug_Interlock = OCT_STR(name=u'cug-Interlock', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Interlock')))
    _CUG_Subscription_intraCUG_Options = ENUM(name=u'intraCUG-Options', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'IntraCUG-Options')))
    _CUG_Subscription_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceGroupList')), opt=True)
    CUG_Subscription._cont = ASN1Dict([
        (u'cug-Index', _CUG_Subscription_cug_Index),
        (u'cug-Interlock', _CUG_Subscription_cug_Interlock),
        (u'intraCUG-Options', _CUG_Subscription_intraCUG_Options),
        (u'basicServiceGroupList', _CUG_Subscription_basicServiceGroupList),
        ])
    CUG_Subscription._ext = []
    
    #-----< CUG-Index >-----#
    CUG_Index = INT(name=u'CUG-Index', mode=MODE_TYPE)
    CUG_Index._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    
    #-----< CUG-Interlock >-----#
    CUG_Interlock = OCT_STR(name=u'CUG-Interlock', mode=MODE_TYPE)
    CUG_Interlock._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< IntraCUG-Options >-----#
    IntraCUG_Options = ENUM(name=u'IntraCUG-Options', mode=MODE_TYPE)
    IntraCUG_Options._cont = ASN1Dict([(u'noCUG-Restrictions', 0), (u'cugIC-CallBarred', 1), (u'cugOG-CallBarred', 2)])
    IntraCUG_Options._ext = None
    
    #-----< maxNumOfCUG >-----#
    maxNumOfCUG = INT(name=u'maxNumOfCUG', mode=MODE_VALUE)
    maxNumOfCUG._val = 10
    
    #-----< CUG-FeatureList >-----#
    CUG_FeatureList = SEQ_OF(name=u'CUG-FeatureList', mode=MODE_TYPE)
    _CUG_FeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Feature')))
    CUG_FeatureList._cont = _CUG_FeatureList__item_
    CUG_FeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< CUG-Feature >-----#
    CUG_Feature = SEQ(name=u'CUG-Feature', mode=MODE_TYPE)
    _CUG_Feature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _CUG_Feature_preferentialCUG_Indicator = INT(name=u'preferentialCUG-Indicator', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CUG-Index')), opt=True)
    _CUG_Feature_interCUG_Restrictions = OCT_STR(name=u'interCUG-Restrictions', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'InterCUG-Restrictions')))
    CUG_Feature._cont = ASN1Dict([
        (u'basicService', _CUG_Feature_basicService),
        (u'preferentialCUG-Indicator', _CUG_Feature_preferentialCUG_Indicator),
        (u'interCUG-Restrictions', _CUG_Feature_interCUG_Restrictions),
        ])
    CUG_Feature._ext = []
    
    #-----< InterCUG-Restrictions >-----#
    InterCUG_Restrictions = OCT_STR(name=u'InterCUG-Restrictions', mode=MODE_TYPE)
    InterCUG_Restrictions._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SS-Data >-----#
    SS_Data = SEQ(name=u'SS-Data', mode=MODE_TYPE)
    _SS_Data_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')), opt=True)
    _SS_Data_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')), opt=True)
    _SS_Data_ss_SubscriptionOption = CHOICE(name=u'ss-SubscriptionOption', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')), opt=True)
    _SS_Data_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceGroupList')), opt=True)
    SS_Data._cont = ASN1Dict([
        (u'ss-Code', _SS_Data_ss_Code),
        (u'ss-Status', _SS_Data_ss_Status),
        (u'ss-SubscriptionOption', _SS_Data_ss_SubscriptionOption),
        (u'basicServiceGroupList', _SS_Data_basicServiceGroupList),
        ])
    SS_Data._ext = []
    
    #-----< SS-SubscriptionOption >-----#
    SS_SubscriptionOption = CHOICE(name=u'SS-SubscriptionOption', mode=MODE_TYPE)
    _SS_SubscriptionOption_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CliRestrictionOption')))
    _SS_SubscriptionOption_overrideCategory = ENUM(name=u'overrideCategory', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'OverrideCategory')))
    SS_SubscriptionOption._cont = ASN1Dict([
        (u'cliRestrictionOption', _SS_SubscriptionOption_cliRestrictionOption),
        (u'overrideCategory', _SS_SubscriptionOption_overrideCategory),
        ])
    SS_SubscriptionOption._ext = None
    
    #-----< CliRestrictionOption >-----#
    CliRestrictionOption = ENUM(name=u'CliRestrictionOption', mode=MODE_TYPE)
    CliRestrictionOption._cont = ASN1Dict([(u'permanent', 0), (u'temporaryDefaultRestricted', 1), (u'temporaryDefaultAllowed', 2)])
    CliRestrictionOption._ext = None
    
    #-----< OverrideCategory >-----#
    OverrideCategory = ENUM(name=u'OverrideCategory', mode=MODE_TYPE)
    OverrideCategory._cont = ASN1Dict([(u'overrideEnabled', 0), (u'overrideDisabled', 1)])
    OverrideCategory._ext = None
    
    #-----< SS-ForBS-Code >-----#
    SS_ForBS_Code = SEQ(name=u'SS-ForBS-Code', mode=MODE_TYPE)
    _SS_ForBS_Code_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    _SS_ForBS_Code_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceCode')), opt=True)
    SS_ForBS_Code._cont = ASN1Dict([
        (u'ss-Code', _SS_ForBS_Code_ss_Code),
        (u'basicService', _SS_ForBS_Code_basicService),
        ])
    SS_ForBS_Code._ext = []
    
    #-----< Cli-RestrictionInfo >-----#
    Cli_RestrictionInfo = SEQ(name=u'Cli-RestrictionInfo', mode=MODE_TYPE)
    _Cli_RestrictionInfo_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')))
    _Cli_RestrictionInfo_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'CliRestrictionOption')), opt=True)
    Cli_RestrictionInfo._cont = ASN1Dict([
        (u'ss-Status', _Cli_RestrictionInfo_ss_Status),
        (u'cliRestrictionOption', _Cli_RestrictionInfo_cliRestrictionOption),
        ])
    Cli_RestrictionInfo._ext = []
    
    #-----< InterrogateSS-Res >-----#
    InterrogateSS_Res = CHOICE(name=u'InterrogateSS-Res', mode=MODE_TYPE)
    _InterrogateSS_Res_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')))
    _InterrogateSS_Res_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _InterrogateSS_Res_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'BasicServiceGroupList')))
    _InterrogateSS_Res_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingFeatureList')))
    _InterrogateSS_Res_cli_RestrictionInfo = SEQ(name=u'cli-RestrictionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Cli-RestrictionInfo')))
    InterrogateSS_Res._cont = ASN1Dict([
        (u'ss-Status', _InterrogateSS_Res_ss_Status),
        (u'forwardedToNumber', _InterrogateSS_Res_forwardedToNumber),
        (u'basicServiceGroupList', _InterrogateSS_Res_basicServiceGroupList),
        (u'forwardingFeatureList', _InterrogateSS_Res_forwardingFeatureList),
        (u'cli-RestrictionInfo', _InterrogateSS_Res_cli_RestrictionInfo),
        ])
    InterrogateSS_Res._ext = None
    
    #-----< SS-UserData >-----#
    SS_UserData = STR_IA5(name=u'SS-UserData', mode=MODE_TYPE)
    SS_UserData._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    
    #-----< USSD-Arg >-----#
    USSD_Arg = SEQ(name=u'USSD-Arg', mode=MODE_TYPE)
    _USSD_Arg_ussd_DataCodingScheme = OCT_STR(name=u'ussd-DataCodingScheme', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-DataCodingScheme')))
    _USSD_Arg_ussd_String = OCT_STR(name=u'ussd-String', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-String')))
    USSD_Arg._cont = ASN1Dict([
        (u'ussd-DataCodingScheme', _USSD_Arg_ussd_DataCodingScheme),
        (u'ussd-String', _USSD_Arg_ussd_String),
        ])
    USSD_Arg._ext = []
    
    #-----< USSD-Res >-----#
    USSD_Res = SEQ(name=u'USSD-Res', mode=MODE_TYPE)
    _USSD_Res_ussd_DataCodingScheme = OCT_STR(name=u'ussd-DataCodingScheme', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-DataCodingScheme')))
    _USSD_Res_ussd_String = OCT_STR(name=u'ussd-String', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-String')))
    USSD_Res._cont = ASN1Dict([
        (u'ussd-DataCodingScheme', _USSD_Res_ussd_DataCodingScheme),
        (u'ussd-String', _USSD_Res_ussd_String),
        ])
    USSD_Res._ext = []
    
    #-----< USSD-DataCodingScheme >-----#
    USSD_DataCodingScheme = OCT_STR(name=u'USSD-DataCodingScheme', mode=MODE_TYPE)
    USSD_DataCodingScheme._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< USSD-String >-----#
    USSD_String = OCT_STR(name=u'USSD-String', mode=MODE_TYPE)
    USSD_String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=160)], ev=None, er=[])
    
    #-----< maxUSSD-StringLength >-----#
    maxUSSD_StringLength = INT(name=u'maxUSSD-StringLength', mode=MODE_VALUE)
    maxUSSD_StringLength._val = 160
    
    #-----< Password >-----#
    Password = STR_NUM(name=u'Password', mode=MODE_TYPE)
    Password._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    Password._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    
    #-----< GuidanceInfo >-----#
    GuidanceInfo = ENUM(name=u'GuidanceInfo', mode=MODE_TYPE)
    GuidanceInfo._cont = ASN1Dict([(u'enterPW', 0), (u'enterNewPW', 1), (u'enterNewPW-Again', 2), (u'badPW-TryAgain', 3), (u'badPW-FormatTryAgain', 4)])
    GuidanceInfo._ext = None
    
    #-----< BeginSubscriberActivityArg >-----#
    BeginSubscriberActivityArg = SEQ(name=u'BeginSubscriberActivityArg', mode=MODE_TYPE)
    _BeginSubscriberActivityArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _BeginSubscriberActivityArg_originatingEntityNumber = OCT_STR(name=u'originatingEntityNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    BeginSubscriberActivityArg._cont = ASN1Dict([
        (u'imsi', _BeginSubscriberActivityArg_imsi),
        (u'originatingEntityNumber', _BeginSubscriberActivityArg_originatingEntityNumber),
        ])
    BeginSubscriberActivityArg._ext = None
    
    #-----< SS-List >-----#
    SS_List = SEQ_OF(name=u'SS-List', mode=MODE_TYPE)
    _SS_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    SS_List._cont = _SS_List__item_
    SS_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    
    #-----< maxNumOfSS >-----#
    maxNumOfSS = INT(name=u'maxNumOfSS', mode=MODE_VALUE)
    maxNumOfSS._val = 30
    
    #-----< SS-InfoList >-----#
    SS_InfoList = SEQ_OF(name=u'SS-InfoList', mode=MODE_TYPE)
    _SS_InfoList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    SS_InfoList._cont = _SS_InfoList__item_
    SS_InfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    
    #-----< ForwardingData >-----#
    ForwardingData = SEQ(name=u'ForwardingData', mode=MODE_TYPE)
    _ForwardingData_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ForwardingData_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _ForwardingData_forwardingOptions = OCT_STR(name=u'forwardingOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'ForwardingOptions')), opt=True)
    ForwardingData._cont = ASN1Dict([
        (u'forwardedToNumber', _ForwardingData_forwardedToNumber),
        (u'forwardedToSubaddress', _ForwardingData_forwardedToSubaddress),
        (u'forwardingOptions', _ForwardingData_forwardingOptions),
        ])
    ForwardingData._ext = []
    
    _all_ = [
        _RegisterSS_Arg_ss_Code,
        _RegisterSS_Arg_basicService,
        _RegisterSS_Arg_forwardedToNumber,
        _RegisterSS_Arg_forwardedToSubaddress,
        _RegisterSS_Arg_noReplyConditionTime,
        RegisterSS_Arg,
        NoReplyConditionTime,
        _SS_Info_forwardingInfo,
        _SS_Info_callBarringInfo,
        _SS_Info_cug_Info,
        _SS_Info_ss_Data,
        SS_Info,
        _ForwardingInfo_ss_Code,
        _ForwardingInfo_forwardingFeatureList,
        ForwardingInfo,
        _ForwardingFeatureList__item_,
        ForwardingFeatureList,
        _ForwardingFeature_basicService,
        _ForwardingFeature_ss_Status,
        _ForwardingFeature_forwardedToNumber,
        _ForwardingFeature_forwardedToSubaddress,
        _ForwardingFeature_forwardingOptions,
        _ForwardingFeature_noReplyConditionTime,
        ForwardingFeature,
        SS_Status,
        ForwardingOptions,
        _CallBarringInfo_ss_Code,
        _CallBarringInfo_callBarringFeatureList,
        CallBarringInfo,
        _CallBarringFeatureList__item_,
        CallBarringFeatureList,
        _CallBarringFeature_basicService,
        _CallBarringFeature_ss_Status,
        CallBarringFeature,
        _CUG_Info_cug_SubscriptionList,
        _CUG_Info_cug_FeatureList,
        CUG_Info,
        _CUG_SubscriptionList__item_,
        CUG_SubscriptionList,
        _CUG_Subscription_cug_Index,
        _CUG_Subscription_cug_Interlock,
        _CUG_Subscription_intraCUG_Options,
        _CUG_Subscription_basicServiceGroupList,
        CUG_Subscription,
        CUG_Index,
        CUG_Interlock,
        IntraCUG_Options,
        maxNumOfCUG,
        _CUG_FeatureList__item_,
        CUG_FeatureList,
        _CUG_Feature_basicService,
        _CUG_Feature_preferentialCUG_Indicator,
        _CUG_Feature_interCUG_Restrictions,
        CUG_Feature,
        InterCUG_Restrictions,
        _SS_Data_ss_Code,
        _SS_Data_ss_Status,
        _SS_Data_ss_SubscriptionOption,
        _SS_Data_basicServiceGroupList,
        SS_Data,
        _SS_SubscriptionOption_cliRestrictionOption,
        _SS_SubscriptionOption_overrideCategory,
        SS_SubscriptionOption,
        CliRestrictionOption,
        OverrideCategory,
        _SS_ForBS_Code_ss_Code,
        _SS_ForBS_Code_basicService,
        SS_ForBS_Code,
        _Cli_RestrictionInfo_ss_Status,
        _Cli_RestrictionInfo_cliRestrictionOption,
        Cli_RestrictionInfo,
        _InterrogateSS_Res_ss_Status,
        _InterrogateSS_Res_forwardedToNumber,
        _InterrogateSS_Res_basicServiceGroupList,
        _InterrogateSS_Res_forwardingFeatureList,
        _InterrogateSS_Res_cli_RestrictionInfo,
        InterrogateSS_Res,
        SS_UserData,
        _USSD_Arg_ussd_DataCodingScheme,
        _USSD_Arg_ussd_String,
        USSD_Arg,
        _USSD_Res_ussd_DataCodingScheme,
        _USSD_Res_ussd_String,
        USSD_Res,
        USSD_DataCodingScheme,
        USSD_String,
        maxUSSD_StringLength,
        Password,
        GuidanceInfo,
        _BeginSubscriberActivityArg_imsi,
        _BeginSubscriberActivityArg_originatingEntityNumber,
        BeginSubscriberActivityArg,
        _SS_List__item_,
        SS_List,
        maxNumOfSS,
        _SS_InfoList__item_,
        SS_InfoList,
        _ForwardingData_forwardedToNumber,
        _ForwardingData_forwardedToSubaddress,
        _ForwardingData_forwardingOptions,
        ForwardingData,
    ]

class MAPv2_SM_DataTypes:

    _name_  = u'MAPv2-SM-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 16, 2]
    
    _obj_ = [
        u'RoutingInfoForSM-Arg',
        u'RoutingInfoForSM-Res',
        u'LocationInfoWithLMSI',
        u'ForwardSM-Arg',
        u'SM-RP-DA',
        u'SM-RP-OA',
        u'ReportSM-DeliveryStatusArg',
        u'SM-DeliveryOutcome',
        u'AlertServiceCentreArg',
        u'InformServiceCentreArg',
        u'MW-Status',
        u'ReadyForSM-Arg',
        u'AlertReason',
        ]
    _type_ = [
        u'RoutingInfoForSM-Arg',
        u'RoutingInfoForSM-Res',
        u'LocationInfoWithLMSI',
        u'ForwardSM-Arg',
        u'SM-RP-DA',
        u'SM-RP-OA',
        u'ReportSM-DeliveryStatusArg',
        u'SM-DeliveryOutcome',
        u'AlertServiceCentreArg',
        u'InformServiceCentreArg',
        u'MW-Status',
        u'ReadyForSM-Arg',
        u'AlertReason',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< RoutingInfoForSM-Arg >-----#
    RoutingInfoForSM_Arg = SEQ(name=u'RoutingInfoForSM-Arg', mode=MODE_TYPE)
    _RoutingInfoForSM_Arg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _RoutingInfoForSM_Arg_sm_RP_PRI = BOOL(name=u'sm-RP-PRI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _RoutingInfoForSM_Arg_serviceCentreAddress = OCT_STR(name=u'serviceCentreAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    _RoutingInfoForSM_Arg_teleservice = OCT_STR(name=u'teleservice', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-TS-Code', 'TeleserviceCode')), opt=True)
    RoutingInfoForSM_Arg._cont = ASN1Dict([
        (u'msisdn', _RoutingInfoForSM_Arg_msisdn),
        (u'sm-RP-PRI', _RoutingInfoForSM_Arg_sm_RP_PRI),
        (u'serviceCentreAddress', _RoutingInfoForSM_Arg_serviceCentreAddress),
        (u'teleservice', _RoutingInfoForSM_Arg_teleservice),
        ])
    RoutingInfoForSM_Arg._ext = []
    
    #-----< RoutingInfoForSM-Res >-----#
    RoutingInfoForSM_Res = SEQ(name=u'RoutingInfoForSM-Res', mode=MODE_TYPE)
    _RoutingInfoForSM_Res_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _RoutingInfoForSM_Res_locationInfoWithLMSI = SEQ(name=u'locationInfoWithLMSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'LocationInfoWithLMSI')))
    _RoutingInfoForSM_Res_mwd_Set = BOOL(name=u'mwd-Set', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    RoutingInfoForSM_Res._cont = ASN1Dict([
        (u'imsi', _RoutingInfoForSM_Res_imsi),
        (u'locationInfoWithLMSI', _RoutingInfoForSM_Res_locationInfoWithLMSI),
        (u'mwd-Set', _RoutingInfoForSM_Res_mwd_Set),
        ])
    RoutingInfoForSM_Res._ext = []
    
    #-----< LocationInfoWithLMSI >-----#
    LocationInfoWithLMSI = SEQ(name=u'LocationInfoWithLMSI', mode=MODE_TYPE)
    _LocationInfoWithLMSI_locationInfo = CHOICE(name=u'locationInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LocationInfo')))
    _LocationInfoWithLMSI_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')), opt=True)
    LocationInfoWithLMSI._cont = ASN1Dict([
        (u'locationInfo', _LocationInfoWithLMSI_locationInfo),
        (u'lmsi', _LocationInfoWithLMSI_lmsi),
        ])
    LocationInfoWithLMSI._ext = []
    
    #-----< ForwardSM-Arg >-----#
    ForwardSM_Arg = SEQ(name=u'ForwardSM-Arg', mode=MODE_TYPE)
    _ForwardSM_Arg_sm_RP_DA = CHOICE(name=u'sm-RP-DA', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'SM-RP-DA')))
    _ForwardSM_Arg_sm_RP_OA = CHOICE(name=u'sm-RP-OA', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'SM-RP-OA')))
    _ForwardSM_Arg_sm_RP_UI = OCT_STR(name=u'sm-RP-UI', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'SignalInfo')))
    _ForwardSM_Arg_moreMessagesToSend = NULL(name=u'moreMessagesToSend', mode=MODE_TYPE, opt=True)
    ForwardSM_Arg._cont = ASN1Dict([
        (u'sm-RP-DA', _ForwardSM_Arg_sm_RP_DA),
        (u'sm-RP-OA', _ForwardSM_Arg_sm_RP_OA),
        (u'sm-RP-UI', _ForwardSM_Arg_sm_RP_UI),
        (u'moreMessagesToSend', _ForwardSM_Arg_moreMessagesToSend),
        ])
    ForwardSM_Arg._ext = []
    
    #-----< SM-RP-DA >-----#
    SM_RP_DA = CHOICE(name=u'SM-RP-DA', mode=MODE_TYPE)
    _SM_RP_DA_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _SM_RP_DA_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'LMSI')))
    _SM_RP_DA_roamingNumber = OCT_STR(name=u'roamingNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _SM_RP_DA_serviceCentreAddressDA = OCT_STR(name=u'serviceCentreAddressDA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    _SM_RP_DA_noSM_RP_DA = NULL(name=u'noSM-RP-DA', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    SM_RP_DA._cont = ASN1Dict([
        (u'imsi', _SM_RP_DA_imsi),
        (u'lmsi', _SM_RP_DA_lmsi),
        (u'roamingNumber', _SM_RP_DA_roamingNumber),
        (u'serviceCentreAddressDA', _SM_RP_DA_serviceCentreAddressDA),
        (u'noSM-RP-DA', _SM_RP_DA_noSM_RP_DA),
        ])
    SM_RP_DA._ext = None
    
    #-----< SM-RP-OA >-----#
    SM_RP_OA = CHOICE(name=u'SM-RP-OA', mode=MODE_TYPE)
    _SM_RP_OA_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _SM_RP_OA_serviceCentreAddressOA = OCT_STR(name=u'serviceCentreAddressOA', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    _SM_RP_OA_noSM_RP_OA = NULL(name=u'noSM-RP-OA', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    SM_RP_OA._cont = ASN1Dict([
        (u'msisdn', _SM_RP_OA_msisdn),
        (u'serviceCentreAddressOA', _SM_RP_OA_serviceCentreAddressOA),
        (u'noSM-RP-OA', _SM_RP_OA_noSM_RP_OA),
        ])
    SM_RP_OA._ext = None
    
    #-----< ReportSM-DeliveryStatusArg >-----#
    ReportSM_DeliveryStatusArg = SEQ(name=u'ReportSM-DeliveryStatusArg', mode=MODE_TYPE)
    _ReportSM_DeliveryStatusArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _ReportSM_DeliveryStatusArg_serviceCentreAddress = OCT_STR(name=u'serviceCentreAddress', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    _ReportSM_DeliveryStatusArg_sm_DeliveryOutcome = ENUM(name=u'sm-DeliveryOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'SM-DeliveryOutcome')), opt=True)
    ReportSM_DeliveryStatusArg._cont = ASN1Dict([
        (u'msisdn', _ReportSM_DeliveryStatusArg_msisdn),
        (u'serviceCentreAddress', _ReportSM_DeliveryStatusArg_serviceCentreAddress),
        (u'sm-DeliveryOutcome', _ReportSM_DeliveryStatusArg_sm_DeliveryOutcome),
        ])
    ReportSM_DeliveryStatusArg._ext = []
    
    #-----< SM-DeliveryOutcome >-----#
    SM_DeliveryOutcome = ENUM(name=u'SM-DeliveryOutcome', mode=MODE_TYPE)
    SM_DeliveryOutcome._cont = ASN1Dict([(u'memoryCapacityExceeded', 0), (u'absentSubscriber', 1), (u'successfulTransfer', 2)])
    SM_DeliveryOutcome._ext = None
    
    #-----< AlertServiceCentreArg >-----#
    AlertServiceCentreArg = SEQ(name=u'AlertServiceCentreArg', mode=MODE_TYPE)
    _AlertServiceCentreArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _AlertServiceCentreArg_serviceCentreAddress = OCT_STR(name=u'serviceCentreAddress', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'AddressString')))
    AlertServiceCentreArg._cont = ASN1Dict([
        (u'msisdn', _AlertServiceCentreArg_msisdn),
        (u'serviceCentreAddress', _AlertServiceCentreArg_serviceCentreAddress),
        ])
    AlertServiceCentreArg._ext = []
    
    #-----< InformServiceCentreArg >-----#
    InformServiceCentreArg = SEQ(name=u'InformServiceCentreArg', mode=MODE_TYPE)
    _InformServiceCentreArg_storedMSISDN = OCT_STR(name=u'storedMSISDN', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _InformServiceCentreArg_mw_Status = BIT_STR(name=u'mw-Status', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'MW-Status')), opt=True)
    InformServiceCentreArg._cont = ASN1Dict([
        (u'storedMSISDN', _InformServiceCentreArg_storedMSISDN),
        (u'mw-Status', _InformServiceCentreArg_mw_Status),
        ])
    InformServiceCentreArg._ext = []
    
    #-----< MW-Status >-----#
    MW_Status = BIT_STR(name=u'MW-Status', mode=MODE_TYPE)
    MW_Status._cont = ASN1Dict([(u'sc-AddressNotIncluded', 0), (u'mnrf-Set', 1), (u'mcef-Set', 2)])
    MW_Status._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< ReadyForSM-Arg >-----#
    ReadyForSM_Arg = SEQ(name=u'ReadyForSM-Arg', mode=MODE_TYPE)
    _ReadyForSM_Arg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _ReadyForSM_Arg_alertReason = ENUM(name=u'alertReason', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'AlertReason')))
    ReadyForSM_Arg._cont = ASN1Dict([
        (u'imsi', _ReadyForSM_Arg_imsi),
        (u'alertReason', _ReadyForSM_Arg_alertReason),
        ])
    ReadyForSM_Arg._ext = []
    
    #-----< AlertReason >-----#
    AlertReason = ENUM(name=u'AlertReason', mode=MODE_TYPE)
    AlertReason._cont = ASN1Dict([(u'ms-Present', 0), (u'memoryAvailable', 1)])
    AlertReason._ext = None
    
    _all_ = [
        _RoutingInfoForSM_Arg_msisdn,
        _RoutingInfoForSM_Arg_sm_RP_PRI,
        _RoutingInfoForSM_Arg_serviceCentreAddress,
        _RoutingInfoForSM_Arg_teleservice,
        RoutingInfoForSM_Arg,
        _RoutingInfoForSM_Res_imsi,
        _RoutingInfoForSM_Res_locationInfoWithLMSI,
        _RoutingInfoForSM_Res_mwd_Set,
        RoutingInfoForSM_Res,
        _LocationInfoWithLMSI_locationInfo,
        _LocationInfoWithLMSI_lmsi,
        LocationInfoWithLMSI,
        _ForwardSM_Arg_sm_RP_DA,
        _ForwardSM_Arg_sm_RP_OA,
        _ForwardSM_Arg_sm_RP_UI,
        _ForwardSM_Arg_moreMessagesToSend,
        ForwardSM_Arg,
        _SM_RP_DA_imsi,
        _SM_RP_DA_lmsi,
        _SM_RP_DA_roamingNumber,
        _SM_RP_DA_serviceCentreAddressDA,
        _SM_RP_DA_noSM_RP_DA,
        SM_RP_DA,
        _SM_RP_OA_msisdn,
        _SM_RP_OA_serviceCentreAddressOA,
        _SM_RP_OA_noSM_RP_OA,
        SM_RP_OA,
        _ReportSM_DeliveryStatusArg_msisdn,
        _ReportSM_DeliveryStatusArg_serviceCentreAddress,
        _ReportSM_DeliveryStatusArg_sm_DeliveryOutcome,
        ReportSM_DeliveryStatusArg,
        SM_DeliveryOutcome,
        _AlertServiceCentreArg_msisdn,
        _AlertServiceCentreArg_serviceCentreAddress,
        AlertServiceCentreArg,
        _InformServiceCentreArg_storedMSISDN,
        _InformServiceCentreArg_mw_Status,
        InformServiceCentreArg,
        MW_Status,
        _ReadyForSM_Arg_imsi,
        _ReadyForSM_Arg_alertReason,
        ReadyForSM_Arg,
        AlertReason,
    ]

class MAPv2_ShortMessageServiceOperations:

    _name_  = u'MAPv2-ShortMessageServiceOperations'
    _oid_   = []
    
    _obj_ = [
        u'sendRoutingInfoForSM',
        u'forwardSM',
        u'reportSM-DeliveryStatus',
        u'noteSubscriberPresent',
        u'alertServiceCentreWithoutResult',
        u'alertServiceCentre',
        u'informServiceCentre',
        u'readyForSM',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'sendRoutingInfoForSM',
        u'forwardSM',
        u'reportSM-DeliveryStatus',
        u'noteSubscriberPresent',
        u'alertServiceCentreWithoutResult',
        u'alertServiceCentre',
        u'informServiceCentre',
        u'readyForSM',
        ]
    _class_ = [
        u'sendRoutingInfoForSM',
        u'forwardSM',
        u'reportSM-DeliveryStatus',
        u'noteSubscriberPresent',
        u'alertServiceCentreWithoutResult',
        u'alertServiceCentre',
        u'informServiceCentre',
        u'readyForSM',
        ]
    _param_ = [
        ]
    
    #-----< sendRoutingInfoForSM >-----#
    sendRoutingInfoForSM = CLASS(name=u'sendRoutingInfoForSM', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendRoutingInfoForSM_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'RoutingInfoForSM-Arg')))
    _sendRoutingInfoForSM_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'RoutingInfoForSM-Res')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    __OPERATION_Errors_val_ParameterType_6 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_7 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    sendRoutingInfoForSM._val = dict([(u'ArgumentType', _sendRoutingInfoForSM_val_ArgumentType), (u'ResultType', _sendRoutingInfoForSM_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 27))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_7), (u'errorCode', (u'local', 13))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 45))])
    
    #-----< forwardSM >-----#
    forwardSM = CLASS(name=u'forwardSM', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _forwardSM_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ForwardSM-Arg')))
    __OPERATION_Errors_val_ParameterType_7_0 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_9 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-DeliveryFailureCause')))
    forwardSM._val = dict([(u'ArgumentType', _forwardSM_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_7_0), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 31))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 32))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 46))])
    
    #-----< reportSM-DeliveryStatus >-----#
    reportSM_DeliveryStatus = CLASS(name=u'reportSM-DeliveryStatus', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _reportSM_DeliveryStatus_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ReportSM-DeliveryStatusArg')))
    _reportSM_DeliveryStatus_val_ResultType = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    reportSM_DeliveryStatus._val = dict([(u'ArgumentType', _reportSM_DeliveryStatus_val_ArgumentType), (u'ResultType', _reportSM_DeliveryStatus_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 33))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 47))])
    
    #-----< noteSubscriberPresent >-----#
    noteSubscriberPresent = CLASS(name=u'noteSubscriberPresent', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _noteSubscriberPresent_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    noteSubscriberPresent._val = dict([(u'ArgumentType', _noteSubscriberPresent_val_ArgumentType), (u'operationCode', (u'local', 48))])
    
    #-----< alertServiceCentreWithoutResult >-----#
    alertServiceCentreWithoutResult = CLASS(name=u'alertServiceCentreWithoutResult', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _alertServiceCentreWithoutResult_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'AlertServiceCentreArg')))
    alertServiceCentreWithoutResult._val = dict([(u'ArgumentType', _alertServiceCentreWithoutResult_val_ArgumentType), (u'operationCode', (u'local', 49))])
    
    #-----< alertServiceCentre >-----#
    alertServiceCentre = CLASS(name=u'alertServiceCentre', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _alertServiceCentre_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'AlertServiceCentreArg')))
    alertServiceCentre._val = dict([(u'ArgumentType', _alertServiceCentre_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 64))])
    
    #-----< informServiceCentre >-----#
    informServiceCentre = CLASS(name=u'informServiceCentre', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _informServiceCentre_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'InformServiceCentreArg')))
    informServiceCentre._val = dict([(u'ArgumentType', _informServiceCentre_val_ArgumentType), (u'operationCode', (u'local', 63))])
    
    #-----< readyForSM >-----#
    readyForSM = CLASS(name=u'readyForSM', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _readyForSM_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ReadyForSM-Arg')))
    readyForSM._val = dict([(u'ArgumentType', _readyForSM_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 66))])
    
    _all_ = [
        sendRoutingInfoForSM,
        _sendRoutingInfoForSM_val_ArgumentType,
        _sendRoutingInfoForSM_val_ResultType,
        __OPERATION_Errors_val_ParameterType_0,
        __OPERATION_Errors_val_ParameterType_6,
        __OPERATION_Errors_val_ParameterType_7,
        forwardSM,
        _forwardSM_val_ArgumentType,
        __OPERATION_Errors_val_ParameterType_7_0,
        __OPERATION_Errors_val_ParameterType_9,
        reportSM_DeliveryStatus,
        _reportSM_DeliveryStatus_val_ArgumentType,
        _reportSM_DeliveryStatus_val_ResultType,
        noteSubscriberPresent,
        _noteSubscriberPresent_val_ArgumentType,
        alertServiceCentreWithoutResult,
        _alertServiceCentreWithoutResult_val_ArgumentType,
        alertServiceCentre,
        _alertServiceCentre_val_ArgumentType,
        informServiceCentre,
        _informServiceCentre_val_ArgumentType,
        readyForSM,
        _readyForSM_val_ArgumentType,
    ]

class MAPv2_BS_Code:

    _name_  = u'MAPv2-BS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 20, 2]
    
    _obj_ = [
        u'BearerServiceCode',
        u'allBearerServices',
        u'allDataCDA-Services',
        u'dataCDA-300bps',
        u'dataCDA-1200bps',
        u'dataCDA-1200-75bps',
        u'dataCDA-2400bps',
        u'dataCDA-4800bps',
        u'dataCDA-9600bps',
        u'allDataCDS-Services',
        u'dataCDS-1200bps',
        u'dataCDS-2400bps',
        u'dataCDS-4800bps',
        u'dataCDS-9600bps',
        u'allPadAccessCA-Services',
        u'padAccessCA-300bps',
        u'padAccessCA-1200bps',
        u'padAccessCA-1200-75bps',
        u'padAccessCA-2400bps',
        u'padAccessCA-4800bps',
        u'padAccessCA-9600bps',
        u'allDataPDS-Services',
        u'dataPDS-2400bps',
        u'dataPDS-4800bps',
        u'dataPDS-9600bps',
        u'allAlternateSpeech-DataCDA',
        u'allAlternateSpeech-DataCDS',
        u'allSpeechFollowedByDataCDA',
        u'allSpeechFollowedByDataCDS',
        u'allDataCircuitAsynchronous',
        u'allAsynchronousServices',
        u'allDataCircuitSynchronous',
        u'allSynchronousServices',
        u'allPLMN-specificBS',
        u'plmn-specificBS-1',
        u'plmn-specificBS-2',
        u'plmn-specificBS-3',
        u'plmn-specificBS-4',
        u'plmn-specificBS-5',
        u'plmn-specificBS-6',
        u'plmn-specificBS-7',
        u'plmn-specificBS-8',
        u'plmn-specificBS-9',
        u'plmn-specificBS-A',
        u'plmn-specificBS-B',
        u'plmn-specificBS-C',
        u'plmn-specificBS-D',
        u'plmn-specificBS-E',
        u'plmn-specificBS-F',
        ]
    _type_ = [
        u'BearerServiceCode',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allBearerServices',
        u'allDataCDA-Services',
        u'dataCDA-300bps',
        u'dataCDA-1200bps',
        u'dataCDA-1200-75bps',
        u'dataCDA-2400bps',
        u'dataCDA-4800bps',
        u'dataCDA-9600bps',
        u'allDataCDS-Services',
        u'dataCDS-1200bps',
        u'dataCDS-2400bps',
        u'dataCDS-4800bps',
        u'dataCDS-9600bps',
        u'allPadAccessCA-Services',
        u'padAccessCA-300bps',
        u'padAccessCA-1200bps',
        u'padAccessCA-1200-75bps',
        u'padAccessCA-2400bps',
        u'padAccessCA-4800bps',
        u'padAccessCA-9600bps',
        u'allDataPDS-Services',
        u'dataPDS-2400bps',
        u'dataPDS-4800bps',
        u'dataPDS-9600bps',
        u'allAlternateSpeech-DataCDA',
        u'allAlternateSpeech-DataCDS',
        u'allSpeechFollowedByDataCDA',
        u'allSpeechFollowedByDataCDS',
        u'allDataCircuitAsynchronous',
        u'allAsynchronousServices',
        u'allDataCircuitSynchronous',
        u'allSynchronousServices',
        u'allPLMN-specificBS',
        u'plmn-specificBS-1',
        u'plmn-specificBS-2',
        u'plmn-specificBS-3',
        u'plmn-specificBS-4',
        u'plmn-specificBS-5',
        u'plmn-specificBS-6',
        u'plmn-specificBS-7',
        u'plmn-specificBS-8',
        u'plmn-specificBS-9',
        u'plmn-specificBS-A',
        u'plmn-specificBS-B',
        u'plmn-specificBS-C',
        u'plmn-specificBS-D',
        u'plmn-specificBS-E',
        u'plmn-specificBS-F',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< BearerServiceCode >-----#
    BearerServiceCode = OCT_STR(name=u'BearerServiceCode', mode=MODE_TYPE)
    BearerServiceCode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< allBearerServices >-----#
    allBearerServices = OCT_STR(name=u'allBearerServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allBearerServices._val = b'\x00'
    
    #-----< allDataCDA-Services >-----#
    allDataCDA_Services = OCT_STR(name=u'allDataCDA-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allDataCDA_Services._val = b'\x10'
    
    #-----< dataCDA-300bps >-----#
    dataCDA_300bps = OCT_STR(name=u'dataCDA-300bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_300bps._val = b'\x11'
    
    #-----< dataCDA-1200bps >-----#
    dataCDA_1200bps = OCT_STR(name=u'dataCDA-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_1200bps._val = b'\x12'
    
    #-----< dataCDA-1200-75bps >-----#
    dataCDA_1200_75bps = OCT_STR(name=u'dataCDA-1200-75bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_1200_75bps._val = b'\x13'
    
    #-----< dataCDA-2400bps >-----#
    dataCDA_2400bps = OCT_STR(name=u'dataCDA-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_2400bps._val = b'\x14'
    
    #-----< dataCDA-4800bps >-----#
    dataCDA_4800bps = OCT_STR(name=u'dataCDA-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_4800bps._val = b'\x15'
    
    #-----< dataCDA-9600bps >-----#
    dataCDA_9600bps = OCT_STR(name=u'dataCDA-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDA_9600bps._val = b'\x16'
    
    #-----< allDataCDS-Services >-----#
    allDataCDS_Services = OCT_STR(name=u'allDataCDS-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allDataCDS_Services._val = b'\x18'
    
    #-----< dataCDS-1200bps >-----#
    dataCDS_1200bps = OCT_STR(name=u'dataCDS-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDS_1200bps._val = b'\x1a'
    
    #-----< dataCDS-2400bps >-----#
    dataCDS_2400bps = OCT_STR(name=u'dataCDS-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDS_2400bps._val = b'\x1c'
    
    #-----< dataCDS-4800bps >-----#
    dataCDS_4800bps = OCT_STR(name=u'dataCDS-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDS_4800bps._val = b'\x1d'
    
    #-----< dataCDS-9600bps >-----#
    dataCDS_9600bps = OCT_STR(name=u'dataCDS-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataCDS_9600bps._val = b'\x1e'
    
    #-----< allPadAccessCA-Services >-----#
    allPadAccessCA_Services = OCT_STR(name=u'allPadAccessCA-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allPadAccessCA_Services._val = b' '
    
    #-----< padAccessCA-300bps >-----#
    padAccessCA_300bps = OCT_STR(name=u'padAccessCA-300bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_300bps._val = b'!'
    
    #-----< padAccessCA-1200bps >-----#
    padAccessCA_1200bps = OCT_STR(name=u'padAccessCA-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_1200bps._val = b'"'
    
    #-----< padAccessCA-1200-75bps >-----#
    padAccessCA_1200_75bps = OCT_STR(name=u'padAccessCA-1200-75bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_1200_75bps._val = b'#'
    
    #-----< padAccessCA-2400bps >-----#
    padAccessCA_2400bps = OCT_STR(name=u'padAccessCA-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_2400bps._val = b'$'
    
    #-----< padAccessCA-4800bps >-----#
    padAccessCA_4800bps = OCT_STR(name=u'padAccessCA-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_4800bps._val = b'%'
    
    #-----< padAccessCA-9600bps >-----#
    padAccessCA_9600bps = OCT_STR(name=u'padAccessCA-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    padAccessCA_9600bps._val = b'&'
    
    #-----< allDataPDS-Services >-----#
    allDataPDS_Services = OCT_STR(name=u'allDataPDS-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allDataPDS_Services._val = b'('
    
    #-----< dataPDS-2400bps >-----#
    dataPDS_2400bps = OCT_STR(name=u'dataPDS-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataPDS_2400bps._val = b','
    
    #-----< dataPDS-4800bps >-----#
    dataPDS_4800bps = OCT_STR(name=u'dataPDS-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataPDS_4800bps._val = b'-'
    
    #-----< dataPDS-9600bps >-----#
    dataPDS_9600bps = OCT_STR(name=u'dataPDS-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    dataPDS_9600bps._val = b'.'
    
    #-----< allAlternateSpeech-DataCDA >-----#
    allAlternateSpeech_DataCDA = OCT_STR(name=u'allAlternateSpeech-DataCDA', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allAlternateSpeech_DataCDA._val = b'0'
    
    #-----< allAlternateSpeech-DataCDS >-----#
    allAlternateSpeech_DataCDS = OCT_STR(name=u'allAlternateSpeech-DataCDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allAlternateSpeech_DataCDS._val = b'8'
    
    #-----< allSpeechFollowedByDataCDA >-----#
    allSpeechFollowedByDataCDA = OCT_STR(name=u'allSpeechFollowedByDataCDA', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allSpeechFollowedByDataCDA._val = b'@'
    
    #-----< allSpeechFollowedByDataCDS >-----#
    allSpeechFollowedByDataCDS = OCT_STR(name=u'allSpeechFollowedByDataCDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allSpeechFollowedByDataCDS._val = b'H'
    
    #-----< allDataCircuitAsynchronous >-----#
    allDataCircuitAsynchronous = OCT_STR(name=u'allDataCircuitAsynchronous', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allDataCircuitAsynchronous._val = b'P'
    
    #-----< allAsynchronousServices >-----#
    allAsynchronousServices = OCT_STR(name=u'allAsynchronousServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allAsynchronousServices._val = b'`'
    
    #-----< allDataCircuitSynchronous >-----#
    allDataCircuitSynchronous = OCT_STR(name=u'allDataCircuitSynchronous', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allDataCircuitSynchronous._val = b'X'
    
    #-----< allSynchronousServices >-----#
    allSynchronousServices = OCT_STR(name=u'allSynchronousServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allSynchronousServices._val = b'h'
    
    #-----< allPLMN-specificBS >-----#
    allPLMN_specificBS = OCT_STR(name=u'allPLMN-specificBS', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    allPLMN_specificBS._val = b'\xd0'
    
    #-----< plmn-specificBS-1 >-----#
    plmn_specificBS_1 = OCT_STR(name=u'plmn-specificBS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_1._val = b'\xd1'
    
    #-----< plmn-specificBS-2 >-----#
    plmn_specificBS_2 = OCT_STR(name=u'plmn-specificBS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_2._val = b'\xd2'
    
    #-----< plmn-specificBS-3 >-----#
    plmn_specificBS_3 = OCT_STR(name=u'plmn-specificBS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_3._val = b'\xd3'
    
    #-----< plmn-specificBS-4 >-----#
    plmn_specificBS_4 = OCT_STR(name=u'plmn-specificBS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_4._val = b'\xd4'
    
    #-----< plmn-specificBS-5 >-----#
    plmn_specificBS_5 = OCT_STR(name=u'plmn-specificBS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_5._val = b'\xd5'
    
    #-----< plmn-specificBS-6 >-----#
    plmn_specificBS_6 = OCT_STR(name=u'plmn-specificBS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_6._val = b'\xd6'
    
    #-----< plmn-specificBS-7 >-----#
    plmn_specificBS_7 = OCT_STR(name=u'plmn-specificBS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_7._val = b'\xd7'
    
    #-----< plmn-specificBS-8 >-----#
    plmn_specificBS_8 = OCT_STR(name=u'plmn-specificBS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_8._val = b'\xd8'
    
    #-----< plmn-specificBS-9 >-----#
    plmn_specificBS_9 = OCT_STR(name=u'plmn-specificBS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_9._val = b'\xd9'
    
    #-----< plmn-specificBS-A >-----#
    plmn_specificBS_A = OCT_STR(name=u'plmn-specificBS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_A._val = b'\xda'
    
    #-----< plmn-specificBS-B >-----#
    plmn_specificBS_B = OCT_STR(name=u'plmn-specificBS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_B._val = b'\xdb'
    
    #-----< plmn-specificBS-C >-----#
    plmn_specificBS_C = OCT_STR(name=u'plmn-specificBS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_C._val = b'\xdc'
    
    #-----< plmn-specificBS-D >-----#
    plmn_specificBS_D = OCT_STR(name=u'plmn-specificBS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_D._val = b'\xdd'
    
    #-----< plmn-specificBS-E >-----#
    plmn_specificBS_E = OCT_STR(name=u'plmn-specificBS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_E._val = b'\xde'
    
    #-----< plmn-specificBS-F >-----#
    plmn_specificBS_F = OCT_STR(name=u'plmn-specificBS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAPv2-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_F._val = b'\xdf'
    
    _all_ = [
        BearerServiceCode,
        allBearerServices,
        allDataCDA_Services,
        dataCDA_300bps,
        dataCDA_1200bps,
        dataCDA_1200_75bps,
        dataCDA_2400bps,
        dataCDA_4800bps,
        dataCDA_9600bps,
        allDataCDS_Services,
        dataCDS_1200bps,
        dataCDS_2400bps,
        dataCDS_4800bps,
        dataCDS_9600bps,
        allPadAccessCA_Services,
        padAccessCA_300bps,
        padAccessCA_1200bps,
        padAccessCA_1200_75bps,
        padAccessCA_2400bps,
        padAccessCA_4800bps,
        padAccessCA_9600bps,
        allDataPDS_Services,
        dataPDS_2400bps,
        dataPDS_4800bps,
        dataPDS_9600bps,
        allAlternateSpeech_DataCDA,
        allAlternateSpeech_DataCDS,
        allSpeechFollowedByDataCDA,
        allSpeechFollowedByDataCDS,
        allDataCircuitAsynchronous,
        allAsynchronousServices,
        allDataCircuitSynchronous,
        allSynchronousServices,
        allPLMN_specificBS,
        plmn_specificBS_1,
        plmn_specificBS_2,
        plmn_specificBS_3,
        plmn_specificBS_4,
        plmn_specificBS_5,
        plmn_specificBS_6,
        plmn_specificBS_7,
        plmn_specificBS_8,
        plmn_specificBS_9,
        plmn_specificBS_A,
        plmn_specificBS_B,
        plmn_specificBS_C,
        plmn_specificBS_D,
        plmn_specificBS_E,
        plmn_specificBS_F,
    ]

class MAPv2_ApplicationContexts:

    _name_  = u'MAPv2-ApplicationContexts'
    _oid_   = [0, 4, 0, 0, 1, 3, 2, 2]
    
    _obj_ = [
        u'map-ac',
        u'networkLocUpContext-v2',
        u'networkLocUpContext-v1',
        u'locationCancellation-v2',
        u'locationCancellation-v1',
        u'roamingNumberEnquiryContext-v2',
        u'roamingNumberEnquiryContext-v1',
        u'locationInfoRetrievalContext-v2',
        u'locationInfoRetrievalContext-v1',
        u'resetContext-v2',
        u'resetContext-v1',
        u'handoverControlContext-v2',
        u'handoverControlContext-v1',
        u'equipmentMngtContext-v2',
        u'equipmentMngtContext-v1',
        u'infoRetrievalContext-v2',
        u'infoRetrievalContext-v1',
        u'interVlrInfoRetrievalContext-v2',
        u'subscriberDataMngtContext-v2',
        u'subscriberDataMngtContext-v1',
        u'tracingContext-v2',
        u'tracingContext-v1',
        u'networkFunctionalSsContext-v2',
        u'networkFunctionalSsContext-v1',
        u'networkUnstructuredSsContext-v2',
        u'shortMsgGatewayContext-v2',
        u'shortMsgGatewayContext-v1',
        u'shortMsgMO-RelayContext-v2',
        u'shortMsgRelayContext-v1',
        u'shortMsgAlertContext-v2',
        u'shortMsgAlertContext-v1',
        u'mwdMngtContext-v2',
        u'mwdMngtContext-v1',
        u'shortMsgMT-RelayContext-v2',
        u'imsiRetrievalContext-v2',
        u'msPurgingContext-v2',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'map-ac',
        u'networkLocUpContext-v2',
        u'networkLocUpContext-v1',
        u'locationCancellation-v2',
        u'locationCancellation-v1',
        u'roamingNumberEnquiryContext-v2',
        u'roamingNumberEnquiryContext-v1',
        u'locationInfoRetrievalContext-v2',
        u'locationInfoRetrievalContext-v1',
        u'resetContext-v2',
        u'resetContext-v1',
        u'handoverControlContext-v2',
        u'handoverControlContext-v1',
        u'equipmentMngtContext-v2',
        u'equipmentMngtContext-v1',
        u'infoRetrievalContext-v2',
        u'infoRetrievalContext-v1',
        u'interVlrInfoRetrievalContext-v2',
        u'subscriberDataMngtContext-v2',
        u'subscriberDataMngtContext-v1',
        u'tracingContext-v2',
        u'tracingContext-v1',
        u'networkFunctionalSsContext-v2',
        u'networkFunctionalSsContext-v1',
        u'networkUnstructuredSsContext-v2',
        u'shortMsgGatewayContext-v2',
        u'shortMsgGatewayContext-v1',
        u'shortMsgMO-RelayContext-v2',
        u'shortMsgRelayContext-v1',
        u'shortMsgAlertContext-v2',
        u'shortMsgAlertContext-v1',
        u'mwdMngtContext-v2',
        u'mwdMngtContext-v1',
        u'shortMsgMT-RelayContext-v2',
        u'imsiRetrievalContext-v2',
        u'msPurgingContext-v2',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< map-ac >-----#
    map_ac = OID(name=u'map-ac', mode=MODE_VALUE)
    map_ac._val = (0, 4, 0, 0, 1, 0)
    
    #-----< networkLocUpContext-v2 >-----#
    networkLocUpContext_v2 = OID(name=u'networkLocUpContext-v2', mode=MODE_VALUE)
    networkLocUpContext_v2._val = (0, 4, 0, 0, 1, 0, 1, 2)
    
    #-----< networkLocUpContext-v1 >-----#
    networkLocUpContext_v1 = OID(name=u'networkLocUpContext-v1', mode=MODE_VALUE)
    networkLocUpContext_v1._val = (0, 4, 0, 0, 1, 0, 1, 1)
    
    #-----< locationCancellation-v2 >-----#
    locationCancellation_v2 = OID(name=u'locationCancellation-v2', mode=MODE_VALUE)
    locationCancellation_v2._val = (0, 4, 0, 0, 1, 0, 2, 2)
    
    #-----< locationCancellation-v1 >-----#
    locationCancellation_v1 = OID(name=u'locationCancellation-v1', mode=MODE_VALUE)
    locationCancellation_v1._val = (0, 4, 0, 0, 1, 0, 2, 1)
    
    #-----< roamingNumberEnquiryContext-v2 >-----#
    roamingNumberEnquiryContext_v2 = OID(name=u'roamingNumberEnquiryContext-v2', mode=MODE_VALUE)
    roamingNumberEnquiryContext_v2._val = (0, 4, 0, 0, 1, 0, 3, 2)
    
    #-----< roamingNumberEnquiryContext-v1 >-----#
    roamingNumberEnquiryContext_v1 = OID(name=u'roamingNumberEnquiryContext-v1', mode=MODE_VALUE)
    roamingNumberEnquiryContext_v1._val = (0, 4, 0, 0, 1, 0, 3, 1)
    
    #-----< locationInfoRetrievalContext-v2 >-----#
    locationInfoRetrievalContext_v2 = OID(name=u'locationInfoRetrievalContext-v2', mode=MODE_VALUE)
    locationInfoRetrievalContext_v2._val = (0, 4, 0, 0, 1, 0, 5, 2)
    
    #-----< locationInfoRetrievalContext-v1 >-----#
    locationInfoRetrievalContext_v1 = OID(name=u'locationInfoRetrievalContext-v1', mode=MODE_VALUE)
    locationInfoRetrievalContext_v1._val = (0, 4, 0, 0, 1, 0, 5, 1)
    
    #-----< resetContext-v2 >-----#
    resetContext_v2 = OID(name=u'resetContext-v2', mode=MODE_VALUE)
    resetContext_v2._val = (0, 4, 0, 0, 1, 0, 10, 2)
    
    #-----< resetContext-v1 >-----#
    resetContext_v1 = OID(name=u'resetContext-v1', mode=MODE_VALUE)
    resetContext_v1._val = (0, 4, 0, 0, 1, 0, 10, 1)
    
    #-----< handoverControlContext-v2 >-----#
    handoverControlContext_v2 = OID(name=u'handoverControlContext-v2', mode=MODE_VALUE)
    handoverControlContext_v2._val = (0, 4, 0, 0, 1, 0, 11, 2)
    
    #-----< handoverControlContext-v1 >-----#
    handoverControlContext_v1 = OID(name=u'handoverControlContext-v1', mode=MODE_VALUE)
    handoverControlContext_v1._val = (0, 4, 0, 0, 1, 0, 11, 1)
    
    #-----< equipmentMngtContext-v2 >-----#
    equipmentMngtContext_v2 = OID(name=u'equipmentMngtContext-v2', mode=MODE_VALUE)
    equipmentMngtContext_v2._val = (0, 4, 0, 0, 1, 0, 13, 2)
    
    #-----< equipmentMngtContext-v1 >-----#
    equipmentMngtContext_v1 = OID(name=u'equipmentMngtContext-v1', mode=MODE_VALUE)
    equipmentMngtContext_v1._val = (0, 4, 0, 0, 1, 0, 13, 1)
    
    #-----< infoRetrievalContext-v2 >-----#
    infoRetrievalContext_v2 = OID(name=u'infoRetrievalContext-v2', mode=MODE_VALUE)
    infoRetrievalContext_v2._val = (0, 4, 0, 0, 1, 0, 14, 2)
    
    #-----< infoRetrievalContext-v1 >-----#
    infoRetrievalContext_v1 = OID(name=u'infoRetrievalContext-v1', mode=MODE_VALUE)
    infoRetrievalContext_v1._val = (0, 4, 0, 0, 1, 0, 14, 1)
    
    #-----< interVlrInfoRetrievalContext-v2 >-----#
    interVlrInfoRetrievalContext_v2 = OID(name=u'interVlrInfoRetrievalContext-v2', mode=MODE_VALUE)
    interVlrInfoRetrievalContext_v2._val = (0, 4, 0, 0, 1, 0, 15, 2)
    
    #-----< subscriberDataMngtContext-v2 >-----#
    subscriberDataMngtContext_v2 = OID(name=u'subscriberDataMngtContext-v2', mode=MODE_VALUE)
    subscriberDataMngtContext_v2._val = (0, 4, 0, 0, 1, 0, 16, 2)
    
    #-----< subscriberDataMngtContext-v1 >-----#
    subscriberDataMngtContext_v1 = OID(name=u'subscriberDataMngtContext-v1', mode=MODE_VALUE)
    subscriberDataMngtContext_v1._val = (0, 4, 0, 0, 1, 0, 16, 1)
    
    #-----< tracingContext-v2 >-----#
    tracingContext_v2 = OID(name=u'tracingContext-v2', mode=MODE_VALUE)
    tracingContext_v2._val = (0, 4, 0, 0, 1, 0, 17, 2)
    
    #-----< tracingContext-v1 >-----#
    tracingContext_v1 = OID(name=u'tracingContext-v1', mode=MODE_VALUE)
    tracingContext_v1._val = (0, 4, 0, 0, 1, 0, 17, 1)
    
    #-----< networkFunctionalSsContext-v2 >-----#
    networkFunctionalSsContext_v2 = OID(name=u'networkFunctionalSsContext-v2', mode=MODE_VALUE)
    networkFunctionalSsContext_v2._val = (0, 4, 0, 0, 1, 0, 18, 2)
    
    #-----< networkFunctionalSsContext-v1 >-----#
    networkFunctionalSsContext_v1 = OID(name=u'networkFunctionalSsContext-v1', mode=MODE_VALUE)
    networkFunctionalSsContext_v1._val = (0, 4, 0, 0, 1, 0, 18, 1)
    
    #-----< networkUnstructuredSsContext-v2 >-----#
    networkUnstructuredSsContext_v2 = OID(name=u'networkUnstructuredSsContext-v2', mode=MODE_VALUE)
    networkUnstructuredSsContext_v2._val = (0, 4, 0, 0, 1, 0, 19, 2)
    
    #-----< shortMsgGatewayContext-v2 >-----#
    shortMsgGatewayContext_v2 = OID(name=u'shortMsgGatewayContext-v2', mode=MODE_VALUE)
    shortMsgGatewayContext_v2._val = (0, 4, 0, 0, 1, 0, 20, 2)
    
    #-----< shortMsgGatewayContext-v1 >-----#
    shortMsgGatewayContext_v1 = OID(name=u'shortMsgGatewayContext-v1', mode=MODE_VALUE)
    shortMsgGatewayContext_v1._val = (0, 4, 0, 0, 1, 0, 20, 1)
    
    #-----< shortMsgMO-RelayContext-v2 >-----#
    shortMsgMO_RelayContext_v2 = OID(name=u'shortMsgMO-RelayContext-v2', mode=MODE_VALUE)
    shortMsgMO_RelayContext_v2._val = (0, 4, 0, 0, 1, 0, 21, 2)
    
    #-----< shortMsgRelayContext-v1 >-----#
    shortMsgRelayContext_v1 = OID(name=u'shortMsgRelayContext-v1', mode=MODE_VALUE)
    shortMsgRelayContext_v1._val = (0, 4, 0, 0, 1, 0, 21, 1)
    
    #-----< shortMsgAlertContext-v2 >-----#
    shortMsgAlertContext_v2 = OID(name=u'shortMsgAlertContext-v2', mode=MODE_VALUE)
    shortMsgAlertContext_v2._val = (0, 4, 0, 0, 1, 0, 23, 2)
    
    #-----< shortMsgAlertContext-v1 >-----#
    shortMsgAlertContext_v1 = OID(name=u'shortMsgAlertContext-v1', mode=MODE_VALUE)
    shortMsgAlertContext_v1._val = (0, 4, 0, 0, 1, 0, 23, 1)
    
    #-----< mwdMngtContext-v2 >-----#
    mwdMngtContext_v2 = OID(name=u'mwdMngtContext-v2', mode=MODE_VALUE)
    mwdMngtContext_v2._val = (0, 4, 0, 0, 1, 0, 24, 2)
    
    #-----< mwdMngtContext-v1 >-----#
    mwdMngtContext_v1 = OID(name=u'mwdMngtContext-v1', mode=MODE_VALUE)
    mwdMngtContext_v1._val = (0, 4, 0, 0, 1, 0, 24, 1)
    
    #-----< shortMsgMT-RelayContext-v2 >-----#
    shortMsgMT_RelayContext_v2 = OID(name=u'shortMsgMT-RelayContext-v2', mode=MODE_VALUE)
    shortMsgMT_RelayContext_v2._val = (0, 4, 0, 0, 1, 0, 25, 2)
    
    #-----< imsiRetrievalContext-v2 >-----#
    imsiRetrievalContext_v2 = OID(name=u'imsiRetrievalContext-v2', mode=MODE_VALUE)
    imsiRetrievalContext_v2._val = (0, 4, 0, 0, 1, 0, 26, 2)
    
    #-----< msPurgingContext-v2 >-----#
    msPurgingContext_v2 = OID(name=u'msPurgingContext-v2', mode=MODE_VALUE)
    msPurgingContext_v2._val = (0, 4, 0, 0, 1, 0, 27, 2)
    
    _all_ = [
        map_ac,
        networkLocUpContext_v2,
        networkLocUpContext_v1,
        locationCancellation_v2,
        locationCancellation_v1,
        roamingNumberEnquiryContext_v2,
        roamingNumberEnquiryContext_v1,
        locationInfoRetrievalContext_v2,
        locationInfoRetrievalContext_v1,
        resetContext_v2,
        resetContext_v1,
        handoverControlContext_v2,
        handoverControlContext_v1,
        equipmentMngtContext_v2,
        equipmentMngtContext_v1,
        infoRetrievalContext_v2,
        infoRetrievalContext_v1,
        interVlrInfoRetrievalContext_v2,
        subscriberDataMngtContext_v2,
        subscriberDataMngtContext_v1,
        tracingContext_v2,
        tracingContext_v1,
        networkFunctionalSsContext_v2,
        networkFunctionalSsContext_v1,
        networkUnstructuredSsContext_v2,
        shortMsgGatewayContext_v2,
        shortMsgGatewayContext_v1,
        shortMsgMO_RelayContext_v2,
        shortMsgRelayContext_v1,
        shortMsgAlertContext_v2,
        shortMsgAlertContext_v1,
        mwdMngtContext_v2,
        mwdMngtContext_v1,
        shortMsgMT_RelayContext_v2,
        imsiRetrievalContext_v2,
        msPurgingContext_v2,
    ]

class MAPv2_OperationAndMaintenanceOperations:

    _name_  = u'MAPv2-OperationAndMaintenanceOperations'
    _oid_   = []
    
    _obj_ = [
        u'activateTraceMode',
        u'deactivateTraceMode',
        u'traceSubscriberActivity',
        u'noteInternalHandover',
        u'sendIMSI',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'activateTraceMode',
        u'deactivateTraceMode',
        u'traceSubscriberActivity',
        u'noteInternalHandover',
        u'sendIMSI',
        ]
    _class_ = [
        u'activateTraceMode',
        u'deactivateTraceMode',
        u'traceSubscriberActivity',
        u'noteInternalHandover',
        u'sendIMSI',
        ]
    _param_ = [
        ]
    
    #-----< activateTraceMode >-----#
    activateTraceMode = CLASS(name=u'activateTraceMode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _activateTraceMode_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'ActivateTraceModeArg')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    activateTraceMode._val = dict([(u'ArgumentType', _activateTraceMode_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))]), dict([(u'errorCode', (u'local', 40))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 50))])
    
    #-----< deactivateTraceMode >-----#
    deactivateTraceMode = CLASS(name=u'deactivateTraceMode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _deactivateTraceMode_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'DeactivateTraceModeArg')))
    deactivateTraceMode._val = dict([(u'ArgumentType', _deactivateTraceMode_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 51))])
    
    #-----< traceSubscriberActivity >-----#
    traceSubscriberActivity = CLASS(name=u'traceSubscriberActivity', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _traceSubscriberActivity_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceSubscriberActivityArg')))
    traceSubscriberActivity._val = dict([(u'ArgumentType', _traceSubscriberActivity_val_ArgumentType), (u'operationCode', (u'local', 52))])
    
    #-----< noteInternalHandover >-----#
    noteInternalHandover = CLASS(name=u'noteInternalHandover', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _noteInternalHandover_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'NoteInternalHO-Arg')))
    noteInternalHandover._val = dict([(u'ArgumentType', _noteInternalHandover_val_ArgumentType), (u'operationCode', (u'local', 35))])
    
    #-----< sendIMSI >-----#
    sendIMSI = CLASS(name=u'sendIMSI', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendIMSI_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _sendIMSI_val_ResultType = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    sendIMSI._val = dict([(u'ArgumentType', _sendIMSI_val_ArgumentType), (u'ResultType', _sendIMSI_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 58))])
    
    _all_ = [
        activateTraceMode,
        _activateTraceMode_val_ArgumentType,
        __OPERATION_Errors_val_ParameterType_0,
        deactivateTraceMode,
        _deactivateTraceMode_val_ArgumentType,
        traceSubscriberActivity,
        _traceSubscriberActivity_val_ArgumentType,
        noteInternalHandover,
        _noteInternalHandover_val_ArgumentType,
        sendIMSI,
        _sendIMSI_val_ArgumentType,
        _sendIMSI_val_ResultType,
    ]

class MAPv2_MobileServiceOperations:

    _name_  = u'MAPv2-MobileServiceOperations'
    _oid_   = []
    
    _obj_ = [
        u'updateLocation',
        u'cancelLocation',
        u'purgeMS',
        u'sendIdentification',
        u'prepareHandover',
        u'performHandover',
        u'sendEndSignal',
        u'processAccessSignalling',
        u'forwardAccessSignalling',
        u'prepareSubsequentHandover',
        u'performSubsequentHandover',
        u'sendAuthenticationInfo',
        u'checkIMEI',
        u'sendParameters',
        u'insertSubscriberData',
        u'deleteSubscriberData',
        u'reset',
        u'forwardCheckSS-Indication',
        u'restoreData',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'updateLocation',
        u'cancelLocation',
        u'purgeMS',
        u'sendIdentification',
        u'prepareHandover',
        u'performHandover',
        u'sendEndSignal',
        u'processAccessSignalling',
        u'forwardAccessSignalling',
        u'prepareSubsequentHandover',
        u'performSubsequentHandover',
        u'sendAuthenticationInfo',
        u'checkIMEI',
        u'sendParameters',
        u'insertSubscriberData',
        u'deleteSubscriberData',
        u'reset',
        u'forwardCheckSS-Indication',
        u'restoreData',
        ]
    _class_ = [
        u'updateLocation',
        u'cancelLocation',
        u'purgeMS',
        u'sendIdentification',
        u'prepareHandover',
        u'performHandover',
        u'sendEndSignal',
        u'processAccessSignalling',
        u'forwardAccessSignalling',
        u'prepareSubsequentHandover',
        u'performSubsequentHandover',
        u'sendAuthenticationInfo',
        u'checkIMEI',
        u'sendParameters',
        u'insertSubscriberData',
        u'deleteSubscriberData',
        u'reset',
        u'forwardCheckSS-Indication',
        u'restoreData',
        ]
    _param_ = [
        ]
    
    #-----< updateLocation >-----#
    updateLocation = CLASS(name=u'updateLocation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _updateLocation_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'UpdateLocationArg')))
    _updateLocation_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'UpdateLocationRes')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    __OPERATION_Errors_val_ParameterType_4 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'RoamingNotAllowedCause')))
    updateLocation._val = dict([(u'ArgumentType', _updateLocation_val_ArgumentType), (u'ResultType', _updateLocation_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 2))])
    
    #-----< cancelLocation >-----#
    cancelLocation = CLASS(name=u'cancelLocation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _cancelLocation_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'CancelLocationArg')))
    cancelLocation._val = dict([(u'ArgumentType', _cancelLocation_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 3))])
    
    #-----< purgeMS >-----#
    purgeMS = CLASS(name=u'purgeMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _purgeMS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PurgeMS-Arg')))
    purgeMS._val = dict([(u'ArgumentType', _purgeMS_val_ArgumentType), (u'operationCode', (u'local', 67))])
    
    #-----< sendIdentification >-----#
    sendIdentification = CLASS(name=u'sendIdentification', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendIdentification_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TMSI')))
    _sendIdentification_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendIdentificationRes')))
    sendIdentification._val = dict([(u'ArgumentType', _sendIdentification_val_ArgumentType), (u'ResultType', _sendIdentification_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 55))])
    
    #-----< prepareHandover >-----#
    prepareHandover = CLASS(name=u'prepareHandover', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _prepareHandover_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareHO-Arg')))
    _prepareHandover_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareHO-Res')))
    prepareHandover._val = dict([(u'ArgumentType', _prepareHandover_val_ArgumentType), (u'ResultType', _prepareHandover_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 25))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 68))])
    
    #-----< performHandover >-----#
    performHandover = CLASS(name=u'performHandover', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _performHandover_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformHO-Arg')))
    _performHandover_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformHO-Res')))
    performHandover._val = dict([(u'ArgumentType', _performHandover_val_ArgumentType), (u'ResultType', _performHandover_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 2))]), dict([(u'errorCode', (u'local', 23))]), dict([(u'errorCode', (u'local', 24))]), dict([(u'errorCode', (u'local', 25))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 28))])
    
    #-----< sendEndSignal >-----#
    sendEndSignal = CLASS(name=u'sendEndSignal', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendEndSignal_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    sendEndSignal._val = dict([(u'ArgumentType', _sendEndSignal_val_ArgumentType), (u'operationCode', (u'local', 29))])
    
    #-----< processAccessSignalling >-----#
    processAccessSignalling = CLASS(name=u'processAccessSignalling', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _processAccessSignalling_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    processAccessSignalling._val = dict([(u'ArgumentType', _processAccessSignalling_val_ArgumentType), (u'operationCode', (u'local', 33))])
    
    #-----< forwardAccessSignalling >-----#
    forwardAccessSignalling = CLASS(name=u'forwardAccessSignalling', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _forwardAccessSignalling_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    forwardAccessSignalling._val = dict([(u'ArgumentType', _forwardAccessSignalling_val_ArgumentType), (u'operationCode', (u'local', 34))])
    
    #-----< prepareSubsequentHandover >-----#
    prepareSubsequentHandover = CLASS(name=u'prepareSubsequentHandover', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _prepareSubsequentHandover_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareSubsequentHO-Arg')))
    _prepareSubsequentHandover_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    prepareSubsequentHandover._val = dict([(u'ArgumentType', _prepareSubsequentHandover_val_ArgumentType), (u'ResultType', _prepareSubsequentHandover_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 3))]), dict([(u'errorCode', (u'local', 26))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 69))])
    
    #-----< performSubsequentHandover >-----#
    performSubsequentHandover = CLASS(name=u'performSubsequentHandover', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _performSubsequentHandover_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformSubsequentHO-Arg')))
    _performSubsequentHandover_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    performSubsequentHandover._val = dict([(u'ArgumentType', _performSubsequentHandover_val_ArgumentType), (u'ResultType', _performSubsequentHandover_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 2))]), dict([(u'errorCode', (u'local', 3))]), dict([(u'errorCode', (u'local', 23))]), dict([(u'errorCode', (u'local', 26))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 30))])
    
    #-----< sendAuthenticationInfo >-----#
    sendAuthenticationInfo = CLASS(name=u'sendAuthenticationInfo', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendAuthenticationInfo_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendAuthenticationInfoArg')))
    _sendAuthenticationInfo_val_ResultType = SEQ_OF(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendAuthenticationInfoRes')))
    sendAuthenticationInfo._val = dict([(u'ArgumentType', _sendAuthenticationInfo_val_ArgumentType), (u'ResultType', _sendAuthenticationInfo_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 56))])
    
    #-----< checkIMEI >-----#
    checkIMEI = CLASS(name=u'checkIMEI', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _checkIMEI_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMEI')))
    _checkIMEI_val_ResultType = ENUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'EquipmentStatus')))
    checkIMEI._val = dict([(u'ArgumentType', _checkIMEI_val_ArgumentType), (u'ResultType', _checkIMEI_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 7))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 43))])
    
    #-----< sendParameters >-----#
    sendParameters = CLASS(name=u'sendParameters', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendParameters_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendParametersArg')))
    _sendParameters_val_ResultType = SEQ_OF(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SentParameterList')))
    sendParameters._val = dict([(u'ArgumentType', _sendParameters_val_ArgumentType), (u'ResultType', _sendParameters_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 9))])
    
    #-----< insertSubscriberData >-----#
    insertSubscriberData = CLASS(name=u'insertSubscriberData', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _insertSubscriberData_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'InsertSubscriberDataArg')))
    _insertSubscriberData_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'InsertSubscriberDataRes')))
    insertSubscriberData._val = dict([(u'ArgumentType', _insertSubscriberData_val_ArgumentType), (u'ResultType', _insertSubscriberData_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 7))])
    
    #-----< deleteSubscriberData >-----#
    deleteSubscriberData = CLASS(name=u'deleteSubscriberData', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _deleteSubscriberData_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'DeleteSubscriberDataArg')))
    _deleteSubscriberData_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'DeleteSubscriberDataRes')))
    deleteSubscriberData._val = dict([(u'ArgumentType', _deleteSubscriberData_val_ArgumentType), (u'ResultType', _deleteSubscriberData_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 8))])
    
    #-----< reset >-----#
    reset = CLASS(name=u'reset', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _reset_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ResetArg')))
    reset._val = dict([(u'ArgumentType', _reset_val_ArgumentType), (u'operationCode', (u'local', 37))])
    
    #-----< forwardCheckSS-Indication >-----#
    forwardCheckSS_Indication = CLASS(name=u'forwardCheckSS-Indication', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    forwardCheckSS_Indication._val = dict([(u'operationCode', (u'local', 38))])
    
    #-----< restoreData >-----#
    restoreData = CLASS(name=u'restoreData', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _restoreData_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RestoreDataArg')))
    _restoreData_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RestoreDataRes')))
    restoreData._val = dict([(u'ArgumentType', _restoreData_val_ArgumentType), (u'ResultType', _restoreData_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 57))])
    
    _all_ = [
        updateLocation,
        _updateLocation_val_ArgumentType,
        _updateLocation_val_ResultType,
        __OPERATION_Errors_val_ParameterType_0,
        __OPERATION_Errors_val_ParameterType_4,
        cancelLocation,
        _cancelLocation_val_ArgumentType,
        purgeMS,
        _purgeMS_val_ArgumentType,
        sendIdentification,
        _sendIdentification_val_ArgumentType,
        _sendIdentification_val_ResultType,
        prepareHandover,
        _prepareHandover_val_ArgumentType,
        _prepareHandover_val_ResultType,
        performHandover,
        _performHandover_val_ArgumentType,
        _performHandover_val_ResultType,
        sendEndSignal,
        _sendEndSignal_val_ArgumentType,
        processAccessSignalling,
        _processAccessSignalling_val_ArgumentType,
        forwardAccessSignalling,
        _forwardAccessSignalling_val_ArgumentType,
        prepareSubsequentHandover,
        _prepareSubsequentHandover_val_ArgumentType,
        _prepareSubsequentHandover_val_ResultType,
        performSubsequentHandover,
        _performSubsequentHandover_val_ArgumentType,
        _performSubsequentHandover_val_ResultType,
        sendAuthenticationInfo,
        _sendAuthenticationInfo_val_ArgumentType,
        _sendAuthenticationInfo_val_ResultType,
        checkIMEI,
        _checkIMEI_val_ArgumentType,
        _checkIMEI_val_ResultType,
        sendParameters,
        _sendParameters_val_ArgumentType,
        _sendParameters_val_ResultType,
        insertSubscriberData,
        _insertSubscriberData_val_ArgumentType,
        _insertSubscriberData_val_ResultType,
        deleteSubscriberData,
        _deleteSubscriberData_val_ArgumentType,
        _deleteSubscriberData_val_ResultType,
        reset,
        _reset_val_ArgumentType,
        forwardCheckSS_Indication,
        restoreData,
        _restoreData_val_ArgumentType,
        _restoreData_val_ResultType,
    ]

class MAPv2_SupplementaryServiceOperations:

    _name_  = u'MAPv2-SupplementaryServiceOperations'
    _oid_   = []
    
    _obj_ = [
        u'registerSS',
        u'eraseSS',
        u'activateSS',
        u'deactivateSS',
        u'interrogateSS',
        u'processUnstructuredSS-Data',
        u'processUnstructuredSS-Request',
        u'unstructuredSS-Request',
        u'unstructuredSS-Notify',
        u'registerPassword',
        u'getPassword',
        u'beginSubscriberActivity',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'registerSS',
        u'eraseSS',
        u'activateSS',
        u'deactivateSS',
        u'interrogateSS',
        u'processUnstructuredSS-Data',
        u'processUnstructuredSS-Request',
        u'unstructuredSS-Request',
        u'unstructuredSS-Notify',
        u'registerPassword',
        u'getPassword',
        u'beginSubscriberActivity',
        ]
    _class_ = [
        u'registerSS',
        u'eraseSS',
        u'activateSS',
        u'deactivateSS',
        u'interrogateSS',
        u'processUnstructuredSS-Data',
        u'processUnstructuredSS-Request',
        u'unstructuredSS-Request',
        u'unstructuredSS-Notify',
        u'registerPassword',
        u'getPassword',
        u'beginSubscriberActivity',
        ]
    _param_ = [
        ]
    
    #-----< registerSS >-----#
    registerSS = CLASS(name=u'registerSS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _registerSS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'RegisterSS-Arg')))
    _registerSS_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    __OPERATION_Errors_val_ParameterType_6 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_8 = OCT_STR(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')))
    __OPERATION_Errors_val_ParameterType_9 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')))
    __OPERATION_Errors_val_ParameterType_10 = SEQ(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SS-IncompatibilityCause')))
    registerSS._val = dict([(u'ArgumentType', _registerSS_val_ArgumentType), (u'ResultType', _registerSS_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10), (u'errorCode', (u'local', 20))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 10))])
    
    #-----< eraseSS >-----#
    eraseSS = CLASS(name=u'eraseSS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _eraseSS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _eraseSS_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    eraseSS._val = dict([(u'ArgumentType', _eraseSS_val_ArgumentType), (u'ResultType', _eraseSS_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 19))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 11))])
    
    #-----< activateSS >-----#
    activateSS = CLASS(name=u'activateSS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _activateSS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _activateSS_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    activateSS._val = dict([(u'ArgumentType', _activateSS_val_ArgumentType), (u'ResultType', _activateSS_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10), (u'errorCode', (u'local', 20))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 12))])
    
    #-----< deactivateSS >-----#
    deactivateSS = CLASS(name=u'deactivateSS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _deactivateSS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _deactivateSS_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    deactivateSS._val = dict([(u'ArgumentType', _deactivateSS_val_ArgumentType), (u'ResultType', _deactivateSS_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 19))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 13))])
    
    #-----< interrogateSS >-----#
    interrogateSS = CLASS(name=u'interrogateSS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _interrogateSS_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _interrogateSS_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'InterrogateSS-Res')))
    interrogateSS._val = dict([(u'ArgumentType', _interrogateSS_val_ArgumentType), (u'ResultType', _interrogateSS_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'errorCode', (u'local', 18))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 14))])
    
    #-----< processUnstructuredSS-Data >-----#
    processUnstructuredSS_Data = CLASS(name=u'processUnstructuredSS-Data', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _processUnstructuredSS_Data_val_ArgumentType = STR_IA5(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-UserData')))
    _processUnstructuredSS_Data_val_ResultType = STR_IA5(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-UserData')))
    processUnstructuredSS_Data._val = dict([(u'ArgumentType', _processUnstructuredSS_Data_val_ArgumentType), (u'ResultType', _processUnstructuredSS_Data_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 36))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 19))])
    
    #-----< processUnstructuredSS-Request >-----#
    processUnstructuredSS_Request = CLASS(name=u'processUnstructuredSS-Request', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _processUnstructuredSS_Request_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    _processUnstructuredSS_Request_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Res')))
    __OPERATION_Errors_val_ParameterType_4 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    processUnstructuredSS_Request._val = dict([(u'ArgumentType', _processUnstructuredSS_Request_val_ArgumentType), (u'ResultType', _processUnstructuredSS_Request_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 13))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 59))])
    
    #-----< unstructuredSS-Request >-----#
    unstructuredSS_Request = CLASS(name=u'unstructuredSS-Request', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _unstructuredSS_Request_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    _unstructuredSS_Request_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Res')))
    __OPERATION_Errors_val_ParameterType_3 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    unstructuredSS_Request._val = dict([(u'ArgumentType', _unstructuredSS_Request_val_ArgumentType), (u'ResultType', _unstructuredSS_Request_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'errorCode', (u'local', 72))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 60))])
    
    #-----< unstructuredSS-Notify >-----#
    unstructuredSS_Notify = CLASS(name=u'unstructuredSS-Notify', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _unstructuredSS_Notify_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    unstructuredSS_Notify._val = dict([(u'ArgumentType', _unstructuredSS_Notify_val_ArgumentType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'errorCode', (u'local', 72))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 61))])
    
    #-----< registerPassword >-----#
    registerPassword = CLASS(name=u'registerPassword', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _registerPassword_val_ArgumentType = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    _registerPassword_val_ResultType = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    _registerPassword_val_ResultType._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    __OPERATION_Errors_val_ParameterType_3_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_4_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')))
    __OPERATION_Errors_val_ParameterType_5 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'PW-RegistrationFailureCause')))
    __OPERATION_Linked_val_ArgumentType_0 = ENUM(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'GuidanceInfo')))
    __OPERATION_Linked_val_ResultType_0 = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    __OPERATION_Linked_val_ResultType_0._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    registerPassword._val = dict([(u'ArgumentType', _registerPassword_val_ArgumentType), (u'ResultType', _registerPassword_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3_0), (u'errorCode', (u'local', 13))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_0), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 37))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'Linked', ASN1Set(rv=[dict([(u'ArgumentType', __OPERATION_Linked_val_ArgumentType_0), (u'ResultType', __OPERATION_Linked_val_ResultType_0), (u'operationCode', (u'local', 18))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 17))])
    
    #-----< getPassword >-----#
    getPassword = CLASS(name=u'getPassword', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _getPassword_val_ArgumentType = ENUM(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'GuidanceInfo')))
    _getPassword_val_ResultType = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    _getPassword_val_ResultType._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    getPassword._val = dict([(u'ArgumentType', _getPassword_val_ArgumentType), (u'ResultType', _getPassword_val_ResultType), (u'operationCode', (u'local', 18))])
    
    #-----< beginSubscriberActivity >-----#
    beginSubscriberActivity = CLASS(name=u'beginSubscriberActivity', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _beginSubscriberActivity_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'BeginSubscriberActivityArg')))
    beginSubscriberActivity._val = dict([(u'ArgumentType', _beginSubscriberActivity_val_ArgumentType), (u'operationCode', (u'local', 54))])
    
    _all_ = [
        registerSS,
        _registerSS_val_ArgumentType,
        _registerSS_val_ResultType,
        __OPERATION_Errors_val_ParameterType_0,
        __OPERATION_Errors_val_ParameterType_6,
        __OPERATION_Errors_val_ParameterType_8,
        __OPERATION_Errors_val_ParameterType_9,
        __OPERATION_Errors_val_ParameterType_10,
        eraseSS,
        _eraseSS_val_ArgumentType,
        _eraseSS_val_ResultType,
        activateSS,
        _activateSS_val_ArgumentType,
        _activateSS_val_ResultType,
        deactivateSS,
        _deactivateSS_val_ArgumentType,
        _deactivateSS_val_ResultType,
        interrogateSS,
        _interrogateSS_val_ArgumentType,
        _interrogateSS_val_ResultType,
        processUnstructuredSS_Data,
        _processUnstructuredSS_Data_val_ArgumentType,
        _processUnstructuredSS_Data_val_ResultType,
        processUnstructuredSS_Request,
        _processUnstructuredSS_Request_val_ArgumentType,
        _processUnstructuredSS_Request_val_ResultType,
        __OPERATION_Errors_val_ParameterType_4,
        unstructuredSS_Request,
        _unstructuredSS_Request_val_ArgumentType,
        _unstructuredSS_Request_val_ResultType,
        __OPERATION_Errors_val_ParameterType_3,
        unstructuredSS_Notify,
        _unstructuredSS_Notify_val_ArgumentType,
        registerPassword,
        _registerPassword_val_ArgumentType,
        _registerPassword_val_ResultType,
        __OPERATION_Errors_val_ParameterType_3_0,
        __OPERATION_Errors_val_ParameterType_4_0,
        __OPERATION_Errors_val_ParameterType_5,
        __OPERATION_Linked_val_ArgumentType_0,
        __OPERATION_Linked_val_ResultType_0,
        getPassword,
        _getPassword_val_ArgumentType,
        _getPassword_val_ResultType,
        beginSubscriberActivity,
        _beginSubscriberActivity_val_ArgumentType,
    ]

class MAPv2_CallHandlingOperations:

    _name_  = u'MAPv2-CallHandlingOperations'
    _oid_   = []
    
    _obj_ = [
        u'sendRoutingInfo',
        u'provideRoamingNumber',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'sendRoutingInfo',
        u'provideRoamingNumber',
        ]
    _class_ = [
        u'sendRoutingInfo',
        u'provideRoamingNumber',
        ]
    _param_ = [
        ]
    
    #-----< sendRoutingInfo >-----#
    sendRoutingInfo = CLASS(name=u'sendRoutingInfo', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _sendRoutingInfo_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'SendRoutingInfoArg')))
    _sendRoutingInfo_val_ResultType = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'SendRoutingInfoRes')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    __OPERATION_Errors_val_ParameterType_8 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_9 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_10 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CUG-RejectCause')))
    sendRoutingInfo._val = dict([(u'ArgumentType', _sendRoutingInfo_val_ArgumentType), (u'ResultType', _sendRoutingInfo_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 44))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 27))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 13))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10), (u'errorCode', (u'local', 15))]), dict([(u'errorCode', (u'local', 14))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 22))])
    
    #-----< provideRoamingNumber >-----#
    provideRoamingNumber = CLASS(name=u'provideRoamingNumber', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _provideRoamingNumber_val_ArgumentType = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'ProvideRoamingNumberArg')))
    _provideRoamingNumber_val_ResultType = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    __OPERATION_Errors_val_ParameterType_4 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    provideRoamingNumber._val = dict([(u'ArgumentType', _provideRoamingNumber_val_ArgumentType), (u'ResultType', _provideRoamingNumber_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 39))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 4))])
    
    _all_ = [
        sendRoutingInfo,
        _sendRoutingInfo_val_ArgumentType,
        _sendRoutingInfo_val_ResultType,
        __OPERATION_Errors_val_ParameterType_0,
        __OPERATION_Errors_val_ParameterType_8,
        __OPERATION_Errors_val_ParameterType_9,
        __OPERATION_Errors_val_ParameterType_10,
        provideRoamingNumber,
        _provideRoamingNumber_val_ArgumentType,
        _provideRoamingNumber_val_ResultType,
        __OPERATION_Errors_val_ParameterType_4,
    ]

class MAPv2_Protocol:

    _name_  = u'MAPv2-Protocol'
    _oid_   = []
    
    _obj_ = [
        u'Supported-MAPv2-Operations',
        ]
    _type_ = [
        ]
    _set_ = [
        u'Supported-MAPv2-Operations',
        ]
    _val_ = [
        ]
    _class_ = [
        u'Supported-MAPv2-Operations',
        ]
    _param_ = [
        ]
    
    #-----< Supported-MAPv2-Operations >-----#
    Supported_MAPv2_Operations = CLASS(name=u'Supported-MAPv2-Operations', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _Supported_MAPv2_Operations_val_ArgumentType_0 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'SendRoutingInfoArg')))
    _Supported_MAPv2_Operations_val_ResultType_0 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'SendRoutingInfoRes')))
    __OPERATION_Errors_val_ParameterType_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'NetworkResource')))
    __OPERATION_Errors_val_ParameterType_8 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_9 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_10 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CUG-RejectCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_1 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CH-DataTypes', 'ProvideRoamingNumberArg')))
    _Supported_MAPv2_Operations_val_ResultType_1 = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    __OPERATION_Errors_val_ParameterType_4 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    _Supported_MAPv2_Operations_val_ArgumentType_2 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'UpdateLocationArg')))
    _Supported_MAPv2_Operations_val_ResultType_2 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'UpdateLocationRes')))
    __OPERATION_Errors_val_ParameterType_4_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'RoamingNotAllowedCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_3 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'CancelLocationArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_4 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PurgeMS-Arg')))
    _Supported_MAPv2_Operations_val_ArgumentType_5 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'TMSI')))
    _Supported_MAPv2_Operations_val_ResultType_5 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendIdentificationRes')))
    _Supported_MAPv2_Operations_val_ArgumentType_6 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareHO-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_6 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareHO-Res')))
    _Supported_MAPv2_Operations_val_ArgumentType_7 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformHO-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_7 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformHO-Res')))
    _Supported_MAPv2_Operations_val_ArgumentType_8 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    _Supported_MAPv2_Operations_val_ArgumentType_9 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    _Supported_MAPv2_Operations_val_ArgumentType_10 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    _Supported_MAPv2_Operations_val_ArgumentType_11 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PrepareSubsequentHO-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_11 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    _Supported_MAPv2_Operations_val_ArgumentType_12 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'PerformSubsequentHO-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_12 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ExternalSignalInfo')))
    _Supported_MAPv2_Operations_val_ArgumentType_13 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendAuthenticationInfoArg')))
    _Supported_MAPv2_Operations_val_ResultType_13 = SEQ_OF(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendAuthenticationInfoRes')))
    _Supported_MAPv2_Operations_val_ArgumentType_14 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMEI')))
    _Supported_MAPv2_Operations_val_ResultType_14 = ENUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'EquipmentStatus')))
    _Supported_MAPv2_Operations_val_ArgumentType_15 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SendParametersArg')))
    _Supported_MAPv2_Operations_val_ResultType_15 = SEQ_OF(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'SentParameterList')))
    _Supported_MAPv2_Operations_val_ArgumentType_16 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'InsertSubscriberDataArg')))
    _Supported_MAPv2_Operations_val_ResultType_16 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'InsertSubscriberDataRes')))
    _Supported_MAPv2_Operations_val_ArgumentType_17 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'DeleteSubscriberDataArg')))
    _Supported_MAPv2_Operations_val_ResultType_17 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'DeleteSubscriberDataRes')))
    _Supported_MAPv2_Operations_val_ArgumentType_18 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'ResetArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_20 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RestoreDataArg')))
    _Supported_MAPv2_Operations_val_ResultType_20 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-MS-DataTypes', 'RestoreDataRes')))
    _Supported_MAPv2_Operations_val_ArgumentType_21 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'ActivateTraceModeArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_22 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'DeactivateTraceModeArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_23 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'TraceSubscriberActivityArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_24 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-OM-DataTypes', 'NoteInternalHO-Arg')))
    _Supported_MAPv2_Operations_val_ArgumentType_25 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _Supported_MAPv2_Operations_val_ResultType_25 = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _Supported_MAPv2_Operations_val_ArgumentType_26 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'RoutingInfoForSM-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_26 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'RoutingInfoForSM-Res')))
    __OPERATION_Errors_val_ParameterType_6 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_7 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_27 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ForwardSM-Arg')))
    __OPERATION_Errors_val_ParameterType_7_0 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    __OPERATION_Errors_val_ParameterType_9_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SM-DeliveryFailureCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_28 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ReportSM-DeliveryStatusArg')))
    _Supported_MAPv2_Operations_val_ResultType_28 = OCT_STR(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'ISDN-AddressString')))
    _Supported_MAPv2_Operations_val_ArgumentType_29 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-CommonDataTypes', 'IMSI')))
    _Supported_MAPv2_Operations_val_ArgumentType_30 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'AlertServiceCentreArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_31 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'AlertServiceCentreArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_32 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'InformServiceCentreArg')))
    _Supported_MAPv2_Operations_val_ArgumentType_33 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SM-DataTypes', 'ReadyForSM-Arg')))
    _Supported_MAPv2_Operations_val_ArgumentType_34 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'RegisterSS-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_34 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    __OPERATION_Errors_val_ParameterType_6_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_8_0 = OCT_STR(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Status')))
    __OPERATION_Errors_val_ParameterType_9_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')))
    __OPERATION_Errors_val_ParameterType_10_0 = SEQ(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'SS-IncompatibilityCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_35 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _Supported_MAPv2_Operations_val_ResultType_35 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    _Supported_MAPv2_Operations_val_ArgumentType_36 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _Supported_MAPv2_Operations_val_ResultType_36 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    _Supported_MAPv2_Operations_val_ArgumentType_37 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _Supported_MAPv2_Operations_val_ResultType_37 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-Info')))
    _Supported_MAPv2_Operations_val_ArgumentType_38 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-ForBS-Code')))
    _Supported_MAPv2_Operations_val_ResultType_38 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'InterrogateSS-Res')))
    _Supported_MAPv2_Operations_val_ArgumentType_39 = STR_IA5(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-UserData')))
    _Supported_MAPv2_Operations_val_ResultType_39 = STR_IA5(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-UserData')))
    _Supported_MAPv2_Operations_val_ArgumentType_40 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_40 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Res')))
    __OPERATION_Errors_val_ParameterType_4_1 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    _Supported_MAPv2_Operations_val_ArgumentType_41 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    _Supported_MAPv2_Operations_val_ResultType_41 = SEQ(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Res')))
    __OPERATION_Errors_val_ParameterType_3 = BOOL(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-Errors', 'Mwd-Set')))
    _Supported_MAPv2_Operations_val_ArgumentType_42 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'USSD-Arg')))
    _Supported_MAPv2_Operations_val_ArgumentType_43 = OCT_STR(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-Code', 'SS-Code')))
    _Supported_MAPv2_Operations_val_ResultType_43 = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    _Supported_MAPv2_Operations_val_ResultType_43._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    __OPERATION_Errors_val_ParameterType_3_0 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'CallBarringCause')))
    __OPERATION_Errors_val_ParameterType_4_2 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'SS-SubscriptionOption')))
    __OPERATION_Errors_val_ParameterType_5 = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-ER-DataTypes', 'PW-RegistrationFailureCause')))
    __OPERATION_Linked_val_ArgumentType_0 = ENUM(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'GuidanceInfo')))
    __OPERATION_Linked_val_ResultType_0 = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    __OPERATION_Linked_val_ResultType_0._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    _Supported_MAPv2_Operations_val_ArgumentType_44 = ENUM(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'GuidanceInfo')))
    _Supported_MAPv2_Operations_val_ResultType_44 = STR_NUM(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'Password')))
    _Supported_MAPv2_Operations_val_ResultType_44._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    _Supported_MAPv2_Operations_val_ArgumentType_45 = SEQ(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('MAPv2-SS-DataTypes', 'BeginSubscriberActivityArg')))
    Supported_MAPv2_Operations._val = ASN1Set(rv=[dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_0), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_0), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 44))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8), (u'errorCode', (u'local', 27))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9), (u'errorCode', (u'local', 13))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10), (u'errorCode', (u'local', 15))]), dict([(u'errorCode', (u'local', 14))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 22))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_1), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_1), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 39))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 4))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_2), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_2), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_0), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 2))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_3), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 3))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_4), (u'operationCode', (u'local', 67))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_5), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_5), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 55))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_6), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_6), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 25))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 68))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_7), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_7), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 2))]), dict([(u'errorCode', (u'local', 23))]), dict([(u'errorCode', (u'local', 24))]), dict([(u'errorCode', (u'local', 25))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 28))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_8), (u'operationCode', (u'local', 29))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_9), (u'operationCode', (u'local', 33))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_10), (u'operationCode', (u'local', 34))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_11), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_11), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 3))]), dict([(u'errorCode', (u'local', 26))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 69))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_12), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_12), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 2))]), dict([(u'errorCode', (u'local', 3))]), dict([(u'errorCode', (u'local', 23))]), dict([(u'errorCode', (u'local', 26))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 30))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_13), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_13), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 56))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_14), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_14), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 7))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 43))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_15), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_15), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 9))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_16), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_16), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 7))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_17), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_17), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 8))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_18), (u'operationCode', (u'local', 37))]), dict([(u'operationCode', (u'local', 38))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_20), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_20), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 57))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_21), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))]), dict([(u'errorCode', (u'local', 40))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 50))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_22), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 51))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_23), (u'operationCode', (u'local', 52))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_24), (u'operationCode', (u'local', 35))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_25), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_25), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 58))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_26), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_26), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6), (u'errorCode', (u'local', 27))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_7), (u'errorCode', (u'local', 13))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 45))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_27), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 5))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_7_0), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 31))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9_0), (u'errorCode', (u'local', 32))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 46))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_28), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_28), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 33))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 47))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_29), (u'operationCode', (u'local', 48))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_30), (u'operationCode', (u'local', 49))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_31), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 64))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_32), (u'operationCode', (u'local', 63))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_33), (u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 21))]), dict([(u'errorCode', (u'local', 1))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 66))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_34), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_34), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6_0), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8_0), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9_1), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10_0), (u'errorCode', (u'local', 20))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 10))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_35), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_35), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6_0), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8_0), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9_1), (u'errorCode', (u'local', 19))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 11))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_36), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_36), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6_0), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8_0), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9_1), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_10_0), (u'errorCode', (u'local', 20))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 12))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_37), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_37), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6_0), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_8_0), (u'errorCode', (u'local', 17))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_9_1), (u'errorCode', (u'local', 19))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 13))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_38), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_38), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 1))]), dict([(u'errorCode', (u'local', 10))]), dict([(u'errorCode', (u'local', 11))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_6_0), (u'errorCode', (u'local', 13))]), dict([(u'errorCode', (u'local', 16))]), dict([(u'errorCode', (u'local', 18))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 14))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_39), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_39), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 36))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 19))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_40), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_40), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_1), (u'errorCode', (u'local', 13))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 59))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_41), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_41), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'errorCode', (u'local', 72))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 60))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_42), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 27))]), dict([(u'errorCode', (u'local', 9))]), dict([(u'errorCode', (u'local', 12))]), dict([(u'errorCode', (u'local', 71))]), dict([(u'errorCode', (u'local', 72))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 61))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_43), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_43), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 34))]), dict([(u'errorCode', (u'local', 35))]), dict([(u'errorCode', (u'local', 36))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3_0), (u'errorCode', (u'local', 13))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_2), (u'errorCode', (u'local', 19))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 37))]), dict([(u'errorCode', (u'local', 38))]), dict([(u'errorCode', (u'local', 43))])], rr=[], ev=None, er=[])), (u'Linked', ASN1Set(rv=[dict([(u'ArgumentType', __OPERATION_Linked_val_ArgumentType_0), (u'ResultType', __OPERATION_Linked_val_ResultType_0), (u'operationCode', (u'local', 18))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 17))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_44), (u'ResultType', _Supported_MAPv2_Operations_val_ResultType_44), (u'operationCode', (u'local', 18))]), dict([(u'ArgumentType', _Supported_MAPv2_Operations_val_ArgumentType_45), (u'operationCode', (u'local', 54))])], rr=[], ev=None, er=[])
    
    _all_ = [
        Supported_MAPv2_Operations,
        _Supported_MAPv2_Operations_val_ArgumentType_0,
        _Supported_MAPv2_Operations_val_ResultType_0,
        __OPERATION_Errors_val_ParameterType_0,
        __OPERATION_Errors_val_ParameterType_8,
        __OPERATION_Errors_val_ParameterType_9,
        __OPERATION_Errors_val_ParameterType_10,
        _Supported_MAPv2_Operations_val_ArgumentType_1,
        _Supported_MAPv2_Operations_val_ResultType_1,
        __OPERATION_Errors_val_ParameterType_4,
        _Supported_MAPv2_Operations_val_ArgumentType_2,
        _Supported_MAPv2_Operations_val_ResultType_2,
        __OPERATION_Errors_val_ParameterType_4_0,
        _Supported_MAPv2_Operations_val_ArgumentType_3,
        _Supported_MAPv2_Operations_val_ArgumentType_4,
        _Supported_MAPv2_Operations_val_ArgumentType_5,
        _Supported_MAPv2_Operations_val_ResultType_5,
        _Supported_MAPv2_Operations_val_ArgumentType_6,
        _Supported_MAPv2_Operations_val_ResultType_6,
        _Supported_MAPv2_Operations_val_ArgumentType_7,
        _Supported_MAPv2_Operations_val_ResultType_7,
        _Supported_MAPv2_Operations_val_ArgumentType_8,
        _Supported_MAPv2_Operations_val_ArgumentType_9,
        _Supported_MAPv2_Operations_val_ArgumentType_10,
        _Supported_MAPv2_Operations_val_ArgumentType_11,
        _Supported_MAPv2_Operations_val_ResultType_11,
        _Supported_MAPv2_Operations_val_ArgumentType_12,
        _Supported_MAPv2_Operations_val_ResultType_12,
        _Supported_MAPv2_Operations_val_ArgumentType_13,
        _Supported_MAPv2_Operations_val_ResultType_13,
        _Supported_MAPv2_Operations_val_ArgumentType_14,
        _Supported_MAPv2_Operations_val_ResultType_14,
        _Supported_MAPv2_Operations_val_ArgumentType_15,
        _Supported_MAPv2_Operations_val_ResultType_15,
        _Supported_MAPv2_Operations_val_ArgumentType_16,
        _Supported_MAPv2_Operations_val_ResultType_16,
        _Supported_MAPv2_Operations_val_ArgumentType_17,
        _Supported_MAPv2_Operations_val_ResultType_17,
        _Supported_MAPv2_Operations_val_ArgumentType_18,
        _Supported_MAPv2_Operations_val_ArgumentType_20,
        _Supported_MAPv2_Operations_val_ResultType_20,
        _Supported_MAPv2_Operations_val_ArgumentType_21,
        _Supported_MAPv2_Operations_val_ArgumentType_22,
        _Supported_MAPv2_Operations_val_ArgumentType_23,
        _Supported_MAPv2_Operations_val_ArgumentType_24,
        _Supported_MAPv2_Operations_val_ArgumentType_25,
        _Supported_MAPv2_Operations_val_ResultType_25,
        _Supported_MAPv2_Operations_val_ArgumentType_26,
        _Supported_MAPv2_Operations_val_ResultType_26,
        __OPERATION_Errors_val_ParameterType_6,
        __OPERATION_Errors_val_ParameterType_7,
        _Supported_MAPv2_Operations_val_ArgumentType_27,
        __OPERATION_Errors_val_ParameterType_7_0,
        __OPERATION_Errors_val_ParameterType_9_0,
        _Supported_MAPv2_Operations_val_ArgumentType_28,
        _Supported_MAPv2_Operations_val_ResultType_28,
        _Supported_MAPv2_Operations_val_ArgumentType_29,
        _Supported_MAPv2_Operations_val_ArgumentType_30,
        _Supported_MAPv2_Operations_val_ArgumentType_31,
        _Supported_MAPv2_Operations_val_ArgumentType_32,
        _Supported_MAPv2_Operations_val_ArgumentType_33,
        _Supported_MAPv2_Operations_val_ArgumentType_34,
        _Supported_MAPv2_Operations_val_ResultType_34,
        __OPERATION_Errors_val_ParameterType_6_0,
        __OPERATION_Errors_val_ParameterType_8_0,
        __OPERATION_Errors_val_ParameterType_9_1,
        __OPERATION_Errors_val_ParameterType_10_0,
        _Supported_MAPv2_Operations_val_ArgumentType_35,
        _Supported_MAPv2_Operations_val_ResultType_35,
        _Supported_MAPv2_Operations_val_ArgumentType_36,
        _Supported_MAPv2_Operations_val_ResultType_36,
        _Supported_MAPv2_Operations_val_ArgumentType_37,
        _Supported_MAPv2_Operations_val_ResultType_37,
        _Supported_MAPv2_Operations_val_ArgumentType_38,
        _Supported_MAPv2_Operations_val_ResultType_38,
        _Supported_MAPv2_Operations_val_ArgumentType_39,
        _Supported_MAPv2_Operations_val_ResultType_39,
        _Supported_MAPv2_Operations_val_ArgumentType_40,
        _Supported_MAPv2_Operations_val_ResultType_40,
        __OPERATION_Errors_val_ParameterType_4_1,
        _Supported_MAPv2_Operations_val_ArgumentType_41,
        _Supported_MAPv2_Operations_val_ResultType_41,
        __OPERATION_Errors_val_ParameterType_3,
        _Supported_MAPv2_Operations_val_ArgumentType_42,
        _Supported_MAPv2_Operations_val_ArgumentType_43,
        _Supported_MAPv2_Operations_val_ResultType_43,
        __OPERATION_Errors_val_ParameterType_3_0,
        __OPERATION_Errors_val_ParameterType_4_2,
        __OPERATION_Errors_val_ParameterType_5,
        __OPERATION_Linked_val_ArgumentType_0,
        __OPERATION_Linked_val_ResultType_0,
        _Supported_MAPv2_Operations_val_ArgumentType_44,
        _Supported_MAPv2_Operations_val_ResultType_44,
        _Supported_MAPv2_Operations_val_ArgumentType_45,
    ]

init_modules(Remote_Operations_Information_Objects, MobileDomainDefinitions, MAPv2_CommonDataTypes, MAPv2_MS_DataTypes, MAPv2_DialogueInformation, MAPv2_SS_Code, MAPv2_CH_DataTypes, MAPv2_ER_DataTypes, MAPv2_Errors, MAPv2_OM_DataTypes, MAPv2_TS_Code, MAPv2_SS_DataTypes, MAPv2_SM_DataTypes, MAPv2_ShortMessageServiceOperations, MAPv2_BS_Code, MAPv2_ApplicationContexts, MAPv2_OperationAndMaintenanceOperations, MAPv2_MobileServiceOperations, MAPv2_SupplementaryServiceOperations, MAPv2_CallHandlingOperations, MAPv2_Protocol)
