# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ipa_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.78 IPA Rest Octets
# top-level object: IPA Rest Octets



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

ipa_downlink_assignment_struct = CSN1List(name='ipa_downlink_assignment_struct', list=[
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Bit(name='tlli', bit=32),
    CSN1Bit(name='tfi_assignment', bit=5),
    CSN1Bit(name='gamma', bit=5),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='timing_advance_value', bit=6)])})]),
  CSN1Val(name='', val='0')])

ipa_uplink_assignment_struct = CSN1List(name='ipa_uplink_assignment_struct', list=[
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Bit(name='random_reference', bit=11),
    CSN1Bit(name='fn_offset', bit=8),
    CSN1Bit(name='gamma', bit=5),
    CSN1Bit(name='timing_advance_value', bit=6),
    CSN1Bit(name='tfi_assignment', bit=5),
    CSN1Bit(name='usf', bit=3),
    CSN1Bit(name='egprs_channel_coding_command', bit=4),
    CSN1Bit(name='radio_access_capabilities_request')]),
  CSN1Val(name='', val='0')])

ipa_single_block_uplink_assignment_struct = CSN1List(name='ipa_single_block_uplink_assignment_struct', list=[
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Bit(name='random_reference', bit=11),
    CSN1Bit(name='fn_offset', bit=8),
    CSN1Bit(name='gamma', bit=5),
    CSN1Bit(name='timing_advance_value', bit=6),
    CSN1Bit(name='starting_time_offset', bit=6)]),
  CSN1Val(name='', val='0')])

ipa_rest_octets = CSN1List(name='ipa_rest_octets', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ipa_uplink_assignment_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ipa_downlink_assignment_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(obj=ipa_single_block_uplink_assignment_struct)])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='rcc', bit=3)]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Ref(obj=spare_padding)])

