# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/si4_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.35 SI 4 Rest Octets
# top-level object: SI4 Rest Octets



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

optional_power_offset = CSN1Alt(name='optional_power_offset', alt={
  'H': ('', [
  CSN1Bit(name='power_offset', bit=2)]),
  'L': ('', [])})

lsa_identity = CSN1Alt(name='lsa_identity', alt={
  '0': ('', [
  CSN1Bit(name='lsa_id', bit=24)]),
  '1': ('', [
  CSN1Bit(name='shortlsa_id', bit=10)])})

lsa_parameters = CSN1List(name='lsa_parameters', list=[
  CSN1Bit(name='prio_thr', bit=3),
  CSN1Bit(name='lsa_offset', bit=3),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='mcc', bit=12),
    CSN1Bit(name='mnc', bit=12)])})])

gprs_indicator = CSN1List(name='gprs_indicator', list=[
  CSN1Bit(name='ra_colour', bit=3),
  CSN1Bit(name='si13_position')])

selection_parameters = CSN1List(name='selection_parameters', list=[
  CSN1Bit(name='cbq'),
  CSN1Bit(name='cell_reselect_offset', bit=6),
  CSN1Bit(name='temporary_offset', bit=3),
  CSN1Bit(name='penalty_time', bit=5)])

break_indicator = CSN1Alt(name='break_indicator', alt={
  'H': ('', []),
  'L': ('', [])})

lsa_id_information = CSN1List(name='lsa_id_information', list=[
  CSN1Ref(obj=lsa_identity),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1SelfRef()])})])

si4_rest_octets_s = CSN1List(name='si4_rest_octets_s', list=[
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(obj=lsa_parameters)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='cell_identity', bit=16)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(obj=lsa_id_information)]),
    'L': ('', [])}),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='cbq3', bit=2),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='si13alt_position')])})]),
    'L': ('', [])})])

optional_selection_parameters = CSN1Alt(name='optional_selection_parameters', alt={
  'H': ('', [
  CSN1Ref(obj=selection_parameters)]),
  'L': ('', [])})

si4_rest_octets_o = CSN1List(name='si4_rest_octets_o', list=[
  CSN1Ref(obj=optional_selection_parameters),
  CSN1Ref(obj=optional_power_offset),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(obj=gprs_indicator)]),
    'L': ('', [])})])

si4_rest_octets = CSN1List(name='si4_rest_octets', list=[
  CSN1Ref(obj=si4_rest_octets_o),
  CSN1Alt(alt={
    'H': ('', [
    CSN1Ref(obj=si4_rest_octets_s)]),
    'L': ('', [
    CSN1Ref(obj=break_indicator)])}),
  CSN1Ref(obj=spare_padding)])

