
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "librpc/gen_ndr/ndr_winreg.h"
#include "librpc/gen_ndr/ndr_winreg_c.h"

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject winreg_String_Type;
staticforward PyTypeObject KeySecurityData_Type;
staticforward PyTypeObject winreg_SecBuf_Type;
staticforward PyTypeObject winreg_StringBuf_Type;
staticforward PyTypeObject winreg_ValNameBuf_Type;
staticforward PyTypeObject KeySecurityAttribute_Type;
staticforward PyTypeObject QueryMultipleValue_Type;
staticforward PyTypeObject winreg_InterfaceType;

void initwinreg(void);static PyTypeObject *Object_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_winreg_String_get_name_len(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name_len;
	py_name_len = PyInt_FromLong(object->name_len);
	return py_name_len;
}

static int py_winreg_String_set_name_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_String_get_name_size(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name_size;
	py_name_size = PyInt_FromLong(object->name_size);
	return py_name_size;
}

static int py_winreg_String_set_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_String_get_name(PyObject *obj, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_String_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_String_getsetters[] = {
	{ discard_const_p(char, "name_len"), py_winreg_String_get_name_len, py_winreg_String_set_name_len },
	{ discard_const_p(char, "name_size"), py_winreg_String_get_name_size, py_winreg_String_set_name_size },
	{ discard_const_p(char, "name"), py_winreg_String_get_name, py_winreg_String_set_name },
	{ NULL }
};

static PyObject *py_winreg_String_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_String, type);
}

static PyObject *py_winreg_String_ndr_pack(PyObject *py_obj)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_winreg_String);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_winreg_String_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_winreg_String);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_winreg_String_ndr_print(PyObject *py_obj)
{
	struct winreg_String *object = (struct winreg_String *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_winreg_String, "winreg_String", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_winreg_String_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_winreg_String_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_winreg_String_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_winreg_String_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winreg_String_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.String",
	.tp_getset = py_winreg_String_getsetters,
	.tp_methods = py_winreg_String_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_winreg_String_new,
};


static PyObject *py_KeySecurityData_get_data(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->len);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->len; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_KeySecurityData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_KeySecurityData_get_size(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_KeySecurityData_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_KeySecurityData_get_len(PyObject *obj, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_KeySecurityData_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityData *object = (struct KeySecurityData *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_KeySecurityData_getsetters[] = {
	{ discard_const_p(char, "data"), py_KeySecurityData_get_data, py_KeySecurityData_set_data },
	{ discard_const_p(char, "size"), py_KeySecurityData_get_size, py_KeySecurityData_set_size },
	{ discard_const_p(char, "len"), py_KeySecurityData_get_len, py_KeySecurityData_set_len },
	{ NULL }
};

static PyObject *py_KeySecurityData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct KeySecurityData, type);
}


static PyTypeObject KeySecurityData_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.KeySecurityData",
	.tp_getset = py_KeySecurityData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_KeySecurityData_new,
};


static PyObject *py_winreg_SecBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_SecBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_SecBuf_get_sd(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_sd;
	py_sd = py_talloc_reference_ex(&KeySecurityData_Type, py_talloc_get_mem_ctx(obj), &object->sd);
	return py_sd;
}

static int py_winreg_SecBuf_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sd = *(struct KeySecurityData *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_winreg_SecBuf_get_inherit(PyObject *obj, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyInt_FromLong(object->inherit);
	return py_inherit;
}

static int py_winreg_SecBuf_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_SecBuf *object = (struct winreg_SecBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->inherit = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_winreg_SecBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_SecBuf_get_length, py_winreg_SecBuf_set_length },
	{ discard_const_p(char, "sd"), py_winreg_SecBuf_get_sd, py_winreg_SecBuf_set_sd },
	{ discard_const_p(char, "inherit"), py_winreg_SecBuf_get_inherit, py_winreg_SecBuf_set_inherit },
	{ NULL }
};

static PyObject *py_winreg_SecBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_SecBuf, type);
}


static PyTypeObject winreg_SecBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.SecBuf",
	.tp_getset = py_winreg_SecBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_winreg_SecBuf_new,
};


static PyObject *py_winreg_StringBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_StringBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_StringBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_winreg_StringBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_StringBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_StringBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_StringBuf *object = (struct winreg_StringBuf *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_StringBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_StringBuf_get_length, py_winreg_StringBuf_set_length },
	{ discard_const_p(char, "size"), py_winreg_StringBuf_get_size, py_winreg_StringBuf_set_size },
	{ discard_const_p(char, "name"), py_winreg_StringBuf_get_name, py_winreg_StringBuf_set_name },
	{ NULL }
};

static PyObject *py_winreg_StringBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_StringBuf, type);
}


static PyTypeObject winreg_StringBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.StringBuf",
	.tp_getset = py_winreg_StringBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_winreg_StringBuf_new,
};


static PyObject *py_winreg_ValNameBuf_get_length(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_winreg_ValNameBuf_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_size(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_winreg_ValNameBuf_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_winreg_ValNameBuf_get_name(PyObject *obj, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_winreg_ValNameBuf_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winreg_ValNameBuf *object = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_winreg_ValNameBuf_getsetters[] = {
	{ discard_const_p(char, "length"), py_winreg_ValNameBuf_get_length, py_winreg_ValNameBuf_set_length },
	{ discard_const_p(char, "size"), py_winreg_ValNameBuf_get_size, py_winreg_ValNameBuf_set_size },
	{ discard_const_p(char, "name"), py_winreg_ValNameBuf_get_name, py_winreg_ValNameBuf_set_name },
	{ NULL }
};

static PyObject *py_winreg_ValNameBuf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct winreg_ValNameBuf, type);
}


static PyTypeObject winreg_ValNameBuf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.ValNameBuf",
	.tp_getset = py_winreg_ValNameBuf_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_winreg_ValNameBuf_new,
};


static PyObject *py_KeySecurityAttribute_get_data_size(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_KeySecurityAttribute_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_sec_data(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_sec_data;
	py_sec_data = py_talloc_reference_ex(&KeySecurityData_Type, py_talloc_get_mem_ctx(obj), &object->sec_data);
	return py_sec_data;
}

static int py_KeySecurityAttribute_set_sec_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&KeySecurityData_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sec_data = *(struct KeySecurityData *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_KeySecurityAttribute_get_inherit(PyObject *obj, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(obj);
	PyObject *py_inherit;
	py_inherit = PyInt_FromLong(object->inherit);
	return py_inherit;
}

static int py_KeySecurityAttribute_set_inherit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeySecurityAttribute *object = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->inherit = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_KeySecurityAttribute_getsetters[] = {
	{ discard_const_p(char, "data_size"), py_KeySecurityAttribute_get_data_size, py_KeySecurityAttribute_set_data_size },
	{ discard_const_p(char, "sec_data"), py_KeySecurityAttribute_get_sec_data, py_KeySecurityAttribute_set_sec_data },
	{ discard_const_p(char, "inherit"), py_KeySecurityAttribute_get_inherit, py_KeySecurityAttribute_set_inherit },
	{ NULL }
};

static PyObject *py_KeySecurityAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct KeySecurityAttribute, type);
}


static PyTypeObject KeySecurityAttribute_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.KeySecurityAttribute",
	.tp_getset = py_KeySecurityAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_KeySecurityAttribute_new,
};


static PyObject *py_QueryMultipleValue_get_ve_valuename(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_ve_valuename;
	if (object->ve_valuename == NULL) {
		py_ve_valuename = Py_None;
		Py_INCREF(py_ve_valuename);
	} else {
		py_ve_valuename = py_talloc_reference_ex(&winreg_ValNameBuf_Type, object->ve_valuename, object->ve_valuename);
	}
	return py_ve_valuename;
}

static int py_QueryMultipleValue_set_ve_valuename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->ve_valuename);
	if (value == Py_None) {
		object->ve_valuename = NULL;
	} else {
		object->ve_valuename = NULL;
		PY_CHECK_TYPE(&winreg_ValNameBuf_Type, value, return -1;);
		if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ve_valuename = (struct winreg_ValNameBuf *)py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_valuelen(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_ve_valuelen;
	py_ve_valuelen = PyInt_FromLong(object->ve_valuelen);
	return py_ve_valuelen;
}

static int py_QueryMultipleValue_set_ve_valuelen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ve_valuelen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_valueptr(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_ve_valueptr;
	py_ve_valueptr = PyInt_FromLong(object->ve_valueptr);
	return py_ve_valueptr;
}

static int py_QueryMultipleValue_set_ve_valueptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ve_valueptr = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QueryMultipleValue_get_ve_type(PyObject *obj, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(obj);
	PyObject *py_ve_type;
	py_ve_type = PyInt_FromLong(object->ve_type);
	return py_ve_type;
}

static int py_QueryMultipleValue_set_ve_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QueryMultipleValue *object = (struct QueryMultipleValue *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ve_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ve_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_QueryMultipleValue_getsetters[] = {
	{ discard_const_p(char, "ve_valuename"), py_QueryMultipleValue_get_ve_valuename, py_QueryMultipleValue_set_ve_valuename },
	{ discard_const_p(char, "ve_valuelen"), py_QueryMultipleValue_get_ve_valuelen, py_QueryMultipleValue_set_ve_valuelen },
	{ discard_const_p(char, "ve_valueptr"), py_QueryMultipleValue_get_ve_valueptr, py_QueryMultipleValue_set_ve_valueptr },
	{ discard_const_p(char, "ve_type"), py_QueryMultipleValue_get_ve_type, py_QueryMultipleValue_set_ve_type },
	{ NULL }
};

static PyObject *py_QueryMultipleValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct QueryMultipleValue, type);
}


static PyTypeObject QueryMultipleValue_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.QueryMultipleValue",
	.tp_getset = py_QueryMultipleValue_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_QueryMultipleValue_new,
};


static bool pack_py_winreg_OpenHKCR_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCR *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCR", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCR_args_out(struct winreg_OpenHKCR *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKCU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCU_args_out(struct winreg_OpenHKCU *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKLM_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKLM *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKLM", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKLM_args_out(struct winreg_OpenHKLM *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPD_args_out(struct winreg_OpenHKPD *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKU_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKU *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKU", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKU_args_out(struct winreg_OpenHKU *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_CloseKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CloseKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_CloseKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_CloseKey_args_out(struct winreg_CloseKey *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_CreateKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_CreateKey *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_options;
	PyObject *py_access_mask;
	PyObject *py_secdesc;
	PyObject *py_action_taken;
	const char *kwnames[] = {
		"handle", "name", "keyclass", "options", "access_mask", "secdesc", "action_taken", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_CreateKey", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_keyclass, &py_options, &py_access_mask, &py_secdesc, &py_action_taken)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct winreg_String *)py_talloc_get_ptr(py_name);
	PY_CHECK_TYPE(&winreg_String_Type, py_keyclass, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_keyclass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.keyclass = *(struct winreg_String *)py_talloc_get_ptr(py_keyclass);
	if (PyLong_Check(py_options)) {
		r->in.options = PyLong_AsLongLong(py_options);
	} else if (PyInt_Check(py_options)) {
		r->in.options = PyInt_AsLong(py_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (py_secdesc == Py_None) {
		r->in.secdesc = NULL;
	} else {
		r->in.secdesc = NULL;
		PY_CHECK_TYPE(&winreg_SecBuf_Type, py_secdesc, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_secdesc)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.secdesc = (struct winreg_SecBuf *)py_talloc_get_ptr(py_secdesc);
	}
	if (py_action_taken == Py_None) {
		r->in.action_taken = NULL;
	} else {
		r->in.action_taken = talloc_ptrtype(r, r->in.action_taken);
		if (PyLong_Check(py_action_taken)) {
			*r->in.action_taken = PyLong_AsLongLong(py_action_taken);
		} else if (PyInt_Check(py_action_taken)) {
			*r->in.action_taken = PyInt_AsLong(py_action_taken);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_CreateKey_args_out(struct winreg_CreateKey *r)
{
	PyObject *result;
	PyObject *py_new_handle;
	PyObject *py_action_taken;
	result = PyTuple_New(2);
	py_new_handle = py_talloc_reference_ex(policy_handle_Type, r->out.new_handle, r->out.new_handle);
	PyTuple_SetItem(result, 0, py_new_handle);
	if (r->out.action_taken == NULL) {
		py_action_taken = Py_None;
		Py_INCREF(py_action_taken);
	} else {
		py_action_taken = PyInt_FromLong(*r->out.action_taken);
	}
	PyTuple_SetItem(result, 1, py_action_taken);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_DeleteKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteKey *r)
{
	PyObject *py_handle;
	PyObject *py_key;
	const char *kwnames[] = {
		"handle", "key", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteKey", discard_const_p(char *, kwnames), &py_handle, &py_key)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_key, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_key)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key = *(struct winreg_String *)py_talloc_get_ptr(py_key);
	return true;
}

static PyObject *unpack_py_winreg_DeleteKey_args_out(struct winreg_DeleteKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_DeleteValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteValue *r)
{
	PyObject *py_handle;
	PyObject *py_value;
	const char *kwnames[] = {
		"handle", "value", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_DeleteValue", discard_const_p(char *, kwnames), &py_handle, &py_value)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_value, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_value)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.value = *(struct winreg_String *)py_talloc_get_ptr(py_value);
	return true;
}

static PyObject *unpack_py_winreg_DeleteValue_args_out(struct winreg_DeleteValue *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_EnumKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumKey *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_last_changed_time;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "keyclass", "last_changed_time", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_EnumKey", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_keyclass, &py_last_changed_time)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_enum_index, return false;);
	r->in.enum_index = PyInt_AsLong(py_enum_index);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&winreg_StringBuf_Type, py_name, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct winreg_StringBuf *)py_talloc_get_ptr(py_name);
	if (py_keyclass == Py_None) {
		r->in.keyclass = NULL;
	} else {
		r->in.keyclass = NULL;
		PY_CHECK_TYPE(&winreg_StringBuf_Type, py_keyclass, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_keyclass)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.keyclass = (struct winreg_StringBuf *)py_talloc_get_ptr(py_keyclass);
	}
	if (py_last_changed_time == Py_None) {
		r->in.last_changed_time = NULL;
	} else {
		r->in.last_changed_time = talloc_ptrtype(r, r->in.last_changed_time);
		if (PyLong_Check(py_last_changed_time)) {
			*r->in.last_changed_time = PyLong_AsLongLong(py_last_changed_time);
		} else if (PyInt_Check(py_last_changed_time)) {
			*r->in.last_changed_time = PyInt_AsLong(py_last_changed_time);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winreg_EnumKey_args_out(struct winreg_EnumKey *r)
{
	PyObject *result;
	PyObject *py_name;
	PyObject *py_keyclass;
	PyObject *py_last_changed_time;
	result = PyTuple_New(3);
	py_name = py_talloc_reference_ex(&winreg_StringBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);
	if (r->out.keyclass == NULL) {
		py_keyclass = Py_None;
		Py_INCREF(py_keyclass);
	} else {
		py_keyclass = py_talloc_reference_ex(&winreg_StringBuf_Type, r->out.keyclass, r->out.keyclass);
	}
	PyTuple_SetItem(result, 1, py_keyclass);
	if (r->out.last_changed_time == NULL) {
		py_last_changed_time = Py_None;
		Py_INCREF(py_last_changed_time);
	} else {
		py_last_changed_time = PyLong_FromLongLong(*r->out.last_changed_time);
	}
	PyTuple_SetItem(result, 2, py_last_changed_time);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_EnumValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_EnumValue *r)
{
	PyObject *py_handle;
	PyObject *py_enum_index;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_value;
	PyObject *py_size;
	PyObject *py_length;
	const char *kwnames[] = {
		"handle", "enum_index", "name", "type", "value", "size", "length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_EnumValue", discard_const_p(char *, kwnames), &py_handle, &py_enum_index, &py_name, &py_type, &py_value, &py_size, &py_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_enum_index, return false;);
	r->in.enum_index = PyInt_AsLong(py_enum_index);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&winreg_ValNameBuf_Type, py_name, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct winreg_ValNameBuf *)py_talloc_get_ptr(py_name);
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		if (PyLong_Check(py_type)) {
			*r->in.type = PyLong_AsLongLong(py_type);
		} else if (PyInt_Check(py_type)) {
			*r->in.type = PyInt_AsLong(py_type);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_value == Py_None) {
		r->in.value = NULL;
	} else {
		r->in.value = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_value, return false;);
		{
			int value_cntr_1;
			r->in.value = talloc_array_ptrtype(r, r->in.value, PyList_GET_SIZE(py_value));
			if (!r->in.value) { return false;; }
			talloc_set_name_const(r->in.value, "ARRAY: r->in.value");
			for (value_cntr_1 = 0; value_cntr_1 < PyList_GET_SIZE(py_value); value_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_value, value_cntr_1), return false;);
				r->in.value[value_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_value, value_cntr_1));
			}
		}
	}
	if (py_size == Py_None) {
		r->in.size = NULL;
	} else {
		r->in.size = talloc_ptrtype(r, r->in.size);
		PY_CHECK_TYPE(&PyInt_Type, py_size, return false;);
		*r->in.size = PyInt_AsLong(py_size);
	}
	if (py_length == Py_None) {
		r->in.length = NULL;
	} else {
		r->in.length = talloc_ptrtype(r, r->in.length);
		PY_CHECK_TYPE(&PyInt_Type, py_length, return false;);
		*r->in.length = PyInt_AsLong(py_length);
	}
	return true;
}

static PyObject *unpack_py_winreg_EnumValue_args_out(struct winreg_EnumValue *r)
{
	PyObject *result;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_value;
	PyObject *py_size;
	PyObject *py_length;
	result = PyTuple_New(5);
	py_name = py_talloc_reference_ex(&winreg_ValNameBuf_Type, r->out.name, r->out.name);
	PyTuple_SetItem(result, 0, py_name);
	if (r->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyInt_FromLong(*r->out.type);
	}
	PyTuple_SetItem(result, 1, py_type);
	if (r->out.value == NULL) {
		py_value = Py_None;
		Py_INCREF(py_value);
	} else {
		py_value = PyList_New(r->out.length?*r->out.length:0);
		if (py_value == NULL) {
			return NULL;
		}
		{
			int value_cntr_1;
			for (value_cntr_1 = 0; value_cntr_1 < r->out.length?*r->out.length:0; value_cntr_1++) {
				PyObject *py_value_1;
				py_value_1 = PyInt_FromLong(r->out.value[value_cntr_1]);
				PyList_SetItem(py_value, value_cntr_1, py_value_1);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_value);
	if (r->out.size == NULL) {
		py_size = Py_None;
		Py_INCREF(py_size);
	} else {
		py_size = PyInt_FromLong(*r->out.size);
	}
	PyTuple_SetItem(result, 3, py_size);
	if (r->out.length == NULL) {
		py_length = Py_None;
		Py_INCREF(py_length);
	} else {
		py_length = PyInt_FromLong(*r->out.length);
	}
	PyTuple_SetItem(result, 4, py_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_FlushKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_FlushKey *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_FlushKey", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_FlushKey_args_out(struct winreg_FlushKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_GetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_GetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	if (PyLong_Check(py_sec_info)) {
		r->in.sec_info = PyLong_AsLongLong(py_sec_info);
	} else if (PyInt_Check(py_sec_info)) {
		r->in.sec_info = PyInt_AsLong(py_sec_info);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_sd)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sd = (struct KeySecurityData *)py_talloc_get_ptr(py_sd);
	return true;
}

static PyObject *unpack_py_winreg_GetKeySecurity_args_out(struct winreg_GetKeySecurity *r)
{
	PyObject *result;
	PyObject *py_sd;
	py_sd = py_talloc_reference_ex(&KeySecurityData_Type, r->out.sd, r->out.sd);
	result = py_sd;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_LoadKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_LoadKey *r)
{
	PyObject *py_handle;
	PyObject *py_keyname;
	PyObject *py_filename;
	const char *kwnames[] = {
		"handle", "keyname", "filename", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_LoadKey", discard_const_p(char *, kwnames), &py_handle, &py_keyname, &py_filename)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	if (py_keyname == Py_None) {
		r->in.keyname = NULL;
	} else {
		r->in.keyname = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_keyname)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.keyname = (struct winreg_String *)py_talloc_get_ptr(py_keyname);
	}
	if (py_filename == Py_None) {
		r->in.filename = NULL;
	} else {
		r->in.filename = NULL;
		PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_filename)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.filename = (struct winreg_String *)py_talloc_get_ptr(py_filename);
	}
	return true;
}

static PyObject *unpack_py_winreg_LoadKey_args_out(struct winreg_LoadKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_NotifyChangeKeyValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_NotifyChangeKeyValue *r)
{
	PyObject *py_handle;
	PyObject *py_watch_subtree;
	PyObject *py_notify_filter;
	PyObject *py_unknown;
	PyObject *py_string1;
	PyObject *py_string2;
	PyObject *py_unknown2;
	const char *kwnames[] = {
		"handle", "watch_subtree", "notify_filter", "unknown", "string1", "string2", "unknown2", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:winreg_NotifyChangeKeyValue", discard_const_p(char *, kwnames), &py_handle, &py_watch_subtree, &py_notify_filter, &py_unknown, &py_string1, &py_string2, &py_unknown2)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_watch_subtree, return false;);
	r->in.watch_subtree = PyInt_AsLong(py_watch_subtree);
	if (PyLong_Check(py_notify_filter)) {
		r->in.notify_filter = PyLong_AsLongLong(py_notify_filter);
	} else if (PyInt_Check(py_notify_filter)) {
		r->in.notify_filter = PyInt_AsLong(py_notify_filter);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_unknown, return false;);
	r->in.unknown = PyInt_AsLong(py_unknown);
	PY_CHECK_TYPE(&winreg_String_Type, py_string1, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_string1)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.string1 = *(struct winreg_String *)py_talloc_get_ptr(py_string1);
	PY_CHECK_TYPE(&winreg_String_Type, py_string2, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_string2)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.string2 = *(struct winreg_String *)py_talloc_get_ptr(py_string2);
	PY_CHECK_TYPE(&PyInt_Type, py_unknown2, return false;);
	r->in.unknown2 = PyInt_AsLong(py_unknown2);
	return true;
}

static PyObject *unpack_py_winreg_NotifyChangeKeyValue_args_out(struct winreg_NotifyChangeKeyValue *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenKey *r)
{
	PyObject *py_parent_handle;
	PyObject *py_keyname;
	PyObject *py_options;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"parent_handle", "keyname", "options", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_OpenKey", discard_const_p(char *, kwnames), &py_parent_handle, &py_keyname, &py_options, &py_access_mask)) {
		return false;
	}

	r->in.parent_handle = talloc_ptrtype(r, r->in.parent_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_parent_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_parent_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.parent_handle = (struct policy_handle *)py_talloc_get_ptr(py_parent_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_keyname, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_keyname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.keyname = *(struct winreg_String *)py_talloc_get_ptr(py_keyname);
	if (PyLong_Check(py_options)) {
		r->in.options = PyLong_AsLongLong(py_options);
	} else if (PyInt_Check(py_options)) {
		r->in.options = PyInt_AsLong(py_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenKey_args_out(struct winreg_OpenKey *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryInfoKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryInfoKey *r)
{
	PyObject *py_handle;
	PyObject *py_classname;
	const char *kwnames[] = {
		"handle", "classname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_QueryInfoKey", discard_const_p(char *, kwnames), &py_handle, &py_classname)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.classname = talloc_ptrtype(r, r->in.classname);
	PY_CHECK_TYPE(&winreg_String_Type, py_classname, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_classname)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.classname = (struct winreg_String *)py_talloc_get_ptr(py_classname);
	return true;
}

static PyObject *unpack_py_winreg_QueryInfoKey_args_out(struct winreg_QueryInfoKey *r)
{
	PyObject *result;
	PyObject *py_classname;
	PyObject *py_num_subkeys;
	PyObject *py_max_subkeylen;
	PyObject *py_max_classlen;
	PyObject *py_num_values;
	PyObject *py_max_valnamelen;
	PyObject *py_max_valbufsize;
	PyObject *py_secdescsize;
	PyObject *py_last_changed_time;
	result = PyTuple_New(9);
	py_classname = py_talloc_reference_ex(&winreg_String_Type, r->out.classname, r->out.classname);
	PyTuple_SetItem(result, 0, py_classname);
	py_num_subkeys = PyInt_FromLong(*r->out.num_subkeys);
	PyTuple_SetItem(result, 1, py_num_subkeys);
	py_max_subkeylen = PyInt_FromLong(*r->out.max_subkeylen);
	PyTuple_SetItem(result, 2, py_max_subkeylen);
	py_max_classlen = PyInt_FromLong(*r->out.max_classlen);
	PyTuple_SetItem(result, 3, py_max_classlen);
	py_num_values = PyInt_FromLong(*r->out.num_values);
	PyTuple_SetItem(result, 4, py_num_values);
	py_max_valnamelen = PyInt_FromLong(*r->out.max_valnamelen);
	PyTuple_SetItem(result, 5, py_max_valnamelen);
	py_max_valbufsize = PyInt_FromLong(*r->out.max_valbufsize);
	PyTuple_SetItem(result, 6, py_max_valbufsize);
	py_secdescsize = PyInt_FromLong(*r->out.secdescsize);
	PyTuple_SetItem(result, 7, py_secdescsize);
	py_last_changed_time = PyLong_FromLongLong(*r->out.last_changed_time);
	PyTuple_SetItem(result, 8, py_last_changed_time);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryValue *r)
{
	PyObject *py_handle;
	PyObject *py_value_name;
	PyObject *py_type;
	PyObject *py_data;
	PyObject *py_data_size;
	PyObject *py_data_length;
	const char *kwnames[] = {
		"handle", "value_name", "type", "data", "data_size", "data_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_QueryValue", discard_const_p(char *, kwnames), &py_handle, &py_value_name, &py_type, &py_data, &py_data_size, &py_data_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.value_name = talloc_ptrtype(r, r->in.value_name);
	PY_CHECK_TYPE(&winreg_String_Type, py_value_name, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_value_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.value_name = (struct winreg_String *)py_talloc_get_ptr(py_value_name);
	if (py_type == Py_None) {
		r->in.type = NULL;
	} else {
		r->in.type = talloc_ptrtype(r, r->in.type);
		if (PyLong_Check(py_type)) {
			*r->in.type = PyLong_AsLongLong(py_type);
		} else if (PyInt_Check(py_type)) {
			*r->in.type = PyInt_AsLong(py_type);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
			if (!r->in.data) { return false;; }
			talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_data, data_cntr_1), return false;);
				r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_data, data_cntr_1));
			}
		}
	}
	if (py_data_size == Py_None) {
		r->in.data_size = NULL;
	} else {
		r->in.data_size = talloc_ptrtype(r, r->in.data_size);
		PY_CHECK_TYPE(&PyInt_Type, py_data_size, return false;);
		*r->in.data_size = PyInt_AsLong(py_data_size);
	}
	if (py_data_length == Py_None) {
		r->in.data_length = NULL;
	} else {
		r->in.data_length = talloc_ptrtype(r, r->in.data_length);
		PY_CHECK_TYPE(&PyInt_Type, py_data_length, return false;);
		*r->in.data_length = PyInt_AsLong(py_data_length);
	}
	return true;
}

static PyObject *unpack_py_winreg_QueryValue_args_out(struct winreg_QueryValue *r)
{
	PyObject *result;
	PyObject *py_type;
	PyObject *py_data;
	PyObject *py_data_size;
	PyObject *py_data_length;
	result = PyTuple_New(4);
	if (r->out.type == NULL) {
		py_type = Py_None;
		Py_INCREF(py_type);
	} else {
		py_type = PyInt_FromLong(*r->out.type);
	}
	PyTuple_SetItem(result, 0, py_type);
	if (r->out.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(r->out.data_length?*r->out.data_length:0);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < r->out.data_length?*r->out.data_length:0; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(r->out.data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_data);
	if (r->out.data_size == NULL) {
		py_data_size = Py_None;
		Py_INCREF(py_data_size);
	} else {
		py_data_size = PyInt_FromLong(*r->out.data_size);
	}
	PyTuple_SetItem(result, 2, py_data_size);
	if (r->out.data_length == NULL) {
		py_data_length = Py_None;
		Py_INCREF(py_data_length);
	} else {
		py_data_length = PyInt_FromLong(*r->out.data_length);
	}
	PyTuple_SetItem(result, 3, py_data_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_ReplaceKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_ReplaceKey *r)
{
	PyObject *py_handle;
	PyObject *py_subkey;
	PyObject *py_new_file;
	PyObject *py_old_file;
	const char *kwnames[] = {
		"handle", "subkey", "new_file", "old_file", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_ReplaceKey", discard_const_p(char *, kwnames), &py_handle, &py_subkey, &py_new_file, &py_old_file)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.subkey = talloc_ptrtype(r, r->in.subkey);
	PY_CHECK_TYPE(&winreg_String_Type, py_subkey, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_subkey)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.subkey = (struct winreg_String *)py_talloc_get_ptr(py_subkey);
	r->in.new_file = talloc_ptrtype(r, r->in.new_file);
	PY_CHECK_TYPE(&winreg_String_Type, py_new_file, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_new_file)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.new_file = (struct winreg_String *)py_talloc_get_ptr(py_new_file);
	r->in.old_file = talloc_ptrtype(r, r->in.old_file);
	PY_CHECK_TYPE(&winreg_String_Type, py_old_file, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_old_file)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.old_file = (struct winreg_String *)py_talloc_get_ptr(py_old_file);
	return true;
}

static PyObject *unpack_py_winreg_ReplaceKey_args_out(struct winreg_ReplaceKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_RestoreKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_RestoreKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "filename", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_RestoreKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)py_talloc_get_ptr(py_filename);
	if (PyLong_Check(py_flags)) {
		r->in.flags = PyLong_AsLongLong(py_flags);
	} else if (PyInt_Check(py_flags)) {
		r->in.flags = PyInt_AsLong(py_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_RestoreKey_args_out(struct winreg_RestoreKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SaveKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_SaveKey *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_sec_attrib;
	const char *kwnames[] = {
		"handle", "filename", "sec_attrib", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SaveKey", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_sec_attrib)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)py_talloc_get_ptr(py_filename);
	if (py_sec_attrib == Py_None) {
		r->in.sec_attrib = NULL;
	} else {
		r->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, py_sec_attrib, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_sec_attrib)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.sec_attrib = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_sec_attrib);
	}
	return true;
}

static PyObject *unpack_py_winreg_SaveKey_args_out(struct winreg_SaveKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SetKeySecurity_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetKeySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sd;
	const char *kwnames[] = {
		"handle", "sec_info", "sd", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_SetKeySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sd)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	if (PyLong_Check(py_sec_info)) {
		r->in.sec_info = PyLong_AsLongLong(py_sec_info);
	} else if (PyInt_Check(py_sec_info)) {
		r->in.sec_info = PyInt_AsLong(py_sec_info);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sd = talloc_ptrtype(r, r->in.sd);
	PY_CHECK_TYPE(&KeySecurityData_Type, py_sd, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_sd)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sd = (struct KeySecurityData *)py_talloc_get_ptr(py_sd);
	return true;
}

static PyObject *unpack_py_winreg_SetKeySecurity_args_out(struct winreg_SetKeySecurity *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SetValue_args_in(PyObject *args, PyObject *kwargs, struct winreg_SetValue *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_type;
	PyObject *py_data;
	const char *kwnames[] = {
		"handle", "name", "type", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_SetValue", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_type, &py_data)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&winreg_String_Type, py_name, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct winreg_String *)py_talloc_get_ptr(py_name);
	if (PyLong_Check(py_type)) {
		r->in.type = PyLong_AsLongLong(py_type);
	} else if (PyInt_Check(py_type)) {
		r->in.type = PyInt_AsLong(py_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.data = talloc_ptrtype(r, r->in.data);
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	{
		int data_cntr_1;
		r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
		if (!r->in.data) { return false;; }
		talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
		for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_data, data_cntr_1), return false;);
			r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_data, data_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.size = PyList_GET_SIZE(py_data);
	return true;
}

static PyObject *unpack_py_winreg_SetValue_args_out(struct winreg_SetValue *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_UnLoadKey_args_in(PyObject *args, PyObject *kwargs, struct winreg_UnLoadKey *r)
{
	PyObject *py_handle;
	PyObject *py_subkey;
	const char *kwnames[] = {
		"handle", "subkey", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_UnLoadKey", discard_const_p(char *, kwnames), &py_handle, &py_subkey)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.subkey = talloc_ptrtype(r, r->in.subkey);
	PY_CHECK_TYPE(&winreg_String_Type, py_subkey, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_subkey)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.subkey = (struct winreg_String *)py_talloc_get_ptr(py_subkey);
	return true;
}

static PyObject *unpack_py_winreg_UnLoadKey_args_out(struct winreg_UnLoadKey *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_InitiateSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdown *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winreg_InitiateSystemShutdown", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot)) {
		return false;
	}

	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		PY_CHECK_TYPE(&PyInt_Type, py_hostname, return false;);
		*r->in.hostname = PyInt_AsLong(py_hostname);
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)py_talloc_get_ptr(py_message);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_timeout, return false;);
	r->in.timeout = PyInt_AsLong(py_timeout);
	PY_CHECK_TYPE(&PyInt_Type, py_force_apps, return false;);
	r->in.force_apps = PyInt_AsLong(py_force_apps);
	PY_CHECK_TYPE(&PyInt_Type, py_do_reboot, return false;);
	r->in.do_reboot = PyInt_AsLong(py_do_reboot);
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdown_args_out(struct winreg_InitiateSystemShutdown *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_AbortSystemShutdown_args_in(PyObject *args, PyObject *kwargs, struct winreg_AbortSystemShutdown *r)
{
	PyObject *py_server;
	const char *kwnames[] = {
		"server", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_AbortSystemShutdown", discard_const_p(char *, kwnames), &py_server)) {
		return false;
	}

	if (py_server == Py_None) {
		r->in.server = NULL;
	} else {
		r->in.server = talloc_ptrtype(r, r->in.server);
		PY_CHECK_TYPE(&PyInt_Type, py_server, return false;);
		*r->in.server = PyInt_AsLong(py_server);
	}
	return true;
}

static PyObject *unpack_py_winreg_AbortSystemShutdown_args_out(struct winreg_AbortSystemShutdown *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_GetVersion_args_in(PyObject *args, PyObject *kwargs, struct winreg_GetVersion *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winreg_GetVersion", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_winreg_GetVersion_args_out(struct winreg_GetVersion *r)
{
	PyObject *result;
	PyObject *py_version;
	py_version = PyInt_FromLong(*r->out.version);
	result = py_version;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKCC_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKCC *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKCC", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKCC_args_out(struct winreg_OpenHKCC *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKDD_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKDD *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKDD", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKDD_args_out(struct winreg_OpenHKDD *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryMultipleValues_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryMultipleValues *r)
{
	PyObject *py_key_handle;
	PyObject *py_values_in;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"key_handle", "values_in", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_QueryMultipleValues", discard_const_p(char *, kwnames), &py_key_handle, &py_values_in, &py_buffer)) {
		return false;
	}

	r->in.key_handle = talloc_ptrtype(r, r->in.key_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_key_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_key_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key_handle = (struct policy_handle *)py_talloc_get_ptr(py_key_handle);
	r->in.values_in = talloc_ptrtype(r, r->in.values_in);
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	{
		int values_in_cntr_1;
		r->in.values_in = talloc_array_ptrtype(r, r->in.values_in, PyList_GET_SIZE(py_values_in));
		if (!r->in.values_in) { return false;; }
		talloc_set_name_const(r->in.values_in, "ARRAY: r->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(py_values_in); values_in_cntr_1++) {
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(py_values_in, values_in_cntr_1), return false;);
			if (talloc_reference(r->in.values_in, py_talloc_get_mem_ctx(PyList_GET_ITEM(py_values_in, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.values_in[values_in_cntr_1] = *(struct QueryMultipleValue *)py_talloc_get_ptr(PyList_GET_ITEM(py_values_in, values_in_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	r->in.num_values = PyList_GET_SIZE(py_values_in);
	if (py_buffer == Py_None) {
		r->in.buffer = NULL;
	} else {
		r->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
		{
			int buffer_cntr_1;
			r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_GET_SIZE(py_buffer));
			if (!r->in.buffer) { return false;; }
			talloc_set_name_const(r->in.buffer, "ARRAY: r->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(py_buffer); buffer_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_buffer, buffer_cntr_1), return false;);
				r->in.buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_buffer, buffer_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.buffer_size = talloc_ptrtype(r, r->in.buffer_size);
	*r->in.buffer_size = PyList_GET_SIZE(py_buffer);
	return true;
}

static PyObject *unpack_py_winreg_QueryMultipleValues_args_out(struct winreg_QueryMultipleValues *r)
{
	PyObject *result;
	PyObject *py_values_out;
	PyObject *py_buffer;
	result = PyTuple_New(2);
	py_values_out = PyList_New(r->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < r->in.num_values; values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = py_talloc_reference_ex(&QueryMultipleValue_Type, r->out.values_out, &r->out.values_out[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	PyTuple_SetItem(result, 0, py_values_out);
	if (r->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*r->out.buffer_size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < *r->out.buffer_size; buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_InitiateSystemShutdownEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_InitiateSystemShutdownEx *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	PyObject *py_reason;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", "reason", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winreg_InitiateSystemShutdownEx", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot, &py_reason)) {
		return false;
	}

	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		PY_CHECK_TYPE(&PyInt_Type, py_hostname, return false;);
		*r->in.hostname = PyInt_AsLong(py_hostname);
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)py_talloc_get_ptr(py_message);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_timeout, return false;);
	r->in.timeout = PyInt_AsLong(py_timeout);
	PY_CHECK_TYPE(&PyInt_Type, py_force_apps, return false;);
	r->in.force_apps = PyInt_AsLong(py_force_apps);
	PY_CHECK_TYPE(&PyInt_Type, py_do_reboot, return false;);
	r->in.do_reboot = PyInt_AsLong(py_do_reboot);
	PY_CHECK_TYPE(&PyInt_Type, py_reason, return false;);
	r->in.reason = PyInt_AsLong(py_reason);
	return true;
}

static PyObject *unpack_py_winreg_InitiateSystemShutdownEx_args_out(struct winreg_InitiateSystemShutdownEx *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_SaveKeyEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_SaveKeyEx *r)
{
	PyObject *py_handle;
	PyObject *py_filename;
	PyObject *py_sec_attrib;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "filename", "sec_attrib", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_SaveKeyEx", discard_const_p(char *, kwnames), &py_handle, &py_filename, &py_sec_attrib, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.filename = talloc_ptrtype(r, r->in.filename);
	PY_CHECK_TYPE(&winreg_String_Type, py_filename, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_filename)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.filename = (struct winreg_String *)py_talloc_get_ptr(py_filename);
	if (py_sec_attrib == Py_None) {
		r->in.sec_attrib = NULL;
	} else {
		r->in.sec_attrib = NULL;
		PY_CHECK_TYPE(&KeySecurityAttribute_Type, py_sec_attrib, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_sec_attrib)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.sec_attrib = (struct KeySecurityAttribute *)py_talloc_get_ptr(py_sec_attrib);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_winreg_SaveKeyEx_args_out(struct winreg_SaveKeyEx *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPT_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPT *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPT", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPT_args_out(struct winreg_OpenHKPT *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_OpenHKPN_args_in(PyObject *args, PyObject *kwargs, struct winreg_OpenHKPN *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winreg_OpenHKPN", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_winreg_OpenHKPN_args_out(struct winreg_OpenHKPN *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_QueryMultipleValues2_args_in(PyObject *args, PyObject *kwargs, struct winreg_QueryMultipleValues2 *r)
{
	PyObject *py_key_handle;
	PyObject *py_values_in;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"key_handle", "values_in", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winreg_QueryMultipleValues2", discard_const_p(char *, kwnames), &py_key_handle, &py_values_in, &py_buffer)) {
		return false;
	}

	r->in.key_handle = talloc_ptrtype(r, r->in.key_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_key_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_key_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key_handle = (struct policy_handle *)py_talloc_get_ptr(py_key_handle);
	r->in.values_in = talloc_ptrtype(r, r->in.values_in);
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	{
		int values_in_cntr_1;
		r->in.values_in = talloc_array_ptrtype(r, r->in.values_in, PyList_GET_SIZE(py_values_in));
		if (!r->in.values_in) { return false;; }
		talloc_set_name_const(r->in.values_in, "ARRAY: r->in.values_in");
		for (values_in_cntr_1 = 0; values_in_cntr_1 < PyList_GET_SIZE(py_values_in); values_in_cntr_1++) {
			PY_CHECK_TYPE(&QueryMultipleValue_Type, PyList_GET_ITEM(py_values_in, values_in_cntr_1), return false;);
			if (talloc_reference(r->in.values_in, py_talloc_get_mem_ctx(PyList_GET_ITEM(py_values_in, values_in_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.values_in[values_in_cntr_1] = *(struct QueryMultipleValue *)py_talloc_get_ptr(PyList_GET_ITEM(py_values_in, values_in_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_values_in, return false;);
	r->in.num_values = PyList_GET_SIZE(py_values_in);
	if (py_buffer == Py_None) {
		r->in.buffer = NULL;
	} else {
		r->in.buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
		{
			int buffer_cntr_1;
			r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_GET_SIZE(py_buffer));
			if (!r->in.buffer) { return false;; }
			talloc_set_name_const(r->in.buffer, "ARRAY: r->in.buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(py_buffer); buffer_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_buffer, buffer_cntr_1), return false;);
				r->in.buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_buffer, buffer_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.offered = talloc_ptrtype(r, r->in.offered);
	*r->in.offered = PyList_GET_SIZE(py_buffer);
	return true;
}

static PyObject *unpack_py_winreg_QueryMultipleValues2_args_out(struct winreg_QueryMultipleValues2 *r)
{
	PyObject *result;
	PyObject *py_values_out;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(3);
	py_values_out = PyList_New(r->in.num_values);
	if (py_values_out == NULL) {
		return NULL;
	}
	{
		int values_out_cntr_1;
		for (values_out_cntr_1 = 0; values_out_cntr_1 < r->in.num_values; values_out_cntr_1++) {
			PyObject *py_values_out_1;
			py_values_out_1 = py_talloc_reference_ex(&QueryMultipleValue_Type, r->out.values_out, &r->out.values_out[values_out_cntr_1]);
			PyList_SetItem(py_values_out, values_out_cntr_1, py_values_out_1);
		}
	}
	PyTuple_SetItem(result, 0, py_values_out);
	if (r->out.buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(*r->in.offered);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < *r->in.offered; buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 2, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_winreg_DeleteKeyEx_args_in(PyObject *args, PyObject *kwargs, struct winreg_DeleteKeyEx *r)
{
	PyObject *py_handle;
	PyObject *py_key;
	PyObject *py_access_mask;
	PyObject *py_reserved;
	const char *kwnames[] = {
		"handle", "key", "access_mask", "reserved", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winreg_DeleteKeyEx", discard_const_p(char *, kwnames), &py_handle, &py_key, &py_access_mask, &py_reserved)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	r->in.key = talloc_ptrtype(r, r->in.key);
	PY_CHECK_TYPE(&winreg_String_Type, py_key, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_key)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.key = (struct winreg_String *)py_talloc_get_ptr(py_key);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_reserved, return false;);
	r->in.reserved = PyInt_AsLong(py_reserved);
	return true;
}

static PyObject *unpack_py_winreg_DeleteKeyEx_args_out(struct winreg_DeleteKeyEx *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_winreg_methods[] = {
	{ "OpenHKCR", "S.OpenHKCR(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCR_r, (py_data_pack_fn)pack_py_winreg_OpenHKCR_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCR_args_out, 0, &ndr_table_winreg },
	{ "OpenHKCU", "S.OpenHKCU(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCU_r, (py_data_pack_fn)pack_py_winreg_OpenHKCU_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCU_args_out, 1, &ndr_table_winreg },
	{ "OpenHKLM", "S.OpenHKLM(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKLM_r, (py_data_pack_fn)pack_py_winreg_OpenHKLM_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKLM_args_out, 2, &ndr_table_winreg },
	{ "OpenHKPD", "S.OpenHKPD(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPD_r, (py_data_pack_fn)pack_py_winreg_OpenHKPD_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPD_args_out, 3, &ndr_table_winreg },
	{ "OpenHKU", "S.OpenHKU(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKU_r, (py_data_pack_fn)pack_py_winreg_OpenHKU_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKU_args_out, 4, &ndr_table_winreg },
	{ "CloseKey", "S.CloseKey(handle) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_CloseKey_r, (py_data_pack_fn)pack_py_winreg_CloseKey_args_in, (py_data_unpack_fn)unpack_py_winreg_CloseKey_args_out, 5, &ndr_table_winreg },
	{ "CreateKey", "S.CreateKey(handle, name, keyclass, options, access_mask, secdesc, action_taken) -> (new_handle, action_taken)", (py_dcerpc_call_fn)dcerpc_winreg_CreateKey_r, (py_data_pack_fn)pack_py_winreg_CreateKey_args_in, (py_data_unpack_fn)unpack_py_winreg_CreateKey_args_out, 6, &ndr_table_winreg },
	{ "DeleteKey", "S.DeleteKey(handle, key) -> None", (py_dcerpc_call_fn)dcerpc_winreg_DeleteKey_r, (py_data_pack_fn)pack_py_winreg_DeleteKey_args_in, (py_data_unpack_fn)unpack_py_winreg_DeleteKey_args_out, 7, &ndr_table_winreg },
	{ "DeleteValue", "S.DeleteValue(handle, value) -> None", (py_dcerpc_call_fn)dcerpc_winreg_DeleteValue_r, (py_data_pack_fn)pack_py_winreg_DeleteValue_args_in, (py_data_unpack_fn)unpack_py_winreg_DeleteValue_args_out, 8, &ndr_table_winreg },
	{ "EnumKey", "S.EnumKey(handle, enum_index, name, keyclass, last_changed_time) -> (name, keyclass, last_changed_time)", (py_dcerpc_call_fn)dcerpc_winreg_EnumKey_r, (py_data_pack_fn)pack_py_winreg_EnumKey_args_in, (py_data_unpack_fn)unpack_py_winreg_EnumKey_args_out, 9, &ndr_table_winreg },
	{ "EnumValue", "S.EnumValue(handle, enum_index, name, type, value, size, length) -> (name, type, value, size, length)", (py_dcerpc_call_fn)dcerpc_winreg_EnumValue_r, (py_data_pack_fn)pack_py_winreg_EnumValue_args_in, (py_data_unpack_fn)unpack_py_winreg_EnumValue_args_out, 10, &ndr_table_winreg },
	{ "FlushKey", "S.FlushKey(handle) -> None", (py_dcerpc_call_fn)dcerpc_winreg_FlushKey_r, (py_data_pack_fn)pack_py_winreg_FlushKey_args_in, (py_data_unpack_fn)unpack_py_winreg_FlushKey_args_out, 11, &ndr_table_winreg },
	{ "GetKeySecurity", "S.GetKeySecurity(handle, sec_info, sd) -> sd", (py_dcerpc_call_fn)dcerpc_winreg_GetKeySecurity_r, (py_data_pack_fn)pack_py_winreg_GetKeySecurity_args_in, (py_data_unpack_fn)unpack_py_winreg_GetKeySecurity_args_out, 12, &ndr_table_winreg },
	{ "LoadKey", "S.LoadKey(handle, keyname, filename) -> None", (py_dcerpc_call_fn)dcerpc_winreg_LoadKey_r, (py_data_pack_fn)pack_py_winreg_LoadKey_args_in, (py_data_unpack_fn)unpack_py_winreg_LoadKey_args_out, 13, &ndr_table_winreg },
	{ "NotifyChangeKeyValue", "S.NotifyChangeKeyValue(handle, watch_subtree, notify_filter, unknown, string1, string2, unknown2) -> None", (py_dcerpc_call_fn)dcerpc_winreg_NotifyChangeKeyValue_r, (py_data_pack_fn)pack_py_winreg_NotifyChangeKeyValue_args_in, (py_data_unpack_fn)unpack_py_winreg_NotifyChangeKeyValue_args_out, 14, &ndr_table_winreg },
	{ "OpenKey", "S.OpenKey(parent_handle, keyname, options, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenKey_r, (py_data_pack_fn)pack_py_winreg_OpenKey_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenKey_args_out, 15, &ndr_table_winreg },
	{ "QueryInfoKey", "S.QueryInfoKey(handle, classname) -> (classname, num_subkeys, max_subkeylen, max_classlen, num_values, max_valnamelen, max_valbufsize, secdescsize, last_changed_time)", (py_dcerpc_call_fn)dcerpc_winreg_QueryInfoKey_r, (py_data_pack_fn)pack_py_winreg_QueryInfoKey_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryInfoKey_args_out, 16, &ndr_table_winreg },
	{ "QueryValue", "S.QueryValue(handle, value_name, type, data, data_size, data_length) -> (type, data, data_size, data_length)", (py_dcerpc_call_fn)dcerpc_winreg_QueryValue_r, (py_data_pack_fn)pack_py_winreg_QueryValue_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryValue_args_out, 17, &ndr_table_winreg },
	{ "ReplaceKey", "S.ReplaceKey(handle, subkey, new_file, old_file) -> None", (py_dcerpc_call_fn)dcerpc_winreg_ReplaceKey_r, (py_data_pack_fn)pack_py_winreg_ReplaceKey_args_in, (py_data_unpack_fn)unpack_py_winreg_ReplaceKey_args_out, 18, &ndr_table_winreg },
	{ "RestoreKey", "S.RestoreKey(handle, filename, flags) -> None", (py_dcerpc_call_fn)dcerpc_winreg_RestoreKey_r, (py_data_pack_fn)pack_py_winreg_RestoreKey_args_in, (py_data_unpack_fn)unpack_py_winreg_RestoreKey_args_out, 19, &ndr_table_winreg },
	{ "SaveKey", "S.SaveKey(handle, filename, sec_attrib) -> None", (py_dcerpc_call_fn)dcerpc_winreg_SaveKey_r, (py_data_pack_fn)pack_py_winreg_SaveKey_args_in, (py_data_unpack_fn)unpack_py_winreg_SaveKey_args_out, 20, &ndr_table_winreg },
	{ "SetKeySecurity", "S.SetKeySecurity(handle, sec_info, sd) -> None", (py_dcerpc_call_fn)dcerpc_winreg_SetKeySecurity_r, (py_data_pack_fn)pack_py_winreg_SetKeySecurity_args_in, (py_data_unpack_fn)unpack_py_winreg_SetKeySecurity_args_out, 21, &ndr_table_winreg },
	{ "SetValue", "S.SetValue(handle, name, type, data) -> None", (py_dcerpc_call_fn)dcerpc_winreg_SetValue_r, (py_data_pack_fn)pack_py_winreg_SetValue_args_in, (py_data_unpack_fn)unpack_py_winreg_SetValue_args_out, 22, &ndr_table_winreg },
	{ "UnLoadKey", "S.UnLoadKey(handle, subkey) -> None", (py_dcerpc_call_fn)dcerpc_winreg_UnLoadKey_r, (py_data_pack_fn)pack_py_winreg_UnLoadKey_args_in, (py_data_unpack_fn)unpack_py_winreg_UnLoadKey_args_out, 23, &ndr_table_winreg },
	{ "InitiateSystemShutdown", "S.InitiateSystemShutdown(hostname, message, timeout, force_apps, do_reboot) -> None", (py_dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdown_r, (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdown_args_in, (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdown_args_out, 24, &ndr_table_winreg },
	{ "AbortSystemShutdown", "S.AbortSystemShutdown(server) -> None", (py_dcerpc_call_fn)dcerpc_winreg_AbortSystemShutdown_r, (py_data_pack_fn)pack_py_winreg_AbortSystemShutdown_args_in, (py_data_unpack_fn)unpack_py_winreg_AbortSystemShutdown_args_out, 25, &ndr_table_winreg },
	{ "GetVersion", "S.GetVersion(handle) -> version", (py_dcerpc_call_fn)dcerpc_winreg_GetVersion_r, (py_data_pack_fn)pack_py_winreg_GetVersion_args_in, (py_data_unpack_fn)unpack_py_winreg_GetVersion_args_out, 26, &ndr_table_winreg },
	{ "OpenHKCC", "S.OpenHKCC(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKCC_r, (py_data_pack_fn)pack_py_winreg_OpenHKCC_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKCC_args_out, 27, &ndr_table_winreg },
	{ "OpenHKDD", "S.OpenHKDD(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKDD_r, (py_data_pack_fn)pack_py_winreg_OpenHKDD_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKDD_args_out, 28, &ndr_table_winreg },
	{ "QueryMultipleValues", "S.QueryMultipleValues(key_handle, values_in, buffer) -> (values_out, buffer)", (py_dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues_r, (py_data_pack_fn)pack_py_winreg_QueryMultipleValues_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryMultipleValues_args_out, 29, &ndr_table_winreg },
	{ "InitiateSystemShutdownEx", "S.InitiateSystemShutdownEx(hostname, message, timeout, force_apps, do_reboot, reason) -> None", (py_dcerpc_call_fn)dcerpc_winreg_InitiateSystemShutdownEx_r, (py_data_pack_fn)pack_py_winreg_InitiateSystemShutdownEx_args_in, (py_data_unpack_fn)unpack_py_winreg_InitiateSystemShutdownEx_args_out, 30, &ndr_table_winreg },
	{ "SaveKeyEx", "S.SaveKeyEx(handle, filename, sec_attrib, flags) -> None", (py_dcerpc_call_fn)dcerpc_winreg_SaveKeyEx_r, (py_data_pack_fn)pack_py_winreg_SaveKeyEx_args_in, (py_data_unpack_fn)unpack_py_winreg_SaveKeyEx_args_out, 31, &ndr_table_winreg },
	{ "OpenHKPT", "S.OpenHKPT(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPT_r, (py_data_pack_fn)pack_py_winreg_OpenHKPT_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPT_args_out, 32, &ndr_table_winreg },
	{ "OpenHKPN", "S.OpenHKPN(system_name, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_winreg_OpenHKPN_r, (py_data_pack_fn)pack_py_winreg_OpenHKPN_args_in, (py_data_unpack_fn)unpack_py_winreg_OpenHKPN_args_out, 33, &ndr_table_winreg },
	{ "QueryMultipleValues2", "S.QueryMultipleValues2(key_handle, values_in, buffer) -> (values_out, buffer, needed)", (py_dcerpc_call_fn)dcerpc_winreg_QueryMultipleValues2_r, (py_data_pack_fn)pack_py_winreg_QueryMultipleValues2_args_in, (py_data_unpack_fn)unpack_py_winreg_QueryMultipleValues2_args_out, 34, &ndr_table_winreg },
	{ "DeleteKeyEx", "S.DeleteKeyEx(handle, key, access_mask, reserved) -> None", (py_dcerpc_call_fn)dcerpc_winreg_DeleteKeyEx_r, (py_data_pack_fn)pack_py_winreg_DeleteKeyEx_args_in, (py_data_unpack_fn)unpack_py_winreg_DeleteKeyEx_args_out, 35, &ndr_table_winreg },
	{ NULL }
};

static PyObject *interface_winreg_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_winreg);
}

#define PY_DOC_WINREG "Remote Registry Service"
static PyTypeObject winreg_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "winreg.winreg",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "winreg(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_WINREG,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_winreg_new,
};

static PyMethodDef winreg_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initwinreg(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_lsa;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_talloc;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	winreg_String_Type.tp_base = Object_Type;

	KeySecurityData_Type.tp_base = Object_Type;

	winreg_SecBuf_Type.tp_base = Object_Type;

	winreg_StringBuf_Type.tp_base = Object_Type;

	winreg_ValNameBuf_Type.tp_base = Object_Type;

	KeySecurityAttribute_Type.tp_base = Object_Type;

	QueryMultipleValue_Type.tp_base = Object_Type;

	winreg_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&winreg_String_Type) < 0)
		return;
	if (PyType_Ready(&KeySecurityData_Type) < 0)
		return;
	if (PyType_Ready(&winreg_SecBuf_Type) < 0)
		return;
	if (PyType_Ready(&winreg_StringBuf_Type) < 0)
		return;
	if (PyType_Ready(&winreg_ValNameBuf_Type) < 0)
		return;
	if (PyType_Ready(&KeySecurityAttribute_Type) < 0)
		return;
	if (PyType_Ready(&QueryMultipleValue_Type) < 0)
		return;
	if (PyType_Ready(&winreg_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&winreg_InterfaceType, py_ndr_winreg_methods))
		return;

#ifdef PY_STRING_PATCH
	PY_STRING_PATCH(&winreg_String_Type);
#endif
#ifdef PY_KEYSECURITYDATA_PATCH
	PY_KEYSECURITYDATA_PATCH(&KeySecurityData_Type);
#endif
#ifdef PY_SECBUF_PATCH
	PY_SECBUF_PATCH(&winreg_SecBuf_Type);
#endif
#ifdef PY_STRINGBUF_PATCH
	PY_STRINGBUF_PATCH(&winreg_StringBuf_Type);
#endif
#ifdef PY_VALNAMEBUF_PATCH
	PY_VALNAMEBUF_PATCH(&winreg_ValNameBuf_Type);
#endif
#ifdef PY_KEYSECURITYATTRIBUTE_PATCH
	PY_KEYSECURITYATTRIBUTE_PATCH(&KeySecurityAttribute_Type);
#endif
#ifdef PY_QUERYMULTIPLEVALUE_PATCH
	PY_QUERYMULTIPLEVALUE_PATCH(&QueryMultipleValue_Type);
#endif
#ifdef PY_WINREG_PATCH
	PY_WINREG_PATCH(&winreg_InterfaceType);
#endif

	m = Py_InitModule3("winreg", winreg_methods, "winreg DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_SECURITY", PyInt_FromLong(REG_NOTIFY_CHANGE_SECURITY));
	PyModule_AddObject(m, "KEY_CREATE_SUB_KEY", PyInt_FromLong(KEY_CREATE_SUB_KEY));
	PyModule_AddObject(m, "KEY_WOW64_64KEY", PyInt_FromLong(KEY_WOW64_64KEY));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_NAME", PyInt_FromLong(REG_NOTIFY_CHANGE_NAME));
	PyModule_AddObject(m, "KEY_QUERY_VALUE", PyInt_FromLong(KEY_QUERY_VALUE));
	PyModule_AddObject(m, "REG_REFRESH_HIVE", PyInt_FromLong(REG_REFRESH_HIVE));
	PyModule_AddObject(m, "REG_ACTION_NONE", PyInt_FromLong(REG_ACTION_NONE));
	PyModule_AddObject(m, "REG_NO_LAZY_FLUSH", PyInt_FromLong(REG_NO_LAZY_FLUSH));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_ATTRIBUTES", PyInt_FromLong(REG_NOTIFY_CHANGE_ATTRIBUTES));
	PyModule_AddObject(m, "REG_OPENED_EXISTING_KEY", PyInt_FromLong(REG_OPENED_EXISTING_KEY));
	PyModule_AddObject(m, "REG_KEY_EXECUTE", PyInt_FromLong(REG_KEY_READ));
	PyModule_AddObject(m, "KEY_ENUMERATE_SUB_KEYS", PyInt_FromLong(KEY_ENUMERATE_SUB_KEYS));
	PyModule_AddObject(m, "REG_NOTIFY_CHANGE_LAST_SET", PyInt_FromLong(REG_NOTIFY_CHANGE_LAST_SET));
	PyModule_AddObject(m, "KEY_NOTIFY", PyInt_FromLong(KEY_NOTIFY));
	PyModule_AddObject(m, "REG_FORCE_RESTORE", PyInt_FromLong(REG_FORCE_RESTORE));
	PyModule_AddObject(m, "REG_OPTION_BACKUP_RESTORE", PyInt_FromLong(REG_OPTION_BACKUP_RESTORE));
	PyModule_AddObject(m, "KEY_SET_VALUE", PyInt_FromLong(KEY_SET_VALUE));
	PyModule_AddObject(m, "REG_KEY_READ", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS|KEY_QUERY_VALUE|KEY_ENUMERATE_SUB_KEYS|KEY_NOTIFY)));
	PyModule_AddObject(m, "REG_WHOLE_HIVE_VOLATILE", PyInt_FromLong(REG_WHOLE_HIVE_VOLATILE));
	PyModule_AddObject(m, "REG_CREATED_NEW_KEY", PyInt_FromLong(REG_CREATED_NEW_KEY));
	PyModule_AddObject(m, "REG_OPTION_NON_VOLATILE", PyInt_FromLong(0x00000000));
	PyModule_AddObject(m, "REG_KEY_WRITE", PyInt_FromLong((STANDARD_RIGHTS_WRITE_ACCESS|KEY_SET_VALUE|KEY_CREATE_SUB_KEY)));
	PyModule_AddObject(m, "KEY_CREATE_LINK", PyInt_FromLong(KEY_CREATE_LINK));
	PyModule_AddObject(m, "REG_OPTION_OPEN_LINK", PyInt_FromLong(REG_OPTION_OPEN_LINK));
	PyModule_AddObject(m, "REG_OPTION_CREATE_LINK", PyInt_FromLong(REG_OPTION_CREATE_LINK));
	PyModule_AddObject(m, "REG_KEY_ALL", PyInt_FromLong((STANDARD_RIGHTS_REQUIRED_ACCESS|REG_KEY_READ|REG_KEY_WRITE|KEY_CREATE_LINK)));
	PyModule_AddObject(m, "KEY_WOW64_32KEY", PyInt_FromLong(KEY_WOW64_32KEY));
	PyModule_AddObject(m, "REG_OPTION_VOLATILE", PyInt_FromLong(REG_OPTION_VOLATILE));
	Py_INCREF((PyObject *)(void *)&winreg_String_Type);
	PyModule_AddObject(m, "String", (PyObject *)(void *)&winreg_String_Type);
	Py_INCREF((PyObject *)(void *)&KeySecurityData_Type);
	PyModule_AddObject(m, "KeySecurityData", (PyObject *)(void *)&KeySecurityData_Type);
	Py_INCREF((PyObject *)(void *)&winreg_SecBuf_Type);
	PyModule_AddObject(m, "SecBuf", (PyObject *)(void *)&winreg_SecBuf_Type);
	Py_INCREF((PyObject *)(void *)&winreg_StringBuf_Type);
	PyModule_AddObject(m, "StringBuf", (PyObject *)(void *)&winreg_StringBuf_Type);
	Py_INCREF((PyObject *)(void *)&winreg_ValNameBuf_Type);
	PyModule_AddObject(m, "ValNameBuf", (PyObject *)(void *)&winreg_ValNameBuf_Type);
	Py_INCREF((PyObject *)(void *)&KeySecurityAttribute_Type);
	PyModule_AddObject(m, "KeySecurityAttribute", (PyObject *)(void *)&KeySecurityAttribute_Type);
	Py_INCREF((PyObject *)(void *)&QueryMultipleValue_Type);
	PyModule_AddObject(m, "QueryMultipleValue", (PyObject *)(void *)&QueryMultipleValue_Type);
	Py_INCREF((PyObject *)(void *)&winreg_InterfaceType);
	PyModule_AddObject(m, "winreg", (PyObject *)(void *)&winreg_InterfaceType);
#ifdef PY_MOD_WINREG_PATCH
	PY_MOD_WINREG_PATCH(m);
#endif

}
