/*
 * Copyright (c) 2018 SignalWire, Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "signalwire-client-c/client.h"

SWCLT_DECLARE(ks_status_t) swclt_init(int default_log_level)
{
	ks_status_t status;

	if (status = ks_init())
		return status;

	swclt_enable_log_output(default_log_level);

	if (status = swclt_hmgr_init()) {
		ks_log(KS_LOG_CRIT, "Failed to initialize client manager: %lu", status);
		ks_shutdown();
		ks_debug_break();
		return status;
	}

	return status;
}

SWCLT_DECLARE(ks_status_t) swclt_shutdown()
{
	swclt_hmgr_shutdown();
	return ks_shutdown();
}

SWCLT_DECLARE(void) swclt_enable_log_output(int default_log_level)
{
	ks_global_set_log_level(default_log_level);
}
