/*
 * VRT RULES
 *
 * Copyright (C) 2014-2021 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "detection_lib_meta.h"

/* declare detection functions */
int rule593eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow for sid 593 */
/* flow:established, to_server; */
static FlowFlags rule593flow1 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule593option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule593flow1 }
};

/* content for sid 593 */
// content:"|00 01 86 A0|", offset 16, depth 4;
static ContentInfo rule593content2 =
{
    (u_int8_t *)("|00 01 86 A0|"), /* pattern (now in snort content format) */
    4, /* depth */
    16, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule593option2 =
{
    OPTION_TYPE_CONTENT,
    { &rule593content2 }
};

// content:"|00 00 00 03|", offset 4, depth 4, relative;
static ContentInfo rule593content3 =
{
    (u_int8_t *)("|00 00 00 03|"), /* pattern (now in snort content format) */
    4, /* depth */
    4, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule593option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule593content3 }
};

// content:"|00 01 87 99|", depth 4, relative;
static ContentInfo rule593content6 =
{
    (u_int8_t *)("|00 01 87 99|"), /* pattern (now in snort content format) */
    4, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule593option6 =
{
    OPTION_TYPE_CONTENT,
    { &rule593content6 }
};

// content:"|00 00 00 00|", offset 8, depth 4;
static ContentInfo rule593content7 =
{
    (u_int8_t *)("|00 00 00 00|"), /* pattern (now in snort content format) */
    4, /* depth */
    8, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule593option7 =
{
    OPTION_TYPE_CONTENT,
    { &rule593content7 }
};

/* byte_test for sid 593 */
/* byte_jump:size 4, offset 4, relative, endian little; */
static ByteData rule593byte_jump4 =
{
    4, /* size */
    0, /* operator, byte_jump doesn't use operator! */
    0, /* value, byte_jump doesn't use value! */
    4, /* offset */
    0, /* multiplier */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule593option4 =
{
    OPTION_TYPE_BYTE_JUMP,
    { &rule593byte_jump4 }
};

/* byte_jump:size 4, offset 4, relative, endian little; */
static ByteData rule593byte_jump5 =
{
    4, /* size */
    0, /* operator, byte_jump doesn't use operator! */
    0, /* value, byte_jump doesn't use value! */
    4, /* offset */
    0, /* multiplier */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule593option5 =
{
    OPTION_TYPE_BYTE_JUMP,
    { &rule593byte_jump5 }
};


/* references for sid 593 */
static RuleReference *rule593refs[] =
{
    NULL
};

RuleOption *rule593options[] =
{
    &rule593option1,
    &rule593option2,
    &rule593option3,
    &rule593option4,
    &rule593option5,
    &rule593option6,
    &rule593option7,
    NULL
};

Rule rule593 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "111", /* DSTPORT   */
   },
   /* metadata */
   {
       RULE_GID,  /* genid (HARDCODED!!!) */
       593, /* sigid */
       18, /* revision */

       "rpc-portmap-decode", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "RPC portmap snmpXdmi request TCP",     /* message */
       rule593refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule593options, /* ptr to rule options */
    NULL,                               /* Use internal eval func */
    0,                                  /* Not initialized */
    0,                                  /* Rule option count, used internally */
    0,                                  /* Flag with no alert, used internally */
    NULL /* ptr to internal data... setup during rule registration */
};



/* detection functions */

int rule593eval(void *p) {
    /* cursors, formally known as doe_ptr */
    const u_int8_t *cursor_normal = 0;

    /* flow:established, to_server; */
    if (checkFlow(p, rule593options[0]->option_u.flowFlags)) {
        // content:"|00 01 86 A0|", offset 16, depth 4;
        if (contentMatch(p, rule593options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"|00 00 00 03|", offset 4, depth 4, relative;
            if (contentMatch(p, rule593options[2]->option_u.content, &cursor_normal) > 0) {
                /* byte_jump:size 4, offset 4, relative, endian little; */
                if (byteJump(p, rule593options[3]->option_u.byte, &cursor_normal)) {
                    /* byte_jump:size 4, offset 4, relative, endian little; */
                    if (byteJump(p, rule593options[4]->option_u.byte, &cursor_normal)) {
                        // content:"|00 01 87 99|", depth 4, relative;
                        if (contentMatch(p, rule593options[5]->option_u.content, &cursor_normal) > 0) {
                            // content:"|00 00 00 00|", offset 8, depth 4;
                            if (contentMatch(p, rule593options[6]->option_u.content, &cursor_normal) > 0) {
                                return RULE_MATCH;
                            }
                        }
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}
