/* 
 * Copyright 2016-2022 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SPOOFER_MANAGER_COMMON_SPOOF_QT_H
#define SPOOFER_MANAGER_COMMON_SPOOF_QT_H

#define QT_DEPRECATED_WARNINGS

#define QT_NO_CAST_FROM_ASCII
#include <QString>
#include <QStringBuilder> // efficient QString concatenation with operator%
#include <QProcess>

#include <QtDebug>
#if QT_VERSION < QT_VERSION_CHECK(5, 5, 0) // qInfo() wasn't added until Qt 5.5
#define QtInfoMsg  (static_cast<QtMsgType>(4))
#define qInfo() (QDebug(QtInfoMsg))
#endif

#define QSL(str) QStringLiteral(str) // efficient ctor for QString literal

// disambiguate a QT signal that is implemented by an overloaded member
#define SIGCAST(type, func, args)  static_cast<void(type::*)args>(&type::func)

#if QT_VERSION >= QT_VERSION_CHECK(5, 6, 0) // 5.6.0 or later
#define QPROCESS_ERROR_OCCURRED  &QProcess::errorOccurred
#else
#define QPROCESS_ERROR_OCCURRED  SIGCAST(QProcess, error, (QProcess::ProcessError))
#endif

#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0) // 5.15.0 or later
#define QNETWORKREPLY_ERROR_OCCURRED  &QNetworkReply::errorOccurred
#else
#define QNETWORKREPLY_ERROR_OCCURRED  SIGCAST(QNetworkReply, error, (QNetworkReply::NetworkError))
#endif

#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0) // 5.15.0 or later
#define QLOCALSOCKET_ERROR_OCCURRED  &QLocalSocket::errorOccurred
#else
#define QLOCALSOCKET_ERROR_OCCURRED  SIGCAST(QLocalSocket, error, (QLocalSocket::LocalSocketError))
#endif

#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0) // 5.15.0 or later
#define Qt_endl  Qt::endl
#define Qt_flush Qt::flush
#define Qt_left  Qt::left
#else
#define Qt_endl  endl
#define Qt_flush flush
#define Qt_left  left
#endif

#if !defined(Q_OS_MACOS) && defined(Q_OS_MAC)
#define Q_OS_MACOS Q_OS_MAC // Q_OS_MACOS replaced Q_OS_MAC in Qt 5.6
#endif

QString processErrorMessage(const QProcess &proc);

#endif // SPOOFER_MANAGER_COMMON_SPOOF_QT_H
