---
title: Developer
---

# Developer Documentation

- [Libraries Licenses](../Libraries_Licenses.md) - which libraries are used and under which licenses
- [Developer/CodeStyle](CodeStyle.md) - information about how the sourcecode should look like
- [Developer/Tests](Tests.md) - information about performed software tests
- [Developer/Unit Tests](Unit_Tests.md) - information about how to set up Unit Tests
- [Developer/GUI Testing](GUI_Testing.md) - information about how to set up "interactive" GUI Tests with PyAutoGUI
- [Developer/Debugging](Debugging.md) - information about debugging SUMO
- [Developer/Exploring the structure](ExploringTheStructure.md) - explore the structure of SUMO with the doxygen documentation
- [Inline code documentation (doxygen)](http://sumo.dlr.de/daily/doxygen/)
- [Developer/Used Tools](Used_Tools.md) - tools used for developing SUMO
- [Developer/Managing Publications](Managing_Publications.md) - how to work with the publications bibtex-file
- [Developer/FMI](FMI.md) - information about the current state of the FMI 2.0 support in SUMO
- [Developer/Maven](Maven.md) - information about using libsumo/libtraci in maven builds

## Build instructions

- [Installing/Linux Build](../Installing/Linux_Build.md) - how to
  build on Linux
- [Installing/Windows Build](../Installing/Windows_Build.md) -
  how to build on Windows
- [Installing/macOS Build](../Installing/MacOS_Build.md) - how to
  build on macOS
- [Developer/Documentation Build](Documentation_Build.md) - how to build the
  documentation
- [Developer/Nightly Build](Nightly_Build.md) - what
  happens every night
- [Status page](https://sumo.dlr.de/daily/) - log files and test
  results of nightly builds

## How Tos

- [How To write an own network importer](How_To/Net_Importer.md)
- [How To extend the vehicle class](How_To/Extend_Vehicles.md)
- [How To implement an own car-following model](How_To/Car-Following_Model.md)
- [How To implement a new device](How_To/Device.md)
- [How To contribute to this documentation](../FAQ.md#how_do_i_contribute_to_the_documentation)
- [How to contribute to SUMO in general](../FAQ.md#how_can_i_contribute_to_sumo)

## Methods, Algorithms, and Subsystems

- [Developer/Implementation Notes](Implementation_Notes/index.md) - more information about several subtopics (error handling, options sub system)
- [Developer/Network Building Process](Network_Building_Process.md)

## Current Development

- [How To add more car-following models](Implementation_Notes/Vehicle_Models.md)
- [Progress on implementing an XML validation](XML_Validation.md)
- [Developer/HowToRelease](HowToRelease.md) - how to build a release
- [Developer/Docker](Docker.md) - projects using Dockerised SUMO
- [Git](GitStuff.md)
- [Visual Studio Code](VisualStudioCode.md) - how to use Visual Studio Code with the SUMO code base

## Continuous integration, code analysis and other external references

- [GitHub project](https://github.com/eclipse/sumo)
- [SourceForge project](https://sourceforge.net/projects/sumo/)
- [Packages on the open build service](https://software.opensuse.org/package/sumo)
- [Nightly builds on the open build service](https://build.opensuse.org/package/show/home:behrisch/sumo_nightly)
- [SUMO on Travis](https://travis-ci.org/eclipse/sumo) (legacy)
- [SUMO brew formula on Travis](https://travis-ci.org/dlr-ts/homebrew-sumo)
- [SUMO on OpenHub](https://www.openhub.net/p/sumo/)
- [SUMO on codeclimate](https://codeclimate.com/github/DLR-TS/sumo)
