// Copyright (c) 2020 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by tailscale.com/cmd/cloner -type Config,Peer,Endpoints,IPPortSet; DO NOT EDIT.

package wgcfg

import (
	"inet.af/netaddr"
	"tailscale.com/tailcfg"
	"tailscale.com/types/wgkey"
)

// Clone makes a deep copy of Config.
// The result aliases no memory with the original.
func (src *Config) Clone() *Config {
	if src == nil {
		return nil
	}
	dst := new(Config)
	*dst = *src
	dst.Addresses = append(src.Addresses[:0:0], src.Addresses...)
	dst.DNS = append(src.DNS[:0:0], src.DNS...)
	dst.Peers = make([]Peer, len(src.Peers))
	for i := range dst.Peers {
		dst.Peers[i] = *src.Peers[i].Clone()
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with command:
//   tailscale.com/cmd/cloner -type Config,Peer,Endpoints,IPPortSet
var _ConfigNeedsRegeneration = Config(struct {
	Name       string
	PrivateKey wgkey.Private
	Addresses  []netaddr.IPPrefix
	MTU        uint16
	DNS        []netaddr.IP
	Peers      []Peer
}{})

// Clone makes a deep copy of Peer.
// The result aliases no memory with the original.
func (src *Peer) Clone() *Peer {
	if src == nil {
		return nil
	}
	dst := new(Peer)
	*dst = *src
	dst.AllowedIPs = append(src.AllowedIPs[:0:0], src.AllowedIPs...)
	dst.Endpoints = *src.Endpoints.Clone()
	return dst
}

// A compilation failure here means this code must be regenerated, with command:
//   tailscale.com/cmd/cloner -type Config,Peer,Endpoints,IPPortSet
var _PeerNeedsRegeneration = Peer(struct {
	PublicKey           wgkey.Key
	AllowedIPs          []netaddr.IPPrefix
	Endpoints           Endpoints
	PersistentKeepalive uint16
}{})

// Clone makes a deep copy of Endpoints.
// The result aliases no memory with the original.
func (src *Endpoints) Clone() *Endpoints {
	if src == nil {
		return nil
	}
	dst := new(Endpoints)
	*dst = *src
	dst.IPPorts = *src.IPPorts.Clone()
	return dst
}

// A compilation failure here means this code must be regenerated, with command:
//   tailscale.com/cmd/cloner -type Config,Peer,Endpoints,IPPortSet
var _EndpointsNeedsRegeneration = Endpoints(struct {
	PublicKey wgkey.Key
	DiscoKey  tailcfg.DiscoKey
	IPPorts   IPPortSet
}{})

// Clone makes a deep copy of IPPortSet.
// The result aliases no memory with the original.
func (src *IPPortSet) Clone() *IPPortSet {
	if src == nil {
		return nil
	}
	dst := new(IPPortSet)
	*dst = *src
	dst.ipp = append(src.ipp[:0:0], src.ipp...)
	return dst
}

// A compilation failure here means this code must be regenerated, with command:
//   tailscale.com/cmd/cloner -type Config,Peer,Endpoints,IPPortSet
var _IPPortSetNeedsRegeneration = IPPortSet(struct {
	ipp []netaddr.IPPort
}{})
