'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var SinkTestList = require('./sink/sinkTest').SinkTestList;
var SinkValidateList = require('./sink/sinkValidate').SinkValidateList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var SinkList;
var SinkPage;
var SinkInstance;
var SinkContext;

/* jshint ignore:start */
/**
 * Initialize the SinkList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SinkList
 *
 * @param {Twilio.Events.V1} version - Version of the resource
 */
/* jshint ignore:end */
SinkList = function SinkList(version) {
  /* jshint ignore:start */
  /**
   * @function sinks
   * @memberof Twilio.Events.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Events.V1.SinkContext}
   */
  /* jshint ignore:end */
  function SinkListInstance(sid) {
    return SinkListInstance.get(sid);
  }

  SinkListInstance._version = version;
  // Path Solution
  SinkListInstance._solution = {};
  SinkListInstance._uri = `/Sinks`;
  /* jshint ignore:start */
  /**
   * create a SinkInstance
   *
   * @function create
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.description - Sink Description.
   * @param {object} opts.sinkConfiguration - JSON Sink configuration.
   * @param {sink.sink_type} opts.sinkType - Sink type.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SinkInstance
   */
  /* jshint ignore:end */
  SinkListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.description)) {
      throw new Error('Required parameter "opts.description" missing.');
    }
    if (_.isUndefined(opts.sinkConfiguration)) {
      throw new Error('Required parameter "opts.sinkConfiguration" missing.');
    }
    if (_.isUndefined(opts.sinkType)) {
      throw new Error('Required parameter "opts.sinkType" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Description': _.get(opts, 'description'),
      'SinkConfiguration': serialize.object(_.get(opts, 'sinkConfiguration')),
      'SinkType': _.get(opts, 'sinkType')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SinkInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams SinkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.inUse] -
   *          A boolean to return sinks used/not used by a subscription.
   * @param {string} [opts.status] - A string to filter sinks by status.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SinkListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SinkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.inUse] -
   *          A boolean to return sinks used/not used by a subscription.
   * @param {string} [opts.status] - A string to filter sinks by status.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SinkListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SinkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.inUse] -
   *          A boolean to return sinks used/not used by a subscription.
   * @param {string} [opts.status] - A string to filter sinks by status.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SinkListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'InUse': serialize.bool(_.get(opts, 'inUse')),
      'Status': _.get(opts, 'status'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SinkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SinkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SinkListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SinkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a sink
   *
   * @function get
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @param {string} sid - A string that uniquely identifies this Sink.
   *
   * @returns {Twilio.Events.V1.SinkContext}
   */
  /* jshint ignore:end */
  SinkListInstance.get = function get(sid) {
    return new SinkContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Events.V1.SinkList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SinkListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SinkListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return SinkListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SinkPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SinkPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SinkSolution} solution - Path solution
 *
 * @returns SinkPage
 */
/* jshint ignore:end */
SinkPage = function SinkPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SinkPage.prototype, Page.prototype);
SinkPage.prototype.constructor = SinkPage;

/* jshint ignore:start */
/**
 * Build an instance of SinkInstance
 *
 * @function getInstance
 * @memberof Twilio.Events.V1.SinkPage#
 *
 * @param {SinkPayload} payload - Payload response from the API
 *
 * @returns SinkInstance
 */
/* jshint ignore:end */
SinkPage.prototype.getInstance = function getInstance(payload) {
  return new SinkInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SinkPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SinkPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SinkPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SinkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SinkInstance
 *
 * @property {Date} dateCreated - The date this Sink was created
 * @property {Date} dateUpdated - The date this Sink was updated
 * @property {string} description - Sink Description
 * @property {string} sid - A string that uniquely identifies this Sink.
 * @property {object} sinkConfiguration - JSON Sink configuration.
 * @property {sink.sink_type} sinkType - Sink type.
 * @property {sink.status} status - The Status of this Sink
 * @property {string} url - The URL of this resource.
 * @property {string} links - Nested resource URLs.
 *
 * @param {V1} version - Version of the resource
 * @param {SinkPayload} payload - The instance payload
 * @param {sid} sid - A string that uniquely identifies this Sink.
 */
/* jshint ignore:end */
SinkInstance = function SinkInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.sinkConfiguration = payload.sink_configuration; // jshint ignore:line
  this.sinkType = payload.sink_type; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(SinkInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SinkContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SinkInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a SinkInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * update a SinkInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.description - Sink Description
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the sinkTest
 *
 * @function sinkTest
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @returns {Twilio.Events.V1.SinkContext.SinkTestList}
 */
/* jshint ignore:end */
SinkInstance.prototype.sinkTest = function sinkTest() {
  return this._proxy.sinkTest;
};

/* jshint ignore:start */
/**
 * Access the sinkValidate
 *
 * @function sinkValidate
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @returns {Twilio.Events.V1.SinkContext.SinkValidateList}
 */
/* jshint ignore:end */
SinkInstance.prototype.sinkValidate = function sinkValidate() {
  return this._proxy.sinkValidate;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SinkInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SinkInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SinkInstance.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SinkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SinkContext
 *
 * @property {Twilio.Events.V1.SinkContext.SinkTestList} sinkTest -
 *          sinkTest resource
 * @property {Twilio.Events.V1.SinkContext.SinkValidateList} sinkValidate -
 *          sinkValidate resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - A string that uniquely identifies this Sink.
 */
/* jshint ignore:end */
SinkContext = function SinkContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Sinks/${sid}`;

  // Dependents
  this._sinkTest = undefined;
  this._sinkValidate = undefined;
};

/* jshint ignore:start */
/**
 * fetch a SinkInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SinkContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SinkInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SinkInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SinkContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SinkInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SinkContext#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.description - Sink Description
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SinkInstance
 */
/* jshint ignore:end */
SinkContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts.description)) {
    throw new Error('Required parameter "opts.description" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'Description': _.get(opts, 'description')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SinkInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(SinkContext.prototype,
  'sinkTest', {
    get: function() {
      if (!this._sinkTest) {
        this._sinkTest = new SinkTestList(this._version, this._solution.sid);
      }
      return this._sinkTest;
    }
});

Object.defineProperty(SinkContext.prototype,
  'sinkValidate', {
    get: function() {
      if (!this._sinkValidate) {
        this._sinkValidate = new SinkValidateList(this._version, this._solution.sid);
      }
      return this._sinkValidate;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SinkContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SinkContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SinkContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SinkList: SinkList,
  SinkPage: SinkPage,
  SinkInstance: SinkInstance,
  SinkContext: SinkContext
};
