/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type TrustProductsEvaluationsStatus = 'compliant'|'noncompliant';

/**
 * Initialize the TrustProductsEvaluationsList
 *
 * @param version - Version of the resource
 * @param trustProductSid - The unique string that identifies the resource
 */
declare function TrustProductsEvaluationsList(version: V1, trustProductSid: string): TrustProductsEvaluationsListInstance;

interface TrustProductsEvaluationsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrustProductsEvaluationsContext;
  /**
   * create a TrustProductsEvaluationsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TrustProductsEvaluationsListInstanceCreateOptions, callback?: (error: Error | null, item: TrustProductsEvaluationsInstance) => any): Promise<TrustProductsEvaluationsInstance>;
  /**
   * Streams TrustProductsEvaluationsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TrustProductsEvaluationsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TrustProductsEvaluationsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TrustProductsEvaluationsListInstanceEachOptions, callback?: (item: TrustProductsEvaluationsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a trust_products_evaluations
   *
   * @param sid - The unique string that identifies the Evaluation resource
   */
  get(sid: string): TrustProductsEvaluationsContext;
  /**
   * Retrieve a single target page of TrustProductsEvaluationsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TrustProductsEvaluationsPage) => any): Promise<TrustProductsEvaluationsPage>;
  /**
   * Retrieve a single target page of TrustProductsEvaluationsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TrustProductsEvaluationsPage) => any): Promise<TrustProductsEvaluationsPage>;
  /**
   * Lists TrustProductsEvaluationsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TrustProductsEvaluationsInstance[]) => any): Promise<TrustProductsEvaluationsInstance[]>;
  /**
   * Lists TrustProductsEvaluationsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TrustProductsEvaluationsListInstanceOptions, callback?: (error: Error | null, items: TrustProductsEvaluationsInstance[]) => any): Promise<TrustProductsEvaluationsInstance[]>;
  /**
   * Retrieve a single page of TrustProductsEvaluationsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TrustProductsEvaluationsPage) => any): Promise<TrustProductsEvaluationsPage>;
  /**
   * Retrieve a single page of TrustProductsEvaluationsInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TrustProductsEvaluationsListInstancePageOptions, callback?: (error: Error | null, items: TrustProductsEvaluationsPage) => any): Promise<TrustProductsEvaluationsPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property policySid - The unique string of a policy
 */
interface TrustProductsEvaluationsListInstanceCreateOptions {
  policySid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TrustProductsEvaluationsListInstanceEachOptions {
  callback?: (item: TrustProductsEvaluationsInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TrustProductsEvaluationsListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TrustProductsEvaluationsListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TrustProductsEvaluationsPayload extends TrustProductsEvaluationsResource, Page.TwilioResponsePayload {
}

interface TrustProductsEvaluationsResource {
  account_sid: string;
  date_created: Date;
  policy_sid: string;
  results: object[];
  sid: string;
  status: TrustProductsEvaluationsStatus;
  trust_product_sid: string;
  url: string;
}

interface TrustProductsEvaluationsSolution {
  trustProductSid?: string;
}


declare class TrustProductsEvaluationsContext {
  /**
   * Initialize the TrustProductsEvaluationsContext
   *
   * @param version - Version of the resource
   * @param trustProductSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V1, trustProductSid: string, sid: string);

  /**
   * fetch a TrustProductsEvaluationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsEvaluationsInstance) => any): Promise<TrustProductsEvaluationsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TrustProductsEvaluationsInstance extends SerializableClass {
  /**
   * Initialize the TrustProductsEvaluationsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param trustProductSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V1, payload: TrustProductsEvaluationsPayload, trustProductSid: string, sid: string);

  private _proxy: TrustProductsEvaluationsContext;
  accountSid: string;
  dateCreated: Date;
  /**
   * fetch a TrustProductsEvaluationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsEvaluationsInstance) => any): Promise<TrustProductsEvaluationsInstance>;
  policySid: string;
  results: object[];
  sid: string;
  status: TrustProductsEvaluationsStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trustProductSid: string;
  url: string;
}


declare class TrustProductsEvaluationsPage extends Page<V1, TrustProductsEvaluationsPayload, TrustProductsEvaluationsResource, TrustProductsEvaluationsInstance> {
  /**
   * Initialize the TrustProductsEvaluationsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TrustProductsEvaluationsSolution);

  /**
   * Build an instance of TrustProductsEvaluationsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrustProductsEvaluationsPayload): TrustProductsEvaluationsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrustProductsEvaluationsContext, TrustProductsEvaluationsInstance, TrustProductsEvaluationsList, TrustProductsEvaluationsListInstance, TrustProductsEvaluationsListInstanceCreateOptions, TrustProductsEvaluationsListInstanceEachOptions, TrustProductsEvaluationsListInstanceOptions, TrustProductsEvaluationsListInstancePageOptions, TrustProductsEvaluationsPage, TrustProductsEvaluationsPayload, TrustProductsEvaluationsResource, TrustProductsEvaluationsSolution, TrustProductsEvaluationsStatus }
