/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the TaskQueueStatisticsList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the TaskQueue
 * @param taskQueueSid - The SID of the TaskQueue from which these statistics were calculated
 */
declare function TaskQueueStatisticsList(version: V1, workspaceSid: string, taskQueueSid: string): TaskQueueStatisticsListInstance;

/**
 * Options to pass to fetch
 *
 * @property endDate - Only calculate statistics from on or before this date
 * @property minutes - Only calculate statistics since this many minutes in the past
 * @property splitByWaitTime - A comma separated list of values that describes the thresholds to calculate statistics on
 * @property startDate - Only calculate statistics from on or after this date
 * @property taskChannel - Only calculate real-time and cumulative statistics for the specified TaskChannel
 */
interface TaskQueueStatisticsInstanceFetchOptions {
  endDate?: Date;
  minutes?: number;
  splitByWaitTime?: string;
  startDate?: Date;
  taskChannel?: string;
}

interface TaskQueueStatisticsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TaskQueueStatisticsContext;
  /**
   * Constructs a task_queue_statistics
   */
  get(): TaskQueueStatisticsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface TaskQueueStatisticsPayload extends TaskQueueStatisticsResource, Page.TwilioResponsePayload {
}

interface TaskQueueStatisticsResource {
  account_sid: string;
  cumulative: object;
  realtime: object;
  task_queue_sid: string;
  url: string;
  workspace_sid: string;
}

interface TaskQueueStatisticsSolution {
  taskQueueSid?: string;
  workspaceSid?: string;
}


declare class TaskQueueStatisticsContext {
  /**
   * Initialize the TaskQueueStatisticsContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the TaskQueue to fetch
   * @param taskQueueSid - The SID of the TaskQueue for which to fetch statistics
   */
  constructor(version: V1, workspaceSid: string, taskQueueSid: string);

  /**
   * fetch a TaskQueueStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TaskQueueStatisticsInstance) => any): Promise<TaskQueueStatisticsInstance>;
  /**
   * fetch a TaskQueueStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: TaskQueueStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: TaskQueueStatisticsInstance) => any): Promise<TaskQueueStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TaskQueueStatisticsInstance extends SerializableClass {
  /**
   * Initialize the TaskQueueStatisticsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the TaskQueue
   * @param taskQueueSid - The SID of the TaskQueue from which these statistics were calculated
   */
  constructor(version: V1, payload: TaskQueueStatisticsPayload, workspaceSid: string, taskQueueSid: string);

  private _proxy: TaskQueueStatisticsContext;
  accountSid: string;
  cumulative: any;
  /**
   * fetch a TaskQueueStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TaskQueueStatisticsInstance) => any): Promise<TaskQueueStatisticsInstance>;
  /**
   * fetch a TaskQueueStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: TaskQueueStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: TaskQueueStatisticsInstance) => any): Promise<TaskQueueStatisticsInstance>;
  realtime: any;
  taskQueueSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workspaceSid: string;
}


declare class TaskQueueStatisticsPage extends Page<V1, TaskQueueStatisticsPayload, TaskQueueStatisticsResource, TaskQueueStatisticsInstance> {
  /**
   * Initialize the TaskQueueStatisticsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TaskQueueStatisticsSolution);

  /**
   * Build an instance of TaskQueueStatisticsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TaskQueueStatisticsPayload): TaskQueueStatisticsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TaskQueueStatisticsContext, TaskQueueStatisticsInstance, TaskQueueStatisticsInstanceFetchOptions, TaskQueueStatisticsList, TaskQueueStatisticsListInstance, TaskQueueStatisticsPage, TaskQueueStatisticsPayload, TaskQueueStatisticsResource, TaskQueueStatisticsSolution }
