'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var TollFreeList;
var TollFreePage;
var TollFreeInstance;

/* jshint ignore:start */
/**
 * Initialize the TollFreeList
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created the resource
 */
/* jshint ignore:end */
TollFreeList = function TollFreeList(version, accountSid) {
  /* jshint ignore:start */
  /**
   * @function tollFree
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeContext}
   */
  /* jshint ignore:end */
  function TollFreeListInstance(sid) {
    return TollFreeListInstance.get(sid);
  }

  TollFreeListInstance._version = version;
  // Path Solution
  TollFreeListInstance._solution = {accountSid: accountSid};
  TollFreeListInstance._uri = `/Accounts/${accountSid}/IncomingPhoneNumbers/TollFree.json`;
  /* jshint ignore:start */
  /**
   * Streams TollFreeInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.beta] - Whether to include new phone numbers
   * @param {string} [opts.friendlyName] -
   *          A string that identifies the resources to read
   * @param {string} [opts.phoneNumber] - The phone numbers of the resources to read
   * @param {string} [opts.origin] -
   *          Include phone numbers based on their origin. By default, phone numbers of all origin are included.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  TollFreeListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists TollFreeInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.beta] - Whether to include new phone numbers
   * @param {string} [opts.friendlyName] -
   *          A string that identifies the resources to read
   * @param {string} [opts.phoneNumber] - The phone numbers of the resources to read
   * @param {string} [opts.origin] -
   *          Include phone numbers based on their origin. By default, phone numbers of all origin are included.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TollFreeListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of TollFreeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.beta] - Whether to include new phone numbers
   * @param {string} [opts.friendlyName] -
   *          A string that identifies the resources to read
   * @param {string} [opts.phoneNumber] - The phone numbers of the resources to read
   * @param {string} [opts.origin] -
   *          Include phone numbers based on their origin. By default, phone numbers of all origin are included.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TollFreeListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Beta': serialize.bool(_.get(opts, 'beta')),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'PhoneNumber': _.get(opts, 'phoneNumber'),
      'Origin': _.get(opts, 'origin'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TollFreePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of TollFreeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TollFreeListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new TollFreePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a TollFreeInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.phoneNumber - The phone number to purchase in E.164 format
   * @param {string} [opts.apiVersion] -
   *          The API version to use for incoming calls made to the new phone number
   * @param {string} [opts.friendlyName] - A string to describe the new phone number
   * @param {string} [opts.smsApplicationSid] -
   *          The SID of the application to handle SMS messages
   * @param {string} [opts.smsFallbackMethod] -
   *          HTTP method used with sms_fallback_url
   * @param {string} [opts.smsFallbackUrl] -
   *          The URL we call when an error occurs while executing TwiML
   * @param {string} [opts.smsMethod] - The HTTP method to use with sms_url
   * @param {string} [opts.smsUrl] -
   *          The URL we should call when the new phone number receives an incoming SMS message
   * @param {string} [opts.statusCallback] -
   *          The URL to send status information to your application
   * @param {string} [opts.statusCallbackMethod] -
   *          The HTTP method we should use to call status_callback
   * @param {string} [opts.voiceApplicationSid] -
   *          The SID of the application to handle the new phone number
   * @param {boolean} [opts.voiceCallerIdLookup] -
   *          Whether to lookup the caller's name
   * @param {string} [opts.voiceFallbackMethod] -
   *          The HTTP method used with voice_fallback_url
   * @param {string} [opts.voiceFallbackUrl] -
   *          The URL we will call when an error occurs in TwiML
   * @param {string} [opts.voiceMethod] - The HTTP method used with the voice_url
   * @param {string} [opts.voiceUrl] -
   *          The URL we should call when the phone number receives a call
   * @param {string} [opts.identitySid] -
   *          The SID of the Identity resource to associate with the new phone number
   * @param {string} [opts.addressSid] -
   *          The SID of the Address resource associated with the phone number
   * @param {toll_free.emergency_status} [opts.emergencyStatus] -
   *          Status determining whether the new phone number is enabled for emergency calling
   * @param {string} [opts.emergencyAddressSid] -
   *          The emergency address configuration to use for emergency calling
   * @param {string} [opts.trunkSid] -
   *          SID of the trunk to handle calls to the new phone number
   * @param {toll_free.voice_receive_mode} [opts.voiceReceiveMode] -
   *          Incoming call type: fax or voice
   * @param {string} [opts.bundleSid] -
   *          The SID of the Bundle resource associated with number
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed TollFreeInstance
   */
  /* jshint ignore:end */
  TollFreeListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.phoneNumber)) {
      throw new Error('Required parameter "opts.phoneNumber" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'PhoneNumber': _.get(opts, 'phoneNumber'),
      'ApiVersion': _.get(opts, 'apiVersion'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'SmsApplicationSid': _.get(opts, 'smsApplicationSid'),
      'SmsFallbackMethod': _.get(opts, 'smsFallbackMethod'),
      'SmsFallbackUrl': _.get(opts, 'smsFallbackUrl'),
      'SmsMethod': _.get(opts, 'smsMethod'),
      'SmsUrl': _.get(opts, 'smsUrl'),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'StatusCallbackMethod': _.get(opts, 'statusCallbackMethod'),
      'VoiceApplicationSid': _.get(opts, 'voiceApplicationSid'),
      'VoiceCallerIdLookup': serialize.bool(_.get(opts, 'voiceCallerIdLookup')),
      'VoiceFallbackMethod': _.get(opts, 'voiceFallbackMethod'),
      'VoiceFallbackUrl': _.get(opts, 'voiceFallbackUrl'),
      'VoiceMethod': _.get(opts, 'voiceMethod'),
      'VoiceUrl': _.get(opts, 'voiceUrl'),
      'IdentitySid': _.get(opts, 'identitySid'),
      'AddressSid': _.get(opts, 'addressSid'),
      'EmergencyStatus': _.get(opts, 'emergencyStatus'),
      'EmergencyAddressSid': _.get(opts, 'emergencyAddressSid'),
      'TrunkSid': _.get(opts, 'trunkSid'),
      'VoiceReceiveMode': _.get(opts, 'voiceReceiveMode'),
      'BundleSid': _.get(opts, 'bundleSid')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TollFreeInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TollFreeListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TollFreeListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return TollFreeListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TollFreePage
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreePage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TollFreeSolution} solution - Path solution
 *
 * @returns TollFreePage
 */
/* jshint ignore:end */
TollFreePage = function TollFreePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TollFreePage.prototype, Page.prototype);
TollFreePage.prototype.constructor = TollFreePage;

/* jshint ignore:start */
/**
 * Build an instance of TollFreeInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreePage#
 *
 * @param {TollFreePayload} payload - Payload response from the API
 *
 * @returns TollFreeInstance
 */
/* jshint ignore:end */
TollFreePage.prototype.getInstance = function getInstance(payload) {
  return new TollFreeInstance(this._version, payload, this._solution.accountSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TollFreePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TollFreePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TollFreeContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} addressSid -
 *          The SID of the Address resource associated with the phone number
 * @property {toll_free.address_requirement} addressRequirements -
 *          Whether the phone number requires an Address registered with Twilio.
 * @property {string} apiVersion -
 *          The API version used to start a new TwiML session
 * @property {boolean} beta -
 *          Whether the phone number is new to the Twilio platform
 * @property {PhoneNumberCapabilities} capabilities -
 *          Indicate if a phone can receive calls or messages
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} identitySid -
 *          The SID of the Identity resource associated with number
 * @property {string} phoneNumber - The phone number in E.164 format
 * @property {string} origin - The phone number's origin. Can be twilio or hosted.
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} smsApplicationSid -
 *          The SID of the application that handles SMS messages sent to the phone number
 * @property {string} smsFallbackMethod -
 *          The HTTP method used with sms_fallback_url
 * @property {string} smsFallbackUrl -
 *          The URL that we call when an error occurs while retrieving or executing the TwiML
 * @property {string} smsMethod - The HTTP method to use with sms_url
 * @property {string} smsUrl -
 *          The URL we call when the phone number receives an incoming SMS message
 * @property {string} statusCallback -
 *          The URL to send status information to your application
 * @property {string} statusCallbackMethod -
 *          The HTTP method we use to call status_callback
 * @property {string} trunkSid -
 *          The SID of the Trunk that handles calls to the phone number
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 * @property {toll_free.voice_receive_mode} voiceReceiveMode -
 *          The voice_receive_mode
 * @property {string} voiceApplicationSid -
 *          The SID of the application that handles calls to the phone number
 * @property {boolean} voiceCallerIdLookup - Whether to lookup the caller's name
 * @property {string} voiceFallbackMethod -
 *          The HTTP method used with voice_fallback_url
 * @property {string} voiceFallbackUrl -
 *          The URL we call when an error occurs in TwiML
 * @property {string} voiceMethod - The HTTP method used with the voice_url
 * @property {string} voiceUrl -
 *          The URL we call when the phone number receives a call
 * @property {toll_free.emergency_status} emergencyStatus -
 *          Whether the phone number is enabled for emergency calling
 * @property {string} emergencyAddressSid -
 *          The emergency address configuration to use for emergency calling
 * @property {string} bundleSid -
 *          The SID of the Bundle resource associated with number
 * @property {string} status - The status
 *
 * @param {V2010} version - Version of the resource
 * @param {TollFreePayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created the resource
 */
/* jshint ignore:end */
TollFreeInstance = function TollFreeInstance(version, payload, accountSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.addressSid = payload.address_sid; // jshint ignore:line
  this.addressRequirements = payload.address_requirements; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.beta = payload.beta; // jshint ignore:line
  this.capabilities = payload.capabilities; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.identitySid = payload.identity_sid; // jshint ignore:line
  this.phoneNumber = payload.phone_number; // jshint ignore:line
  this.origin = payload.origin; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.smsApplicationSid = payload.sms_application_sid; // jshint ignore:line
  this.smsFallbackMethod = payload.sms_fallback_method; // jshint ignore:line
  this.smsFallbackUrl = payload.sms_fallback_url; // jshint ignore:line
  this.smsMethod = payload.sms_method; // jshint ignore:line
  this.smsUrl = payload.sms_url; // jshint ignore:line
  this.statusCallback = payload.status_callback; // jshint ignore:line
  this.statusCallbackMethod = payload.status_callback_method; // jshint ignore:line
  this.trunkSid = payload.trunk_sid; // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line
  this.voiceReceiveMode = payload.voice_receive_mode; // jshint ignore:line
  this.voiceApplicationSid = payload.voice_application_sid; // jshint ignore:line
  this.voiceCallerIdLookup = payload.voice_caller_id_lookup; // jshint ignore:line
  this.voiceFallbackMethod = payload.voice_fallback_method; // jshint ignore:line
  this.voiceFallbackUrl = payload.voice_fallback_url; // jshint ignore:line
  this.voiceMethod = payload.voice_method; // jshint ignore:line
  this.voiceUrl = payload.voice_url; // jshint ignore:line
  this.emergencyStatus = payload.emergency_status; // jshint ignore:line
  this.emergencyAddressSid = payload.emergency_address_sid; // jshint ignore:line
  this.bundleSid = payload.bundle_sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.TollFreeInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TollFreeInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TollFreeInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TollFreeList: TollFreeList,
  TollFreePage: TollFreePage,
  TollFreeInstance: TollFreeInstance
};
