/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SchemaVersionList } from './schema/version';
import { SchemaVersionListInstance } from './schema/version';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SchemaList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function SchemaList(version: V1): SchemaListInstance;

interface SchemaListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SchemaContext;
  /**
   * Constructs a schema
   *
   * @param id - The unique identifier of the schema.
   */
  get(id: string): SchemaContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface SchemaPayload extends SchemaResource, Page.TwilioResponsePayload {
}

interface SchemaResource {
  id: string;
  latest_version: number;
  latest_version_date_created: Date;
  links: string;
  url: string;
}

interface SchemaSolution {
}


declare class SchemaContext {
  /**
   * Initialize the SchemaContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param id - The unique identifier of the schema.
   */
  constructor(version: V1, id: string);

  /**
   * fetch a SchemaInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SchemaInstance) => any): Promise<SchemaInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  versions: SchemaVersionListInstance;
}


declare class SchemaInstance extends SerializableClass {
  /**
   * Initialize the SchemaContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param id - The unique identifier of the schema.
   */
  constructor(version: V1, payload: SchemaPayload, id: string);

  private _proxy: SchemaContext;
  /**
   * fetch a SchemaInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SchemaInstance) => any): Promise<SchemaInstance>;
  id: string;
  latestVersion: number;
  latestVersionDateCreated: Date;
  links: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  /**
   * Access the versions
   */
  versions(): SchemaVersionListInstance;
}


declare class SchemaPage extends Page<V1, SchemaPayload, SchemaResource, SchemaInstance> {
  /**
   * Initialize the SchemaPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SchemaSolution);

  /**
   * Build an instance of SchemaInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SchemaPayload): SchemaInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SchemaContext, SchemaInstance, SchemaList, SchemaListInstance, SchemaPage, SchemaPayload, SchemaResource, SchemaSolution }
