/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type BrandRegistrationStatus = 'PENDING'|'APPROVED'|'FAILED';

/**
 * Initialize the BrandRegistrationList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function BrandRegistrationList(version: V1): BrandRegistrationListInstance;

interface BrandRegistrationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BrandRegistrationContext;
  /**
   * create a BrandRegistrationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: BrandRegistrationListInstanceCreateOptions, callback?: (error: Error | null, item: BrandRegistrationInstance) => any): Promise<BrandRegistrationInstance>;
  /**
   * Streams BrandRegistrationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: BrandRegistrationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams BrandRegistrationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: BrandRegistrationListInstanceEachOptions, callback?: (item: BrandRegistrationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a brand_registration
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): BrandRegistrationContext;
  /**
   * Retrieve a single target page of BrandRegistrationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: BrandRegistrationPage) => any): Promise<BrandRegistrationPage>;
  /**
   * Retrieve a single target page of BrandRegistrationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: BrandRegistrationPage) => any): Promise<BrandRegistrationPage>;
  /**
   * Lists BrandRegistrationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: BrandRegistrationInstance[]) => any): Promise<BrandRegistrationInstance[]>;
  /**
   * Lists BrandRegistrationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: BrandRegistrationListInstanceOptions, callback?: (error: Error | null, items: BrandRegistrationInstance[]) => any): Promise<BrandRegistrationInstance[]>;
  /**
   * Retrieve a single page of BrandRegistrationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: BrandRegistrationPage) => any): Promise<BrandRegistrationPage>;
  /**
   * Retrieve a single page of BrandRegistrationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: BrandRegistrationListInstancePageOptions, callback?: (error: Error | null, items: BrandRegistrationPage) => any): Promise<BrandRegistrationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property a2PProfileBundleSid - A2P Messaging Profile Bundle Sid
 * @property brandType - Type of brand being created. One of: "STANDARD", "STARTER".
 * @property customerProfileBundleSid - Customer Profile Bundle Sid
 * @property mock - A boolean that specifies whether brand should be a mock or not. If true, brand will be registered as a mock brand. Defaults to false if no value is provided.
 */
interface BrandRegistrationListInstanceCreateOptions {
  a2PProfileBundleSid: string;
  brandType?: string;
  customerProfileBundleSid: string;
  mock?: boolean;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface BrandRegistrationListInstanceEachOptions {
  callback?: (item: BrandRegistrationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface BrandRegistrationListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface BrandRegistrationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface BrandRegistrationPayload extends BrandRegistrationResource, Page.TwilioResponsePayload {
}

interface BrandRegistrationResource {
  a2p_profile_bundle_sid: string;
  account_sid: string;
  brand_score: number;
  brand_type: string;
  customer_profile_bundle_sid: string;
  date_created: Date;
  date_updated: Date;
  failure_reason: string;
  mock: boolean;
  sid: string;
  status: BrandRegistrationStatus;
  tcr_id: string;
  url: string;
}

interface BrandRegistrationSolution {
}


declare class BrandRegistrationContext {
  /**
   * Initialize the BrandRegistrationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a BrandRegistrationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandRegistrationInstance) => any): Promise<BrandRegistrationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BrandRegistrationInstance extends SerializableClass {
  /**
   * Initialize the BrandRegistrationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: BrandRegistrationPayload, sid: string);

  private _proxy: BrandRegistrationContext;
  a2PProfileBundleSid: string;
  accountSid: string;
  brandScore: number;
  brandType: string;
  customerProfileBundleSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  failureReason: string;
  /**
   * fetch a BrandRegistrationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandRegistrationInstance) => any): Promise<BrandRegistrationInstance>;
  mock: boolean;
  sid: string;
  status: BrandRegistrationStatus;
  tcrId: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class BrandRegistrationPage extends Page<V1, BrandRegistrationPayload, BrandRegistrationResource, BrandRegistrationInstance> {
  /**
   * Initialize the BrandRegistrationPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: BrandRegistrationSolution);

  /**
   * Build an instance of BrandRegistrationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BrandRegistrationPayload): BrandRegistrationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BrandRegistrationContext, BrandRegistrationInstance, BrandRegistrationList, BrandRegistrationListInstance, BrandRegistrationListInstanceCreateOptions, BrandRegistrationListInstanceEachOptions, BrandRegistrationListInstanceOptions, BrandRegistrationListInstancePageOptions, BrandRegistrationPage, BrandRegistrationPayload, BrandRegistrationResource, BrandRegistrationSolution, BrandRegistrationStatus }
