/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the VerificationTemplateList
 *
 * @param version - Version of the resource
 */
declare function VerificationTemplateList(version: V2): VerificationTemplateListInstance;

interface VerificationTemplateListInstance {
  /**
   * Streams VerificationTemplateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: VerificationTemplateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams VerificationTemplateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: VerificationTemplateListInstanceEachOptions, callback?: (item: VerificationTemplateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of VerificationTemplateInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: VerificationTemplatePage) => any): Promise<VerificationTemplatePage>;
  /**
   * Retrieve a single target page of VerificationTemplateInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: VerificationTemplatePage) => any): Promise<VerificationTemplatePage>;
  /**
   * Lists VerificationTemplateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: VerificationTemplateInstance[]) => any): Promise<VerificationTemplateInstance[]>;
  /**
   * Lists VerificationTemplateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: VerificationTemplateListInstanceOptions, callback?: (error: Error | null, items: VerificationTemplateInstance[]) => any): Promise<VerificationTemplateInstance[]>;
  /**
   * Retrieve a single page of VerificationTemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: VerificationTemplatePage) => any): Promise<VerificationTemplatePage>;
  /**
   * Retrieve a single page of VerificationTemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: VerificationTemplateListInstancePageOptions, callback?: (error: Error | null, items: VerificationTemplatePage) => any): Promise<VerificationTemplatePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - Filter templates using friendly name
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface VerificationTemplateListInstanceEachOptions {
  callback?: (item: VerificationTemplateInstance, done: (err?: Error) => void) => void;
  done?: Function;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property friendlyName - Filter templates using friendly name
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface VerificationTemplateListInstanceOptions {
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property friendlyName - Filter templates using friendly name
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface VerificationTemplateListInstancePageOptions {
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface VerificationTemplatePayload extends VerificationTemplateResource, Page.TwilioResponsePayload {
}

interface VerificationTemplateResource {
  account_sid: string;
  friendly_name: string;
  sid: string;
  translations: object;
}

interface VerificationTemplateSolution {
}


declare class VerificationTemplateInstance extends SerializableClass {
  /**
   * Initialize the VerificationTemplateContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: VerificationTemplatePayload);

  accountSid: string;
  friendlyName: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  translations: any;
}


declare class VerificationTemplatePage extends Page<V2, VerificationTemplatePayload, VerificationTemplateResource, VerificationTemplateInstance> {
  /**
   * Initialize the VerificationTemplatePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: VerificationTemplateSolution);

  /**
   * Build an instance of VerificationTemplateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: VerificationTemplatePayload): VerificationTemplateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { VerificationTemplateInstance, VerificationTemplateList, VerificationTemplateListInstance, VerificationTemplateListInstanceEachOptions, VerificationTemplateListInstanceOptions, VerificationTemplateListInstancePageOptions, VerificationTemplatePage, VerificationTemplatePayload, VerificationTemplateResource, VerificationTemplateSolution }
