'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var SettingsList;
var SettingsPage;
var SettingsInstance;
var SettingsContext;

/* jshint ignore:start */
/**
 * Initialize the SettingsList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Voice.V1.DialingPermissionsContext.SettingsList
 *
 * @param {Twilio.Voice.V1} version - Version of the resource
 */
/* jshint ignore:end */
SettingsList = function SettingsList(version) {
  /* jshint ignore:start */
  /**
   * @function settings
   * @memberof Twilio.Voice.V1.DialingPermissionsContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Voice.V1.DialingPermissionsContext.SettingsContext}
   */
  /* jshint ignore:end */
  function SettingsListInstance(sid) {
    return SettingsListInstance.get(sid);
  }

  SettingsListInstance._version = version;
  // Path Solution
  SettingsListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a settings
   *
   * @function get
   * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsList#
   *
   * @returns {Twilio.Voice.V1.DialingPermissionsContext.SettingsContext}
   */
  /* jshint ignore:end */
  SettingsListInstance.get = function get() {
    return new SettingsContext(this._version);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SettingsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SettingsListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return SettingsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SettingsPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Voice.V1.DialingPermissionsContext.SettingsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SettingsSolution} solution - Path solution
 *
 * @returns SettingsPage
 */
/* jshint ignore:end */
SettingsPage = function SettingsPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SettingsPage.prototype, Page.prototype);
SettingsPage.prototype.constructor = SettingsPage;

/* jshint ignore:start */
/**
 * Build an instance of SettingsInstance
 *
 * @function getInstance
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsPage#
 *
 * @param {SettingsPayload} payload - Payload response from the API
 *
 * @returns SettingsInstance
 */
/* jshint ignore:end */
SettingsPage.prototype.getInstance = function getInstance(payload) {
  return new SettingsInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SettingsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SettingsPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SettingsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Voice.V1.DialingPermissionsContext.SettingsInstance
 *
 * @property {boolean} dialingPermissionsInheritance -
 *          `true` if the sub-account will inherit voice dialing permissions from the Master Project; otherwise `false`
 * @property {string} url - The absolute URL of this resource
 *
 * @param {V1} version - Version of the resource
 * @param {SettingsPayload} payload - The instance payload
 */
/* jshint ignore:end */
SettingsInstance = function SettingsInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.dialingPermissionsInheritance = payload.dialing_permissions_inheritance; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

Object.defineProperty(SettingsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SettingsContext(this._version);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SettingsInstance
 *
 * @function fetch
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SettingsInstance
 */
/* jshint ignore:end */
SettingsInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a SettingsInstance
 *
 * @function update
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {boolean} [opts.dialingPermissionsInheritance] -
 *          `true` for the sub-account to inherit voice dialing permissions from the Master Project; otherwise `false`
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SettingsInstance
 */
/* jshint ignore:end */
SettingsInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SettingsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SettingsInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SettingsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Voice.V1.DialingPermissionsContext.SettingsContext
 *
 * @param {V1} version - Version of the resource
 */
/* jshint ignore:end */
SettingsContext = function SettingsContext(version) {
  this._version = version;

  // Path Solution
  this._solution = {};
  this._uri = `/Settings`;
};

/* jshint ignore:start */
/**
 * fetch a SettingsInstance
 *
 * @function fetch
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SettingsInstance
 */
/* jshint ignore:end */
SettingsContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SettingsInstance(this._version, payload));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SettingsInstance
 *
 * @function update
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {boolean} [opts.dialingPermissionsInheritance] -
 *          `true` for the sub-account to inherit voice dialing permissions from the Master Project; otherwise `false`
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SettingsInstance
 */
/* jshint ignore:end */
SettingsContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'DialingPermissionsInheritance': serialize.bool(_.get(opts, 'dialingPermissionsInheritance'))
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SettingsInstance(this._version, payload));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Voice.V1.DialingPermissionsContext.SettingsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SettingsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SettingsContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SettingsList: SettingsList,
  SettingsPage: SettingsPage,
  SettingsInstance: SettingsInstance,
  SettingsContext: SettingsContext
};
