'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var NotificationList;
var NotificationPage;
var NotificationInstance;
var NotificationContext;

/* jshint ignore:start */
/**
 * Initialize the NotificationList
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationList
 *
 * @param {Twilio.Conversations.V1} version - Version of the resource
 * @param {string} chatServiceSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
NotificationList = function NotificationList(version, chatServiceSid) {
  /* jshint ignore:start */
  /**
   * @function notifications
   * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext}
   */
  /* jshint ignore:end */
  function NotificationListInstance(sid) {
    return NotificationListInstance.get(sid);
  }

  NotificationListInstance._version = version;
  // Path Solution
  NotificationListInstance._solution = {chatServiceSid: chatServiceSid};
  /* jshint ignore:start */
  /**
   * Constructs a notification
   *
   * @function get
   * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationList#
   *
   * @returns {Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext}
   */
  /* jshint ignore:end */
  NotificationListInstance.get = function get() {
    return new NotificationContext(this._version, this._solution.chatServiceSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  NotificationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  NotificationListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return NotificationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the NotificationPage
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {NotificationSolution} solution - Path solution
 *
 * @returns NotificationPage
 */
/* jshint ignore:end */
NotificationPage = function NotificationPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(NotificationPage.prototype, Page.prototype);
NotificationPage.prototype.constructor = NotificationPage;

/* jshint ignore:start */
/**
 * Build an instance of NotificationInstance
 *
 * @function getInstance
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationPage#
 *
 * @param {NotificationPayload} payload - Payload response from the API
 *
 * @returns NotificationInstance
 */
/* jshint ignore:end */
NotificationPage.prototype.getInstance = function getInstance(payload) {
  return new NotificationInstance(this._version, payload, this._solution.chatServiceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
NotificationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NotificationPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NotificationContext
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationInstance
 *
 * @property {string} accountSid -
 *          The unique ID of the Account responsible for this configuration.
 * @property {string} chatServiceSid -
 *          The SID of the Conversation Service that the Configuration applies to.
 * @property {object} newMessage -
 *          The Push Notification configuration for New Messages.
 * @property {object} addedToConversation -
 *          The Push Notification configuration for being added to a Conversation.
 * @property {object} removedFromConversation -
 *          The Push Notification configuration for being removed from a Conversation.
 * @property {boolean} logEnabled - Weather the notification logging is enabled.
 * @property {string} url - An absolute URL for this configuration.
 *
 * @param {V1} version - Version of the resource
 * @param {NotificationPayload} payload - The instance payload
 * @param {sid} chatServiceSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
NotificationInstance = function NotificationInstance(version, payload,
                                                      chatServiceSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.chatServiceSid = payload.chat_service_sid; // jshint ignore:line
  this.newMessage = payload.new_message; // jshint ignore:line
  this.addedToConversation = payload.added_to_conversation; // jshint ignore:line
  this.removedFromConversation = payload.removed_from_conversation; // jshint ignore:line
  this.logEnabled = payload.log_enabled; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {chatServiceSid: chatServiceSid, };
};

Object.defineProperty(NotificationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new NotificationContext(this._version, this._solution.chatServiceSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a NotificationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {boolean} [opts.logEnabled] -
 *          Weather the notification logging is enabled.
 * @param {boolean} [opts.newMessage.enabled] -
 *          Whether to send a notification when a new message is added to a conversation.
 * @param {string} [opts.newMessage.template] -
 *          The template to use to create the notification text displayed when a new message is added to a conversation.
 * @param {string} [opts.newMessage.sound] -
 *          The name of the sound to play when a new message is added to a conversation.
 * @param {boolean} [opts.newMessage.badgeCountEnabled] -
 *          Whether the new message badge is enabled.
 * @param {boolean} [opts.addedToConversation.enabled] -
 *          Whether to send a notification when a participant is added to a conversation.
 * @param {string} [opts.addedToConversation.template] -
 *          The template to use to create the notification text displayed when a participant is added to a conversation.
 * @param {string} [opts.addedToConversation.sound] -
 *          The name of the sound to play when a participant is added to a conversation.
 * @param {boolean} [opts.removedFromConversation.enabled] -
 *          Whether to send a notification to a user when they are removed from a conversation.
 * @param {string} [opts.removedFromConversation.template] -
 *          The template to use to create the notification text displayed to a user when they are removed.
 * @param {string} [opts.removedFromConversation.sound] -
 *          The name of the sound to play to a user when they are removed from a conversation.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NotificationInstance
 */
/* jshint ignore:end */
NotificationInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a NotificationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NotificationInstance
 */
/* jshint ignore:end */
NotificationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
NotificationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NotificationInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NotificationContext
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} chatServiceSid -
 *          The SID of the Conversation Service that the Configuration applies to.
 */
/* jshint ignore:end */
NotificationContext = function NotificationContext(version, chatServiceSid) {
  this._version = version;

  // Path Solution
  this._solution = {chatServiceSid: chatServiceSid, };
  this._uri = `/Services/${chatServiceSid}/Configuration/Notifications`;
};

/* jshint ignore:start */
/**
 * update a NotificationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext#
 *
 * @param {object} [opts] - Options for request
 * @param {boolean} [opts.logEnabled] -
 *          Weather the notification logging is enabled.
 * @param {boolean} [opts.newMessage.enabled] -
 *          Whether to send a notification when a new message is added to a conversation.
 * @param {string} [opts.newMessage.template] -
 *          The template to use to create the notification text displayed when a new message is added to a conversation.
 * @param {string} [opts.newMessage.sound] -
 *          The name of the sound to play when a new message is added to a conversation.
 * @param {boolean} [opts.newMessage.badgeCountEnabled] -
 *          Whether the new message badge is enabled.
 * @param {boolean} [opts.addedToConversation.enabled] -
 *          Whether to send a notification when a participant is added to a conversation.
 * @param {string} [opts.addedToConversation.template] -
 *          The template to use to create the notification text displayed when a participant is added to a conversation.
 * @param {string} [opts.addedToConversation.sound] -
 *          The name of the sound to play when a participant is added to a conversation.
 * @param {boolean} [opts.removedFromConversation.enabled] -
 *          Whether to send a notification to a user when they are removed from a conversation.
 * @param {string} [opts.removedFromConversation.template] -
 *          The template to use to create the notification text displayed to a user when they are removed.
 * @param {string} [opts.removedFromConversation.sound] -
 *          The name of the sound to play to a user when they are removed from a conversation.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NotificationInstance
 */
/* jshint ignore:end */
NotificationContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'LogEnabled': serialize.bool(_.get(opts, 'logEnabled')),
    'NewMessage.Enabled': serialize.bool(_.get(opts, 'newMessage.enabled')),
    'NewMessage.Template': _.get(opts, 'newMessage.template'),
    'NewMessage.Sound': _.get(opts, 'newMessage.sound'),
    'NewMessage.BadgeCountEnabled': serialize.bool(_.get(opts, 'newMessage.badgeCountEnabled')),
    'AddedToConversation.Enabled': serialize.bool(_.get(opts, 'addedToConversation.enabled')),
    'AddedToConversation.Template': _.get(opts, 'addedToConversation.template'),
    'AddedToConversation.Sound': _.get(opts, 'addedToConversation.sound'),
    'RemovedFromConversation.Enabled': serialize.bool(_.get(opts, 'removedFromConversation.enabled')),
    'RemovedFromConversation.Template': _.get(opts, 'removedFromConversation.template'),
    'RemovedFromConversation.Sound': _.get(opts, 'removedFromConversation.sound')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new NotificationInstance(this._version, payload, this._solution.chatServiceSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a NotificationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NotificationInstance
 */
/* jshint ignore:end */
NotificationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new NotificationInstance(this._version, payload, this._solution.chatServiceSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.ConfigurationContext.NotificationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
NotificationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

NotificationContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  NotificationList: NotificationList,
  NotificationPage: NotificationPage,
  NotificationInstance: NotificationInstance,
  NotificationContext: NotificationContext
};
