'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var StreamMessageList;
var StreamMessagePage;
var StreamMessageInstance;

/* jshint ignore:start */
/**
 * Initialize the StreamMessageList
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageList
 *
 * @param {Twilio.Sync.V1} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @param {string} streamSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
StreamMessageList = function StreamMessageList(version, serviceSid, streamSid) {
  /* jshint ignore:start */
  /**
   * @function streamMessages
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageContext}
   */
  /* jshint ignore:end */
  function StreamMessageListInstance(sid) {
    return StreamMessageListInstance.get(sid);
  }

  StreamMessageListInstance._version = version;
  // Path Solution
  StreamMessageListInstance._solution = {serviceSid: serviceSid, streamSid: streamSid};
  StreamMessageListInstance._uri = `/Services/${serviceSid}/Streams/${streamSid}/Messages`;
  /* jshint ignore:start */
  /**
   * create a StreamMessageInstance
   *
   * @function create
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageList#
   *
   * @param {object} opts - Options for request
   * @param {object} opts.data -
   *          A JSON string that represents an arbitrary, schema-less object that makes up the Stream Message body
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed StreamMessageInstance
   */
  /* jshint ignore:end */
  StreamMessageListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.data)) {
      throw new Error('Required parameter "opts.data" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({'Data': serialize.object(_.get(opts, 'data'))});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new StreamMessageInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  StreamMessageListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  StreamMessageListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return StreamMessageListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the StreamMessagePage
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessagePage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {StreamMessageSolution} solution - Path solution
 *
 * @returns StreamMessagePage
 */
/* jshint ignore:end */
StreamMessagePage = function StreamMessagePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(StreamMessagePage.prototype, Page.prototype);
StreamMessagePage.prototype.constructor = StreamMessagePage;

/* jshint ignore:start */
/**
 * Build an instance of StreamMessageInstance
 *
 * @function getInstance
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessagePage#
 *
 * @param {StreamMessagePayload} payload - Payload response from the API
 *
 * @returns StreamMessageInstance
 */
/* jshint ignore:end */
StreamMessagePage.prototype.getInstance = function getInstance(payload) {
  return new StreamMessageInstance(
    this._version,
    payload,
    this._solution.serviceSid,
    this._solution.streamSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessagePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
StreamMessagePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

StreamMessagePage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the StreamMessageContext
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {object} data - Stream Message body
 *
 * @param {V1} version - Version of the resource
 * @param {StreamMessagePayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @param {sid} streamSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
StreamMessageInstance = function StreamMessageInstance(version, payload,
                                                        serviceSid, streamSid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, streamSid: streamSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
StreamMessageInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

StreamMessageInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  StreamMessageList: StreamMessageList,
  StreamMessagePage: StreamMessagePage,
  StreamMessageInstance: StreamMessageInstance
};
