/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the BalanceList
 *
 * @param version - Version of the resource
 * @param accountSid - Account Sid.
 */
declare function BalanceList(version: V2010, accountSid: string): BalanceListInstance;

interface BalanceListInstance {
  /**
   * fetch a BalanceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BalanceListInstance) => any): Promise<BalanceInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface BalancePayload extends BalanceResource, Page.TwilioResponsePayload {
}

interface BalanceResource {
  account_sid: string;
  balance: string;
  currency: string;
}

interface BalanceSolution {
  accountSid?: string;
}


declare class BalanceInstance extends SerializableClass {
  /**
   * Initialize the BalanceContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - Account Sid.
   */
  constructor(version: V2010, payload: BalancePayload, accountSid: string);

  accountSid: string;
  balance: string;
  currency: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BalancePage extends Page<V2010, BalancePayload, BalanceResource, BalanceInstance> {
  /**
   * Initialize the BalancePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: BalanceSolution);

  /**
   * Build an instance of BalanceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BalancePayload): BalanceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BalanceInstance, BalanceList, BalanceListInstance, BalancePage, BalancePayload, BalanceResource, BalanceSolution }
