'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var AddressConfigurationList;
var AddressConfigurationPage;
var AddressConfigurationInstance;
var AddressConfigurationContext;

/* jshint ignore:start */
/**
 * Initialize the AddressConfigurationList
 *
 * @constructor Twilio.Conversations.V1.AddressConfigurationList
 *
 * @param {Twilio.Conversations.V1} version - Version of the resource
 */
/* jshint ignore:end */
AddressConfigurationList = function AddressConfigurationList(version) {
  /* jshint ignore:start */
  /**
   * @function addressConfigurations
   * @memberof Twilio.Conversations.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Conversations.V1.AddressConfigurationContext}
   */
  /* jshint ignore:end */
  function AddressConfigurationListInstance(sid) {
    return AddressConfigurationListInstance.get(sid);
  }

  AddressConfigurationListInstance._version = version;
  // Path Solution
  AddressConfigurationListInstance._solution = {};
  AddressConfigurationListInstance._uri = `/Configuration/Addresses`;
  /* jshint ignore:start */
  /**
   * Streams AddressConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AddressConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AddressConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AddressConfigurationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AddressConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.getPage = function getPage(targetUrl, callback)
                                                               {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AddressConfigurationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a AddressConfigurationInstance
   *
   * @function create
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {object} opts - Options for request
   * @param {address_configuration.type} opts.type - Type of Address.
   * @param {string} opts.address - The unique address to be configured.
   * @param {string} [opts.friendlyName] -
   *          The human-readable name of this configuration.
   * @param {boolean} [opts.autoCreation.enabled] -
   *          Enable/Disable auto-creating conversations for messages to this address
   * @param {address_configuration.auto_creation_type} [opts.autoCreation.type] -
   *          Type of Auto Creation.
   * @param {string} [opts.autoCreation.conversationServiceSid] -
   *          Conversation Service for the auto-created conversation.
   * @param {string} [opts.autoCreation.webhookUrl] -
   *          For type `webhook`, the url for the webhook request.
   * @param {address_configuration.method} [opts.autoCreation.webhookMethod] -
   *          For type `webhook`, the HTTP method to be used when sending a webhook request.
   * @param {string|list} [opts.autoCreation.webhookFilters] -
   *          The list of events, firing webhook event for this Conversation.
   * @param {string} [opts.autoCreation.studioFlowSid] -
   *          For type `studio`, the studio flow SID, where the webhook should be sent to.
   * @param {number} [opts.autoCreation.studioRetryCount] -
   *          For type `studio`, number of times to retry the webhook request
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed AddressConfigurationInstance
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['type'])) {
      throw new Error('Required parameter "opts[\'type\']" missing.');
    }
    if (_.isUndefined(opts['address'])) {
      throw new Error('Required parameter "opts[\'address\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Type': _.get(opts, 'type'),
      'Address': _.get(opts, 'address'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'AutoCreation.Enabled': serialize.bool(_.get(opts, 'autoCreation.enabled')),
      'AutoCreation.Type': _.get(opts, 'autoCreation.type'),
      'AutoCreation.ConversationServiceSid': _.get(opts, 'autoCreation.conversationServiceSid'),
      'AutoCreation.WebhookUrl': _.get(opts, 'autoCreation.webhookUrl'),
      'AutoCreation.WebhookMethod': _.get(opts, 'autoCreation.webhookMethod'),
      'AutoCreation.WebhookFilters': serialize.map(_.get(opts, 'autoCreation.webhookFilters'), function(e) { return e; }),
      'AutoCreation.StudioFlowSid': _.get(opts, 'autoCreation.studioFlowSid'),
      'AutoCreation.StudioRetryCount': _.get(opts, 'autoCreation.studioRetryCount')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AddressConfigurationInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a address_configuration
   *
   * @function get
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @param {string} sid - The SID or Address of the Configuration.
   *
   * @returns {Twilio.Conversations.V1.AddressConfigurationContext}
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.get = function get(sid) {
    return new AddressConfigurationContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Conversations.V1.AddressConfigurationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AddressConfigurationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AddressConfigurationListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return AddressConfigurationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AddressConfigurationPage
 *
 * @constructor Twilio.Conversations.V1.AddressConfigurationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AddressConfigurationSolution} solution - Path solution
 *
 * @returns AddressConfigurationPage
 */
/* jshint ignore:end */
AddressConfigurationPage = function AddressConfigurationPage(version, response,
    solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AddressConfigurationPage.prototype, Page.prototype);
AddressConfigurationPage.prototype.constructor = AddressConfigurationPage;

/* jshint ignore:start */
/**
 * Build an instance of AddressConfigurationInstance
 *
 * @function getInstance
 * @memberof Twilio.Conversations.V1.AddressConfigurationPage#
 *
 * @param {AddressConfigurationPayload} payload - Payload response from the API
 *
 * @returns AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationPage.prototype.getInstance = function getInstance(payload) {
  return new AddressConfigurationInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.AddressConfigurationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddressConfigurationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AddressConfigurationPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AddressConfigurationContext
 *
 * @constructor Twilio.Conversations.V1.AddressConfigurationInstance
 *
 * @property {string} sid -
 *          A 34 character string that uniquely identifies this resource.
 * @property {string} accountSid -
 *          The unique ID of the Account the address belongs to.
 * @property {string} type - Type of Address, value can be `whatsapp` or `sms`.
 * @property {string} address - The unique address to be configured.
 * @property {string} friendlyName - The human-readable name of this configuration.
 * @property {object} autoCreation - Auto Creation configuration for the address.
 * @property {Date} dateCreated - The date that this resource was created.
 * @property {Date} dateUpdated - The date that this resource was last updated.
 * @property {string} url - An absolute URL for this address configuration.
 *
 * @param {V1} version - Version of the resource
 * @param {AddressConfigurationPayload} payload - The instance payload
 * @param {sid_like} sid - The SID or Address of the Configuration.
 */
/* jshint ignore:end */
AddressConfigurationInstance = function AddressConfigurationInstance(version,
    payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.type = payload.type; // jshint ignore:line
  this.address = payload.address; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.autoCreation = payload.auto_creation; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(AddressConfigurationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AddressConfigurationContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AddressConfigurationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.AddressConfigurationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a AddressConfigurationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.AddressConfigurationInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          The human-readable name of this configuration.
 * @param {boolean} [opts.autoCreation.enabled] -
 *          Enable/Disable auto-creating conversations for messages to this address
 * @param {address_configuration.auto_creation_type} [opts.autoCreation.type] -
 *          Type of Auto Creation.
 * @param {string} [opts.autoCreation.conversationServiceSid] -
 *          Conversation Service for the auto-created conversation.
 * @param {string} [opts.autoCreation.webhookUrl] -
 *          For type `webhook`, the url for the webhook request.
 * @param {address_configuration.method} [opts.autoCreation.webhookMethod] -
 *          For type `webhook`, the HTTP method to be used when sending a webhook request.
 * @param {string|list} [opts.autoCreation.webhookFilters] -
 *          The list of events, firing webhook event for this Conversation.
 * @param {string} [opts.autoCreation.studioFlowSid] -
 *          For type `studio`, the studio flow SID, where the webhook should be sent to.
 * @param {number} [opts.autoCreation.studioRetryCount] -
 *          For type `studio`, number of times to retry the webhook request
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationInstance.prototype.update = function update(opts, callback)
    {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a AddressConfigurationInstance
 *
 * @function remove
 * @memberof Twilio.Conversations.V1.AddressConfigurationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.AddressConfigurationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddressConfigurationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AddressConfigurationInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AddressConfigurationContext
 *
 * @constructor Twilio.Conversations.V1.AddressConfigurationContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} sid - The SID or Address of the Configuration.
 */
/* jshint ignore:end */
AddressConfigurationContext = function AddressConfigurationContext(version, sid)
    {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Configuration/Addresses/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a AddressConfigurationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.AddressConfigurationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AddressConfigurationInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a AddressConfigurationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.AddressConfigurationContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          The human-readable name of this configuration.
 * @param {boolean} [opts.autoCreation.enabled] -
 *          Enable/Disable auto-creating conversations for messages to this address
 * @param {address_configuration.auto_creation_type} [opts.autoCreation.type] -
 *          Type of Auto Creation.
 * @param {string} [opts.autoCreation.conversationServiceSid] -
 *          Conversation Service for the auto-created conversation.
 * @param {string} [opts.autoCreation.webhookUrl] -
 *          For type `webhook`, the url for the webhook request.
 * @param {address_configuration.method} [opts.autoCreation.webhookMethod] -
 *          For type `webhook`, the HTTP method to be used when sending a webhook request.
 * @param {string|list} [opts.autoCreation.webhookFilters] -
 *          The list of events, firing webhook event for this Conversation.
 * @param {string} [opts.autoCreation.studioFlowSid] -
 *          For type `studio`, the studio flow SID, where the webhook should be sent to.
 * @param {number} [opts.autoCreation.studioRetryCount] -
 *          For type `studio`, number of times to retry the webhook request
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'AutoCreation.Enabled': serialize.bool(_.get(opts, 'autoCreation.enabled')),
    'AutoCreation.Type': _.get(opts, 'autoCreation.type'),
    'AutoCreation.ConversationServiceSid': _.get(opts, 'autoCreation.conversationServiceSid'),
    'AutoCreation.WebhookUrl': _.get(opts, 'autoCreation.webhookUrl'),
    'AutoCreation.WebhookMethod': _.get(opts, 'autoCreation.webhookMethod'),
    'AutoCreation.WebhookFilters': serialize.map(_.get(opts, 'autoCreation.webhookFilters'), function(e) { return e; }),
    'AutoCreation.StudioFlowSid': _.get(opts, 'autoCreation.studioFlowSid'),
    'AutoCreation.StudioRetryCount': _.get(opts, 'autoCreation.studioRetryCount')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new AddressConfigurationInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a AddressConfigurationInstance
 *
 * @function remove
 * @memberof Twilio.Conversations.V1.AddressConfigurationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddressConfigurationInstance
 */
/* jshint ignore:end */
AddressConfigurationContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.AddressConfigurationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddressConfigurationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AddressConfigurationContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AddressConfigurationList: AddressConfigurationList,
  AddressConfigurationPage: AddressConfigurationPage,
  AddressConfigurationInstance: AddressConfigurationInstance,
  AddressConfigurationContext: AddressConfigurationContext
};
