'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var AccessTokenList;
var AccessTokenPage;
var AccessTokenInstance;
var AccessTokenContext;

/* jshint ignore:start */
/**
 * Initialize the AccessTokenList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.AccessTokenList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid - Verify Service Sid.
 */
/* jshint ignore:end */
AccessTokenList = function AccessTokenList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function accessTokens
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.AccessTokenContext}
   */
  /* jshint ignore:end */
  function AccessTokenListInstance(sid) {
    return AccessTokenListInstance.get(sid);
  }

  AccessTokenListInstance._version = version;
  // Path Solution
  AccessTokenListInstance._solution = {serviceSid: serviceSid};
  AccessTokenListInstance._uri = `/Services/${serviceSid}/AccessTokens`;
  /* jshint ignore:start */
  /**
   * create a AccessTokenInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.identity - Unique external identifier of the Entity
   * @param {access_token.factor_types} opts.factorType - The Type of this Factor
   * @param {string} [opts.factorFriendlyName] - The factor friendly name
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed AccessTokenInstance
   */
  /* jshint ignore:end */
  AccessTokenListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['identity'])) {
      throw new Error('Required parameter "opts[\'identity\']" missing.');
    }
    if (_.isUndefined(opts['factorType'])) {
      throw new Error('Required parameter "opts[\'factorType\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Identity': _.get(opts, 'identity'),
      'FactorType': _.get(opts, 'factorType'),
      'FactorFriendlyName': _.get(opts, 'factorFriendlyName')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AccessTokenInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a access_token
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenList#
   *
   * @param {string} sid - A string that uniquely identifies this Access Token.
   *
   * @returns {Twilio.Verify.V2.ServiceContext.AccessTokenContext}
   */
  /* jshint ignore:end */
  AccessTokenListInstance.get = function get(sid) {
    return new AccessTokenContext(this._version, this._solution.serviceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AccessTokenListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AccessTokenListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return AccessTokenListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AccessTokenPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.AccessTokenPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AccessTokenSolution} solution - Path solution
 *
 * @returns AccessTokenPage
 */
/* jshint ignore:end */
AccessTokenPage = function AccessTokenPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AccessTokenPage.prototype, Page.prototype);
AccessTokenPage.prototype.constructor = AccessTokenPage;

/* jshint ignore:start */
/**
 * Build an instance of AccessTokenInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenPage#
 *
 * @param {AccessTokenPayload} payload - Payload response from the API
 *
 * @returns AccessTokenInstance
 */
/* jshint ignore:end */
AccessTokenPage.prototype.getInstance = function getInstance(payload) {
  return new AccessTokenInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AccessTokenPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AccessTokenPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AccessTokenContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.AccessTokenInstance
 *
 * @property {string} sid - A string that uniquely identifies this Access Token.
 * @property {string} accountSid - Account Sid.
 * @property {string} serviceSid - Verify Service Sid.
 * @property {string} entityIdentity - Unique external identifier of the Entity
 * @property {access_token.factor_types} factorType - The Type of the Factor
 * @property {string} factorFriendlyName -
 *          A human readable description of this factor.
 * @property {string} token - Generated access token.
 * @property {string} url - The URL of this resource.
 *
 * @param {V2} version - Version of the resource
 * @param {AccessTokenPayload} payload - The instance payload
 * @param {sid} serviceSid - Verify Service Sid.
 * @param {sid} sid - A string that uniquely identifies this Access Token.
 */
/* jshint ignore:end */
AccessTokenInstance = function AccessTokenInstance(version, payload, serviceSid,
                                                    sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.entityIdentity = payload.entity_identity; // jshint ignore:line
  this.factorType = payload.factor_type; // jshint ignore:line
  this.factorFriendlyName = payload.factor_friendly_name; // jshint ignore:line
  this.token = payload.token; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, sid: sid || this.sid, };
};

Object.defineProperty(AccessTokenInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AccessTokenContext(
          this._version,
          this._solution.serviceSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AccessTokenInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AccessTokenInstance
 */
/* jshint ignore:end */
AccessTokenInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AccessTokenInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AccessTokenInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AccessTokenContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.AccessTokenContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid - Service Sid.
 * @param {sid} sid - A string that uniquely identifies this Access Token.
 */
/* jshint ignore:end */
AccessTokenContext = function AccessTokenContext(version, serviceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, sid: sid, };
  this._uri = `/Services/${serviceSid}/AccessTokens/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a AccessTokenInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AccessTokenInstance
 */
/* jshint ignore:end */
AccessTokenContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AccessTokenInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.AccessTokenContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AccessTokenContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AccessTokenContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AccessTokenList: AccessTokenList,
  AccessTokenPage: AccessTokenPage,
  AccessTokenInstance: AccessTokenInstance,
  AccessTokenContext: AccessTokenContext
};
