'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var SubscribedEventList = require(
    './subscription/subscribedEvent').SubscribedEventList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var SubscriptionList;
var SubscriptionPage;
var SubscriptionInstance;
var SubscriptionContext;

/* jshint ignore:start */
/**
 * Initialize the SubscriptionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionList
 *
 * @param {Twilio.Events.V1} version - Version of the resource
 */
/* jshint ignore:end */
SubscriptionList = function SubscriptionList(version) {
  /* jshint ignore:start */
  /**
   * @function subscriptions
   * @memberof Twilio.Events.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Events.V1.SubscriptionContext}
   */
  /* jshint ignore:end */
  function SubscriptionListInstance(sid) {
    return SubscriptionListInstance.get(sid);
  }

  SubscriptionListInstance._version = version;
  // Path Solution
  SubscriptionListInstance._solution = {};
  SubscriptionListInstance._uri = `/Subscriptions`;
  /* jshint ignore:start */
  /**
   * Streams SubscriptionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sinkSid] - Sink SID.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SubscriptionListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SubscriptionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sinkSid] - Sink SID.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscriptionListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sinkSid] - Sink SID.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscriptionListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'SinkSid': _.get(opts, 'sinkSid'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscriptionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscriptionListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscriptionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a SubscriptionInstance
   *
   * @function create
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.description - Subscription description
   * @param {string} opts.sinkSid - Sink SID.
   * @param {object|list} opts.types - Subscribed Event Types
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SubscriptionInstance
   */
  /* jshint ignore:end */
  SubscriptionListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['description'])) {
      throw new Error('Required parameter "opts[\'description\']" missing.');
    }
    if (_.isUndefined(opts['sinkSid'])) {
      throw new Error('Required parameter "opts[\'sinkSid\']" missing.');
    }
    if (_.isUndefined(opts['types'])) {
      throw new Error('Required parameter "opts[\'types\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Description': _.get(opts, 'description'),
      'SinkSid': _.get(opts, 'sinkSid'),
      'Types': serialize.map(_.get(opts, 'types'), function(e) { return serialize.object(e); })
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscriptionInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a subscription
   *
   * @function get
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @param {string} sid - A string that uniquely identifies this Subscription.
   *
   * @returns {Twilio.Events.V1.SubscriptionContext}
   */
  /* jshint ignore:end */
  SubscriptionListInstance.get = function get(sid) {
    return new SubscriptionContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Events.V1.SubscriptionList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SubscriptionListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SubscriptionListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return SubscriptionListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SubscriptionPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SubscriptionSolution} solution - Path solution
 *
 * @returns SubscriptionPage
 */
/* jshint ignore:end */
SubscriptionPage = function SubscriptionPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SubscriptionPage.prototype, Page.prototype);
SubscriptionPage.prototype.constructor = SubscriptionPage;

/* jshint ignore:start */
/**
 * Build an instance of SubscriptionInstance
 *
 * @function getInstance
 * @memberof Twilio.Events.V1.SubscriptionPage#
 *
 * @param {SubscriptionPayload} payload - Payload response from the API
 *
 * @returns SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionPage.prototype.getInstance = function getInstance(payload) {
  return new SubscriptionInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscriptionPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscriptionPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscriptionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionInstance
 *
 * @property {string} accountSid - Account SID.
 * @property {string} sid - A string that uniquely identifies this Subscription.
 * @property {Date} dateCreated - The date this Subscription was created
 * @property {Date} dateUpdated - The date this Subscription was updated
 * @property {string} description - Subscription description
 * @property {string} sinkSid - Sink SID.
 * @property {string} url - The URL of this resource.
 * @property {string} links - Nested resource URLs.
 *
 * @param {V1} version - Version of the resource
 * @param {SubscriptionPayload} payload - The instance payload
 * @param {sid} sid - A string that uniquely identifies this Subscription.
 */
/* jshint ignore:end */
SubscriptionInstance = function SubscriptionInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.sinkSid = payload.sink_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(SubscriptionInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SubscriptionContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SubscriptionInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SubscriptionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a SubscriptionInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SubscriptionInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.description] - Subscription description.
 * @param {string} [opts.sinkSid] - Sink SID.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a SubscriptionInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SubscriptionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the subscribedEvents
 *
 * @function subscribedEvents
 * @memberof Twilio.Events.V1.SubscriptionInstance#
 *
 * @returns {Twilio.Events.V1.SubscriptionContext.SubscribedEventList}
 */
/* jshint ignore:end */
SubscriptionInstance.prototype.subscribedEvents = function subscribedEvents() {
  return this._proxy.subscribedEvents;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscriptionInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscriptionInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscriptionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionContext
 *
 * @property {Twilio.Events.V1.SubscriptionContext.SubscribedEventList} subscribedEvents -
 *          subscribedEvents resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - A string that uniquely identifies this Subscription.
 */
/* jshint ignore:end */
SubscriptionContext = function SubscriptionContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Subscriptions/${sid}`;

  // Dependents
  this._subscribedEvents = undefined;
};

/* jshint ignore:start */
/**
 * fetch a SubscriptionInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SubscriptionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SubscriptionInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SubscriptionInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SubscriptionContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.description] - Subscription description.
 * @param {string} [opts.sinkSid] - Sink SID.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Description': _.get(opts, 'description'),
    'SinkSid': _.get(opts, 'sinkSid')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SubscriptionInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SubscriptionInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SubscriptionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscriptionInstance
 */
/* jshint ignore:end */
SubscriptionContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(SubscriptionContext.prototype,
  'subscribedEvents', {
    get: function() {
      if (!this._subscribedEvents) {
        this._subscribedEvents = new SubscribedEventList(this._version, this._solution.sid);
      }
      return this._subscribedEvents;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscriptionContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SubscriptionContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SubscriptionList: SubscriptionList,
  SubscriptionPage: SubscriptionPage,
  SubscriptionInstance: SubscriptionInstance,
  SubscriptionContext: SubscriptionContext
};
