'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var ChannelList = require('./v1/channel').ChannelList;
var ConfigurationList = require('./v1/configuration').ConfigurationList;
var FlexFlowList = require('./v1/flexFlow').FlexFlowList;
var InteractionList = require('./v1/interaction').InteractionList;
var Version = require('../../base/Version');  /* jshint ignore:line */
var WebChannelList = require('./v1/webChannel').WebChannelList;


/* jshint ignore:start */
/**
 * Initialize the V1 version of FlexApi
 *
 * @constructor Twilio.FlexApi.V1
 *
 * @property {Twilio.FlexApi.V1.ChannelList} channel - channel resource
 * @property {Twilio.FlexApi.V1.ConfigurationList} configuration -
 *          configuration resource
 * @property {Twilio.FlexApi.V1.FlexFlowList} flexFlow - flexFlow resource
 * @property {Twilio.FlexApi.V1.InteractionList} interaction - interaction resource
 * @property {Twilio.FlexApi.V1.WebChannelList} webChannel - webChannel resource
 *
 * @param {Twilio.FlexApi} domain - The twilio domain
 */
/* jshint ignore:end */
function V1(domain) {
  Version.prototype.constructor.call(this, domain, 'v1');

  // Resources
  this._channel = undefined;
  this._configuration = undefined;
  this._flexFlow = undefined;
  this._interaction = undefined;
  this._webChannel = undefined;
}

_.extend(V1.prototype, Version.prototype);
V1.prototype.constructor = V1;

Object.defineProperty(V1.prototype,
  'channel', {
    get: function() {
      this._channel = this._channel || new ChannelList(this);
      return this._channel;
    }
});

Object.defineProperty(V1.prototype,
  'configuration', {
    get: function() {
      this._configuration = this._configuration || new ConfigurationList(this);
      return this._configuration;
    }
});

Object.defineProperty(V1.prototype,
  'flexFlow', {
    get: function() {
      this._flexFlow = this._flexFlow || new FlexFlowList(this);
      return this._flexFlow;
    }
});

Object.defineProperty(V1.prototype,
  'interaction', {
    get: function() {
      this._interaction = this._interaction || new InteractionList(this);
      return this._interaction;
    }
});

Object.defineProperty(V1.prototype,
  'webChannel', {
    get: function() {
      this._webChannel = this._webChannel || new WebChannelList(this);
      return this._webChannel;
    }
});

module.exports = V1;
