'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var WebhookList;
var WebhookPage;
var WebhookInstance;
var WebhookContext;

/* jshint ignore:start */
/**
 * Initialize the WebhookList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.WebhookList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid - Service Sid.
 */
/* jshint ignore:end */
WebhookList = function WebhookList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function webhooks
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.WebhookContext}
   */
  /* jshint ignore:end */
  function WebhookListInstance(sid) {
    return WebhookListInstance.get(sid);
  }

  WebhookListInstance._version = version;
  // Path Solution
  WebhookListInstance._solution = {serviceSid: serviceSid};
  WebhookListInstance._uri = `/Services/${serviceSid}/Webhooks`;
  /* jshint ignore:start */
  /**
   * create a WebhookInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName -
   *          The string that you assigned to describe the webhook
   * @param {string|list} opts.eventTypes -
   *          The array of events that this Webhook is subscribed to.
   * @param {string} opts.webhookUrl - The URL associated with this Webhook.
   * @param {webhook.status} [opts.status] - The webhook status
   * @param {webhook.version} [opts.version] - The webhook version
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed WebhookInstance
   */
  /* jshint ignore:end */
  WebhookListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['friendlyName'])) {
      throw new Error('Required parameter "opts[\'friendlyName\']" missing.');
    }
    if (_.isUndefined(opts['eventTypes'])) {
      throw new Error('Required parameter "opts[\'eventTypes\']" missing.');
    }
    if (_.isUndefined(opts['webhookUrl'])) {
      throw new Error('Required parameter "opts[\'webhookUrl\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'EventTypes': serialize.map(_.get(opts, 'eventTypes'), function(e) { return e; }),
      'WebhookUrl': _.get(opts, 'webhookUrl'),
      'Status': _.get(opts, 'status'),
      'Version': _.get(opts, 'version')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebhookInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams WebhookInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  WebhookListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists WebhookInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebhookListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of WebhookInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebhookListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebhookPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of WebhookInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebhookListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebhookPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a webhook
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @param {string} sid - The unique string that identifies the resource to fetch
   *
   * @returns {Twilio.Verify.V2.ServiceContext.WebhookContext}
   */
  /* jshint ignore:end */
  WebhookListInstance.get = function get(sid) {
    return new WebhookContext(this._version, this._solution.serviceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.WebhookList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WebhookListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WebhookListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return WebhookListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WebhookPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.WebhookPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WebhookSolution} solution - Path solution
 *
 * @returns WebhookPage
 */
/* jshint ignore:end */
WebhookPage = function WebhookPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WebhookPage.prototype, Page.prototype);
WebhookPage.prototype.constructor = WebhookPage;

/* jshint ignore:start */
/**
 * Build an instance of WebhookInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookPage#
 *
 * @param {WebhookPayload} payload - Payload response from the API
 *
 * @returns WebhookInstance
 */
/* jshint ignore:end */
WebhookPage.prototype.getInstance = function getInstance(payload) {
  return new WebhookInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebhookPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WebhookPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WebhookContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.WebhookInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} serviceSid - Service Sid.
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the webhook
 * @property {string} eventTypes -
 *          The array of events that this Webhook is subscribed to.
 * @property {webhook.status} status - The webhook status
 * @property {webhook.version} version - The webhook version
 * @property {string} webhookUrl - The URL associated with this Webhook.
 * @property {webhook.methods} webhookMethod -
 *          The method used when calling the webhook's URL.
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the Webhook resource
 *
 * @param {V2} version - Version of the resource
 * @param {WebhookPayload} payload - The instance payload
 * @param {sid} serviceSid - Service Sid.
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
WebhookInstance = function WebhookInstance(version, payload, serviceSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.eventTypes = payload.event_types; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.version = payload.version; // jshint ignore:line
  this.webhookUrl = payload.webhook_url; // jshint ignore:line
  this.webhookMethod = payload.webhook_method; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, sid: sid || this.sid, };
};

Object.defineProperty(WebhookInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WebhookContext(this._version, this._solution.serviceSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a WebhookInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          The string that you assigned to describe the webhook
 * @param {string|list} [opts.eventTypes] -
 *          The array of events that this Webhook is subscribed to.
 * @param {string} [opts.webhookUrl] - The URL associated with this Webhook.
 * @param {webhook.status} [opts.status] - The webhook status
 * @param {webhook.version} [opts.version] - The webhook version
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a WebhookInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a WebhookInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebhookInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WebhookInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WebhookContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Verify.V2.ServiceContext.WebhookContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid - Service Sid.
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
WebhookContext = function WebhookContext(version, serviceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, sid: sid, };
  this._uri = `/Services/${serviceSid}/Webhooks/${sid}`;
};

/* jshint ignore:start */
/**
 * update a WebhookInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          The string that you assigned to describe the webhook
 * @param {string|list} [opts.eventTypes] -
 *          The array of events that this Webhook is subscribed to.
 * @param {string} [opts.webhookUrl] - The URL associated with this Webhook.
 * @param {webhook.status} [opts.status] - The webhook status
 * @param {webhook.version} [opts.version] - The webhook version
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'EventTypes': serialize.map(_.get(opts, 'eventTypes'), function(e) { return e; }),
    'WebhookUrl': _.get(opts, 'webhookUrl'),
    'Status': _.get(opts, 'status'),
    'Version': _.get(opts, 'version')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WebhookInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a WebhookInstance
 *
 * @function remove
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a WebhookInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebhookInstance
 */
/* jshint ignore:end */
WebhookContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new WebhookInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.WebhookContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebhookContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WebhookContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WebhookList: WebhookList,
  WebhookPage: WebhookPage,
  WebhookInstance: WebhookInstance,
  WebhookContext: WebhookContext
};
