/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SecondaryAuthTokenList
 *
 * @param version - Version of the resource
 */
declare function SecondaryAuthTokenList(version: V1): SecondaryAuthTokenListInstance;

interface SecondaryAuthTokenListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SecondaryAuthTokenContext;
  /**
   * Constructs a secondary_auth_token
   */
  get(): SecondaryAuthTokenContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface SecondaryAuthTokenPayload extends SecondaryAuthTokenResource, Page.TwilioResponsePayload {
}

interface SecondaryAuthTokenResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  secondary_auth_token: string;
  url: string;
}

interface SecondaryAuthTokenSolution {
}


declare class SecondaryAuthTokenContext {
  /**
   * Initialize the SecondaryAuthTokenContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * create a SecondaryAuthTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: SecondaryAuthTokenInstance) => any): Promise<SecondaryAuthTokenInstance>;
  /**
   * remove a SecondaryAuthTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SecondaryAuthTokenInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SecondaryAuthTokenInstance extends SerializableClass {
  /**
   * Initialize the SecondaryAuthTokenContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: SecondaryAuthTokenPayload);

  private _proxy: SecondaryAuthTokenContext;
  accountSid: string;
  /**
   * create a SecondaryAuthTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, items: SecondaryAuthTokenInstance) => any): Promise<SecondaryAuthTokenInstance>;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * remove a SecondaryAuthTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SecondaryAuthTokenInstance) => any): Promise<boolean>;
  secondaryAuthToken: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class SecondaryAuthTokenPage extends Page<V1, SecondaryAuthTokenPayload, SecondaryAuthTokenResource, SecondaryAuthTokenInstance> {
  /**
   * Initialize the SecondaryAuthTokenPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SecondaryAuthTokenSolution);

  /**
   * Build an instance of SecondaryAuthTokenInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SecondaryAuthTokenPayload): SecondaryAuthTokenInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SecondaryAuthTokenContext, SecondaryAuthTokenInstance, SecondaryAuthTokenList, SecondaryAuthTokenListInstance, SecondaryAuthTokenPage, SecondaryAuthTokenPayload, SecondaryAuthTokenResource, SecondaryAuthTokenSolution }
