'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var UserRolesList;
var UserRolesPage;
var UserRolesInstance;
var UserRolesContext;

/* jshint ignore:start */
/**
 * Initialize the UserRolesList
 *
 * @constructor Twilio.FlexApi.V1.UserRolesList
 *
 * @param {Twilio.FlexApi.V1} version - Version of the resource
 */
/* jshint ignore:end */
UserRolesList = function UserRolesList(version) {
  /* jshint ignore:start */
  /**
   * @function userRoles
   * @memberof Twilio.FlexApi.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.FlexApi.V1.UserRolesContext}
   */
  /* jshint ignore:end */
  function UserRolesListInstance(sid) {
    return UserRolesListInstance.get(sid);
  }

  UserRolesListInstance._version = version;
  // Path Solution
  UserRolesListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a user_roles
   *
   * @function get
   * @memberof Twilio.FlexApi.V1.UserRolesList#
   *
   * @returns {Twilio.FlexApi.V1.UserRolesContext}
   */
  /* jshint ignore:end */
  UserRolesListInstance.get = function get() {
    return new UserRolesContext(this._version);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.FlexApi.V1.UserRolesList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UserRolesListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UserRolesListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return UserRolesListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UserRolesPage
 *
 * @constructor Twilio.FlexApi.V1.UserRolesPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UserRolesSolution} solution - Path solution
 *
 * @returns UserRolesPage
 */
/* jshint ignore:end */
UserRolesPage = function UserRolesPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UserRolesPage.prototype, Page.prototype);
UserRolesPage.prototype.constructor = UserRolesPage;

/* jshint ignore:start */
/**
 * Build an instance of UserRolesInstance
 *
 * @function getInstance
 * @memberof Twilio.FlexApi.V1.UserRolesPage#
 *
 * @param {UserRolesPayload} payload - Payload response from the API
 *
 * @returns UserRolesInstance
 */
/* jshint ignore:end */
UserRolesPage.prototype.getInstance = function getInstance(payload) {
  return new UserRolesInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.UserRolesPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserRolesPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserRolesPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserRolesContext
 *
 * @constructor Twilio.FlexApi.V1.UserRolesInstance
 *
 * @property {string} roles - Flex Insights roles for the user
 * @property {string} url - The url
 *
 * @param {V1} version - Version of the resource
 * @param {UserRolesPayload} payload - The instance payload
 */
/* jshint ignore:end */
UserRolesInstance = function UserRolesInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.roles = payload.roles; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

Object.defineProperty(UserRolesInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new UserRolesContext(this._version);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a UserRolesInstance
 *
 * @function fetch
 * @memberof Twilio.FlexApi.V1.UserRolesInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.token] - The Token HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserRolesInstance
 */
/* jshint ignore:end */
UserRolesInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.UserRolesInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserRolesInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserRolesInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserRolesContext
 *
 * @constructor Twilio.FlexApi.V1.UserRolesContext
 *
 * @param {V1} version - Version of the resource
 */
/* jshint ignore:end */
UserRolesContext = function UserRolesContext(version) {
  this._version = version;

  // Path Solution
  this._solution = {};
  this._uri = `/Accounts/UserRoles`;
};

/* jshint ignore:start */
/**
 * fetch a UserRolesInstance
 *
 * @function fetch
 * @memberof Twilio.FlexApi.V1.UserRolesContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.token] - The Token HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserRolesInstance
 */
/* jshint ignore:end */
UserRolesContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var headers = values.of({'Token': _.get(opts, 'token')});

  var promise = this._version.fetch({uri: this._uri, method: 'GET', headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(new UserRolesInstance(this._version, payload));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.UserRolesContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserRolesContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

UserRolesContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UserRolesList: UserRolesList,
  UserRolesPage: UserRolesPage,
  UserRolesInstance: UserRolesInstance,
  UserRolesContext: UserRolesContext
};
