/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2010 = require('../../../V2010');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the UserDefinedMessageList
 *
 * @param version - Version of the resource
 * @param accountSid - Account SID.
 * @param callSid - Call SID.
 */
declare function UserDefinedMessageList(version: V2010, accountSid: string, callSid: string): UserDefinedMessageListInstance;

interface UserDefinedMessageListInstance {
  /**
   * create a UserDefinedMessageInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: UserDefinedMessageListInstanceCreateOptions, callback?: (error: Error | null, item: UserDefinedMessageInstance) => any): Promise<UserDefinedMessageInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property content - The User Defined Message in the form of URL-encoded JSON string.
 * @property idempotencyKey - A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.
 */
interface UserDefinedMessageListInstanceCreateOptions {
  content: string;
  idempotencyKey?: string;
}

interface UserDefinedMessagePayload extends UserDefinedMessageResource, Page.TwilioResponsePayload {
}

interface UserDefinedMessageResource {
  account_sid: string;
  call_sid: string;
  date_created: Date;
  sid: string;
}

interface UserDefinedMessageSolution {
  accountSid?: string;
  callSid?: string;
}


declare class UserDefinedMessageInstance extends SerializableClass {
  /**
   * Initialize the UserDefinedMessageContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - Account SID.
   * @param callSid - Call SID.
   */
  constructor(version: V2010, payload: UserDefinedMessagePayload, accountSid: string, callSid: string);

  accountSid: string;
  callSid: string;
  dateCreated: Date;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class UserDefinedMessagePage extends Page<V2010, UserDefinedMessagePayload, UserDefinedMessageResource, UserDefinedMessageInstance> {
  /**
   * Initialize the UserDefinedMessagePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: UserDefinedMessageSolution);

  /**
   * Build an instance of UserDefinedMessageInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UserDefinedMessagePayload): UserDefinedMessageInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UserDefinedMessageInstance, UserDefinedMessageList, UserDefinedMessageListInstance, UserDefinedMessageListInstanceCreateOptions, UserDefinedMessagePage, UserDefinedMessagePayload, UserDefinedMessageResource, UserDefinedMessageSolution }
