'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var StreamMessageList = require('./syncStream/streamMessage').StreamMessageList;
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var SyncStreamList;
var SyncStreamPage;
var SyncStreamInstance;
var SyncStreamContext;

/* jshint ignore:start */
/**
 * Initialize the SyncStreamList
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamList
 *
 * @param {Twilio.Sync.V1} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 */
/* jshint ignore:end */
SyncStreamList = function SyncStreamList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function syncStreams
   * @memberof Twilio.Sync.V1.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Sync.V1.ServiceContext.SyncStreamContext}
   */
  /* jshint ignore:end */
  function SyncStreamListInstance(sid) {
    return SyncStreamListInstance.get(sid);
  }

  SyncStreamListInstance._version = version;
  // Path Solution
  SyncStreamListInstance._solution = {serviceSid: serviceSid};
  SyncStreamListInstance._uri = `/Services/${serviceSid}/Streams`;
  /* jshint ignore:start */
  /**
   * create a SyncStreamInstance
   *
   * @function create
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.uniqueName] -
   *          An application-defined string that uniquely identifies the resource
   * @param {number} [opts.ttl] -
   *          How long, in seconds, before the Stream expires and is deleted
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SyncStreamInstance
   */
  /* jshint ignore:end */
  SyncStreamListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({'UniqueName': _.get(opts, 'uniqueName'), 'Ttl': _.get(opts, 'ttl')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncStreamInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams SyncStreamInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SyncStreamListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SyncStreamInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncStreamListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SyncStreamInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncStreamListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncStreamPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SyncStreamInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncStreamListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncStreamPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a sync_stream
   *
   * @function get
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @param {string} sid - The SID of the Stream resource to fetch
   *
   * @returns {Twilio.Sync.V1.ServiceContext.SyncStreamContext}
   */
  /* jshint ignore:end */
  SyncStreamListInstance.get = function get(sid) {
    return new SyncStreamContext(this._version, this._solution.serviceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SyncStreamListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SyncStreamListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return SyncStreamListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SyncStreamPage
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SyncStreamSolution} solution - Path solution
 *
 * @returns SyncStreamPage
 */
/* jshint ignore:end */
SyncStreamPage = function SyncStreamPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SyncStreamPage.prototype, Page.prototype);
SyncStreamPage.prototype.constructor = SyncStreamPage;

/* jshint ignore:start */
/**
 * Build an instance of SyncStreamInstance
 *
 * @function getInstance
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamPage#
 *
 * @param {SyncStreamPayload} payload - Payload response from the API
 *
 * @returns SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamPage.prototype.getInstance = function getInstance(payload) {
  return new SyncStreamInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncStreamPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncStreamPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncStreamContext
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @property {string} url - The absolute URL of the Message Stream resource
 * @property {string} links - The URLs of the Stream's nested resources
 * @property {Date} dateExpires -
 *          The ISO 8601 date and time in GMT when the Message Stream expires
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} createdBy - The Identity of the Stream's creator
 *
 * @param {V1} version - Version of the resource
 * @param {SyncStreamPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @param {sid_like} sid - The SID of the Stream resource to fetch
 */
/* jshint ignore:end */
SyncStreamInstance = function SyncStreamInstance(version, payload, serviceSid,
                                                  sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.dateExpires = deserialize.iso8601DateTime(payload.date_expires); // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.createdBy = payload.created_by; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, sid: sid || this.sid, };
};

Object.defineProperty(SyncStreamInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SyncStreamContext(this._version, this._solution.serviceSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SyncStreamInstance
 *
 * @function fetch
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a SyncStreamInstance
 *
 * @function remove
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * update a SyncStreamInstance
 *
 * @function update
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.ttl] -
 *          How long, in seconds, before the Stream expires and is deleted
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the streamMessages
 *
 * @function streamMessages
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamInstance#
 *
 * @returns {Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageList}
 */
/* jshint ignore:end */
SyncStreamInstance.prototype.streamMessages = function streamMessages() {
  return this._proxy.streamMessages;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncStreamInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncStreamInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncStreamContext
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncStreamContext
 *
 * @property {Twilio.Sync.V1.ServiceContext.SyncStreamContext.StreamMessageList} streamMessages -
 *          streamMessages resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} serviceSid -
 *          The SID of the Sync Service with the Sync Stream resource to fetch
 * @param {sid_like} sid - The SID of the Stream resource to fetch
 */
/* jshint ignore:end */
SyncStreamContext = function SyncStreamContext(version, serviceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, sid: sid, };
  this._uri = `/Services/${serviceSid}/Streams/${sid}`;

  // Dependents
  this._streamMessages = undefined;
};

/* jshint ignore:start */
/**
 * fetch a SyncStreamInstance
 *
 * @function fetch
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncStreamInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SyncStreamInstance
 *
 * @function remove
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SyncStreamInstance
 *
 * @function update
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.ttl] -
 *          How long, in seconds, before the Stream expires and is deleted
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncStreamInstance
 */
/* jshint ignore:end */
SyncStreamContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'Ttl': _.get(opts, 'ttl')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncStreamInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(SyncStreamContext.prototype,
  'streamMessages', {
    get: function() {
      if (!this._streamMessages) {
        this._streamMessages = new StreamMessageList(
          this._version,
          this._solution.serviceSid,
          this._solution.sid
        );
      }
      return this._streamMessages;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncStreamContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncStreamContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SyncStreamContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SyncStreamList: SyncStreamList,
  SyncStreamPage: SyncStreamPage,
  SyncStreamInstance: SyncStreamInstance,
  SyncStreamContext: SyncStreamContext
};
