/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

type AnonymizeStatus = 'connected'|'disconnected';

/**
 * Initialize the AnonymizeList
 *
 * @param version - Version of the resource
 * @param roomSid - The SID of the participant's room
 * @param sid - The unique string that identifies the resource
 */
declare function AnonymizeList(version: V1, roomSid: string, sid: string): AnonymizeListInstance;

interface AnonymizeListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AnonymizeContext;
  /**
   * Constructs a anonymize
   */
  get(): AnonymizeContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AnonymizePayload extends AnonymizeResource, Page.TwilioResponsePayload {
}

interface AnonymizeResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  duration: number;
  end_time: Date;
  identity: string;
  room_sid: string;
  sid: string;
  start_time: Date;
  status: AnonymizeStatus;
  url: string;
}

interface AnonymizeSolution {
  roomSid?: string;
  sid?: string;
}


declare class AnonymizeContext {
  /**
   * Initialize the AnonymizeContext
   *
   * @param version - Version of the resource
   * @param roomSid - The SID of the room with the participant to update
   * @param sid - The SID that identifies the resource to update
   */
  constructor(version: V1, roomSid: string, sid: string);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnonymizeInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnonymizeInstance) => any): Promise<AnonymizeInstance>;
}


declare class AnonymizeInstance extends SerializableClass {
  /**
   * Initialize the AnonymizeContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param roomSid - The SID of the participant's room
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: AnonymizePayload, roomSid: string, sid: string);

  private _proxy: AnonymizeContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  duration: number;
  endTime: Date;
  identity: string;
  roomSid: string;
  sid: string;
  startTime: Date;
  status: AnonymizeStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnonymizeInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnonymizeInstance) => any): Promise<AnonymizeInstance>;
  url: string;
}


declare class AnonymizePage extends Page<V1, AnonymizePayload, AnonymizeResource, AnonymizeInstance> {
  /**
   * Initialize the AnonymizePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AnonymizeSolution);

  /**
   * Build an instance of AnonymizeInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AnonymizePayload): AnonymizeInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AnonymizeContext, AnonymizeInstance, AnonymizeList, AnonymizeListInstance, AnonymizePage, AnonymizePayload, AnonymizeResource, AnonymizeSolution, AnonymizeStatus }
