/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the WebChannelsList
 *
 * @param version - Version of the resource
 */
declare function WebChannelsList(version: V2): WebChannelsListInstance;

interface WebChannelsListInstance {
  /**
   * create a WebChannelsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: WebChannelsListInstanceCreateOptions, callback?: (error: Error | null, item: WebChannelsInstance) => any): Promise<WebChannelsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property addressSid - The SID of the Conversations Address
 * @property chatFriendlyName - The Conversation's friendly name
 * @property customerFriendlyName - The Conversation participant's friendly name
 * @property preEngagementData - The pre-engagement data
 */
interface WebChannelsListInstanceCreateOptions {
  addressSid: string;
  chatFriendlyName?: string;
  customerFriendlyName?: string;
  preEngagementData?: string;
}

interface WebChannelsPayload extends WebChannelsResource, Page.TwilioResponsePayload {
}

interface WebChannelsResource {
  conversation_sid: string;
  identity: string;
}

interface WebChannelsSolution {
}


declare class WebChannelsInstance extends SerializableClass {
  /**
   * Initialize the WebChannelsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: WebChannelsPayload);

  conversationSid: string;
  identity: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class WebChannelsPage extends Page<V2, WebChannelsPayload, WebChannelsResource, WebChannelsInstance> {
  /**
   * Initialize the WebChannelsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: WebChannelsSolution);

  /**
   * Build an instance of WebChannelsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WebChannelsPayload): WebChannelsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WebChannelsInstance, WebChannelsList, WebChannelsListInstance, WebChannelsListInstanceCreateOptions, WebChannelsPage, WebChannelsPayload, WebChannelsResource, WebChannelsSolution }
