/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the DomainCertsList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function DomainCertsList(version: V1): DomainCertsListInstance;

/**
 * Options to pass to update
 *
 * @property tlsCert - Certificate and private key information for this domain.
 */
interface DomainCertsInstanceUpdateOptions {
  tlsCert: string;
}

interface DomainCertsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): DomainCertsContext;
  /**
   * Constructs a domain_certs
   *
   * @param domainSid - Unique string used to identify the domain that this certificate should be associated with.
   */
  get(domainSid: string): DomainCertsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface DomainCertsPayload extends DomainCertsResource, Page.TwilioResponsePayload {
}

interface DomainCertsResource {
  certificate_sid: string;
  date_created: Date;
  date_expires: Date;
  date_updated: Date;
  domain_name: string;
  domain_sid: string;
  url: string;
  validated: boolean;
}

interface DomainCertsSolution {
}


declare class DomainCertsContext {
  /**
   * Initialize the DomainCertsContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param domainSid - Unique string used to identify the domain that this certificate should be associated with.
   */
  constructor(version: V1, domainSid: string);

  /**
   * fetch a DomainCertsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<DomainCertsInstance>;
  /**
   * remove a DomainCertsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a DomainCertsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: DomainCertsInstanceUpdateOptions, callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<DomainCertsInstance>;
}


declare class DomainCertsInstance extends SerializableClass {
  /**
   * Initialize the DomainCertsContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param domainSid - Unique string used to identify the domain that this certificate should be associated with.
   */
  constructor(version: V1, payload: DomainCertsPayload, domainSid: string);

  private _proxy: DomainCertsContext;
  certificateSid: string;
  dateCreated: Date;
  dateExpires: Date;
  dateUpdated: Date;
  domainName: string;
  domainSid: string;
  /**
   * fetch a DomainCertsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<DomainCertsInstance>;
  /**
   * remove a DomainCertsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a DomainCertsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: DomainCertsInstanceUpdateOptions, callback?: (error: Error | null, items: DomainCertsInstance) => any): Promise<DomainCertsInstance>;
  url: string;
  validated: boolean;
}


declare class DomainCertsPage extends Page<V1, DomainCertsPayload, DomainCertsResource, DomainCertsInstance> {
  /**
   * Initialize the DomainCertsPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: DomainCertsSolution);

  /**
   * Build an instance of DomainCertsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: DomainCertsPayload): DomainCertsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { DomainCertsContext, DomainCertsInstance, DomainCertsInstanceUpdateOptions, DomainCertsList, DomainCertsListInstance, DomainCertsPage, DomainCertsPayload, DomainCertsResource, DomainCertsSolution }
