/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type TollfreeVerificationOptInType = 'VERBAL'|'WEB_FORM'|'PAPER_FORM'|'VIA_TEXT'|'MOBILE_QR_CODE';

type TollfreeVerificationStatus = 'PENDING_REVIEW'|'IN_REVIEW'|'TWILIO_APPROVED'|'TWILIO_REJECTED';

/**
 * Initialize the TollfreeVerificationList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function TollfreeVerificationList(version: V1): TollfreeVerificationListInstance;

/**
 * Options to pass to update
 *
 * @property additionalInformation - Additional information to be provided for verification
 * @property businessCity - The city of the business or organization using the Tollfree number
 * @property businessContactEmail - The email address of the contact for the business or organization using the Tollfree number
 * @property businessContactFirstName - The first name of the contact for the business or organization using the Tollfree number
 * @property businessContactLastName - The last name of the contact for the business or organization using the Tollfree number
 * @property businessContactPhone - The phone number of the contact for the business or organization using the Tollfree number
 * @property businessCountry - The country of the business or organization using the Tollfree number
 * @property businessName - The name of the business or organization using the Tollfree number
 * @property businessPostalCode - The postal code of the business or organization using the Tollfree number
 * @property businessStateProvinceRegion - The state/province/region of the business or organization using the Tollfree number
 * @property businessStreetAddress - The address of the business or organization using the Tollfree number
 * @property businessStreetAddress2 - The address of the business or organization using the Tollfree number
 * @property businessWebsite - The website of the business or organization using the Tollfree number
 * @property messageVolume - Estimate monthly volume of messages from the Tollfree Number
 * @property notificationEmail - The email address to receive the notification about the verification result.
 * @property optInImageUrls - Link to an image that shows the opt-in workflow. Multiple images allowed and must be a publicly hosted URL
 * @property optInType - Describe how a user opts-in to text messages
 * @property productionMessageSample - An example of message content, i.e. a sample message
 * @property useCaseCategories - The category of the use case for the Tollfree Number. List as many are applicable.
 * @property useCaseSummary - Further explaination on how messaging is used by the business or organization
 */
interface TollfreeVerificationInstanceUpdateOptions {
  additionalInformation?: string;
  businessCity?: string;
  businessContactEmail?: string;
  businessContactFirstName?: string;
  businessContactLastName?: string;
  businessContactPhone?: string;
  businessCountry?: string;
  businessName?: string;
  businessPostalCode?: string;
  businessStateProvinceRegion?: string;
  businessStreetAddress?: string;
  businessStreetAddress2?: string;
  businessWebsite?: string;
  messageVolume?: string;
  notificationEmail?: string;
  optInImageUrls?: string | string[];
  optInType?: TollfreeVerificationOptInType;
  productionMessageSample?: string;
  useCaseCategories?: string | string[];
  useCaseSummary?: string;
}

interface TollfreeVerificationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TollfreeVerificationContext;
  /**
   * create a TollfreeVerificationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TollfreeVerificationListInstanceCreateOptions, callback?: (error: Error | null, item: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  /**
   * Streams TollfreeVerificationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TollfreeVerificationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TollfreeVerificationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TollfreeVerificationListInstanceEachOptions, callback?: (item: TollfreeVerificationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a tollfree_verification
   *
   * @param sid - Tollfree Verification Sid
   */
  get(sid: string): TollfreeVerificationContext;
  /**
   * Retrieve a single target page of TollfreeVerificationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TollfreeVerificationPage) => any): Promise<TollfreeVerificationPage>;
  /**
   * Retrieve a single target page of TollfreeVerificationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TollfreeVerificationPage) => any): Promise<TollfreeVerificationPage>;
  /**
   * Lists TollfreeVerificationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TollfreeVerificationInstance[]) => any): Promise<TollfreeVerificationInstance[]>;
  /**
   * Lists TollfreeVerificationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TollfreeVerificationListInstanceOptions, callback?: (error: Error | null, items: TollfreeVerificationInstance[]) => any): Promise<TollfreeVerificationInstance[]>;
  /**
   * Retrieve a single page of TollfreeVerificationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TollfreeVerificationPage) => any): Promise<TollfreeVerificationPage>;
  /**
   * Retrieve a single page of TollfreeVerificationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TollfreeVerificationListInstancePageOptions, callback?: (error: Error | null, items: TollfreeVerificationPage) => any): Promise<TollfreeVerificationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property additionalInformation - Additional information to be provided for verification
 * @property businessCity - The city of the business or organization using the Tollfree number
 * @property businessContactEmail - The email address of the contact for the business or organization using the Tollfree number
 * @property businessContactFirstName - The first name of the contact for the business or organization using the Tollfree number
 * @property businessContactLastName - The last name of the contact for the business or organization using the Tollfree number
 * @property businessContactPhone - The phone number of the contact for the business or organization using the Tollfree number
 * @property businessCountry - The country of the business or organization using the Tollfree number
 * @property businessName - The name of the business or organization using the Tollfree number
 * @property businessPostalCode - The postal code of the business or organization using the Tollfree number
 * @property businessStateProvinceRegion - The state/province/region of the business or organization using the Tollfree number
 * @property businessStreetAddress - The address of the business or organization using the Tollfree number
 * @property businessStreetAddress2 - The address of the business or organization using the Tollfree number
 * @property businessWebsite - The website of the business or organization using the Tollfree number
 * @property customerProfileSid - Customer's Profile Bundle BundleSid
 * @property messageVolume - Estimate monthly volume of messages from the Tollfree Number
 * @property notificationEmail - The email address to receive the notification about the verification result.
 * @property optInImageUrls - Link to an image that shows the opt-in workflow. Multiple images allowed and must be a publicly hosted URL
 * @property optInType - Describe how a user opts-in to text messages
 * @property productionMessageSample - An example of message content, i.e. a sample message
 * @property tollfreePhoneNumberSid - The SID of the Phone Number associated with the Tollfree Verification
 * @property useCaseCategories - The category of the use case for the Tollfree Number. List as many are applicable.
 * @property useCaseSummary - Further explaination on how messaging is used by the business or organization
 */
interface TollfreeVerificationListInstanceCreateOptions {
  additionalInformation?: string;
  businessCity?: string;
  businessContactEmail?: string;
  businessContactFirstName?: string;
  businessContactLastName?: string;
  businessContactPhone?: string;
  businessCountry?: string;
  businessName: string;
  businessPostalCode?: string;
  businessStateProvinceRegion?: string;
  businessStreetAddress?: string;
  businessStreetAddress2?: string;
  businessWebsite: string;
  customerProfileSid?: string;
  messageVolume: string;
  notificationEmail: string;
  optInImageUrls: string | string[];
  optInType: TollfreeVerificationOptInType;
  productionMessageSample: string;
  tollfreePhoneNumberSid: string;
  useCaseCategories: string | string[];
  useCaseSummary: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - The compliance status of the Tollfree Verification record.
 * @property tollfreePhoneNumberSid - The SID of the Phone Number associated with the Tollfree Verification
 */
interface TollfreeVerificationListInstanceEachOptions {
  callback?: (item: TollfreeVerificationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
  status?: TollfreeVerificationStatus;
  tollfreePhoneNumberSid?: string;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - The compliance status of the Tollfree Verification record.
 * @property tollfreePhoneNumberSid - The SID of the Phone Number associated with the Tollfree Verification
 */
interface TollfreeVerificationListInstanceOptions {
  limit?: number;
  pageSize?: number;
  status?: TollfreeVerificationStatus;
  tollfreePhoneNumberSid?: string;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - The compliance status of the Tollfree Verification record.
 * @property tollfreePhoneNumberSid - The SID of the Phone Number associated with the Tollfree Verification
 */
interface TollfreeVerificationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: TollfreeVerificationStatus;
  tollfreePhoneNumberSid?: string;
}

interface TollfreeVerificationPayload extends TollfreeVerificationResource, Page.TwilioResponsePayload {
}

interface TollfreeVerificationResource {
  account_sid: string;
  additional_information: string;
  business_city: string;
  business_contact_email: string;
  business_contact_first_name: string;
  business_contact_last_name: string;
  business_contact_phone: string;
  business_country: string;
  business_name: string;
  business_postal_code: string;
  business_state_province_region: string;
  business_street_address: string;
  business_street_address2: string;
  business_website: string;
  customer_profile_sid: string;
  date_created: Date;
  date_updated: Date;
  message_volume: string;
  notification_email: string;
  opt_in_image_urls: string[];
  opt_in_type: TollfreeVerificationOptInType;
  production_message_sample: string;
  regulated_item_sid: string;
  resource_links: object;
  sid: string;
  status: TollfreeVerificationStatus;
  tollfree_phone_number_sid: string;
  trust_product_sid: string;
  url: string;
  use_case_categories: string[];
  use_case_summary: string;
}

interface TollfreeVerificationSolution {
}


declare class TollfreeVerificationContext {
  /**
   * Initialize the TollfreeVerificationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - Tollfree Verification Sid
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a TollfreeVerificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a TollfreeVerificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  /**
   * update a TollfreeVerificationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TollfreeVerificationInstanceUpdateOptions, callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
}


declare class TollfreeVerificationInstance extends SerializableClass {
  /**
   * Initialize the TollfreeVerificationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - Tollfree Verification Sid
   */
  constructor(version: V1, payload: TollfreeVerificationPayload, sid: string);

  private _proxy: TollfreeVerificationContext;
  accountSid: string;
  additionalInformation: string;
  businessCity: string;
  businessContactEmail: string;
  businessContactFirstName: string;
  businessContactLastName: string;
  businessContactPhone: string;
  businessCountry: string;
  businessName: string;
  businessPostalCode: string;
  businessStateProvinceRegion: string;
  businessStreetAddress: string;
  businessStreetAddress2: string;
  businessWebsite: string;
  customerProfileSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a TollfreeVerificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  messageVolume: string;
  notificationEmail: string;
  optInImageUrls: string[];
  optInType: TollfreeVerificationOptInType;
  productionMessageSample: string;
  regulatedItemSid: string;
  resourceLinks: any;
  sid: string;
  status: TollfreeVerificationStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  tollfreePhoneNumberSid: string;
  trustProductSid: string;
  /**
   * update a TollfreeVerificationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  /**
   * update a TollfreeVerificationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: TollfreeVerificationInstanceUpdateOptions, callback?: (error: Error | null, items: TollfreeVerificationInstance) => any): Promise<TollfreeVerificationInstance>;
  url: string;
  useCaseCategories: string[];
  useCaseSummary: string;
}


declare class TollfreeVerificationPage extends Page<V1, TollfreeVerificationPayload, TollfreeVerificationResource, TollfreeVerificationInstance> {
  /**
   * Initialize the TollfreeVerificationPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TollfreeVerificationSolution);

  /**
   * Build an instance of TollfreeVerificationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TollfreeVerificationPayload): TollfreeVerificationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TollfreeVerificationContext, TollfreeVerificationInstance, TollfreeVerificationInstanceUpdateOptions, TollfreeVerificationList, TollfreeVerificationListInstance, TollfreeVerificationListInstanceCreateOptions, TollfreeVerificationListInstanceEachOptions, TollfreeVerificationListInstanceOptions, TollfreeVerificationListInstancePageOptions, TollfreeVerificationOptInType, TollfreeVerificationPage, TollfreeVerificationPayload, TollfreeVerificationResource, TollfreeVerificationSolution, TollfreeVerificationStatus }
