"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamplePage = exports.SampleListInstance = exports.SampleInstance = exports.SampleContextImpl = void 0;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../../base/Page"));
const deserialize = require("../../../../../base/deserialize");
const serialize = require("../../../../../base/serialize");
const utility_1 = require("../../../../../base/utility");
class SampleContextImpl {
    constructor(_version, assistantSid, taskSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantSid)) {
            throw new Error("Parameter 'assistantSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(taskSid)) {
            throw new Error("Parameter 'taskSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { assistantSid, taskSid, sid };
        this._uri = `/Assistants/${assistantSid}/Tasks/${taskSid}/Samples/${sid}`;
    }
    remove(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new SampleInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.taskSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["language"] !== undefined)
            data["Language"] = params["language"];
        if (params["taggedText"] !== undefined)
            data["TaggedText"] = params["taggedText"];
        if (params["sourceChannel"] !== undefined)
            data["SourceChannel"] = params["sourceChannel"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new SampleInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.taskSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.SampleContextImpl = SampleContextImpl;
class SampleInstance {
    constructor(_version, payload, assistantSid, taskSid, sid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.taskSid = payload.task_sid;
        this.language = payload.language;
        this.assistantSid = payload.assistant_sid;
        this.sid = payload.sid;
        this.taggedText = payload.tagged_text;
        this.url = payload.url;
        this.sourceChannel = payload.source_channel;
        this._solution = { assistantSid, taskSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new SampleContextImpl(this._version, this._solution.assistantSid, this._solution.taskSid, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a SampleInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a SampleInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed SampleInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            taskSid: this.taskSid,
            language: this.language,
            assistantSid: this.assistantSid,
            sid: this.sid,
            taggedText: this.taggedText,
            url: this.url,
            sourceChannel: this.sourceChannel,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.SampleInstance = SampleInstance;
function SampleListInstance(version, assistantSid, taskSid) {
    if (!(0, utility_1.isValidPathParam)(assistantSid)) {
        throw new Error("Parameter 'assistantSid' is not valid.");
    }
    if (!(0, utility_1.isValidPathParam)(taskSid)) {
        throw new Error("Parameter 'taskSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new SampleContextImpl(version, assistantSid, taskSid, sid);
    };
    instance._version = version;
    instance._solution = { assistantSid, taskSid };
    instance._uri = `/Assistants/${assistantSid}/Tasks/${taskSid}/Samples`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["language"] === null || params["language"] === undefined) {
            throw new Error("Required parameter \"params['language']\" missing.");
        }
        if (params["taggedText"] === null || params["taggedText"] === undefined) {
            throw new Error("Required parameter \"params['taggedText']\" missing.");
        }
        let data = {};
        data["Language"] = params["language"];
        data["TaggedText"] = params["taggedText"];
        if (params["sourceChannel"] !== undefined)
            data["SourceChannel"] = params["sourceChannel"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new SampleInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.taskSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["language"] !== undefined)
            data["Language"] = params["language"];
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new SamplePage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new SamplePage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.SampleListInstance = SampleListInstance;
class SamplePage extends Page_1.default {
    /**
     * Initialize the SamplePage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of SampleInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new SampleInstance(this._version, payload, this._solution.assistantSid, this._solution.taskSid);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.SamplePage = SamplePage;
