/**
 * A mutex implementation that can be used to lock access between concurrent async functions
 */
export declare class Mutex {
    private locked;
    /**
     * Create a new Mutex
     */
    constructor();
    /**
     *  Yield the current execution context, effectively moving it to the back of the promise queue
     */
    private sleep;
    /**
     * Wait until the Mutex is available and claim it
     */
    lock(): Promise<void>;
    /**
     * Unlock the Mutex
     */
    unlock(): void;
}
