/* valaversionattribute.c generated by valac, the Vala compiler
 * generated from valaversionattribute.vala, do not modify */

/* valaversionattribute.vala
 *
 * Copyright (C) 2013  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "vala.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _ValaParamSpecVersionAttribute ValaParamSpecVersionAttribute;

struct _ValaVersionAttributePrivate {
	ValaSymbol* symbol;
	gboolean* _deprecated;
	gboolean* _experimental;
};

struct _ValaParamSpecVersionAttribute {
	GParamSpec parent_instance;
};

static gint ValaVersionAttribute_private_offset;
static gpointer vala_version_attribute_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_version_attribute_finalize (ValaVersionAttribute * obj);
static GType vala_version_attribute_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_version_attribute_get_instance_private (ValaVersionAttribute* self)
{
	return G_STRUCT_MEMBER_P (self, ValaVersionAttribute_private_offset);
}

/**
 * Constructs a new VersionAttribute.
 *
 * @param symbol the owner
 * @return a new VersionAttribute
 * @see Vala.Symbol
 */
ValaVersionAttribute*
vala_version_attribute_construct (GType object_type,
                                  ValaSymbol* symbol)
{
	ValaVersionAttribute* self = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (ValaVersionAttribute*) g_type_create_instance (object_type);
	self->priv->symbol = symbol;
	return self;
}

ValaVersionAttribute*
vala_version_attribute_new (ValaSymbol* symbol)
{
	return vala_version_attribute_construct (VALA_TYPE_VERSION_ATTRIBUTE, symbol);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_version_attribute_get_deprecated (ValaVersionAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_deprecated;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		ValaSymbol* _tmp4_;
		gboolean* _tmp13_;
		_tmp4_ = self->priv->symbol;
		if (vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp4_, "Version", "deprecated", FALSE)) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->symbol;
			_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "Version", "deprecated_since", NULL);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ != NULL;
			_g_free0 (_tmp7_);
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->symbol;
			_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "Version", "replacement", NULL);
			_tmp10_ = _tmp9_;
			_tmp2_ = _tmp10_ != NULL;
			_g_free0 (_tmp10_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp11_;
			ValaAttribute* _tmp12_;
			_tmp11_ = self->priv->symbol;
			_tmp12_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp11_, "Deprecated");
			_tmp1_ = _tmp12_ != NULL;
		}
		_tmp13_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_deprecated);
		self->priv->_deprecated = _tmp13_;
	}
	_tmp14_ = self->priv->_deprecated;
	result = *_tmp14_;
	return result;
}

void
vala_version_attribute_set_deprecated (ValaVersionAttribute* self,
                                       gboolean value)
{
	gboolean* _tmp0_;
	ValaSymbol* _tmp1_;
	gboolean* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_deprecated);
	self->priv->_deprecated = _tmp0_;
	_tmp1_ = self->priv->symbol;
	_tmp2_ = self->priv->_deprecated;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp1_, "Version", "deprecated", *_tmp2_, NULL);
}

gchar*
vala_version_attribute_get_deprecated_since (ValaVersionAttribute* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp1_, "Version", "deprecated_since", NULL);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->symbol;
		_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "Deprecated", "since", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

void
vala_version_attribute_set_deprecated_since (ValaVersionAttribute* self,
                                             const gchar* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "deprecated_since", value, NULL);
}

gchar*
vala_version_attribute_get_replacement (ValaVersionAttribute* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp1_, "Version", "replacement", NULL);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->symbol;
		_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "Deprecated", "replacement", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

void
vala_version_attribute_set_replacement (ValaVersionAttribute* self,
                                        const gchar* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "replacement", value, NULL);
}

gboolean
vala_version_attribute_get_experimental (ValaVersionAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_experimental;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaSymbol* _tmp3_;
		gboolean* _tmp9_;
		_tmp3_ = self->priv->symbol;
		if (vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp3_, "Version", "experimental", FALSE)) {
			_tmp2_ = TRUE;
		} else {
			ValaSymbol* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = self->priv->symbol;
			_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp4_, "Version", "experimental_until", NULL);
			_tmp6_ = _tmp5_;
			_tmp2_ = _tmp6_ != NULL;
			_g_free0 (_tmp6_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			ValaAttribute* _tmp8_;
			_tmp7_ = self->priv->symbol;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp7_, "Experimental");
			_tmp1_ = _tmp8_ != NULL;
		}
		_tmp9_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_experimental);
		self->priv->_experimental = _tmp9_;
	}
	_tmp10_ = self->priv->_experimental;
	result = *_tmp10_;
	return result;
}

void
vala_version_attribute_set_experimental (ValaVersionAttribute* self,
                                         gboolean value)
{
	gboolean* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_experimental);
	self->priv->_experimental = _tmp0_;
	_tmp1_ = self->priv->symbol;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp1_, "Version", "experimental", value, NULL);
}

gchar*
vala_version_attribute_get_experimental_until (ValaVersionAttribute* self)
{
	gchar* result;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "experimental_until", NULL);
	result = _tmp1_;
	return result;
}

void
vala_version_attribute_set_experimental_until (ValaVersionAttribute* self,
                                               const gchar* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "experimental_until", value, NULL);
}

gchar*
vala_version_attribute_get_since (ValaVersionAttribute* self)
{
	gchar* result;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "since", NULL);
	result = _tmp1_;
	return result;
}

void
vala_version_attribute_set_since (ValaVersionAttribute* self,
                                  const gchar* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "since", value, NULL);
}

/**
 * Check to see if the symbol is experimental, deprecated or not available
 * and emit a warning if it is.
 */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
vala_version_attribute_check (ValaVersionAttribute* self,
                              ValaCodeContext* context,
                              ValaSourceReference* source_ref)
{
	gboolean _result_ = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp50_ = FALSE;
	ValaSymbol* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp96_ = FALSE;
	ValaSymbol* _tmp97_;
	gboolean _tmp98_;
	gboolean _tmp99_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_result_ = FALSE;
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_symbol_get_external_package (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_version_attribute_get_deprecated (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* package_version = NULL;
		ValaSymbol* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFile* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp6_ = self->priv->symbol;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_source_reference_get_file (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_file_get_installed_version (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		package_version = _tmp13_;
		_tmp15_ = vala_code_context_get_deprecated (context);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			_tmp19_ = package_version;
			if (_tmp19_ == NULL) {
				_tmp18_ = TRUE;
			} else {
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = vala_version_attribute_get_deprecated_since (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp18_ = _tmp22_ == NULL;
				_g_free0 (_tmp22_);
			}
			if (_tmp18_) {
				_tmp17_ = TRUE;
			} else {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = package_version;
				_tmp24_ = vala_version_attribute_get_deprecated_since (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_;
				_tmp17_ = vala_version_attribute_cmp_versions (_tmp23_, _tmp26_) >= 0;
				_g_free0 (_tmp26_);
			}
			_tmp14_ = _tmp17_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_;
			ValaSymbol* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp28_ = vala_version_attribute_get_deprecated_since (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_ == NULL;
			_g_free0 (_tmp30_);
			if (_tmp31_) {
				gchar* _tmp32_;
				_tmp32_ = g_strdup ("is deprecated");
				_g_free0 (_tmp27_);
				_tmp27_ = _tmp32_;
			} else {
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp33_ = vala_version_attribute_get_deprecated_since (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup_printf ("has been deprecated since %s", _tmp35_);
				_g_free0 (_tmp27_);
				_tmp27_ = _tmp36_;
				_g_free0 (_tmp35_);
			}
			_tmp38_ = vala_version_attribute_get_replacement (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp40_ == NULL;
			_g_free0 (_tmp40_);
			if (_tmp41_) {
				gchar* _tmp42_;
				_tmp42_ = g_strdup ("");
				_g_free0 (_tmp37_);
				_tmp37_ = _tmp42_;
			} else {
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp43_ = vala_version_attribute_get_replacement (self);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup_printf (". Use %s", _tmp45_);
				_g_free0 (_tmp37_);
				_tmp37_ = _tmp46_;
				_g_free0 (_tmp45_);
			}
			_tmp47_ = self->priv->symbol;
			_tmp48_ = vala_symbol_get_full_name (_tmp47_);
			_tmp49_ = _tmp48_;
			vala_report_deprecated (source_ref, "`%s' %s%s", _tmp49_, _tmp27_, _tmp37_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp27_);
		}
		_result_ = TRUE;
		_g_free0 (package_version);
	}
	_tmp51_ = self->priv->symbol;
	_tmp52_ = vala_symbol_get_external_package (_tmp51_);
	_tmp53_ = _tmp52_;
	if (_tmp53_) {
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp54_ = vala_version_attribute_get_since (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = _tmp55_;
		_tmp50_ = _tmp56_ != NULL;
		_g_free0 (_tmp56_);
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		gchar* package_version = NULL;
		ValaSymbol* _tmp57_;
		ValaSourceReference* _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaSourceFile* _tmp60_;
		ValaSourceFile* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_;
		gboolean _tmp68_;
		_tmp57_ = self->priv->symbol;
		_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_source_reference_get_file (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_source_file_get_installed_version (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strdup (_tmp63_);
		package_version = _tmp64_;
		_tmp67_ = vala_code_context_get_since_check (context);
		_tmp68_ = _tmp67_;
		if (_tmp68_) {
			const gchar* _tmp69_;
			_tmp69_ = package_version;
			_tmp66_ = _tmp69_ != NULL;
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			const gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			_tmp70_ = package_version;
			_tmp71_ = vala_version_attribute_get_since (self);
			_tmp72_ = _tmp71_;
			_tmp73_ = _tmp72_;
			_tmp65_ = vala_version_attribute_cmp_versions (_tmp70_, _tmp73_) < 0;
			_g_free0 (_tmp73_);
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			const gchar* filename = NULL;
			ValaSymbol* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceFile* _tmp77_;
			ValaSourceFile* _tmp78_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* pkg = NULL;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			ValaSymbol* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			const gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			_tmp74_ = self->priv->symbol;
			_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_source_reference_get_file (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = vala_source_file_get_filename (_tmp78_);
			_tmp80_ = _tmp79_;
			filename = _tmp80_;
			_tmp81_ = filename;
			_tmp82_ = filename;
			_tmp83_ = string_slice (_tmp81_, (glong) 0, (glong) string_last_index_of_char (_tmp82_, (gunichar) '.', 0));
			_tmp84_ = _tmp83_;
			_tmp85_ = g_path_get_basename (_tmp84_);
			_tmp86_ = _tmp85_;
			_g_free0 (_tmp84_);
			pkg = _tmp86_;
			_tmp87_ = self->priv->symbol;
			_tmp88_ = vala_symbol_get_full_name (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = pkg;
			_tmp91_ = package_version;
			_tmp92_ = pkg;
			_tmp93_ = vala_version_attribute_get_since (self);
			_tmp94_ = _tmp93_;
			_tmp95_ = _tmp94_;
			vala_report_error (source_ref, "`%s' is not available in %s %s. Use %s >= %s", _tmp89_, _tmp90_, _tmp91_, _tmp92_, _tmp95_);
			_g_free0 (_tmp95_);
			_g_free0 (_tmp89_);
			_g_free0 (pkg);
		}
		_result_ = TRUE;
		_g_free0 (package_version);
	}
	_tmp97_ = self->priv->symbol;
	_tmp98_ = vala_symbol_get_external_package (_tmp97_);
	_tmp99_ = _tmp98_;
	if (_tmp99_) {
		gboolean _tmp100_;
		gboolean _tmp101_;
		_tmp100_ = vala_version_attribute_get_experimental (self);
		_tmp101_ = _tmp100_;
		_tmp96_ = _tmp101_;
	} else {
		_tmp96_ = FALSE;
	}
	if (_tmp96_) {
		gboolean _tmp102_;
		gboolean _tmp103_;
		_tmp102_ = vala_code_context_get_experimental (context);
		_tmp103_ = _tmp102_;
		if (!_tmp103_) {
			gchar* package_version = NULL;
			ValaSymbol* _tmp104_;
			ValaSourceReference* _tmp105_;
			ValaSourceReference* _tmp106_;
			ValaSourceFile* _tmp107_;
			ValaSourceFile* _tmp108_;
			const gchar* _tmp109_;
			const gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* experimental_until = NULL;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gboolean _tmp114_ = FALSE;
			gboolean _tmp115_ = FALSE;
			const gchar* _tmp116_;
			_tmp104_ = self->priv->symbol;
			_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_source_reference_get_file (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_source_file_get_installed_version (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp111_ = g_strdup (_tmp110_);
			package_version = _tmp111_;
			_tmp112_ = vala_version_attribute_get_experimental_until (self);
			_tmp113_ = _tmp112_;
			experimental_until = _tmp113_;
			_tmp116_ = experimental_until;
			if (_tmp116_ == NULL) {
				_tmp115_ = TRUE;
			} else {
				const gchar* _tmp117_;
				_tmp117_ = package_version;
				_tmp115_ = _tmp117_ == NULL;
			}
			if (_tmp115_) {
				_tmp114_ = TRUE;
			} else {
				const gchar* _tmp118_;
				const gchar* _tmp119_;
				_tmp118_ = package_version;
				_tmp119_ = experimental_until;
				_tmp114_ = vala_version_attribute_cmp_versions (_tmp118_, _tmp119_) < 0;
			}
			if (_tmp114_) {
				gchar* _tmp120_ = NULL;
				const gchar* _tmp121_;
				ValaSymbol* _tmp125_;
				gchar* _tmp126_;
				gchar* _tmp127_;
				_tmp121_ = experimental_until;
				if (_tmp121_ != NULL) {
					const gchar* _tmp122_;
					gchar* _tmp123_;
					_tmp122_ = experimental_until;
					_tmp123_ = g_strdup_printf (" until %s", _tmp122_);
					_g_free0 (_tmp120_);
					_tmp120_ = _tmp123_;
				} else {
					gchar* _tmp124_;
					_tmp124_ = g_strdup ("");
					_g_free0 (_tmp120_);
					_tmp120_ = _tmp124_;
				}
				_tmp125_ = self->priv->symbol;
				_tmp126_ = vala_symbol_get_full_name (_tmp125_);
				_tmp127_ = _tmp126_;
				vala_report_experimental (source_ref, "`%s' is experimental%s", _tmp127_, _tmp120_);
				_g_free0 (_tmp127_);
				_g_free0 (_tmp120_);
			}
			_g_free0 (experimental_until);
			_g_free0 (package_version);
		}
		_result_ = TRUE;
	}
	result = _result_;
	return result;
}

/**
 * A simple version comparison function.
 *
 * @param v1str a version number
 * @param v2str a version number
 * @return an integer less than, equal to, or greater than zero, if v1str is <, == or > than v2str
 * @see GLib.CompareFunc
 */
gint
vala_version_attribute_cmp_versions (const gchar* v1str,
                                     const gchar* v2str)
{
	gchar** v1arr = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint v1arr_length1;
	gint _v1arr_size_;
	gchar** v2arr = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint v2arr_length1;
	gint _v2arr_size_;
	gint i = 0;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gboolean _tmp20_ = FALSE;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gint result = 0;
	g_return_val_if_fail (v1str != NULL, 0);
	g_return_val_if_fail (v2str != NULL, 0);
	_tmp1_ = _tmp0_ = g_strsplit (v1str, ".", 0);
	v1arr = _tmp1_;
	v1arr_length1 = _vala_array_length (_tmp0_);
	_v1arr_size_ = v1arr_length1;
	_tmp3_ = _tmp2_ = g_strsplit (v2str, ".", 0);
	v2arr = _tmp3_;
	v2arr_length1 = _vala_array_length (_tmp2_);
	_v2arr_size_ = v2arr_length1;
	i = 0;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint v1num = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint v2num = 0;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		_tmp5_ = v1arr;
		_tmp5__length1 = v1arr_length1;
		_tmp6_ = _tmp5_[i];
		if (_tmp6_ != NULL) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = v2arr;
			_tmp7__length1 = v2arr_length1;
			_tmp8_ = _tmp7_[i];
			_tmp4_ = _tmp8_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp9_ = v1arr;
		_tmp9__length1 = v1arr_length1;
		_tmp10_ = _tmp9_[i];
		v1num = atoi (_tmp10_);
		_tmp11_ = v2arr;
		_tmp11__length1 = v2arr_length1;
		_tmp12_ = _tmp11_[i];
		v2num = atoi (_tmp12_);
		if (v1num < 0) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = v2num < 0;
		}
		if (_tmp13_) {
			result = 0;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		if (v1num > v2num) {
			result = 1;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		if (v1num < v2num) {
			result = -1;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp14_ = i;
		i = _tmp14_ + 1;
	}
	_tmp16_ = v1arr;
	_tmp16__length1 = v1arr_length1;
	_tmp17_ = _tmp16_[i];
	if (_tmp17_ != NULL) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp19_;
		_tmp18_ = v2arr;
		_tmp18__length1 = v2arr_length1;
		_tmp19_ = _tmp18_[i];
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		result = 1;
		v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
		v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp21_ = v1arr;
	_tmp21__length1 = v1arr_length1;
	_tmp22_ = _tmp21_[i];
	if (_tmp22_ == NULL) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		_tmp23_ = v2arr;
		_tmp23__length1 = v2arr_length1;
		_tmp24_ = _tmp23_[i];
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		result = -1;
		v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
		v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = 0;
	v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
	v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_value_version_attribute_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_version_attribute_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_version_attribute_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_version_attribute_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_version_attribute_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_version_attribute_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_version_attribute_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVersionAttribute * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_version_attribute_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_version_attribute_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	ValaVersionAttribute ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_version_attribute_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_version_attribute (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ValaParamSpecVersionAttribute* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VERSION_ATTRIBUTE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_version_attribute (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_version_attribute (GValue* value,
                                  gpointer v_object)
{
	ValaVersionAttribute * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VERSION_ATTRIBUTE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_version_attribute_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_version_attribute_unref (old);
	}
}

void
vala_value_take_version_attribute (GValue* value,
                                   gpointer v_object)
{
	ValaVersionAttribute * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VERSION_ATTRIBUTE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_version_attribute_unref (old);
	}
}

static void
vala_version_attribute_class_init (ValaVersionAttributeClass * klass,
                                   gpointer klass_data)
{
	vala_version_attribute_parent_class = g_type_class_peek_parent (klass);
	((ValaVersionAttributeClass *) klass)->finalize = vala_version_attribute_finalize;
	g_type_class_adjust_private_offset (klass, &ValaVersionAttribute_private_offset);
}

static void
vala_version_attribute_instance_init (ValaVersionAttribute * self,
                                      gpointer klass)
{
	self->priv = vala_version_attribute_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_version_attribute_finalize (ValaVersionAttribute * obj)
{
	ValaVersionAttribute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttribute);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_deprecated);
	_g_free0 (self->priv->_experimental);
}

/**
 * Represents a [Version] attribute
 */
static GType
vala_version_attribute_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_version_attribute_init, vala_value_version_attribute_free_value, vala_value_version_attribute_copy_value, vala_value_version_attribute_peek_pointer, "p", vala_value_version_attribute_collect_value, "p", vala_value_version_attribute_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaVersionAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_version_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVersionAttribute), 0, (GInstanceInitFunc) vala_version_attribute_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_version_attribute_type_id;
	vala_version_attribute_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVersionAttribute", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaVersionAttribute_private_offset = g_type_add_instance_private (vala_version_attribute_type_id, sizeof (ValaVersionAttributePrivate));
	return vala_version_attribute_type_id;
}

GType
vala_version_attribute_get_type (void)
{
	static volatile gsize vala_version_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&vala_version_attribute_type_id__volatile)) {
		GType vala_version_attribute_type_id;
		vala_version_attribute_type_id = vala_version_attribute_get_type_once ();
		g_once_init_leave (&vala_version_attribute_type_id__volatile, vala_version_attribute_type_id);
	}
	return vala_version_attribute_type_id__volatile;
}

gpointer
vala_version_attribute_ref (gpointer instance)
{
	ValaVersionAttribute * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_version_attribute_unref (gpointer instance)
{
	ValaVersionAttribute * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VERSION_ATTRIBUTE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

