"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable brace-style */
const settings = __importStar(require("../util/settings"));
// @ts-ignore
const zigbee_herdsman_converters_1 = __importDefault(require("zigbee-herdsman-converters"));
class Device {
    constructor(device) {
        this.device = device;
    }
    get endpoints() { return this.device.endpoints; }
    get zhDevice() { return this.device; }
    get ieeeAddr() { return this.device.ieeeAddr; }
    get ID() { return this.device.ieeeAddr; }
    get settings() { return { ...settings.get().device_options, ...settings.getDevice(this.ieeeAddr) }; }
    get name() {
        var _a;
        return this.type === 'Coordinator' ? 'Coordinator' : ((_a = this.settings) === null || _a === void 0 ? void 0 : _a.friendlyName) || this.ieeeAddr;
    }
    get lastSeen() { return this.device.lastSeen; }
    get modelID() { return this.device.modelID; }
    get softwareBuildID() { return this.device.softwareBuildID; }
    get dateCode() { return this.device.dateCode; }
    get interviewCompleted() { return this.device.interviewCompleted; }
    get networkAddress() { return this.device.networkAddress; }
    get manufacturerName() { return this.device.manufacturerName; }
    get interviewing() { return this.device.interviewing; }
    get type() { return this.device.type; }
    get powerSource() { return this.device.powerSource; }
    get definition() {
        if (!this._definition && !this.device.interviewing) {
            this._definition = zigbee_herdsman_converters_1.default.findByDevice(this.device);
        }
        return this._definition;
    }
    async ping(disableRecovery) { await this.device.ping(disableRecovery); }
    async removeFromNetwork() { await this.device.removeFromNetwork(); }
    endpoint(key) {
        var _a, _b, _c;
        let endpoint;
        if (key == null)
            key = 'default';
        if (!isNaN(Number(key))) {
            endpoint = this.device.getEndpoint(Number(key));
        }
        else if ((_a = this.definition) === null || _a === void 0 ? void 0 : _a.endpoint) {
            const ID = (_c = (_b = this.definition) === null || _b === void 0 ? void 0 : _b.endpoint) === null || _c === void 0 ? void 0 : _c.call(_b, this.device)[key];
            if (ID)
                endpoint = this.device.getEndpoint(ID);
            else if (key === 'default')
                endpoint = this.device.endpoints[0];
            else
                return null;
        }
        else {
            /* istanbul ignore next */
            if (key !== 'default')
                return null;
            endpoint = this.device.endpoints[0];
        }
        return endpoint;
    }
    isXiaomiDevice() {
        const xiaomiManufacturerID = [4151, 4447];
        /* istanbul ignore next */
        return this.zhDevice.modelID !== 'lumi.router' && xiaomiManufacturerID.includes(this.zhDevice.manufacturerID) &&
            (!this.zhDevice.manufacturerName || !this.zhDevice.manufacturerName.startsWith('Trust'));
    }
    isRouter() { return this.zhDevice.type === 'Router'; }
    lqi() { return this.zhDevice.lqi(); }
    routingTable() { return this.zhDevice.routingTable(); }
}
exports.default = Device;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGV2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vbGliL21vZGVsL2RldmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxnQ0FBZ0M7QUFDaEMsMkRBQTZDO0FBQzdDLGFBQWE7QUFDYiw0RkFBNkM7QUFFN0MsTUFBcUIsTUFBTTtJQTRCdkIsWUFBWSxNQUFnQjtRQUN4QixJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztJQUN6QixDQUFDO0lBMUJELElBQUksU0FBUyxLQUFrQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUEsQ0FBQztJQUM3RCxJQUFJLFFBQVEsS0FBYyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQSxDQUFDO0lBQzlDLElBQUksUUFBUSxLQUFZLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQSxDQUFDO0lBQ3JELElBQUksRUFBRSxLQUFZLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQSxDQUFDO0lBQy9DLElBQUksUUFBUSxLQUFvQixPQUFPLEVBQUMsR0FBRyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsY0FBYyxFQUFFLEdBQUcsUUFBUSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUMsQ0FBQyxDQUFBLENBQUM7SUFDakgsSUFBSSxJQUFJOztRQUNKLE9BQU8sSUFBSSxDQUFDLElBQUksS0FBSyxhQUFhLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQSxNQUFBLElBQUksQ0FBQyxRQUFRLDBDQUFFLFlBQVksS0FBSSxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQUEsQ0FBQztJQUN2RyxJQUFJLFFBQVEsS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUEsQ0FBQztJQUNyRCxJQUFJLE9BQU8sS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUEsQ0FBQztJQUNuRCxJQUFJLGVBQWUsS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUEsQ0FBQztJQUNuRSxJQUFJLFFBQVEsS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUEsQ0FBQztJQUNyRCxJQUFJLGtCQUFrQixLQUFhLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFBLENBQUM7SUFDMUUsSUFBSSxjQUFjLEtBQVksT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxDQUFBLENBQUM7SUFDakUsSUFBSSxnQkFBZ0IsS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsQ0FBQSxDQUFDO0lBQ3JFLElBQUksWUFBWSxLQUFhLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQSxDQUFDO0lBQzlELElBQUksSUFBSSxLQUF1RSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUEsQ0FBQztJQUN4RyxJQUFJLFdBQVcsS0FBWSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLENBQUEsQ0FBQztJQUMzRCxJQUFJLFVBQVU7UUFDVixJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFO1lBQ2hELElBQUksQ0FBQyxXQUFXLEdBQUcsb0NBQUcsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3BEO1FBQ0QsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzVCLENBQUM7SUFNRCxLQUFLLENBQUMsSUFBSSxDQUFDLGVBQXdCLElBQWtCLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQSxDQUFDO0lBQzlGLEtBQUssQ0FBQyxpQkFBaUIsS0FBbUIsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLGlCQUFpQixFQUFFLENBQUMsQ0FBQSxDQUFDO0lBRWpGLFFBQVEsQ0FBQyxHQUFZOztRQUNqQixJQUFJLFFBQW9CLENBQUM7UUFDekIsSUFBSSxHQUFHLElBQUksSUFBSTtZQUFFLEdBQUcsR0FBRyxTQUFTLENBQUM7UUFFakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRTtZQUNyQixRQUFRLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7U0FDbkQ7YUFBTSxJQUFJLE1BQUEsSUFBSSxDQUFDLFVBQVUsMENBQUUsUUFBUSxFQUFFO1lBQ2xDLE1BQU0sRUFBRSxHQUFHLE1BQUEsTUFBQSxJQUFJLENBQUMsVUFBVSwwQ0FBRSxRQUFRLG1EQUFHLElBQUksQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUM7WUFDekQsSUFBSSxFQUFFO2dCQUFFLFFBQVEsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUMsQ0FBQztpQkFDMUMsSUFBSSxHQUFHLEtBQUssU0FBUztnQkFBRSxRQUFRLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7O2dCQUMzRCxPQUFPLElBQUksQ0FBQztTQUNwQjthQUFNO1lBQ0gsMEJBQTBCO1lBQzFCLElBQUksR0FBRyxLQUFLLFNBQVM7Z0JBQUUsT0FBTyxJQUFJLENBQUM7WUFDbkMsUUFBUSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3ZDO1FBRUQsT0FBTyxRQUFRLENBQUM7SUFDcEIsQ0FBQztJQUVELGNBQWM7UUFDVixNQUFNLG9CQUFvQixHQUFHLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzFDLDBCQUEwQjtRQUMxQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxLQUFLLGFBQWEsSUFBSSxvQkFBb0IsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUM7WUFDekcsQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLENBQUM7SUFFRCxRQUFRLEtBQWEsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksS0FBSyxRQUFRLENBQUMsQ0FBQSxDQUFDO0lBQzdELEdBQUcsS0FBa0IsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUEsQ0FBQztJQUNqRCxZQUFZLEtBQTJCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFBLENBQUM7Q0FDL0U7QUFqRUQseUJBaUVDIn0=