"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineNIF = void 0;
const cc_1 = require("@zwave-js/cc");
const safe_1 = require("@zwave-js/core/safe");
function determineNIF() {
    const basicDeviceClass = 0x02; // Static Controller
    const genericDeviceClass = 0x02; // Static Controller
    const specificDeviceClass = 0x07; // Gateway
    const implementedCCs = safe_1.allCCs.filter((cc) => (0, cc_1.getImplementedVersion)(cc) > 0);
    // Encapsulation CCs are always supported
    const implementedEncapsulationCCs = safe_1.encapsulationCCs.filter((cc) => implementedCCs.includes(cc) &&
        // A node MUST advertise support for Multi Channel Command Class only if it implements End Points.
        // A node able to communicate using the Multi Channel encapsulation but implementing no End Point
        // MUST NOT advertise support for the Multi Channel Command Class.
        // --> We do not implement end points
        cc !== safe_1.CommandClasses["Multi Channel"]);
    // The supported CCs are mostly determined by the Z-Wave+ v2 device type specification
    const supportedCCs = new Set([
        // Z-Wave Plus Info must be listed first
        safe_1.CommandClasses["Z-Wave Plus Info"],
        // Mandatory CCs for Z-Wave Plus v2 devices:
        // Association SHOULD be within the first 6 entries
        safe_1.CommandClasses.Association,
        safe_1.CommandClasses["Association Group Information"],
        safe_1.CommandClasses["Device Reset Locally"],
        safe_1.CommandClasses["Firmware Update Meta Data"],
        safe_1.CommandClasses.Indicator,
        safe_1.CommandClasses["Manufacturer Specific"],
        safe_1.CommandClasses["Multi Channel Association"],
        safe_1.CommandClasses.Powerlevel,
        safe_1.CommandClasses.Version,
        // Gateway device type MUST support Inclusion Controller and Time CC
        safe_1.CommandClasses["Inclusion Controller"],
        safe_1.CommandClasses.Time,
        ...implementedEncapsulationCCs,
    ]);
    // CC:0000.00.00.12.004: It is NOT RECOMMENDED to advertise controlled Command Classes.
    return {
        basicDeviceClass,
        genericDeviceClass,
        specificDeviceClass,
        supportedCCs: [...supportedCCs],
        controlledCCs: [],
    };
}
exports.determineNIF = determineNIF;
//# sourceMappingURL=NodeInformationFrame.js.map