"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.behaviors = void 0;
const WindowCoveringCC_1 = require("@zwave-js/cc/WindowCoveringCC");
const safe_1 = require("@zwave-js/core/safe");
const testing_1 = require("@zwave-js/testing");
const defaultCapabilities = {
    supportedParameters: [],
};
const respondToWindowCoveringSupportedGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof WindowCoveringCC_1.WindowCoveringCCSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(safe_1.CommandClasses["Window Covering"], frame.payload.endpointIndex),
            };
            const cc = new WindowCoveringCC_1.WindowCoveringCCSupportedReport(self.host, {
                nodeId: controller.host.ownNodeId,
                supportedParameters: capabilities.supportedParameters,
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
        return false;
    },
};
exports.behaviors = [respondToWindowCoveringSupportedGet];
//# sourceMappingURL=WindowCovering.js.map