"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDefaultBehaviors = void 0;
const cc_1 = require("@zwave-js/cc");
const ZWavePlusCC_1 = require("@zwave-js/cc/ZWavePlusCC");
const ZWaveProtocolCC_1 = require("@zwave-js/cc/ZWaveProtocolCC");
const testing_1 = require("@zwave-js/testing");
const respondToRequestNodeInfo = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof ZWaveProtocolCC_1.ZWaveProtocolCCRequestNodeInformationFrame) {
            const cc = new ZWaveProtocolCC_1.ZWaveProtocolCCNodeInformationFrame(self.host, {
                nodeId: self.id,
                ...self.capabilities,
                supportedCCs: [...self.implementedCCs]
                    .filter(([, info]) => info.isSupported)
                    .map(([ccId]) => ccId),
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
    },
};
const respondToZWavePlusCCGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof ZWavePlusCC_1.ZWavePlusCCGet) {
            const cc = new ZWavePlusCC_1.ZWavePlusCCReport(self.host, {
                nodeId: controller.host.ownNodeId,
                zwavePlusVersion: 2,
                nodeType: cc_1.ZWavePlusNodeType.Node,
                roleType: self.capabilities.isListening
                    ? cc_1.ZWavePlusRoleType.AlwaysOnSlave
                    : self.capabilities.isFrequentListening
                        ? cc_1.ZWavePlusRoleType.SleepingListeningSlave
                        : cc_1.ZWavePlusRoleType.SleepingReportingSlave,
                installerIcon: 0x0000,
                userIcon: 0x0000,
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: true,
            }));
            return true;
        }
    },
};
// TODO: We should handle this more generically:
const respondToS0ZWavePlusCCGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof cc_1.SecurityCCCommandEncapsulation &&
            frame.payload.encapsulated instanceof ZWavePlusCC_1.ZWavePlusCCGet) {
            let cc = new ZWavePlusCC_1.ZWavePlusCCReport(self.host, {
                nodeId: controller.host.ownNodeId,
                zwavePlusVersion: 2,
                nodeType: cc_1.ZWavePlusNodeType.Node,
                roleType: self.capabilities.isListening
                    ? cc_1.ZWavePlusRoleType.AlwaysOnSlave
                    : self.capabilities.isFrequentListening
                        ? cc_1.ZWavePlusRoleType.SleepingListeningSlave
                        : cc_1.ZWavePlusRoleType.SleepingReportingSlave,
                installerIcon: 0x0000,
                userIcon: 0x0000,
            });
            cc = cc_1.SecurityCC.encapsulate(self.host, cc);
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: true,
            }));
            return true;
        }
    },
};
const respondToS2ZWavePlusCCGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof cc_1.Security2CCMessageEncapsulation &&
            frame.payload.encapsulated instanceof ZWavePlusCC_1.ZWavePlusCCGet) {
            let cc = new ZWavePlusCC_1.ZWavePlusCCReport(self.host, {
                nodeId: controller.host.ownNodeId,
                zwavePlusVersion: 2,
                nodeType: cc_1.ZWavePlusNodeType.Node,
                roleType: self.capabilities.isListening
                    ? cc_1.ZWavePlusRoleType.AlwaysOnSlave
                    : self.capabilities.isFrequentListening
                        ? cc_1.ZWavePlusRoleType.SleepingListeningSlave
                        : cc_1.ZWavePlusRoleType.SleepingReportingSlave,
                installerIcon: 0x0000,
                userIcon: 0x0000,
            });
            cc = cc_1.Security2CC.encapsulate(self.host, cc);
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: true,
            }));
            return true;
        }
    },
};
/** Predefined default behaviors that are required for interacting with the Mock Controller correctly */
function createDefaultBehaviors() {
    return [
        respondToRequestNodeInfo,
        respondToZWavePlusCCGet,
        respondToS0ZWavePlusCCGet,
        respondToS2ZWavePlusCCGet,
    ];
}
exports.createDefaultBehaviors = createDefaultBehaviors;
//# sourceMappingURL=MockNodeBehaviors.js.map