/// <reference types="node" />
import { ZWaveDataRate, type MessageOrCCLogEntry } from "@zwave-js/core";
import type { ZWaveHost } from "@zwave-js/host";
import { Message, type MessageBaseOptions, type MessageDeserializationOptions, type SuccessIndicator } from "@zwave-js/serial";
import { type AllOrNone } from "@zwave-js/shared";
export type SetPriorityRouteRequestOptions = {
    destinationNodeId: number;
} & AllOrNone<{
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
}>;
export declare class SetPriorityRouteRequest extends Message {
    constructor(host: ZWaveHost, options: MessageDeserializationOptions | (MessageBaseOptions & SetPriorityRouteRequestOptions));
    destinationNodeId: number;
    repeaters: number[] | undefined;
    routeSpeed: ZWaveDataRate | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SetPriorityRouteResponse extends Message implements SuccessIndicator {
    constructor(host: ZWaveHost, options: MessageDeserializationOptions);
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SetPriorityRouteMessages.d.ts.map