import { type MockControllerBehavior, type MockControllerOptions, type MockNodeBehavior, type MockNodeOptions } from "@zwave-js/testing";
export type MockServerControllerOptions = Pick<MockControllerOptions, "ownNodeId" | "homeId" | "capabilities"> & {
    behaviors?: MockControllerBehavior[];
};
export type MockServerNodeOptions = Pick<MockNodeOptions, "id" | "capabilities"> & {
    behaviors?: MockNodeBehavior[];
};
export interface MockServerOptions {
    interface?: string;
    port?: number;
    config?: {
        controller?: MockServerControllerOptions;
        nodes?: MockServerNodeOptions[];
    };
}
export declare class MockServer {
    private options;
    constructor(options?: MockServerOptions);
    private serialport;
    private binding;
    private server;
    start(): Promise<void>;
    stop(): Promise<void>;
}
//# sourceMappingURL=mockServer.d.ts.map