/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;

public abstract class AnnotationsDirectory {
    public static final AnnotationsDirectory EMPTY = new AnnotationsDirectory(){

        @Override
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        public AnnotationIterator getFieldAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        public AnnotationIterator getMethodAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        public AnnotationIterator getParameterAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }
    };

    public abstract Set<? extends DexBackedAnnotation> getClassAnnotations();

    public abstract AnnotationIterator getFieldAnnotationIterator();

    public abstract AnnotationIterator getMethodAnnotationIterator();

    public abstract AnnotationIterator getParameterAnnotationIterator();

    public static AnnotationsDirectory newOrEmpty(DexBackedDexFile dexFile, int directoryAnnotationsOffset) {
        if (directoryAnnotationsOffset == 0) {
            return EMPTY;
        }
        return new AnnotationsDirectoryImpl(dexFile, directoryAnnotationsOffset);
    }

    public static Set<? extends DexBackedAnnotation> getAnnotations(final DexBackedDexFile dexFile, final int annotationSetOffset) {
        if (annotationSetOffset != 0) {
            final int size = dexFile.getDataBuffer().readSmallUint(annotationSetOffset);
            return new FixedSizeSet<DexBackedAnnotation>(){

                @Override
                public DexBackedAnnotation readItem(int index) {
                    int annotationOffset = dexFile.getDataBuffer().readSmallUint(annotationSetOffset + 4 + 4 * index);
                    return new DexBackedAnnotation(dexFile, annotationOffset);
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
        return ImmutableSet.of();
    }

    public static List<Set<? extends DexBackedAnnotation>> getParameterAnnotations(final DexBackedDexFile dexFile, final int annotationSetListOffset) {
        if (annotationSetListOffset > 0) {
            final int size = dexFile.getDataBuffer().readSmallUint(annotationSetListOffset);
            return new FixedSizeList<Set<? extends DexBackedAnnotation>>(){

                @Override
                public Set<? extends DexBackedAnnotation> readItem(int index) {
                    int annotationSetOffset = dexFile.getDataBuffer().readSmallUint(annotationSetListOffset + 4 + index * 4);
                    return AnnotationsDirectory.getAnnotations(dexFile, annotationSetOffset);
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
        return ImmutableList.of();
    }

    private static class AnnotationsDirectoryImpl
    extends AnnotationsDirectory {
        public final DexBackedDexFile dexFile;
        private final int directoryOffset;

        public AnnotationsDirectoryImpl(DexBackedDexFile dexFile, int directoryOffset) {
            this.dexFile = dexFile;
            this.directoryOffset = directoryOffset;
        }

        public int getFieldAnnotationCount() {
            return this.dexFile.getDataBuffer().readSmallUint(this.directoryOffset + 4);
        }

        public int getMethodAnnotationCount() {
            return this.dexFile.getDataBuffer().readSmallUint(this.directoryOffset + 8);
        }

        public int getParameterAnnotationCount() {
            return this.dexFile.getDataBuffer().readSmallUint(this.directoryOffset + 12);
        }

        @Override
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return AnnotationsDirectoryImpl.getAnnotations(this.dexFile, this.dexFile.getDataBuffer().readSmallUint(this.directoryOffset));
        }

        @Override
        public AnnotationIterator getFieldAnnotationIterator() {
            int fieldAnnotationCount = this.getFieldAnnotationCount();
            if (fieldAnnotationCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            return new AnnotationIteratorImpl(this.directoryOffset + 16, fieldAnnotationCount);
        }

        @Override
        public AnnotationIterator getMethodAnnotationIterator() {
            int methodCount = this.getMethodAnnotationCount();
            if (methodCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8;
            return new AnnotationIteratorImpl(methodAnnotationsOffset, methodCount);
        }

        @Override
        public AnnotationIterator getParameterAnnotationIterator() {
            int parameterAnnotationCount = this.getParameterAnnotationCount();
            if (parameterAnnotationCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodCount = this.getMethodAnnotationCount();
            int parameterAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8 + methodCount * 8;
            return new AnnotationIteratorImpl(parameterAnnotationsOffset, parameterAnnotationCount);
        }

        private class AnnotationIteratorImpl
        implements AnnotationIterator {
            private final int startOffset;
            private final int size;
            private int currentIndex;
            private int currentItemIndex;

            public AnnotationIteratorImpl(int startOffset, int size) {
                this.startOffset = startOffset;
                this.size = size;
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.getDataBuffer().readSmallUint(startOffset);
                this.currentIndex = 0;
            }

            @Override
            public int seekTo(int itemIndex) {
                while (this.currentItemIndex < itemIndex && this.currentIndex + 1 < this.size) {
                    ++this.currentIndex;
                    this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.getDataBuffer().readSmallUint(this.startOffset + this.currentIndex * 8);
                }
                if (this.currentItemIndex == itemIndex) {
                    return AnnotationsDirectoryImpl.this.dexFile.getDataBuffer().readSmallUint(this.startOffset + this.currentIndex * 8 + 4);
                }
                return 0;
            }
        }
    }

    public static interface AnnotationIterator {
        public static final AnnotationIterator EMPTY = new AnnotationIterator(){

            @Override
            public int seekTo(int key) {
                return 0;
            }
        };

        public int seekTo(int var1);
    }
}

