/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Map;

/** The response class of {@link android.app.appsearch.AppSearchSession#getSchema AppSearchSession#getSchema} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetSchemaResponse {

GetSchemaResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns the overall database schema version.
 *
 * <p>If the database is empty, 0 will be returned.

 * @return Value is 0 or greater
 */

public int getVersion() { throw new RuntimeException("Stub!"); }

/**
 * Return the schemas most recently successfully provided to {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema}.
 *
 * <p>It is inefficient to call this method repeatedly.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.app.appsearch.AppSearchSchema> getSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns all the schema types that are opted out of being displayed and visible on any system
 * UI surface.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getSchemaTypesNotDisplayedBySystem() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of schema types to the set of packages that have access to that schema
 * type.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<android.app.appsearch.PackageIdentifier>> getSchemaTypesVisibleToPackages() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of schema types to the Map of {@link android.Manifest.permission}
 * combinations that querier must hold to access that schema type.
 *
 * <p>The querier could read the {@link android.app.appsearch.GenericDocument GenericDocument} objects under the {@code schemaType} if
 * they holds ALL required permissions of ANY of the individual value sets.
 *
 * <p>For example, if the Map contains {@code {% verbatim %}{{permissionA, PermissionB}, {
 * PermissionC, PermissionD}, {PermissionE}}{% endverbatim %}}.
 *
 * <ul>
 *   <li>A querier holds both PermissionA and PermissionB has access.
 *   <li>A querier holds both PermissionC and PermissionD has access.
 *   <li>A querier holds only PermissionE has access.
 *   <li>A querier holds both PermissionA and PermissionE has access.
 *   <li>A querier holds only PermissionA doesn't have access.
 *   <li>A querier holds both PermissionA and PermissionC doesn't have access.
 * </ul>
 *
 * @return The map contains schema type and all combinations of required permission for querier
 *     to access it. The supported Permission are {@link android.app.appsearch.SetSchemaRequest#READ_SMS SetSchemaRequest#READ_SMS}, {@link android.app.appsearch.SetSchemaRequest#READ_CALENDAR      }, {@link android.app.appsearch.SetSchemaRequest#READ_CONTACTS SetSchemaRequest#READ_CONTACTS}, {@link android.app.appsearch.SetSchemaRequest#READ_EXTERNAL_STORAGE      }, {@link android.app.appsearch.SetSchemaRequest#READ_HOME_APP_SEARCH_DATA      } and {@link android.app.appsearch.SetSchemaRequest#READ_ASSISTANT_APP_SEARCH_DATA      }.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<java.util.Set<java.lang.Integer>>> getRequiredPermissionsForSchemaTypeVisibility() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Create a {@link android.app.appsearch.GetSchemaResponse.Builder Builder} object} */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the database overall schema version.
 *
 * <p>Default version is 0
 
 * @param version Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setVersion(int version) { throw new RuntimeException("Stub!"); }

/**
 * Adds one {@link android.app.appsearch.AppSearchSchema AppSearchSchema} to the schema list.
 * @param schema This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder addSchema(@android.annotation.NonNull android.app.appsearch.AppSearchSchema schema) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether or not documents from the provided {@code schemaType} will be displayed and
 * visible on any system UI surface.
 *
 * @param schemaType The name of an {@link android.app.appsearch.AppSearchSchema AppSearchSchema} within the same {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse}, which won't be displayed by system.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder addSchemaTypeNotDisplayedBySystem(@android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether or not documents from the provided {@code schemaType} can be read by the
 * specified package.
 *
 * <p>Each package is represented by a {@link android.app.appsearch.PackageIdentifier PackageIdentifier}, containing a package name
 * and a byte array of type {@link android.content.pm.PackageManager#CERT_INPUT_SHA256}.
 *
 * <p>To opt into one-way data sharing with another application, the developer will need to
 * explicitly grant the other application’s package name and certificate Read access to its
 * data.
 *
 * <p>For two-way data sharing, both applications need to explicitly grant Read access to
 * one another.
 *
 * @param schemaType The schema type to set visibility on.
 * This value cannot be {@code null}.
 * @param packageIdentifiers Represents the package that has access to the given schema
 *     type.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setSchemaTypeVisibleToPackages(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<android.app.appsearch.PackageIdentifier> packageIdentifiers) { throw new RuntimeException("Stub!"); }

/**
 * Sets a set of required {@link android.Manifest.permission} combinations to the given
 * schema type.
 *
 * <p>The querier could read the {@link android.app.appsearch.GenericDocument GenericDocument} objects under the {@code
 * schemaType} if they holds ALL required permissions of ANY of the individual value sets.
 *
 * <p>For example, if the Map contains {@code {% verbatim %}{{permissionA, PermissionB},
 * {PermissionC, PermissionD}, {PermissionE}}{% endverbatim %}}.
 *
 * <ul>
 *   <li>A querier holds both PermissionA and PermissionB has access.
 *   <li>A querier holds both PermissionC and PermissionD has access.
 *   <li>A querier holds only PermissionE has access.
 *   <li>A querier holds both PermissionA and PermissionE has access.
 *   <li>A querier holds only PermissionA doesn't have access.
 *   <li>A querier holds both PermissionA and PermissionC doesn't have access.
 * </ul>
 *
 * @see android.Manifest.permission#READ_SMS
 * @see android.Manifest.permission#READ_CALENDAR
 * @see android.Manifest.permission#READ_CONTACTS
 * @see android.Manifest.permission#READ_EXTERNAL_STORAGE
 * @see android.Manifest.permission#READ_HOME_APP_SEARCH_DATA
 * @see android.Manifest.permission#READ_ASSISTANT_APP_SEARCH_DATA
 * @param schemaType The schema type to set visibility on.
 * This value cannot be {@code null}.
 * @param visibleToPermissions The Android permissions that will be required to access the
 *     given schema.
 
 * Value is {@link android.app.appsearch.SetSchemaRequest#READ_SMS}, {@link android.app.appsearch.SetSchemaRequest#READ_CALENDAR}, {@link android.app.appsearch.SetSchemaRequest#READ_CONTACTS}, {@link android.app.appsearch.SetSchemaRequest#READ_EXTERNAL_STORAGE}, {@link android.app.appsearch.SetSchemaRequest#READ_HOME_APP_SEARCH_DATA}, or {@link android.app.appsearch.SetSchemaRequest#READ_ASSISTANT_APP_SEARCH_DATA}
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setRequiredPermissionsForSchemaTypeVisibility(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<java.util.Set<java.lang.Integer>> visibleToPermissions) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse build() { throw new RuntimeException("Stub!"); }
}

}

