/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;

import android.os.Parcelable;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothAdapter;

/**
 * Criteria for filtering result from Bluetooth LE scans. A {@link android.bluetooth.le.ScanFilter ScanFilter} allows clients to
 * restrict scan results to only those that are of interest to them.
 * <p>
 * Current filtering on the following fields are supported:
 * <li>Service UUIDs which identify the bluetooth gatt services running on the device.
 * <li>Name of remote Bluetooth LE device.
 * <li>Mac address of the remote device.
 * <li>Service data which is the data associated with a service.
 * <li>Manufacturer specific data which is the data associated with a particular manufacturer.
 * <li>Advertising data type and corresponding data.
 *
 * @see android.bluetooth.le.ScanResult
 * @see android.bluetooth.le.BluetoothLeScanner
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScanFilter implements android.os.Parcelable {

private ScanFilter() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns the filter set the device name field of Bluetooth advertisement data.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getDeviceName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the filter set on the service uuid.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getServiceUuid() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getServiceUuidMask() { throw new RuntimeException("Stub!"); }

/**
 * Returns the filter set on the service Solicitation uuid.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getServiceSolicitationUuid() { throw new RuntimeException("Stub!"); }

/**
 * Returns the filter set on the service Solicitation uuid mask.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getServiceSolicitationUuidMask() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getDeviceAddress() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getServiceData() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getServiceDataMask() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.ParcelUuid getServiceDataUuid() { throw new RuntimeException("Stub!"); }

/**
 * Returns the manufacturer id. -1 if the manufacturer filter is not set.
 */

public int getManufacturerId() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getManufacturerData() { throw new RuntimeException("Stub!"); }

/**
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getManufacturerDataMask() { throw new RuntimeException("Stub!"); }

/**
 * Returns the advertising data type of this filter.
 * Returns {@link android.bluetooth.le.ScanRecord#DATA_TYPE_NONE ScanRecord#DATA_TYPE_NONE} if the type is not set.
 * The values of advertising data type are defined in the Bluetooth Generic Access Profile
 * (https://www.bluetooth.com/specifications/assigned-numbers/)

 * @return Value is {@link android.bluetooth.le.ScanRecord#DATA_TYPE_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_SHORT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TX_POWER_LEVEL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CLASS_OF_DEVICE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_DEVICE_ID}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SECURITY_MANAGER_OUT_OF_BAND_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SLAVE_CONNECTION_INTERVAL_RANGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PUBLIC_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RANDOM_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_APPEARANCE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_BLUETOOTH_DEVICE_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_ROLE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_CONFIRMATION_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_RANDOM_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_URI}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_INDOOR_POSITIONING}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TRANSPORT_DISCOVERY_DATA}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SUPPORTED_FEATURES}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CHANNEL_MAP_UPDATE_INDICATION}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PB_ADV}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_MESSAGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_BEACON}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BIG_INFO}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BROADCAST_CODE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RESOLVABLE_SET_IDENTIFIER}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL_LONG}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_3D_INFORMATION_DATA}, or {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MANUFACTURER_SPECIFIC_DATA}
 */

public int getAdvertisingDataType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the advertising data of this filter.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getAdvertisingData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the advertising data mask of this filter.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getAdvertisingDataMask() { throw new RuntimeException("Stub!"); }

/**
 * Check if the scan filter matches a {@code scanResult}. A scan result is considered as a match
 * if it matches all the field filters.
 */

public boolean matches(android.bluetooth.le.ScanResult scanResult) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.os.Parcelable.Creator} to create {@link android.bluetooth.le.ScanFilter ScanFilter} from parcel.
 */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.le.ScanFilter> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for {@link android.bluetooth.le.ScanFilter ScanFilter}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set filter on device name.
 */

public android.bluetooth.le.ScanFilter.Builder setDeviceName(java.lang.String deviceName) { throw new RuntimeException("Stub!"); }

/**
 * Set a scan filter on the remote device address.
 * <p>
 * The address passed to this API must be in big endian byte order. It needs to be in the
 * format of "01:02:03:AB:CD:EF". The device address can be validated using
 * {@link android.bluetooth.BluetoothAdapter#checkBluetoothAddress BluetoothAdapter#checkBluetoothAddress}. The @AddressType is defaulted to
 * {@link android.bluetooth.BluetoothDevice#ADDRESS_TYPE_PUBLIC BluetoothDevice#ADDRESS_TYPE_PUBLIC}.
 *
 * @param deviceAddress the remote device Bluetooth address for the filter
 * @throws java.lang.IllegalArgumentException if the {@code deviceAddress} is invalid
 */

public android.bluetooth.le.ScanFilter.Builder setDeviceAddress(java.lang.String deviceAddress) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on service uuid.
 */

public android.bluetooth.le.ScanFilter.Builder setServiceUuid(android.os.ParcelUuid serviceUuid) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on partial service uuid. The {@code uuidMask} is the bit mask for the
 * {@code serviceUuid}. Set any bit in the mask to 1 to indicate a match is needed for the
 * bit in {@code serviceUuid}, and 0 to ignore that bit.
 *
 * @throws java.lang.IllegalArgumentException If {@code serviceUuid} is {@code null} but {@code
 * uuidMask} is not {@code null}.
 */

public android.bluetooth.le.ScanFilter.Builder setServiceUuid(android.os.ParcelUuid serviceUuid, android.os.ParcelUuid uuidMask) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on service solicitation uuid.
 
 * @param serviceSolicitationUuid This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.le.ScanFilter.Builder setServiceSolicitationUuid(@android.annotation.Nullable android.os.ParcelUuid serviceSolicitationUuid) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on partial service Solicitation uuid. The {@code SolicitationUuidMask} is the
 * bit mask for the {@code serviceSolicitationUuid}. Set any bit in the mask to 1 to
 * indicate a match is needed for the bit in {@code serviceSolicitationUuid}, and 0 to
 * ignore that bit.
 *
 * @param serviceSolicitationUuid can only be null if solicitationUuidMask is null.
 * @param solicitationUuidMask can be null or a mask with no restriction.
 *
 * @throws java.lang.IllegalArgumentException If {@code serviceSolicitationUuid} is {@code null} but
 *             {@code serviceSolicitationUuidMask} is not {@code null}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.le.ScanFilter.Builder setServiceSolicitationUuid(@android.annotation.Nullable android.os.ParcelUuid serviceSolicitationUuid, @android.annotation.Nullable android.os.ParcelUuid solicitationUuidMask) { throw new RuntimeException("Stub!"); }

/**
 * Set filtering on service data.
 *
 * @throws java.lang.IllegalArgumentException If {@code serviceDataUuid} is null.
 */

public android.bluetooth.le.ScanFilter.Builder setServiceData(android.os.ParcelUuid serviceDataUuid, byte[] serviceData) { throw new RuntimeException("Stub!"); }

/**
 * Set partial filter on service data. For any bit in the mask, set it to 1 if it needs to
 * match the one in service data, otherwise set it to 0 to ignore that bit.
 * <p>
 * The {@code serviceDataMask} must have the same length of the {@code serviceData}.
 *
 * @throws java.lang.IllegalArgumentException If {@code serviceDataUuid} is null or {@code
 * serviceDataMask} is {@code null} while {@code serviceData} is not or {@code
 * serviceDataMask} and {@code serviceData} has different length.
 */

public android.bluetooth.le.ScanFilter.Builder setServiceData(android.os.ParcelUuid serviceDataUuid, byte[] serviceData, byte[] serviceDataMask) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on on manufacturerData. A negative manufacturerId is considered as invalid id.
 *
 * @throws java.lang.IllegalArgumentException If the {@code manufacturerId} is invalid.
 */

public android.bluetooth.le.ScanFilter.Builder setManufacturerData(int manufacturerId, byte[] manufacturerData) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on partial manufacture data. For any bit in the mask, set it the 1 if it needs
 * to match the one in manufacturer data, otherwise set it to 0.
 * <p>
 * The {@code manufacturerDataMask} must have the same length of {@code manufacturerData}.
 *
 * @throws java.lang.IllegalArgumentException If the {@code manufacturerId} is invalid, or {@code
 * manufacturerData} is null while {@code manufacturerDataMask} is not, or {@code
 * manufacturerData} and {@code manufacturerDataMask} have different length.
 */

public android.bluetooth.le.ScanFilter.Builder setManufacturerData(int manufacturerId, byte[] manufacturerData, byte[] manufacturerDataMask) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on advertising data with specific advertising data type.
 * For any bit in the mask, set it the 1 if it needs to match the one in
 * advertising data, otherwise set it to 0.
 * <p>
 * The values of {@code advertisingDataType} are assigned by Bluetooth SIG. For more
 * details refer to Bluetooth Generic Access Profile.
 * (https://www.bluetooth.com/specifications/assigned-numbers/)
 * The {@code advertisingDataMask} must have the same length of {@code advertisingData}.
 *
 * @throws java.lang.IllegalArgumentException If the {@code advertisingDataType} is invalid, {@code
 * advertisingData} or {@code advertisingDataMask} is null or {@code
 * advertisingData} and {@code advertisingDataMask} have different length.
 
 * @param advertisingDataType Value is {@link android.bluetooth.le.ScanRecord#DATA_TYPE_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_SHORT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TX_POWER_LEVEL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CLASS_OF_DEVICE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_DEVICE_ID}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SECURITY_MANAGER_OUT_OF_BAND_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SLAVE_CONNECTION_INTERVAL_RANGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PUBLIC_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RANDOM_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_APPEARANCE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_BLUETOOTH_DEVICE_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_ROLE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_CONFIRMATION_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_RANDOM_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_URI}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_INDOOR_POSITIONING}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TRANSPORT_DISCOVERY_DATA}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SUPPORTED_FEATURES}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CHANNEL_MAP_UPDATE_INDICATION}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PB_ADV}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_MESSAGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_BEACON}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BIG_INFO}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BROADCAST_CODE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RESOLVABLE_SET_IDENTIFIER}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL_LONG}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_3D_INFORMATION_DATA}, or {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MANUFACTURER_SPECIFIC_DATA}
 * @param advertisingData This value cannot be {@code null}.
 * @param advertisingDataMask This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.le.ScanFilter.Builder setAdvertisingDataTypeWithData(int advertisingDataType, @android.annotation.NonNull byte[] advertisingData, @android.annotation.NonNull byte[] advertisingDataMask) { throw new RuntimeException("Stub!"); }

/**
 * Set filter on advertising data with specific advertising data type.
 * <p>
 * The values of {@code advertisingDataType} are assigned by Bluetooth SIG. For more
 * details refer to Bluetooth Generic Access Profile.
 * (https://www.bluetooth.com/specifications/assigned-numbers/)
 * @throws java.lang.IllegalArgumentException If the {@code advertisingDataType} is invalid
 
 * @param advertisingDataType Value is {@link android.bluetooth.le.ScanRecord#DATA_TYPE_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_SHORT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LOCAL_NAME_COMPLETE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TX_POWER_LEVEL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CLASS_OF_DEVICE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_DEVICE_ID}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SECURITY_MANAGER_OUT_OF_BAND_FLAGS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SLAVE_CONNECTION_INTERVAL_RANGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_16_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PUBLIC_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RANDOM_TARGET_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_APPEARANCE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_BLUETOOTH_DEVICE_ADDRESS}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_ROLE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_HASH_C_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R_256}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_SOLICITATION_UUIDS_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_32_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_SERVICE_DATA_128_BIT}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_CONFIRMATION_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SECURE_CONNECTIONS_RANDOM_VALUE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_URI}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_INDOOR_POSITIONING}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_TRANSPORT_DISCOVERY_DATA}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_LE_SUPPORTED_FEATURES}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_CHANNEL_MAP_UPDATE_INDICATION}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_PB_ADV}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_MESSAGE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MESH_BEACON}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BIG_INFO}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_BROADCAST_CODE}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_RESOLVABLE_SET_IDENTIFIER}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_ADVERTISING_INTERVAL_LONG}, {@link android.bluetooth.le.ScanRecord#DATA_TYPE_3D_INFORMATION_DATA}, or {@link android.bluetooth.le.ScanRecord#DATA_TYPE_MANUFACTURER_SPECIFIC_DATA}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.le.ScanFilter.Builder setAdvertisingDataType(int advertisingDataType) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.bluetooth.le.ScanFilter ScanFilter}.
 *
 * @throws java.lang.IllegalArgumentException If the filter cannot be built.
 */

public android.bluetooth.le.ScanFilter build() { throw new RuntimeException("Stub!"); }
}

}

