/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;

import java.util.List;
import java.util.Map;

/**
 * Represents a scan record from Bluetooth LE scan.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScanRecord {

private ScanRecord() { throw new RuntimeException("Stub!"); }

/**
 * Returns the advertising flags indicating the discoverable mode and capability of the device.
 * Returns -1 if the flag field is not set.
 */

public int getAdvertiseFlags() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of service UUIDs within the advertisement that are used to identify the
 * bluetooth GATT services.
 */

public java.util.List<android.os.ParcelUuid> getServiceUuids() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of service solicitation UUIDs within the advertisement that are used to
 * identify the Bluetooth GATT services.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.os.ParcelUuid> getServiceSolicitationUuids() { throw new RuntimeException("Stub!"); }

/**
 * Returns a sparse array of manufacturer identifier and its corresponding manufacturer specific
 * data.
 */

public android.util.SparseArray<byte[]> getManufacturerSpecificData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the manufacturer specific data associated with the manufacturer id. Returns
 * {@code null} if the {@code manufacturerId} is not found.
 */

@android.annotation.Nullable
public byte[] getManufacturerSpecificData(int manufacturerId) { throw new RuntimeException("Stub!"); }

/**
 * Returns a map of service UUID and its corresponding service data.
 */

public java.util.Map<android.os.ParcelUuid,byte[]> getServiceData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the service data byte array associated with the {@code serviceUuid}. Returns
 * {@code null} if the {@code serviceDataUuid} is not found.
 */

@android.annotation.Nullable
public byte[] getServiceData(android.os.ParcelUuid serviceDataUuid) { throw new RuntimeException("Stub!"); }

/**
 * Returns the transmission power level of the packet in dBm. Returns {@link java.lang.Integer#MIN_VALUE Integer#MIN_VALUE}
 * if the field is not set. This value can be used to calculate the path loss of a received
 * packet using the following equation:
 * <p>
 * <code>pathloss = txPowerLevel - rssi</code>
 */

public int getTxPowerLevel() { throw new RuntimeException("Stub!"); }

/**
 * Returns the local name of the BLE device. This is a UTF-8 encoded string.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getDeviceName() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map of advertising data type and its corresponding advertising data.
 * The values of advertising data type are defined in the Bluetooth Generic Access Profile
 * (https://www.bluetooth.com/specifications/assigned-numbers/)

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,byte[]> getAdvertisingDataMap() { throw new RuntimeException("Stub!"); }

/**
 * Returns raw bytes of scan record.
 */

public byte[] getBytes() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Data type is 3D Information Data, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_3D_INFORMATION_DATA = 61; // 0x3d

/**
 * Data type is Advertising Interval, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_ADVERTISING_INTERVAL = 26; // 0x1a

/**
 * Data type is Advertising Interval - long, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_ADVERTISING_INTERVAL_LONG = 47; // 0x2f

/**
 * Data type is Appearance, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_APPEARANCE = 25; // 0x19

/**
 * Data type is BIGInfo, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_BIG_INFO = 44; // 0x2c

/**
 * Data type is Broadcast_Code, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_BROADCAST_CODE = 45; // 0x2d

/**
 * Data type is Channel Map Update Indication, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_CHANNEL_MAP_UPDATE_INDICATION = 40; // 0x28

/**
 * Data type is Class of Device, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_CLASS_OF_DEVICE = 13; // 0xd

/**
 * Data type is Device ID, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_DEVICE_ID = 16; // 0x10

/**
 * Data type is Flags, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_FLAGS = 1; // 0x1

/**
 * Data type is Indoor Positioning, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_INDOOR_POSITIONING = 37; // 0x25

/**
 * Data type is LE Bluetooth Device Address, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_LE_BLUETOOTH_DEVICE_ADDRESS = 27; // 0x1b

/**
 * Data type is LE Role, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_LE_ROLE = 28; // 0x1c

/**
 * Data type is LE Secure Connections Confirmation Value, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_LE_SECURE_CONNECTIONS_CONFIRMATION_VALUE = 34; // 0x22

/**
 * Data type is LE Secure Connections Random Value, see the Bluetooth Generic Access Profile for
 * more details.
 */

public static final int DATA_TYPE_LE_SECURE_CONNECTIONS_RANDOM_VALUE = 35; // 0x23

/**
 * Data type is LE Supported Features, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_LE_SUPPORTED_FEATURES = 39; // 0x27

/**
 * Data type is Complete Local Name, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_LOCAL_NAME_COMPLETE = 9; // 0x9

/**
 * Data type is Shortened Local Name, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_LOCAL_NAME_SHORT = 8; // 0x8

/**
 * Data type is Manufacturer Specific Data, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_MANUFACTURER_SPECIFIC_DATA = 255; // 0xff

/**
 * Data type is Mesh Beacon, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_MESH_BEACON = 43; // 0x2b

/**
 * Data type is Mesh Message, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_MESH_MESSAGE = 42; // 0x2a

/**
 * Data type is not set for the filter. Will not filter advertising data type.
 */

public static final int DATA_TYPE_NONE = -1; // 0xffffffff

/**
 * Data type is PB-ADV, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_PB_ADV = 41; // 0x29

/**
 * Data type is Public Target Address, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_PUBLIC_TARGET_ADDRESS = 23; // 0x17

/**
 * Data type is Random Target Address, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_RANDOM_TARGET_ADDRESS = 24; // 0x18

/**
 * Data type is Resolvable Set Identifier, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_RESOLVABLE_SET_IDENTIFIER = 46; // 0x2e

/**
 * Data type is Security Manager Out of Band Flags, see the Bluetooth Generic Access Profile for
 * more details.
 */

public static final int DATA_TYPE_SECURITY_MANAGER_OUT_OF_BAND_FLAGS = 17; // 0x11

/**
 * Data type is Service Data - 128-bit UUID, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SERVICE_DATA_128_BIT = 33; // 0x21

/**
 * Data type is Service Data - 16-bit UUID, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SERVICE_DATA_16_BIT = 22; // 0x16

/**
 * Data type is Service Data - 32-bit UUID, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SERVICE_DATA_32_BIT = 32; // 0x20

/**
 * Data type is List of 128-bit Service Solicitation UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_SOLICITATION_UUIDS_128_BIT = 21; // 0x15

/**
 * Data type is List of 16-bit Service Solicitation UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_SOLICITATION_UUIDS_16_BIT = 20; // 0x14

/**
 * Data type is List of 32-bit Service Solicitation UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_SOLICITATION_UUIDS_32_BIT = 31; // 0x1f

/**
 * Data type is Complete List of 128-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE = 7; // 0x7

/**
 * Data type is Incomplete List of 128-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for the details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL = 6; // 0x6

/**
 * Data type is Complete List of 16-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE = 3; // 0x3

/**
 * Data type is Incomplete List of 16-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for the details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL = 2; // 0x2

/**
 * Data type is Complete List of 32-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for more details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE = 5; // 0x5

/**
 * Data type is Incomplete List of 32-bit Service Class UUIDs, see the Bluetooth Generic Access
 * Profile for the details.
 */

public static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL = 4; // 0x4

/**
 * Data type is Simple Pairing Hash C, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SIMPLE_PAIRING_HASH_C = 14; // 0xe

/**
 * Data type is Simple Pairing Hash C-256, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SIMPLE_PAIRING_HASH_C_256 = 29; // 0x1d

/**
 * Data type is Simple Pairing Randomizer R, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R = 15; // 0xf

/**
 * Data type is Simple Pairing Randomizer R-256, see the Bluetooth Generic Access Profile for
 * more details.
 */

public static final int DATA_TYPE_SIMPLE_PAIRING_RANDOMIZER_R_256 = 30; // 0x1e

/**
 * Data type is Slave Connection Interval Range, see the Bluetooth Generic Access Profile for
 * more details.
 */

public static final int DATA_TYPE_SLAVE_CONNECTION_INTERVAL_RANGE = 18; // 0x12

/**
 * Data type is Transport Discovery Data, see the Bluetooth Generic Access Profile for more
 * details.
 */

public static final int DATA_TYPE_TRANSPORT_DISCOVERY_DATA = 38; // 0x26

/**
 * Data type is Tx Power Level, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_TX_POWER_LEVEL = 10; // 0xa

/**
 * Data type is URI, see the Bluetooth Generic Access Profile for more details.
 */

public static final int DATA_TYPE_URI = 36; // 0x24
}

