/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2.params;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RecommendedStreamConfigurationMap {

RecommendedStreamConfigurationMap() { throw new RuntimeException("Stub!"); }

public int getRecommendedUseCase() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getOutputFormats() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<java.lang.Integer> getValidOutputFormatsForInput(int inputFormat) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<java.lang.Integer> getInputFormats() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Size> getInputSizes(int format) { throw new RuntimeException("Stub!"); }

public boolean isOutputSupportedFor(int format) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Size> getOutputSizes(int format) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Size> getHighSpeedVideoSizes() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Range<java.lang.Integer>> getHighSpeedVideoFpsRangesFor(@android.annotation.NonNull android.util.Size size) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Range<java.lang.Integer>> getHighSpeedVideoFpsRanges() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Size> getHighSpeedVideoSizesFor(@android.annotation.NonNull android.util.Range<java.lang.Integer> fpsRange) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<android.util.Size> getHighResolutionOutputSizes(int format) { throw new RuntimeException("Stub!"); }

public long getOutputMinFrameDuration(int format, @android.annotation.NonNull android.util.Size size) { throw new RuntimeException("Stub!"); }

public long getOutputStallDuration(int format, @android.annotation.NonNull android.util.Size size) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public <T> java.util.Set<android.util.Size> getOutputSizes(@android.annotation.NonNull java.lang.Class<T> klass) { throw new RuntimeException("Stub!"); }

public <T> long getOutputMinFrameDuration(@android.annotation.NonNull java.lang.Class<T> klass, @android.annotation.NonNull android.util.Size size) { throw new RuntimeException("Stub!"); }

public <T> long getOutputStallDuration(@android.annotation.NonNull java.lang.Class<T> klass, @android.annotation.NonNull android.util.Size size) { throw new RuntimeException("Stub!"); }

public boolean isOutputSupportedFor(@android.annotation.NonNull android.view.Surface surface) { throw new RuntimeException("Stub!"); }

public static final int USECASE_10BIT_OUTPUT = 8; // 0x8

public static final int USECASE_LOW_LATENCY_SNAPSHOT = 6; // 0x6

public static final int USECASE_PREVIEW = 0; // 0x0

public static final int USECASE_RAW = 5; // 0x5

public static final int USECASE_RECORD = 1; // 0x1

public static final int USECASE_SNAPSHOT = 3; // 0x3

public static final int USECASE_VIDEO_SNAPSHOT = 2; // 0x2

public static final int USECASE_ZSL = 4; // 0x4
}

